/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.context;

import com.aventstack.extentreports.Status;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.pdf.structure.cell.TextLinkCell;
import tech.grasshopper.reporter.annotation.AnnotationStore;
import tech.grasshopper.reporter.context.AttributeSummaryDisplay;

public class ContextAttributeSummary
extends AttributeSummaryDisplay {
    private static final float HEADER_NAME_WIDTH = 215.0f;
    private static final float HEADER_PASS_WIDTH = 45.0f;
    private static final float HEADER_FAIL_WIDTH = 45.0f;
    private static final float HEADER_SKIP_WIDTH = 45.0f;
    private static final float HEADER_WARN_WIDTH = 45.0f;
    private static final float HEADER_INFO_WIDTH = 45.0f;
    private static final float HEADER_PASS_PERCENT_WIDTH = 60.0f;
    private Map<String, Map<Status, Integer>> data;
    protected AnnotationStore annotations;

    @Override
    public void display() {
        this.data = this.contextAttributeData();
        if (this.data.isEmpty()) {
            return;
        }
        this.createTableBuilder();
        this.createTitleRow();
        this.createHeaderRow();
        this.createDataRows();
        this.drawTable();
    }

    private void createTableBuilder() {
        this.tableBuilder = Table.builder().addColumnsOfWidth(new float[]{215.0f, 45.0f, 45.0f, 45.0f, 45.0f, 45.0f, 60.0f}).padding(5.0f).borderColor(Color.LIGHT_GRAY).borderWidth(1.0f).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.TOP);
    }

    private void createTitleRow() {
        this.tableBuilder.addRow(Row.builder().height(Float.valueOf(25.0f)).font(this.reportFont.getBoldItalicFont()).fontSize(Integer.valueOf(15)).borderWidth(0.0f).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(this.type.toString()).textColor(this.config.attributeHeaderColor(this.type))).horizontalAlignment(HorizontalAlignment.LEFT)).colSpan(7)).build()).build());
    }

    private void createHeaderRow() {
        this.tableBuilder.addRow(Row.builder().height(Float.valueOf(25.0f)).font(this.reportFont.getItalicFont()).fontSize(Integer.valueOf(13)).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text("Name").textColor(this.config.attributeNameColor(this.type))).font(this.reportFont.getBoldItalicFont())).lineSpacing(1.0f)).horizontalAlignment(HorizontalAlignment.LEFT)).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Pass").textColor(this.config.getPassColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Fail").textColor(this.config.getFailColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Skip").textColor(this.config.getSkipColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Warn").textColor(this.config.getWarnColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Info").textColor(this.config.getInfoColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Pass %").textColor(this.config.getPassColor())).build()).build());
    }

    private void createDataRows() {
        this.data.forEach((k, v) -> {
            Annotation annotation = Annotation.builder().title(this.type.toString().toLowerCase() + "- " + k).build();
            this.annotations.addAttributeNameAnnotation(annotation);
            int passpercent = v.getOrDefault(Status.PASS, 0) * 100 / v.values().stream().mapToInt(Integer::intValue).sum();
            Row row = Row.builder().font(this.TABLE_CONTENT_FONT).fontSize(Integer.valueOf(12)).wordBreak(Boolean.valueOf(true)).padding(7.0f).add(this.createAttributeNameCell(this.textSanitizer.sanitizeText((String)k), annotation)).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(v.getOrDefault(Status.PASS, 0))).textColor(this.config.getPassColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(v.getOrDefault(Status.FAIL, 0))).textColor(this.config.getFailColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(v.getOrDefault(Status.SKIP, 0))).textColor(this.config.getSkipColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(v.getOrDefault(Status.WARNING, 0))).textColor(this.config.getWarnColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(v.getOrDefault(Status.INFO, 0))).textColor(this.config.getInfoColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(passpercent)).textColor(this.config.getPassColor())).build()).build();
            this.tableBuilder.addRow(row);
        });
    }

    private AbstractCell createAttributeNameCell(String title, Annotation annotation) {
        if (this.config.isDisplayAttributeDetails()) {
            return ((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)TextLinkCell.builder().annotation(annotation).text(title)).lineSpacing(1.0f)).textColor(this.config.attributeNameColor(this.type))).horizontalAlignment(HorizontalAlignment.LEFT)).build();
        }
        return ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(title).lineSpacing(1.0f)).textColor(this.config.attributeNameColor(this.type))).horizontalAlignment(HorizontalAlignment.LEFT)).build();
    }

    private static Map<String, Map<Status, Integer>> $default$data() {
        return new LinkedHashMap<String, Map<Status, Integer>>();
    }

    protected ContextAttributeSummary(ContextAttributeSummaryBuilder<?, ?> b) {
        super((AttributeSummaryDisplay.AttributeSummaryDisplayBuilder<?, ?>)b);
        this.data = ((ContextAttributeSummaryBuilder)b).data$set ? ((ContextAttributeSummaryBuilder)b).data$value : ContextAttributeSummary.$default$data();
        this.annotations = ((ContextAttributeSummaryBuilder)b).annotations;
    }

    public static ContextAttributeSummaryBuilder<?, ?> builder() {
        return new ContextAttributeSummaryBuilderImpl();
    }

    public Map<String, Map<Status, Integer>> getData() {
        return this.data;
    }

    public AnnotationStore getAnnotations() {
        return this.annotations;
    }

    public void setData(Map<String, Map<Status, Integer>> data) {
        this.data = data;
    }

    public void setAnnotations(AnnotationStore annotations) {
        this.annotations = annotations;
    }

    @Override
    public String toString() {
        return "ContextAttributeSummary(data=" + this.getData() + ", annotations=" + this.getAnnotations() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextAttributeSummary)) {
            return false;
        }
        ContextAttributeSummary other = (ContextAttributeSummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Map<Status, Integer>> this$data = this.getData();
        Map<String, Map<Status, Integer>> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        AnnotationStore this$annotations = this.getAnnotations();
        AnnotationStore other$annotations = other.getAnnotations();
        return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ContextAttributeSummary;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Map<Status, Integer>> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        AnnotationStore $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        return result;
    }

    private static final class ContextAttributeSummaryBuilderImpl
    extends ContextAttributeSummaryBuilder<ContextAttributeSummary, ContextAttributeSummaryBuilderImpl> {
        private ContextAttributeSummaryBuilderImpl() {
        }

        @Override
        protected ContextAttributeSummaryBuilderImpl self() {
            return this;
        }

        @Override
        public ContextAttributeSummary build() {
            return new ContextAttributeSummary(this);
        }
    }

    public static abstract class ContextAttributeSummaryBuilder<C extends ContextAttributeSummary, B extends ContextAttributeSummaryBuilder<C, B>>
    extends AttributeSummaryDisplay.AttributeSummaryDisplayBuilder<C, B> {
        private boolean data$set;
        private Map<String, Map<Status, Integer>> data$value;
        private AnnotationStore annotations;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B data(Map<String, Map<Status, Integer>> data) {
            this.data$value = data;
            this.data$set = true;
            return (B)this.self();
        }

        public B annotations(AnnotationStore annotations) {
            this.annotations = annotations;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ContextAttributeSummary.ContextAttributeSummaryBuilder(super=" + super.toString() + ", data$value=" + this.data$value + ", annotations=" + this.annotations + ")";
        }
    }
}

