/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter;

import com.aventstack.extentreports.model.Report;
import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PageMode;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import tech.grasshopper.reporter.annotation.AnnotationProcessor;
import tech.grasshopper.reporter.annotation.AnnotationStore;
import tech.grasshopper.reporter.annotation.FileAnnotationProcessor;
import tech.grasshopper.reporter.bookmark.Bookmark;
import tech.grasshopper.reporter.config.ExtentPDFReporterConfig;
import tech.grasshopper.reporter.context.AttributeSummary;
import tech.grasshopper.reporter.context.detail.AttributeDetails;
import tech.grasshopper.reporter.dashboard.Dashboard;
import tech.grasshopper.reporter.destination.Destination;
import tech.grasshopper.reporter.expanded.BDDMediaSummary;
import tech.grasshopper.reporter.expanded.MediaSummary;
import tech.grasshopper.reporter.font.ReportFont;
import tech.grasshopper.reporter.header.PageHeader;
import tech.grasshopper.reporter.tests.TestBDDDetails;
import tech.grasshopper.reporter.tests.TestDetails;

public class ReportGenerator {
    protected Report report;
    protected ExtentPDFReporterConfig config;
    protected File reportFile;
    protected PDDocument document;
    protected ReportFont reportFont;
    protected Destination.DestinationStore destinations;
    protected AnnotationStore annotations;
    protected PageHeader pageHeader;

    public ReportGenerator(Report report, ExtentPDFReporterConfig config, File file) {
        this.report = report;
        this.config = config;
        this.reportFile = file;
        this.document = new PDDocument();
        this.reportFont = new ReportFont(this.document);
        this.destinations = new Destination.DestinationStore();
        this.annotations = new AnnotationStore();
        this.pageHeader = new PageHeader();
        this.createReportDirectory();
    }

    public void generate() throws IOException {
        this.createDashboardSection();
        this.createAttributeSummarySection();
        this.createTestDetailsSection();
        this.createAttributeDetailsSection();
        this.createExpandedMediaSection();
        this.processAnnotations();
        this.processFileAnnotations();
        Bookmark bookmark = Bookmark.builder().destinationStore(this.destinations).config(this.config).report(this.report).build();
        PDDocumentOutline outline = bookmark.createDocumentOutline();
        this.document.getDocumentCatalog().setDocumentOutline(outline);
        this.document.getDocumentCatalog().setPageMode(PageMode.USE_OUTLINES);
        this.pageHeader.processHeader(this.document, this.reportFont);
        this.document.save(this.reportFile);
        this.document.close();
    }

    protected void processAnnotations() {
        AnnotationProcessor.builder().annotations(this.annotations).destinations(this.destinations).config(this.config).build().processAnnotations();
    }

    protected void processFileAnnotations() {
        if (this.config.isDisplayAttachedMedia()) {
            FileAnnotationProcessor.builder().annotations(this.annotations).document(this.document).build().updateAttachments();
        }
    }

    protected void createExpandedMediaSection() {
        if (this.config.isDisplayExpandedMedia()) {
            if (this.report.isBDD()) {
                ((BDDMediaSummary)((BDDMediaSummary.BDDMediaSummaryBuilder)((BDDMediaSummary.BDDMediaSummaryBuilder)((BDDMediaSummary.BDDMediaSummaryBuilder)((BDDMediaSummary.BDDMediaSummaryBuilder)((BDDMediaSummary.BDDMediaSummaryBuilder)((BDDMediaSummary.BDDMediaSummaryBuilder)((BDDMediaSummary.BDDMediaSummaryBuilder)BDDMediaSummary.builder().document(this.document)).report(this.report)).reportFont(this.reportFont)).config(this.config)).destinations(this.destinations)).annotations(this.annotations)).pageHeader(this.pageHeader)).build()).createSection();
            } else {
                ((MediaSummary)((MediaSummary.MediaSummaryBuilder)((MediaSummary.MediaSummaryBuilder)((MediaSummary.MediaSummaryBuilder)((MediaSummary.MediaSummaryBuilder)((MediaSummary.MediaSummaryBuilder)((MediaSummary.MediaSummaryBuilder)((MediaSummary.MediaSummaryBuilder)MediaSummary.builder().document(this.document)).report(this.report)).reportFont(this.reportFont)).config(this.config)).destinations(this.destinations)).annotations(this.annotations)).pageHeader(this.pageHeader)).build()).createSection();
            }
        }
    }

    protected void createAttributeDetailsSection() {
        if (this.config.isDisplayAttributeDetails()) {
            ((AttributeDetails)((AttributeDetails.AttributeDetailsBuilder)((AttributeDetails.AttributeDetailsBuilder)((AttributeDetails.AttributeDetailsBuilder)((AttributeDetails.AttributeDetailsBuilder)((AttributeDetails.AttributeDetailsBuilder)((AttributeDetails.AttributeDetailsBuilder)((AttributeDetails.AttributeDetailsBuilder)AttributeDetails.builder().document(this.document)).report(this.report)).reportFont(this.reportFont)).config(this.config)).destinations(this.destinations)).annotations(this.annotations)).pageHeader(this.pageHeader)).build()).createSection();
        }
    }

    protected void createTestDetailsSection() {
        if (this.config.isDisplayTestDetails()) {
            if (this.report.isBDD()) {
                ((TestBDDDetails)((TestBDDDetails.TestBDDDetailsBuilder)((TestBDDDetails.TestBDDDetailsBuilder)((TestBDDDetails.TestBDDDetailsBuilder)((TestBDDDetails.TestBDDDetailsBuilder)((TestBDDDetails.TestBDDDetailsBuilder)((TestBDDDetails.TestBDDDetailsBuilder)((TestBDDDetails.TestBDDDetailsBuilder)TestBDDDetails.builder().document(this.document)).report(this.report)).reportFont(this.reportFont)).config(this.config)).destinations(this.destinations)).annotations(this.annotations)).pageHeader(this.pageHeader)).build()).createSection();
            } else {
                ((TestDetails)((TestDetails.TestDetailsBuilder)((TestDetails.TestDetailsBuilder)((TestDetails.TestDetailsBuilder)((TestDetails.TestDetailsBuilder)((TestDetails.TestDetailsBuilder)((TestDetails.TestDetailsBuilder)((TestDetails.TestDetailsBuilder)TestDetails.builder().document(this.document)).report(this.report)).reportFont(this.reportFont)).config(this.config)).destinations(this.destinations)).annotations(this.annotations)).pageHeader(this.pageHeader)).build()).createSection();
            }
        }
    }

    protected void createAttributeSummarySection() {
        if (this.config.isDisplayAttributeSummary()) {
            ((AttributeSummary)((AttributeSummary.AttributeSummaryBuilder)((AttributeSummary.AttributeSummaryBuilder)((AttributeSummary.AttributeSummaryBuilder)((AttributeSummary.AttributeSummaryBuilder)((AttributeSummary.AttributeSummaryBuilder)((AttributeSummary.AttributeSummaryBuilder)((AttributeSummary.AttributeSummaryBuilder)AttributeSummary.builder().document(this.document)).report(this.report)).reportFont(this.reportFont)).config(this.config)).destinations(this.destinations)).annotations(this.annotations)).pageHeader(this.pageHeader)).build()).createSection();
        }
    }

    protected void createDashboardSection() {
        ((Dashboard)((Dashboard.DashboardBuilder)((Dashboard.DashboardBuilder)((Dashboard.DashboardBuilder)((Dashboard.DashboardBuilder)((Dashboard.DashboardBuilder)Dashboard.builder().document(this.document)).reportFont(this.reportFont)).report(this.report)).config(this.config)).destinations(this.destinations)).build()).createSection();
    }

    private void createReportDirectory() {
        File dir = new File(this.reportFile.getParent());
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public Report getReport() {
        return this.report;
    }

    public ExtentPDFReporterConfig getConfig() {
        return this.config;
    }

    public File getReportFile() {
        return this.reportFile;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public ReportFont getReportFont() {
        return this.reportFont;
    }

    public Destination.DestinationStore getDestinations() {
        return this.destinations;
    }

    public AnnotationStore getAnnotations() {
        return this.annotations;
    }

    public PageHeader getPageHeader() {
        return this.pageHeader;
    }
}

