/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.util.StringUtils;

public class SqlMethodAnalyzer {
    private static final Set<String> CLOSING_METHOD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(JdbcMethod.CONNECTION_CLOSE.methodName, JdbcMethod.CONNECTION_ABORT.methodName, JdbcMethod.STATEMENT_CLOSE.methodName, JdbcMethod.CALLABLESTATEMENT_CLOSE.methodName, JdbcMethod.PREPAREDSTATEMENT_CLOSE.methodName, JdbcMethod.RESULTSET_CLOSE.methodName)));
    private static final Set<String> EXECUTE_SQL_METHOD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(JdbcMethod.STATEMENT_EXECUTE.methodName, JdbcMethod.STATEMENT_EXECUTEQUERY.methodName, JdbcMethod.STATEMENT_EXECUTEUPDATE.methodName, JdbcMethod.CALLABLESTATEMENT_EXECUTE.methodName, JdbcMethod.CALLABLESTATEMENT_EXECUTEQUERY.methodName, JdbcMethod.CALLABLESTATEMENT_EXECUTEUPDATE.methodName, JdbcMethod.PREPAREDSTATEMENT_EXECUTE.methodName, JdbcMethod.PREPAREDSTATEMENT_EXECUTEQUERY.methodName, JdbcMethod.PREPAREDSTATEMENT_EXECUTEUPDATE.methodName)));
    private static final Set<String> CLOSE_TRANSACTION_METHOD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(JdbcMethod.CONNECTION_COMMIT.methodName, JdbcMethod.CONNECTION_ROLLBACK.methodName, JdbcMethod.CONNECTION_CLOSE.methodName, JdbcMethod.CONNECTION_ABORT.methodName)));

    public boolean doesOpenTransaction(Connection conn, String methodName, Object[] args) {
        boolean autocommit;
        if (!EXECUTE_SQL_METHOD_NAMES.contains(methodName) || args == null || args.length < 1) {
            return false;
        }
        String statement = this.getFirstSqlStatement(String.valueOf(args[0]));
        if (this.isStatementStartingTransaction(statement)) {
            return true;
        }
        try {
            autocommit = conn.getAutoCommit();
        }
        catch (SQLException e) {
            return false;
        }
        return !autocommit && this.isStatementDml(statement);
    }

    private String getFirstSqlStatement(String sql) {
        List<String> statementList = this.parseMultiStatementQueries(sql);
        if (statementList.isEmpty()) {
            return sql;
        }
        String statement = statementList.get(0);
        statement = statement.toUpperCase();
        statement = statement.replaceAll("\\s*/\\*(.*?)\\*/\\s*", " ").trim();
        return statement;
    }

    private List<String> parseMultiStatementQueries(String query) {
        if (StringUtils.isNullOrEmpty(query)) {
            return new ArrayList<String>();
        }
        if ((query = query.replaceAll("\\s+", " ")).trim().isEmpty()) {
            return new ArrayList<String>();
        }
        return Arrays.stream(query.split(";")).collect(Collectors.toList());
    }

    public boolean doesCloseTransaction(Connection conn, String methodName, Object[] args) {
        if (CLOSE_TRANSACTION_METHOD_NAMES.contains(methodName)) {
            return true;
        }
        if (this.doesSwitchAutoCommitFalseTrue(conn, methodName, args)) {
            return true;
        }
        if (!methodName.contains("execute") || args == null || args.length < 1) {
            return false;
        }
        String statement = this.getFirstSqlStatement(String.valueOf(args[0]));
        return this.isStatementClosingTransaction(statement);
    }

    public boolean isStatementDml(String statement) {
        return !this.isStatementStartingTransaction(statement) && !this.isStatementClosingTransaction(statement) && !statement.startsWith("SET ") && !statement.startsWith("USE ") && !statement.startsWith("SHOW ");
    }

    public boolean isStatementStartingTransaction(String statement) {
        return statement.startsWith("BEGIN") || statement.startsWith("START TRANSACTION");
    }

    public boolean isStatementClosingTransaction(String statement) {
        return statement.startsWith("COMMIT") || statement.startsWith("ROLLBACK") || statement.startsWith("END") || statement.startsWith("ABORT");
    }

    public boolean isStatementSettingAutoCommit(String methodName, Object[] args) {
        if (args == null || args.length < 1) {
            return false;
        }
        if (!EXECUTE_SQL_METHOD_NAMES.contains(methodName)) {
            return false;
        }
        String statement = this.getFirstSqlStatement(String.valueOf(args[0]));
        return statement.startsWith("SET AUTOCOMMIT");
    }

    public boolean doesSwitchAutoCommitFalseTrue(Connection conn, String methodName, Object[] jdbcMethodArgs) {
        boolean oldAutoCommitVal;
        boolean isStatementSettingAutoCommit = this.isStatementSettingAutoCommit(methodName, jdbcMethodArgs);
        if (!isStatementSettingAutoCommit && !JdbcMethod.CONNECTION_SETAUTOCOMMIT.methodName.equals(methodName)) {
            return false;
        }
        Boolean newAutoCommitVal = null;
        try {
            oldAutoCommitVal = conn.getAutoCommit();
        }
        catch (SQLException e) {
            return false;
        }
        if (JdbcMethod.CONNECTION_SETAUTOCOMMIT.methodName.equals(methodName) && jdbcMethodArgs.length > 0) {
            newAutoCommitVal = (Boolean)jdbcMethodArgs[0];
        } else if (isStatementSettingAutoCommit) {
            newAutoCommitVal = this.getAutoCommitValueFromSqlStatement(jdbcMethodArgs);
        }
        return !oldAutoCommitVal && Boolean.TRUE.equals(newAutoCommitVal);
    }

    public Boolean getAutoCommitValueFromSqlStatement(Object[] args) {
        int valueIndex;
        if (args == null || args.length < 1) {
            return null;
        }
        String sql = this.getFirstSqlStatement(String.valueOf(args[0]));
        int separatorIndex = sql.indexOf("=");
        if (separatorIndex != -1) {
            valueIndex = separatorIndex + 1;
        } else {
            separatorIndex = sql.indexOf(" TO ");
            if (separatorIndex == -1) {
                return null;
            }
            valueIndex = separatorIndex + 3;
        }
        sql = sql.substring(valueIndex);
        if (sql.contains(";")) {
            sql = sql.substring(0, sql.indexOf(";"));
        }
        if ("FALSE".equals(sql = sql.trim()) || "0".equals(sql) || "OFF".equals(sql)) {
            return false;
        }
        if ("TRUE".equals(sql) || "1".equals(sql) || "ON".equals(sql)) {
            return true;
        }
        return null;
    }

    public boolean isMethodClosingSqlObject(String methodName) {
        return CLOSING_METHOD_NAMES.contains(methodName);
    }
}

