/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.targetdriverdialect;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.targetdriverdialect.ConnectInfo;
import software.amazon.jdbc.targetdriverdialect.GenericTargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.MysqlConnectorJDriverHelper;

public class MysqlConnectorJTargetDriverDialect
extends GenericTargetDriverDialect {
    private static final String DRIVER_CLASS_NAME = "com.mysql.cj.jdbc.Driver";
    private static final String DS_CLASS_NAME = "com.mysql.cj.jdbc.MysqlDataSource";
    private static final String CP_DS_CLASS_NAME = "com.mysql.cj.jdbc.MysqlConnectionPoolDataSource";
    private static final Set<String> MYSQL_ALLOWED_ON_CLOSED_METHOD_NAMES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.addAll(GenericTargetDriverDialect.ALLOWED_ON_CLOSED_METHODS);
            this.add(JdbcMethod.CONNECTION_GETCATALOG.methodName);
            this.add(JdbcMethod.CONNECTION_ISREADONLY.methodName);
            this.add(JdbcMethod.CONNECTION_GETAUTOCOMMIT.methodName);
            this.add(JdbcMethod.CONNECTION_GETHOLDABILITY.methodName);
            this.add(JdbcMethod.CONNECTION_GETCLIENTINFO.methodName);
            this.add(JdbcMethod.CONNECTION_GETNETWORKTIMEOUT.methodName);
            this.add(JdbcMethod.CONNECTION_GETTYPEMAP.methodName);
            this.add(JdbcMethod.CONNECTION_CREATECLOB.methodName);
            this.add(JdbcMethod.CONNECTION_CREATEBLOB.methodName);
            this.add(JdbcMethod.CONNECTION_CREATENCLOB.methodName);
            this.add(JdbcMethod.CONNECTION_SETHOLDABILITY.methodName);
        }
    });

    @Override
    public boolean isDialect(Driver driver) {
        return DRIVER_CLASS_NAME.equals(driver.getClass().getName());
    }

    @Override
    public boolean isDialect(String dataSourceClass) {
        return DS_CLASS_NAME.equals(dataSourceClass) || CP_DS_CLASS_NAME.equals(dataSourceClass);
    }

    @Override
    public ConnectInfo prepareConnectInfo(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        String databaseName = PropertyDefinition.DATABASE.getString(props) != null ? PropertyDefinition.DATABASE.getString(props) : "";
        String urlBuilder = protocol + hostSpec.getUrl() + databaseName;
        PropertyDefinition.removeAllExcept(props, PropertyDefinition.USER.name, PropertyDefinition.PASSWORD.name, PropertyDefinition.TCP_KEEP_ALIVE.name, PropertyDefinition.SOCKET_TIMEOUT.name, PropertyDefinition.CONNECT_TIMEOUT.name);
        return new ConnectInfo(urlBuilder, props);
    }

    @Override
    public void prepareDataSource(@NonNull DataSource dataSource, @NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        MysqlConnectorJDriverHelper helper = new MysqlConnectorJDriverHelper();
        helper.prepareDataSource(dataSource, hostSpec, props);
    }

    @Override
    public boolean isDriverRegistered() throws SQLException {
        MysqlConnectorJDriverHelper helper = new MysqlConnectorJDriverHelper();
        return helper.isDriverRegistered();
    }

    @Override
    public void registerDriver() throws SQLException {
        MysqlConnectorJDriverHelper helper = new MysqlConnectorJDriverHelper();
        helper.registerDriver();
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean ping(@NonNull Connection connection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Set<String> getAllowedOnConnectionMethodNames() {
        return MYSQL_ALLOWED_ON_CLOSED_METHOD_NAMES;
    }

    @Override
    public String getSQLState(Throwable throwable) {
        MysqlConnectorJDriverHelper helper = new MysqlConnectorJDriverHelper();
        return helper.getSQLState(throwable);
    }
}

