/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm2;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.plugin.efm2.HostMonitor;
import software.amazon.jdbc.plugin.efm2.HostMonitorConnectionContext;
import software.amazon.jdbc.util.ExecutorFactory;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.connection.ConnectionService;
import software.amazon.jdbc.util.monitoring.AbstractMonitor;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class HostMonitorImpl
extends AbstractMonitor
implements HostMonitor {
    private static final Logger LOGGER = Logger.getLogger(HostMonitorImpl.class.getName());
    private static final long THREAD_SLEEP_NANO = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final long TERMINATION_TIMEOUT_SEC = 30L;
    private static final String MONITORING_PROPERTY_PREFIX = "monitoring-";
    protected static final Executor ABORT_EXECUTOR = ExecutorFactory.newSingleThreadExecutor("abort");
    private final Queue<WeakReference<HostMonitorConnectionContext>> activeContexts = new ConcurrentLinkedQueue<WeakReference<HostMonitorConnectionContext>>();
    private final Map<Long, Queue<WeakReference<HostMonitorConnectionContext>>> newContexts = new ConcurrentHashMap<Long, Queue<WeakReference<HostMonitorConnectionContext>>>();
    private final ConnectionService connectionService;
    private final TelemetryFactory telemetryFactory;
    private final Properties properties;
    private final HostSpec hostSpec;
    private Connection monitoringConn = null;
    private final long failureDetectionTimeNano;
    private final long failureDetectionIntervalNano;
    private final int failureDetectionCount;
    private long invalidNodeStartTimeNano;
    private long failureCount;
    private boolean nodeUnhealthy = false;
    private final TelemetryCounter abortedConnectionsCounter;

    public HostMonitorImpl(@NonNull ConnectionService connectionService, @NonNull TelemetryFactory telemetryFactory, @NonNull HostSpec hostSpec, @NonNull Properties properties, int failureDetectionTimeMillis, int failureDetectionIntervalMillis, int failureDetectionCount, TelemetryCounter abortedConnectionsCounter) {
        super(30L, ExecutorFactory.newFixedThreadPool(2, "efm2-monitor"));
        this.connectionService = connectionService;
        this.telemetryFactory = telemetryFactory;
        this.hostSpec = hostSpec;
        this.properties = properties;
        this.failureDetectionTimeNano = TimeUnit.MILLISECONDS.toNanos(failureDetectionTimeMillis);
        this.failureDetectionIntervalNano = TimeUnit.MILLISECONDS.toNanos(failureDetectionIntervalMillis);
        this.failureDetectionCount = failureDetectionCount;
        this.abortedConnectionsCounter = abortedConnectionsCounter;
    }

    @Override
    public boolean canDispose() {
        return this.activeContexts.isEmpty() && this.newContexts.isEmpty();
    }

    @Override
    public void start() {
        this.monitorExecutor.submit(this::newContextRun);
        this.monitorExecutor.submit(this);
        this.monitorExecutor.shutdown();
    }

    @Override
    public void startMonitoring(HostMonitorConnectionContext context) {
        if (this.stop.get()) {
            LOGGER.warning(() -> Messages.get("HostMonitorImpl.monitorIsStopped", new Object[]{this.hostSpec.getHost()}));
        }
        long currentTimeNano = this.getCurrentTimeNano();
        long startMonitoringTimeNano = this.truncateNanoToSeconds(currentTimeNano + this.failureDetectionTimeNano);
        Queue queue = this.newContexts.computeIfAbsent(startMonitoringTimeNano, key -> new ConcurrentLinkedQueue());
        queue.add(new WeakReference<HostMonitorConnectionContext>(context));
    }

    private long truncateNanoToSeconds(long timeNano) {
        return TimeUnit.SECONDS.toNanos(TimeUnit.NANOSECONDS.toSeconds(timeNano));
    }

    long getCurrentTimeNano() {
        return System.nanoTime();
    }

    public void newContextRun() {
        block4: {
            LOGGER.finest(() -> Messages.get("HostMonitorImpl.startMonitoringThreadNewContext", new Object[]{this.hostSpec.getHost()}));
            try {
                while (!this.stop.get()) {
                    long currentTimeNano = this.getCurrentTimeNano();
                    this.lastActivityTimestampNanos.set(currentTimeNano);
                    ArrayList<Long> processedKeys = new ArrayList<Long>();
                    this.newContexts.entrySet().stream().filter(entry -> (Long)entry.getKey() < currentTimeNano).forEach(entry -> {
                        WeakReference contextWeakRef;
                        Queue queue = (Queue)entry.getValue();
                        processedKeys.add((Long)entry.getKey());
                        while ((contextWeakRef = (WeakReference)queue.poll()) != null) {
                            HostMonitorConnectionContext context = (HostMonitorConnectionContext)contextWeakRef.get();
                            if (context == null || !context.isActive()) continue;
                            this.activeContexts.add(contextWeakRef);
                        }
                    });
                    processedKeys.forEach(this.newContexts::remove);
                    TimeUnit.SECONDS.sleep(1L);
                }
            }
            catch (InterruptedException currentTimeNano) {
            }
            catch (Exception ex) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block4;
                LOGGER.log(Level.FINEST, Messages.get("HostMonitorImpl.exceptionDuringMonitoringStop", new Object[]{this.hostSpec.getHost()}), ex);
            }
        }
        LOGGER.finest(() -> Messages.get("HostMonitorImpl.stopMonitoringThreadNewContext", new Object[]{this.hostSpec.getHost()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        LOGGER.finest(() -> Messages.get("HostMonitorImpl.startMonitoringThread", new Object[]{this.hostSpec.getHost()}));
        try {
            while (!this.stop.get()) {
                WeakReference<HostMonitorConnectionContext> monitorContextWeakRef;
                if (this.activeContexts.isEmpty() && !this.nodeUnhealthy) {
                    TimeUnit.NANOSECONDS.sleep(THREAD_SLEEP_NANO);
                    continue;
                }
                long statusCheckStartTimeNano = this.getCurrentTimeNano();
                boolean isValid = this.checkConnectionStatus();
                long statusCheckEndTimeNano = this.getCurrentTimeNano();
                this.updateNodeHealthStatus(isValid, statusCheckStartTimeNano, statusCheckEndTimeNano);
                ArrayList<WeakReference<HostMonitorConnectionContext>> tmpActiveContexts = new ArrayList<WeakReference<HostMonitorConnectionContext>>();
                while ((monitorContextWeakRef = this.activeContexts.poll()) != null && !this.stop.get()) {
                    HostMonitorConnectionContext monitorContext = (HostMonitorConnectionContext)monitorContextWeakRef.get();
                    if (monitorContext == null) continue;
                    if (this.nodeUnhealthy) {
                        monitorContext.setNodeUnhealthy(true);
                        Connection connectionToAbort = monitorContext.getConnection();
                        monitorContext.setInactive();
                        if (connectionToAbort == null) continue;
                        this.abortConnection(connectionToAbort);
                        if (this.abortedConnectionsCounter == null) continue;
                        this.abortedConnectionsCounter.inc();
                        continue;
                    }
                    if (!monitorContext.isActive()) continue;
                    tmpActiveContexts.add(monitorContextWeakRef);
                }
                this.activeContexts.addAll(tmpActiveContexts);
                long delayNano = this.failureDetectionIntervalNano - (statusCheckEndTimeNano - statusCheckStartTimeNano);
                if (delayNano < THREAD_SLEEP_NANO) {
                    delayNano = THREAD_SLEEP_NANO;
                }
                TimeUnit.NANOSECONDS.sleep(delayNano);
            }
        }
        catch (InterruptedException statusCheckStartTimeNano) {
        }
        catch (Exception ex) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, Messages.get("HostMonitorImpl.exceptionDuringMonitoringStop", new Object[]{this.hostSpec.getHost()}), ex);
            }
        }
        finally {
            this.stop.set(true);
            if (this.monitoringConn != null) {
                try {
                    this.monitoringConn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        LOGGER.finest(() -> Messages.get("HostMonitorImpl.stopMonitoringThread", new Object[]{this.hostSpec.getHost()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkConnectionStatus() {
        TelemetryContext connectContext = this.telemetryFactory.openTelemetryContext("connection status check", TelemetryTraceLevel.FORCE_TOP_LEVEL);
        if (connectContext != null) {
            connectContext.setAttribute("url", this.hostSpec.getHost());
        }
        try {
            if (this.monitoringConn == null || this.monitoringConn.isClosed()) {
                Properties monitoringConnProperties = PropertyUtils.copyProperties(this.properties);
                this.properties.stringPropertyNames().stream().filter(p -> p.startsWith(MONITORING_PROPERTY_PREFIX)).forEach(p -> {
                    monitoringConnProperties.put(p.substring(MONITORING_PROPERTY_PREFIX.length()), this.properties.getProperty((String)p));
                    monitoringConnProperties.remove(p);
                });
                LOGGER.finest(() -> "Opening a monitoring connection to " + this.hostSpec.getUrl());
                this.monitoringConn = this.connectionService.open(this.hostSpec, monitoringConnProperties);
                LOGGER.finest(() -> "Opened monitoring connection: " + this.monitoringConn);
                boolean bl = true;
                return bl;
            }
            int validTimeout = (int)TimeUnit.NANOSECONDS.toSeconds(this.failureDetectionIntervalNano - THREAD_SLEEP_NANO) / 2;
            boolean bl = this.monitoringConn.isValid(validTimeout);
            return bl;
        }
        catch (SQLException sqlEx) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (connectContext != null) {
                connectContext.closeContext();
            }
        }
    }

    private void updateNodeHealthStatus(boolean connectionValid, long statusCheckStartNano, long statusCheckEndNano) {
        if (!connectionValid) {
            long maxInvalidNodeDurationNano;
            long invalidNodeDurationNano;
            ++this.failureCount;
            if (this.invalidNodeStartTimeNano == 0L) {
                this.invalidNodeStartTimeNano = statusCheckStartNano;
            }
            if ((invalidNodeDurationNano = statusCheckEndNano - this.invalidNodeStartTimeNano) >= (maxInvalidNodeDurationNano = this.failureDetectionIntervalNano * (long)Math.max(0, this.failureDetectionCount - 1))) {
                LOGGER.fine(() -> Messages.get("HostMonitorConnectionContext.hostDead", new Object[]{this.hostSpec.getHost()}));
                this.nodeUnhealthy = true;
                return;
            }
            LOGGER.finest(() -> Messages.get("HostMonitorConnectionContext.hostNotResponding", new Object[]{this.hostSpec.getHost(), this.failureCount}));
            return;
        }
        if (this.failureCount > 0L) {
            LOGGER.finest(() -> Messages.get("HostMonitorConnectionContext.hostAlive", new Object[]{this.hostSpec.getHost()}));
        }
        this.failureCount = 0L;
        this.invalidNodeStartTimeNano = 0L;
        this.nodeUnhealthy = false;
    }

    private void abortConnection(@NonNull Connection connectionToAbort) {
        try {
            connectionToAbort.abort(ABORT_EXECUTOR);
            connectionToAbort.close();
        }
        catch (SQLException sqlEx) {
            LOGGER.finest(() -> Messages.get("HostMonitorConnectionContext.exceptionAbortingConnection", new Object[]{sqlEx.getMessage()}));
        }
    }

    @Override
    public void close() {
        if (this.monitoringConn != null) {
            try {
                this.monitoringConn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

