/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.StructuredData;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.StructuredDataTerminal;

public class StructuredDataContent {
    private final StructuredDataTerminal Terminal;
    private final List<StructuredData> DataList;
    private final Map<String, StructuredData> DataMap;

    protected StructuredDataContent(BuilderImpl builder) {
        this.Terminal = builder.Terminal();
        this.DataList = builder.DataList();
        this.DataMap = builder.DataMap();
    }

    public StructuredDataTerminal Terminal() {
        return this.Terminal;
    }

    public List<StructuredData> DataList() {
        return this.DataList;
    }

    public Map<String, StructuredData> DataMap() {
        return this.DataMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected StructuredDataTerminal Terminal;
        protected List<StructuredData> DataList;
        protected Map<String, StructuredData> DataMap;

        protected BuilderImpl() {
        }

        protected BuilderImpl(StructuredDataContent model) {
            this.Terminal = model.Terminal();
            this.DataList = model.DataList();
            this.DataMap = model.DataMap();
        }

        @Override
        public Builder Terminal(StructuredDataTerminal Terminal) {
            this.Terminal = Terminal;
            return this;
        }

        @Override
        public StructuredDataTerminal Terminal() {
            return this.Terminal;
        }

        @Override
        public Builder DataList(List<StructuredData> DataList) {
            this.DataList = DataList;
            return this;
        }

        @Override
        public List<StructuredData> DataList() {
            return this.DataList;
        }

        @Override
        public Builder DataMap(Map<String, StructuredData> DataMap) {
            this.DataMap = DataMap;
            return this;
        }

        @Override
        public Map<String, StructuredData> DataMap() {
            return this.DataMap;
        }

        @Override
        public StructuredDataContent build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`StructuredDataContent` is a Union. A Union MUST have one and only one value set.");
            }
            return new StructuredDataContent(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.Terminal, this.DataList, this.DataMap};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder Terminal(StructuredDataTerminal var1);

        public StructuredDataTerminal Terminal();

        public Builder DataList(List<StructuredData> var1);

        public List<StructuredData> DataList();

        public Builder DataMap(Map<String, StructuredData> var1);

        public Map<String, StructuredData> DataMap();

        public StructuredDataContent build();
    }
}

