/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.StructuredDataContent;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.StructuredDataTerminal;

public class StructuredData {
    private final StructuredDataContent content;
    private final Map<String, StructuredDataTerminal> attributes;

    protected StructuredData(BuilderImpl builder) {
        this.content = builder.content();
        this.attributes = builder.attributes();
    }

    public StructuredDataContent content() {
        return this.content;
    }

    public Map<String, StructuredDataTerminal> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected StructuredDataContent content;
        protected Map<String, StructuredDataTerminal> attributes;

        protected BuilderImpl() {
        }

        protected BuilderImpl(StructuredData model) {
            this.content = model.content();
            this.attributes = model.attributes();
        }

        @Override
        public Builder content(StructuredDataContent content) {
            this.content = content;
            return this;
        }

        @Override
        public StructuredDataContent content() {
            return this.content;
        }

        @Override
        public Builder attributes(Map<String, StructuredDataTerminal> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Override
        public Map<String, StructuredDataTerminal> attributes() {
            return this.attributes;
        }

        @Override
        public StructuredData build() {
            if (Objects.isNull(this.content())) {
                throw new IllegalArgumentException("Missing value for required field `content`");
            }
            return new StructuredData(this);
        }
    }

    public static interface Builder {
        public Builder content(StructuredDataContent var1);

        public StructuredDataContent content();

        public Builder attributes(Map<String, StructuredDataTerminal> var1);

        public Map<String, StructuredDataTerminal> attributes();

        public StructuredData build();
    }
}

