/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.ParsedHeader;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.StructuredData;

public class EncryptStructureOutput {
    private final StructuredData encryptedStructure;
    private final ParsedHeader parsedHeader;

    protected EncryptStructureOutput(BuilderImpl builder) {
        this.encryptedStructure = builder.encryptedStructure();
        this.parsedHeader = builder.parsedHeader();
    }

    public StructuredData encryptedStructure() {
        return this.encryptedStructure;
    }

    public ParsedHeader parsedHeader() {
        return this.parsedHeader;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected StructuredData encryptedStructure;
        protected ParsedHeader parsedHeader;

        protected BuilderImpl() {
        }

        protected BuilderImpl(EncryptStructureOutput model) {
            this.encryptedStructure = model.encryptedStructure();
            this.parsedHeader = model.parsedHeader();
        }

        @Override
        public Builder encryptedStructure(StructuredData encryptedStructure) {
            this.encryptedStructure = encryptedStructure;
            return this;
        }

        @Override
        public StructuredData encryptedStructure() {
            return this.encryptedStructure;
        }

        @Override
        public Builder parsedHeader(ParsedHeader parsedHeader) {
            this.parsedHeader = parsedHeader;
            return this;
        }

        @Override
        public ParsedHeader parsedHeader() {
            return this.parsedHeader;
        }

        @Override
        public EncryptStructureOutput build() {
            if (Objects.isNull(this.encryptedStructure())) {
                throw new IllegalArgumentException("Missing value for required field `encryptedStructure`");
            }
            if (Objects.isNull(this.parsedHeader())) {
                throw new IllegalArgumentException("Missing value for required field `parsedHeader`");
            }
            return new EncryptStructureOutput(this);
        }
    }

    public static interface Builder {
        public Builder encryptedStructure(StructuredData var1);

        public StructuredData encryptedStructure();

        public Builder parsedHeader(ParsedHeader var1);

        public ParsedHeader parsedHeader();

        public EncryptStructureOutput build();
    }
}

