/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.ParsedHeader;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.StructuredData;

public class DecryptStructureOutput {
    private final StructuredData plaintextStructure;
    private final ParsedHeader parsedHeader;

    protected DecryptStructureOutput(BuilderImpl builder) {
        this.plaintextStructure = builder.plaintextStructure();
        this.parsedHeader = builder.parsedHeader();
    }

    public StructuredData plaintextStructure() {
        return this.plaintextStructure;
    }

    public ParsedHeader parsedHeader() {
        return this.parsedHeader;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected StructuredData plaintextStructure;
        protected ParsedHeader parsedHeader;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DecryptStructureOutput model) {
            this.plaintextStructure = model.plaintextStructure();
            this.parsedHeader = model.parsedHeader();
        }

        @Override
        public Builder plaintextStructure(StructuredData plaintextStructure) {
            this.plaintextStructure = plaintextStructure;
            return this;
        }

        @Override
        public StructuredData plaintextStructure() {
            return this.plaintextStructure;
        }

        @Override
        public Builder parsedHeader(ParsedHeader parsedHeader) {
            this.parsedHeader = parsedHeader;
            return this;
        }

        @Override
        public ParsedHeader parsedHeader() {
            return this.parsedHeader;
        }

        @Override
        public DecryptStructureOutput build() {
            if (Objects.isNull(this.plaintextStructure())) {
                throw new IllegalArgumentException("Missing value for required field `plaintextStructure`");
            }
            if (Objects.isNull(this.parsedHeader())) {
                throw new IllegalArgumentException("Missing value for required field `parsedHeader`");
            }
            return new DecryptStructureOutput(this);
        }
    }

    public static interface Builder {
        public Builder plaintextStructure(StructuredData var1);

        public StructuredData plaintextStructure();

        public Builder parsedHeader(ParsedHeader var1);

        public ParsedHeader parsedHeader();

        public DecryptStructureOutput build();
    }
}

