/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoAction;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoSchema;

public class CryptoSchemaContent {
    private final CryptoAction Action;
    private final Map<String, CryptoSchema> SchemaMap;
    private final List<CryptoSchema> SchemaList;

    protected CryptoSchemaContent(BuilderImpl builder) {
        this.Action = builder.Action();
        this.SchemaMap = builder.SchemaMap();
        this.SchemaList = builder.SchemaList();
    }

    public CryptoAction Action() {
        return this.Action;
    }

    public Map<String, CryptoSchema> SchemaMap() {
        return this.SchemaMap;
    }

    public List<CryptoSchema> SchemaList() {
        return this.SchemaList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected CryptoAction Action;
        protected Map<String, CryptoSchema> SchemaMap;
        protected List<CryptoSchema> SchemaList;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CryptoSchemaContent model) {
            this.Action = model.Action();
            this.SchemaMap = model.SchemaMap();
            this.SchemaList = model.SchemaList();
        }

        @Override
        public Builder Action(CryptoAction Action) {
            this.Action = Action;
            return this;
        }

        @Override
        public CryptoAction Action() {
            return this.Action;
        }

        @Override
        public Builder SchemaMap(Map<String, CryptoSchema> SchemaMap) {
            this.SchemaMap = SchemaMap;
            return this;
        }

        @Override
        public Map<String, CryptoSchema> SchemaMap() {
            return this.SchemaMap;
        }

        @Override
        public Builder SchemaList(List<CryptoSchema> SchemaList) {
            this.SchemaList = SchemaList;
            return this;
        }

        @Override
        public List<CryptoSchema> SchemaList() {
            return this.SchemaList;
        }

        @Override
        public CryptoSchemaContent build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`CryptoSchemaContent` is a Union. A Union MUST have one and only one value set.");
            }
            return new CryptoSchemaContent(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.Action, this.SchemaMap, this.SchemaList};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder Action(CryptoAction var1);

        public CryptoAction Action();

        public Builder SchemaMap(Map<String, CryptoSchema> var1);

        public Map<String, CryptoSchema> SchemaMap();

        public Builder SchemaList(List<CryptoSchema> var1);

        public List<CryptoSchema> SchemaList();

        public CryptoSchemaContent build();
    }
}

