/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.AuthenticateAction;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoSchemaContent;

public class CryptoSchema {
    private final CryptoSchemaContent content;
    private final Map<String, AuthenticateAction> attributes;

    protected CryptoSchema(BuilderImpl builder) {
        this.content = builder.content();
        this.attributes = builder.attributes();
    }

    public CryptoSchemaContent content() {
        return this.content;
    }

    public Map<String, AuthenticateAction> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected CryptoSchemaContent content;
        protected Map<String, AuthenticateAction> attributes;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CryptoSchema model) {
            this.content = model.content();
            this.attributes = model.attributes();
        }

        @Override
        public Builder content(CryptoSchemaContent content) {
            this.content = content;
            return this;
        }

        @Override
        public CryptoSchemaContent content() {
            return this.content;
        }

        @Override
        public Builder attributes(Map<String, AuthenticateAction> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Override
        public Map<String, AuthenticateAction> attributes() {
            return this.attributes;
        }

        @Override
        public CryptoSchema build() {
            if (Objects.isNull(this.content())) {
                throw new IllegalArgumentException("Missing value for required field `content`");
            }
            return new CryptoSchema(this);
        }
    }

    public static interface Builder {
        public Builder content(CryptoSchemaContent var1);

        public CryptoSchemaContent content();

        public Builder attributes(Map<String, AuthenticateAction> var1);

        public Map<String, AuthenticateAction> attributes();

        public CryptoSchema build();
    }
}

