/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types;

import Wrappers_Compile.Option;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredData;
import software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager;

public class EncryptStructureInput {
    public DafnySequence<? extends Character> _tableName;
    public StructuredData _plaintextStructure;
    public CryptoSchema _cryptoSchema;
    public ICryptographicMaterialsManager _cmm;
    public Option<DBEAlgorithmSuiteId> _algorithmSuiteId;
    public Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>> _encryptionContext;
    private static final EncryptStructureInput theDefault = EncryptStructureInput.create((DafnySequence<? extends Character>)DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR), StructuredData.Default(), CryptoSchema.Default(), null, (Option<DBEAlgorithmSuiteId>)Option.Default(), (Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>>)Option.Default());
    private static final TypeDescriptor<EncryptStructureInput> _TYPE = TypeDescriptor.referenceWithInitializer(EncryptStructureInput.class, () -> EncryptStructureInput.Default());

    public EncryptStructureInput(DafnySequence<? extends Character> tableName, StructuredData plaintextStructure, CryptoSchema cryptoSchema, ICryptographicMaterialsManager cmm, Option<DBEAlgorithmSuiteId> algorithmSuiteId, Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>> encryptionContext) {
        this._tableName = tableName;
        this._plaintextStructure = plaintextStructure;
        this._cryptoSchema = cryptoSchema;
        this._cmm = cmm;
        this._algorithmSuiteId = algorithmSuiteId;
        this._encryptionContext = encryptionContext;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        EncryptStructureInput o = (EncryptStructureInput)other;
        return Objects.equals(this._tableName, o._tableName) && Objects.equals(this._plaintextStructure, o._plaintextStructure) && Objects.equals(this._cryptoSchema, o._cryptoSchema) && this._cmm == o._cmm && Objects.equals(this._algorithmSuiteId, o._algorithmSuiteId) && Objects.equals(this._encryptionContext, o._encryptionContext);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._tableName);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._plaintextStructure);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._cryptoSchema);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._cmm);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._algorithmSuiteId);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._encryptionContext);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types_Compile.EncryptStructureInput.EncryptStructureInput");
        s.append("(");
        s.append(Helpers.toString(this._tableName));
        s.append(", ");
        s.append(Helpers.toString((Object)this._plaintextStructure));
        s.append(", ");
        s.append(Helpers.toString((Object)this._cryptoSchema));
        s.append(", ");
        s.append(Helpers.toString((Object)this._cmm));
        s.append(", ");
        s.append(Helpers.toString(this._algorithmSuiteId));
        s.append(", ");
        s.append(Helpers.toString(this._encryptionContext));
        s.append(")");
        return s.toString();
    }

    public static EncryptStructureInput Default() {
        return theDefault;
    }

    public static TypeDescriptor<EncryptStructureInput> _typeDescriptor() {
        return _TYPE;
    }

    public static EncryptStructureInput create(DafnySequence<? extends Character> tableName, StructuredData plaintextStructure, CryptoSchema cryptoSchema, ICryptographicMaterialsManager cmm, Option<DBEAlgorithmSuiteId> algorithmSuiteId, Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>> encryptionContext) {
        return new EncryptStructureInput(tableName, plaintextStructure, cryptoSchema, cmm, algorithmSuiteId, encryptionContext);
    }

    public static EncryptStructureInput create_EncryptStructureInput(DafnySequence<? extends Character> tableName, StructuredData plaintextStructure, CryptoSchema cryptoSchema, ICryptographicMaterialsManager cmm, Option<DBEAlgorithmSuiteId> algorithmSuiteId, Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>> encryptionContext) {
        return EncryptStructureInput.create(tableName, plaintextStructure, cryptoSchema, cmm, algorithmSuiteId, encryptionContext);
    }

    public boolean is_EncryptStructureInput() {
        return true;
    }

    public DafnySequence<? extends Character> dtor_tableName() {
        return this._tableName;
    }

    public StructuredData dtor_plaintextStructure() {
        return this._plaintextStructure;
    }

    public CryptoSchema dtor_cryptoSchema() {
        return this._cryptoSchema;
    }

    public ICryptographicMaterialsManager dtor_cmm() {
        return this._cmm;
    }

    public Option<DBEAlgorithmSuiteId> dtor_algorithmSuiteId() {
        return this._algorithmSuiteId;
    }

    public Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>> dtor_encryptionContext() {
        return this._encryptionContext;
    }
}

