/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model;

import java.util.Objects;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

public class QueryOutputTransformInput {
    private final QueryResponse sdkOutput;
    private final QueryRequest originalInput;

    protected QueryOutputTransformInput(BuilderImpl builder) {
        this.sdkOutput = builder.sdkOutput();
        this.originalInput = builder.originalInput();
    }

    public QueryResponse sdkOutput() {
        return this.sdkOutput;
    }

    public QueryRequest originalInput() {
        return this.originalInput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected QueryResponse sdkOutput;
        protected QueryRequest originalInput;

        protected BuilderImpl() {
        }

        protected BuilderImpl(QueryOutputTransformInput model) {
            this.sdkOutput = model.sdkOutput();
            this.originalInput = model.originalInput();
        }

        @Override
        public Builder sdkOutput(QueryResponse sdkOutput) {
            this.sdkOutput = sdkOutput;
            return this;
        }

        @Override
        public QueryResponse sdkOutput() {
            return this.sdkOutput;
        }

        @Override
        public Builder originalInput(QueryRequest originalInput) {
            this.originalInput = originalInput;
            return this;
        }

        @Override
        public QueryRequest originalInput() {
            return this.originalInput;
        }

        @Override
        public QueryOutputTransformInput build() {
            if (Objects.isNull(this.sdkOutput())) {
                throw new IllegalArgumentException("Missing value for required field `sdkOutput`");
            }
            if (Objects.isNull(this.originalInput())) {
                throw new IllegalArgumentException("Missing value for required field `originalInput`");
            }
            return new QueryOutputTransformInput(this);
        }
    }

    public static interface Builder {
        public Builder sdkOutput(QueryResponse var1);

        public QueryResponse sdkOutput();

        public Builder originalInput(QueryRequest var1);

        public QueryRequest originalInput();

        public QueryOutputTransformInput build();
    }
}

