/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.Objects;

public class SingleKeyStore {
    private final String keyId;
    private final Integer cacheTTL;

    protected SingleKeyStore(BuilderImpl builder) {
        this.keyId = builder.keyId();
        this.cacheTTL = builder.cacheTTL();
    }

    public String keyId() {
        return this.keyId;
    }

    public Integer cacheTTL() {
        return this.cacheTTL;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String keyId;
        protected Integer cacheTTL;

        protected BuilderImpl() {
        }

        protected BuilderImpl(SingleKeyStore model) {
            this.keyId = model.keyId();
            this.cacheTTL = model.cacheTTL();
        }

        @Override
        public Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        @Override
        public String keyId() {
            return this.keyId;
        }

        @Override
        public Builder cacheTTL(Integer cacheTTL) {
            this.cacheTTL = cacheTTL;
            return this;
        }

        @Override
        public Integer cacheTTL() {
            return this.cacheTTL;
        }

        @Override
        public SingleKeyStore build() {
            if (Objects.isNull(this.keyId())) {
                throw new IllegalArgumentException("Missing value for required field `keyId`");
            }
            if (Objects.isNull(this.cacheTTL())) {
                throw new IllegalArgumentException("Missing value for required field `cacheTTL`");
            }
            return new SingleKeyStore(this);
        }
    }

    public static interface Builder {
        public Builder keyId(String var1);

        public String keyId();

        public Builder cacheTTL(Integer var1);

        public Integer cacheTTL();

        public SingleKeyStore build();
    }
}

