/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.List;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.BeaconKeySource;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.CompoundBeacon;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.StandardBeacon;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.VirtualField;
import software.amazon.cryptography.keystore.KeyStore;

public class BeaconVersion {
    private final int version;
    private final KeyStore keyStore;
    private final BeaconKeySource keySource;
    private final List<StandardBeacon> standardBeacons;
    private final List<CompoundBeacon> compoundBeacons;
    private final List<VirtualField> virtualFields;

    protected BeaconVersion(BuilderImpl builder) {
        this.version = builder.version();
        this.keyStore = builder.keyStore();
        this.keySource = builder.keySource();
        this.standardBeacons = builder.standardBeacons();
        this.compoundBeacons = builder.compoundBeacons();
        this.virtualFields = builder.virtualFields();
    }

    public int version() {
        return this.version;
    }

    public KeyStore keyStore() {
        return this.keyStore;
    }

    public BeaconKeySource keySource() {
        return this.keySource;
    }

    public List<StandardBeacon> standardBeacons() {
        return this.standardBeacons;
    }

    public List<CompoundBeacon> compoundBeacons() {
        return this.compoundBeacons;
    }

    public List<VirtualField> virtualFields() {
        return this.virtualFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected int version;
        private boolean _versionSet = false;
        protected KeyStore keyStore;
        protected BeaconKeySource keySource;
        protected List<StandardBeacon> standardBeacons;
        protected List<CompoundBeacon> compoundBeacons;
        protected List<VirtualField> virtualFields;

        protected BuilderImpl() {
        }

        protected BuilderImpl(BeaconVersion model) {
            this.version = model.version();
            this._versionSet = true;
            this.keyStore = model.keyStore();
            this.keySource = model.keySource();
            this.standardBeacons = model.standardBeacons();
            this.compoundBeacons = model.compoundBeacons();
            this.virtualFields = model.virtualFields();
        }

        @Override
        public Builder version(int version) {
            this.version = version;
            this._versionSet = true;
            return this;
        }

        @Override
        public int version() {
            return this.version;
        }

        @Override
        public Builder keyStore(KeyStore keyStore) {
            this.keyStore = keyStore;
            return this;
        }

        @Override
        public KeyStore keyStore() {
            return this.keyStore;
        }

        @Override
        public Builder keySource(BeaconKeySource keySource) {
            this.keySource = keySource;
            return this;
        }

        @Override
        public BeaconKeySource keySource() {
            return this.keySource;
        }

        @Override
        public Builder standardBeacons(List<StandardBeacon> standardBeacons) {
            this.standardBeacons = standardBeacons;
            return this;
        }

        @Override
        public List<StandardBeacon> standardBeacons() {
            return this.standardBeacons;
        }

        @Override
        public Builder compoundBeacons(List<CompoundBeacon> compoundBeacons) {
            this.compoundBeacons = compoundBeacons;
            return this;
        }

        @Override
        public List<CompoundBeacon> compoundBeacons() {
            return this.compoundBeacons;
        }

        @Override
        public Builder virtualFields(List<VirtualField> virtualFields) {
            this.virtualFields = virtualFields;
            return this;
        }

        @Override
        public List<VirtualField> virtualFields() {
            return this.virtualFields;
        }

        @Override
        public BeaconVersion build() {
            if (!this._versionSet) {
                throw new IllegalArgumentException("Missing value for required field `version`");
            }
            if (this._versionSet && this.version() < 1) {
                throw new IllegalArgumentException("`version` must be greater than or equal to 1");
            }
            if (Objects.isNull(this.keyStore())) {
                throw new IllegalArgumentException("Missing value for required field `keyStore`");
            }
            if (Objects.isNull(this.keySource())) {
                throw new IllegalArgumentException("Missing value for required field `keySource`");
            }
            if (Objects.isNull(this.standardBeacons())) {
                throw new IllegalArgumentException("Missing value for required field `standardBeacons`");
            }
            if (Objects.nonNull(this.standardBeacons()) && this.standardBeacons().size() < 1) {
                throw new IllegalArgumentException("The size of `standardBeacons` must be greater than or equal to 1");
            }
            if (Objects.nonNull(this.compoundBeacons()) && this.compoundBeacons().size() < 1) {
                throw new IllegalArgumentException("The size of `compoundBeacons` must be greater than or equal to 1");
            }
            if (Objects.nonNull(this.virtualFields()) && this.virtualFields().size() < 1) {
                throw new IllegalArgumentException("The size of `virtualFields` must be greater than or equal to 1");
            }
            return new BeaconVersion(this);
        }
    }

    public static interface Builder {
        public Builder version(int var1);

        public int version();

        public Builder keyStore(KeyStore var1);

        public KeyStore keyStore();

        public Builder keySource(BeaconKeySource var1);

        public BeaconKeySource keySource();

        public Builder standardBeacons(List<StandardBeacon> var1);

        public List<StandardBeacon> standardBeacons();

        public Builder compoundBeacons(List<CompoundBeacon> var1);

        public List<CompoundBeacon> compoundBeacons();

        public Builder virtualFields(List<VirtualField> var1);

        public List<VirtualField> virtualFields();

        public BeaconVersion build();
    }
}

