/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types;

import Wrappers_Compile.Option;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.BeaconKeySource;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.CompoundBeacon;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.StandardBeacon;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualField;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;

public class BeaconVersion {
    public int _version;
    public IKeyStoreClient _keyStore;
    public BeaconKeySource _keySource;
    public DafnySequence<? extends StandardBeacon> _standardBeacons;
    public Option<DafnySequence<? extends CompoundBeacon>> _compoundBeacons;
    public Option<DafnySequence<? extends VirtualField>> _virtualFields;
    private static final BeaconVersion theDefault = BeaconVersion.create(0, null, BeaconKeySource.Default(), (DafnySequence<? extends StandardBeacon>)DafnySequence.empty(StandardBeacon._typeDescriptor()), (Option<DafnySequence<? extends CompoundBeacon>>)Option.Default(), (Option<DafnySequence<? extends VirtualField>>)Option.Default());
    private static final TypeDescriptor<BeaconVersion> _TYPE = TypeDescriptor.referenceWithInitializer(BeaconVersion.class, () -> BeaconVersion.Default());

    public BeaconVersion(int version, IKeyStoreClient keyStore, BeaconKeySource keySource, DafnySequence<? extends StandardBeacon> standardBeacons, Option<DafnySequence<? extends CompoundBeacon>> compoundBeacons, Option<DafnySequence<? extends VirtualField>> virtualFields) {
        this._version = version;
        this._keyStore = keyStore;
        this._keySource = keySource;
        this._standardBeacons = standardBeacons;
        this._compoundBeacons = compoundBeacons;
        this._virtualFields = virtualFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        BeaconVersion o = (BeaconVersion)other;
        return this._version == o._version && this._keyStore == o._keyStore && Objects.equals(this._keySource, o._keySource) && Objects.equals(this._standardBeacons, o._standardBeacons) && Objects.equals(this._compoundBeacons, o._compoundBeacons) && Objects.equals(this._virtualFields, o._virtualFields);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._version);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._keyStore);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._keySource);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._standardBeacons);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._compoundBeacons);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._virtualFields);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types_Compile.BeaconVersion.BeaconVersion");
        s.append("(");
        s.append(this._version);
        s.append(", ");
        s.append(Helpers.toString((Object)this._keyStore));
        s.append(", ");
        s.append(Helpers.toString((Object)this._keySource));
        s.append(", ");
        s.append(Helpers.toString(this._standardBeacons));
        s.append(", ");
        s.append(Helpers.toString(this._compoundBeacons));
        s.append(", ");
        s.append(Helpers.toString(this._virtualFields));
        s.append(")");
        return s.toString();
    }

    public static BeaconVersion Default() {
        return theDefault;
    }

    public static TypeDescriptor<BeaconVersion> _typeDescriptor() {
        return _TYPE;
    }

    public static BeaconVersion create(int version, IKeyStoreClient keyStore, BeaconKeySource keySource, DafnySequence<? extends StandardBeacon> standardBeacons, Option<DafnySequence<? extends CompoundBeacon>> compoundBeacons, Option<DafnySequence<? extends VirtualField>> virtualFields) {
        return new BeaconVersion(version, keyStore, keySource, standardBeacons, compoundBeacons, virtualFields);
    }

    public static BeaconVersion create_BeaconVersion(int version, IKeyStoreClient keyStore, BeaconKeySource keySource, DafnySequence<? extends StandardBeacon> standardBeacons, Option<DafnySequence<? extends CompoundBeacon>> compoundBeacons, Option<DafnySequence<? extends VirtualField>> virtualFields) {
        return BeaconVersion.create(version, keyStore, keySource, standardBeacons, compoundBeacons, virtualFields);
    }

    public boolean is_BeaconVersion() {
        return true;
    }

    public int dtor_version() {
        return this._version;
    }

    public IKeyStoreClient dtor_keyStore() {
        return this._keyStore;
    }

    public BeaconKeySource dtor_keySource() {
        return this._keySource;
    }

    public DafnySequence<? extends StandardBeacon> dtor_standardBeacons() {
        return this._standardBeacons;
    }

    public Option<DafnySequence<? extends CompoundBeacon>> dtor_compoundBeacons() {
        return this._compoundBeacons;
    }

    public Option<DafnySequence<? extends VirtualField>> dtor_virtualFields() {
        return this._virtualFields;
    }
}

