/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.enhancedclient;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.IndexMetadata;
import software.amazon.awssdk.enhanced.dynamodb.KeyAttributeMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.DynamoDbEncryptionInterceptor;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.enhancedclient.CreateDynamoDbEncryptionInterceptorInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.enhancedclient.DynamoDbEnhancedTableEncryptionConfig;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.DynamoDbEncryptionException;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.DynamoDbTableEncryptionConfig;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.DynamoDbTablesEncryptionConfig;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoAction;
import software.amazon.cryptography.materialproviders.ICryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.IKeyring;

public class DynamoDbEnhancedClientEncryption {
    public static DynamoDbEncryptionInterceptor CreateDynamoDbEncryptionInterceptor(CreateDynamoDbEncryptionInterceptorInput input) {
        HashMap<String, DynamoDbTableEncryptionConfig> tableConfigs = new HashMap<String, DynamoDbTableEncryptionConfig>();
        input.tableEncryptionConfigs().forEach((name, config) -> tableConfigs.put((String)name, DynamoDbEnhancedClientEncryption.getTableConfig(config, name)));
        return DynamoDbEncryptionInterceptor.builder().config(DynamoDbTablesEncryptionConfig.builder().tableEncryptionConfigs(tableConfigs).build()).build();
    }

    private static Set<String> attributeNamesUsedInIndices(TableMetadata tableMetadata) {
        HashSet<String> allIndexAttributes = new HashSet<String>();
        tableMetadata.indices().stream().map(IndexMetadata::partitionKey).filter(Optional::isPresent).map(Optional::get).map(KeyAttributeMetadata::name).forEach(allIndexAttributes::add);
        tableMetadata.indices().stream().map(IndexMetadata::sortKey).filter(Optional::isPresent).map(Optional::get).map(KeyAttributeMetadata::name).forEach(allIndexAttributes::add);
        return allIndexAttributes;
    }

    private static DynamoDbTableEncryptionConfig getTableConfig(DynamoDbEnhancedTableEncryptionConfig configWithSchema, String tableName) {
        HashMap<String, CryptoAction> actions = new HashMap<String, CryptoAction>();
        TableSchema<?> topTableSchema = configWithSchema.schemaOnEncrypt();
        Set<String> signOnlyAttributes = DynamoDbEnhancedClientEncryption.getSignOnlyAttributes(topTableSchema);
        Set<String> doNothingAttributes = DynamoDbEnhancedClientEncryption.getDoNothingAttributes(topTableSchema);
        Set<String> keyAttributes = DynamoDbEnhancedClientEncryption.attributeNamesUsedInIndices(topTableSchema.tableMetadata());
        if (!Collections.disjoint(keyAttributes, doNothingAttributes)) {
            throw DynamoDbEncryptionException.builder().message(String.format("Cannot use @DynamoDbEncryptionDoNothing on primary key attributes. Found on Table Name: %s", tableName)).build();
        }
        if (!Collections.disjoint(signOnlyAttributes, doNothingAttributes)) {
            throw DynamoDbEncryptionException.builder().message(String.format("Cannot use @DynamoDbEncryptionDoNothing and @DynamoDbEncryptionSignOnly on same attribute. Found on Table Name: %s", tableName)).build();
        }
        List attributeNames = topTableSchema.attributeNames();
        StringBuilder path = new StringBuilder();
        path.append(tableName).append(".");
        for (String attributeName : attributeNames) {
            if (keyAttributes.contains(attributeName)) {
                actions.put(attributeName, CryptoAction.SIGN_ONLY);
            } else if (signOnlyAttributes.contains(attributeName)) {
                actions.put(attributeName, CryptoAction.SIGN_ONLY);
            } else if (doNothingAttributes.contains(attributeName)) {
                actions.put(attributeName, CryptoAction.DO_NOTHING);
            } else {
                actions.put(attributeName, CryptoAction.ENCRYPT_AND_SIGN);
            }
            DynamoDbEnhancedClientEncryption.scanForIgnoredEncryptionTags(topTableSchema, attributeName, path);
        }
        DynamoDbTableEncryptionConfig.Builder builder = DynamoDbTableEncryptionConfig.builder();
        String partitionName = topTableSchema.tableMetadata().primaryPartitionKey();
        builder = builder.partitionKeyName(partitionName);
        Optional sortName = topTableSchema.tableMetadata().primarySortKey();
        if (sortName.isPresent()) {
            builder = builder.sortKeyName((String)sortName.get());
        }
        if (!Objects.isNull(configWithSchema.keyring())) {
            builder = builder.keyring((IKeyring)configWithSchema.keyring());
        }
        if (!Objects.isNull(configWithSchema.cmm())) {
            builder = builder.cmm((ICryptographicMaterialsManager)configWithSchema.cmm());
        }
        if (!Objects.isNull(configWithSchema.logicalTableName())) {
            builder = builder.logicalTableName(configWithSchema.logicalTableName());
        }
        if (!Objects.isNull((Object)configWithSchema.plaintextOverride())) {
            builder = builder.plaintextOverride(configWithSchema.plaintextOverride());
        }
        return builder.allowedUnsignedAttributePrefix(configWithSchema.allowedUnsignedAttributePrefix()).allowedUnsignedAttributes(configWithSchema.allowedUnsignedAttributes()).attributeActionsOnEncrypt(actions).legacyOverride(configWithSchema.legacyOverride()).build();
    }

    private static Set<String> getSignOnlyAttributes(TableSchema<?> tableSchema) {
        return tableSchema.tableMetadata().customMetadataObject("DynamoDbEncryption:SortOnly", Set.class).orElseGet(HashSet::new);
    }

    private static Set<String> getDoNothingAttributes(TableSchema<?> tableSchema) {
        return tableSchema.tableMetadata().customMetadataObject("DynamoDbEncryption:DoNothing", Set.class).orElseGet(HashSet::new);
    }

    private static void scanForIgnoredEncryptionTags(TableSchema<?> tableSchema, String attributeName, StringBuilder path) {
        AttributeConverter attributeConverter = tableSchema.converterForAttribute((Object)attributeName);
        StringBuilder attributePath = new StringBuilder(path).append(attributeName).append(".");
        if (Objects.nonNull(attributeConverter) && Objects.nonNull(attributeConverter.type()) && attributeConverter.type().tableSchema().isPresent()) {
            TableSchema subTableSchema = (TableSchema)attributeConverter.type().tableSchema().get();
            Set<String> signOnlyAttributes = DynamoDbEnhancedClientEncryption.getSignOnlyAttributes(subTableSchema);
            if (signOnlyAttributes.size() > 0) {
                throw DynamoDbEncryptionException.builder().message(String.format("Detected DynamoDbEncryption Tag %s on a nested attribute with Path %s. This is NOT Supported at this time!", "DynamoDbEncryption:SortOnly", attributePath.append(signOnlyAttributes.toArray()[0]))).build();
            }
            Set<String> doNothingAttributes = DynamoDbEnhancedClientEncryption.getDoNothingAttributes(subTableSchema);
            if (doNothingAttributes.size() > 0) {
                throw DynamoDbEncryptionException.builder().message(String.format("Detected DynamoDbEncryption Tag %s on a nested attribute with Path %s. This is NOT Supported at this time!", "DynamoDbEncryption:DoNothing", attributePath.append(doNothingAttributes.toArray()[0]))).build();
            }
            List subAttributeNames = subTableSchema.attributeNames();
            for (String subAttributeName : subAttributeNames) {
                DynamoDbEnhancedClientEncryption.scanForIgnoredEncryptionTags(subTableSchema, subAttributeName, attributePath);
            }
        }
    }
}

