/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.AwsResponseMetadata;
import software.amazon.awssdk.core.ClientType;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.DynamoDbEncryptionExecutionAttribute;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.SupportedOperations;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.DynamoDbTablesEncryptionConfig;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.DynamoDbEncryptionTransforms;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.BatchExecuteStatementInputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.BatchExecuteStatementOutputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.BatchGetItemInputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.BatchGetItemOutputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.BatchWriteItemInputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.BatchWriteItemOutputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.DeleteItemInputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.DynamoDbEncryptionTransformsException;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.ExecuteStatementInputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.ExecuteStatementOutputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.ExecuteTransactionInputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.ExecuteTransactionOutputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.GetItemInputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.GetItemOutputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.PutItemInputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.PutItemOutputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.QueryInputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.QueryOutputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.ScanInputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.ScanOutputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.TransactGetItemsInputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.TransactGetItemsOutputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.TransactWriteItemsInputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.TransactWriteItemsOutputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.UpdateItemInputTransformInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model.UpdateItemOutputTransformInput;

public class DynamoDbEncryptionInterceptor
implements ExecutionInterceptor {
    private final DynamoDbTablesEncryptionConfig config;
    private DynamoDbEncryptionTransforms transformer;
    static final String DDB_NAME = "DynamoDb";

    protected DynamoDbEncryptionInterceptor(BuilderImpl builder) {
        this.config = builder.config();
        this.transformer = DynamoDbEncryptionTransforms.builder().DynamoDbTablesEncryptionConfig(this.config).build();
    }

    public DynamoDbTablesEncryptionConfig config() {
        return this.config;
    }

    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        SdkRequest outgoingRequest;
        SdkRequest originalRequest = context.request();
        if (!((String)executionAttributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME)).equals(DDB_NAME)) {
            throw DynamoDbEncryptionTransformsException.builder().message("DynamoDbEncryptionInterceptor does not support use with services other than DynamoDb.").build();
        }
        if (!((ClientType)executionAttributes.getAttribute(SdkExecutionAttribute.CLIENT_TYPE)).equals((Object)ClientType.SYNC)) {
            throw DynamoDbEncryptionTransformsException.builder().message("DynamoDbEncryptionInterceptor does not support use with the Async client.").build();
        }
        executionAttributes.putAttribute(DynamoDbEncryptionExecutionAttribute.ORIGINAL_REQUEST, (Object)originalRequest);
        String operationName = (String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME);
        this.checkSupportedOperation(operationName);
        switch (operationName) {
            case "BatchExecuteStatement": {
                BatchExecuteStatementRequest transformedRequest = this.transformer.BatchExecuteStatementInputTransform(BatchExecuteStatementInputTransformInput.builder().sdkInput((BatchExecuteStatementRequest)originalRequest).build()).transformedInput();
                outgoingRequest = this.copyOverrideConfig((AwsRequest)((BatchExecuteStatementRequest)originalRequest), (AwsRequest)transformedRequest);
                break;
            }
            case "BatchGetItem": {
                BatchGetItemRequest transformedRequest = this.transformer.BatchGetItemInputTransform(BatchGetItemInputTransformInput.builder().sdkInput((BatchGetItemRequest)originalRequest).build()).transformedInput();
                outgoingRequest = this.copyOverrideConfig((AwsRequest)((BatchGetItemRequest)originalRequest), (AwsRequest)transformedRequest);
                break;
            }
            case "BatchWriteItem": {
                BatchWriteItemRequest transformedRequest = this.transformer.BatchWriteItemInputTransform(BatchWriteItemInputTransformInput.builder().sdkInput((BatchWriteItemRequest)originalRequest).build()).transformedInput();
                outgoingRequest = this.copyOverrideConfig((AwsRequest)((BatchWriteItemRequest)originalRequest), (AwsRequest)transformedRequest);
                break;
            }
            case "DeleteItem": {
                DeleteItemRequest transformedRequest = this.transformer.DeleteItemInputTransform(DeleteItemInputTransformInput.builder().sdkInput((DeleteItemRequest)originalRequest).build()).transformedInput();
                outgoingRequest = this.copyOverrideConfig((AwsRequest)((DeleteItemRequest)originalRequest), (AwsRequest)transformedRequest);
                break;
            }
            case "ExecuteStatement": {
                ExecuteStatementRequest transformedRequest = this.transformer.ExecuteStatementInputTransform(ExecuteStatementInputTransformInput.builder().sdkInput((ExecuteStatementRequest)originalRequest).build()).transformedInput();
                outgoingRequest = this.copyOverrideConfig((AwsRequest)((ExecuteStatementRequest)originalRequest), (AwsRequest)transformedRequest);
                break;
            }
            case "ExecuteTransaction": {
                ExecuteTransactionRequest transformedRequest = this.transformer.ExecuteTransactionInputTransform(ExecuteTransactionInputTransformInput.builder().sdkInput((ExecuteTransactionRequest)originalRequest).build()).transformedInput();
                outgoingRequest = this.copyOverrideConfig((AwsRequest)((ExecuteTransactionRequest)originalRequest), (AwsRequest)transformedRequest);
                break;
            }
            case "GetItem": {
                GetItemRequest transformedRequest = this.transformer.GetItemInputTransform(GetItemInputTransformInput.builder().sdkInput((GetItemRequest)originalRequest).build()).transformedInput();
                outgoingRequest = this.copyOverrideConfig((AwsRequest)((GetItemRequest)originalRequest), (AwsRequest)transformedRequest);
                break;
            }
            case "PutItem": {
                PutItemRequest transformedRequest = this.transformer.PutItemInputTransform(PutItemInputTransformInput.builder().sdkInput((PutItemRequest)originalRequest).build()).transformedInput();
                outgoingRequest = this.copyOverrideConfig((AwsRequest)((PutItemRequest)originalRequest), (AwsRequest)transformedRequest);
                break;
            }
            case "Query": {
                QueryRequest queryRequest = (QueryRequest)originalRequest;
                QueryRequest transformedRequest = this.transformer.QueryInputTransform(QueryInputTransformInput.builder().sdkInput(queryRequest).build()).transformedInput();
                transformedRequest = (QueryRequest)transformedRequest.toBuilder().exclusiveStartKey(queryRequest.exclusiveStartKey()).build();
                outgoingRequest = this.copyOverrideConfig((AwsRequest)queryRequest, (AwsRequest)transformedRequest);
                break;
            }
            case "Scan": {
                ScanRequest scanRequest = (ScanRequest)originalRequest;
                ScanRequest transformedRequest = this.transformer.ScanInputTransform(ScanInputTransformInput.builder().sdkInput(scanRequest).build()).transformedInput();
                transformedRequest = (ScanRequest)transformedRequest.toBuilder().exclusiveStartKey(scanRequest.exclusiveStartKey()).build();
                outgoingRequest = this.copyOverrideConfig((AwsRequest)scanRequest, (AwsRequest)transformedRequest);
                break;
            }
            case "TransactGetItems": {
                TransactGetItemsRequest transformedRequest = this.transformer.TransactGetItemsInputTransform(TransactGetItemsInputTransformInput.builder().sdkInput((TransactGetItemsRequest)originalRequest).build()).transformedInput();
                outgoingRequest = this.copyOverrideConfig((AwsRequest)((TransactGetItemsRequest)originalRequest), (AwsRequest)transformedRequest);
                break;
            }
            case "TransactWriteItems": {
                TransactWriteItemsRequest transformedRequest = this.transformer.TransactWriteItemsInputTransform(TransactWriteItemsInputTransformInput.builder().sdkInput((TransactWriteItemsRequest)originalRequest).build()).transformedInput();
                outgoingRequest = this.copyOverrideConfig((AwsRequest)((TransactWriteItemsRequest)originalRequest), (AwsRequest)transformedRequest);
                break;
            }
            case "UpdateItem": {
                UpdateItemRequest transformedRequest = this.transformer.UpdateItemInputTransform(UpdateItemInputTransformInput.builder().sdkInput((UpdateItemRequest)originalRequest).build()).transformedInput();
                outgoingRequest = this.copyOverrideConfig((AwsRequest)((UpdateItemRequest)originalRequest), (AwsRequest)transformedRequest);
                break;
            }
            default: {
                outgoingRequest = originalRequest;
            }
        }
        return outgoingRequest;
    }

    public SdkResponse modifyResponse(Context.ModifyResponse context, ExecutionAttributes executionAttributes) {
        SdkResponse outgoingResponse;
        SdkResponse originalResponse = context.response();
        if (!((String)executionAttributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME)).equals(DDB_NAME)) {
            throw DynamoDbEncryptionTransformsException.builder().message("DynamoDbEncryptionInterceptor does not support use with services other than DynamoDb.").build();
        }
        if (!((ClientType)executionAttributes.getAttribute(SdkExecutionAttribute.CLIENT_TYPE)).equals((Object)ClientType.SYNC)) {
            throw DynamoDbEncryptionTransformsException.builder().message("DynamoDbEncryptionInterceptor does not support use with the Async client.").build();
        }
        SdkRequest originalRequest = (SdkRequest)executionAttributes.getAttribute(DynamoDbEncryptionExecutionAttribute.ORIGINAL_REQUEST);
        String operationName = (String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME);
        this.checkSupportedOperation(operationName);
        switch (operationName) {
            case "BatchExecuteStatement": {
                BatchExecuteStatementResponse transformedResponse = this.transformer.BatchExecuteStatementOutputTransform(BatchExecuteStatementOutputTransformInput.builder().sdkOutput((BatchExecuteStatementResponse)originalResponse).originalInput((BatchExecuteStatementRequest)originalRequest).build()).transformedOutput();
                outgoingResponse = transformedResponse.toBuilder().responseMetadata((AwsResponseMetadata)((BatchExecuteStatementResponse)originalResponse).responseMetadata()).sdkHttpResponse(originalResponse.sdkHttpResponse()).build();
                break;
            }
            case "BatchGetItem": {
                BatchGetItemResponse transformedResponse = this.transformer.BatchGetItemOutputTransform(BatchGetItemOutputTransformInput.builder().sdkOutput((BatchGetItemResponse)originalResponse).originalInput((BatchGetItemRequest)originalRequest).build()).transformedOutput();
                outgoingResponse = transformedResponse.toBuilder().responseMetadata((AwsResponseMetadata)((BatchGetItemResponse)originalResponse).responseMetadata()).sdkHttpResponse(originalResponse.sdkHttpResponse()).build();
                break;
            }
            case "BatchWriteItem": {
                BatchWriteItemResponse transformedResponse = this.transformer.BatchWriteItemOutputTransform(BatchWriteItemOutputTransformInput.builder().sdkOutput((BatchWriteItemResponse)originalResponse).originalInput((BatchWriteItemRequest)originalRequest).build()).transformedOutput();
                outgoingResponse = transformedResponse.toBuilder().responseMetadata((AwsResponseMetadata)((BatchWriteItemResponse)originalResponse).responseMetadata()).sdkHttpResponse(originalResponse.sdkHttpResponse()).build();
                break;
            }
            case "ExecuteStatement": {
                ExecuteStatementResponse transformedResponse = this.transformer.ExecuteStatementOutputTransform(ExecuteStatementOutputTransformInput.builder().sdkOutput((ExecuteStatementResponse)originalResponse).originalInput((ExecuteStatementRequest)originalRequest).build()).transformedOutput();
                outgoingResponse = transformedResponse.toBuilder().responseMetadata((AwsResponseMetadata)((ExecuteStatementResponse)originalResponse).responseMetadata()).sdkHttpResponse(originalResponse.sdkHttpResponse()).build();
                break;
            }
            case "ExecuteTransaction": {
                ExecuteTransactionResponse transformedResponse = this.transformer.ExecuteTransactionOutputTransform(ExecuteTransactionOutputTransformInput.builder().sdkOutput((ExecuteTransactionResponse)originalResponse).originalInput((ExecuteTransactionRequest)originalRequest).build()).transformedOutput();
                outgoingResponse = transformedResponse.toBuilder().responseMetadata((AwsResponseMetadata)((ExecuteTransactionResponse)originalResponse).responseMetadata()).sdkHttpResponse(originalResponse.sdkHttpResponse()).build();
                break;
            }
            case "GetItem": {
                GetItemResponse transformedResponse = this.transformer.GetItemOutputTransform(GetItemOutputTransformInput.builder().sdkOutput((GetItemResponse)originalResponse).originalInput((GetItemRequest)originalRequest).build()).transformedOutput();
                outgoingResponse = transformedResponse.toBuilder().responseMetadata((AwsResponseMetadata)((GetItemResponse)originalResponse).responseMetadata()).sdkHttpResponse(originalResponse.sdkHttpResponse()).build();
                break;
            }
            case "PutItem": {
                PutItemResponse transformedResponse = this.transformer.PutItemOutputTransform(PutItemOutputTransformInput.builder().sdkOutput((PutItemResponse)originalResponse).originalInput((PutItemRequest)originalRequest).build()).transformedOutput();
                outgoingResponse = transformedResponse.toBuilder().responseMetadata((AwsResponseMetadata)((PutItemResponse)originalResponse).responseMetadata()).sdkHttpResponse(originalResponse.sdkHttpResponse()).build();
                break;
            }
            case "Query": {
                QueryResponse transformedResponse = this.transformer.QueryOutputTransform(QueryOutputTransformInput.builder().sdkOutput((QueryResponse)originalResponse).originalInput((QueryRequest)originalRequest).build()).transformedOutput();
                outgoingResponse = transformedResponse.toBuilder().responseMetadata((AwsResponseMetadata)((QueryResponse)originalResponse).responseMetadata()).sdkHttpResponse(originalResponse.sdkHttpResponse()).build();
                break;
            }
            case "Scan": {
                ScanResponse transformedResponse = this.transformer.ScanOutputTransform(ScanOutputTransformInput.builder().sdkOutput((ScanResponse)originalResponse).originalInput((ScanRequest)originalRequest).build()).transformedOutput();
                outgoingResponse = transformedResponse.toBuilder().responseMetadata((AwsResponseMetadata)((ScanResponse)originalResponse).responseMetadata()).sdkHttpResponse(originalResponse.sdkHttpResponse()).build();
                break;
            }
            case "TransactGetItems": {
                TransactGetItemsResponse transformedResponse = this.transformer.TransactGetItemsOutputTransform(TransactGetItemsOutputTransformInput.builder().sdkOutput((TransactGetItemsResponse)originalResponse).originalInput((TransactGetItemsRequest)originalRequest).build()).transformedOutput();
                outgoingResponse = transformedResponse.toBuilder().responseMetadata((AwsResponseMetadata)((TransactGetItemsResponse)originalResponse).responseMetadata()).sdkHttpResponse(originalResponse.sdkHttpResponse()).build();
                break;
            }
            case "TransactWriteItems": {
                TransactWriteItemsResponse transformedResponse = this.transformer.TransactWriteItemsOutputTransform(TransactWriteItemsOutputTransformInput.builder().sdkOutput((TransactWriteItemsResponse)originalResponse).originalInput((TransactWriteItemsRequest)originalRequest).build()).transformedOutput();
                outgoingResponse = transformedResponse.toBuilder().responseMetadata((AwsResponseMetadata)((TransactWriteItemsResponse)originalResponse).responseMetadata()).sdkHttpResponse(originalResponse.sdkHttpResponse()).build();
                break;
            }
            case "UpdateItem": {
                UpdateItemResponse transformedResponse = this.transformer.UpdateItemOutputTransform(UpdateItemOutputTransformInput.builder().sdkOutput((UpdateItemResponse)originalResponse).originalInput((UpdateItemRequest)originalRequest).build()).transformedOutput();
                outgoingResponse = transformedResponse.toBuilder().responseMetadata((AwsResponseMetadata)((UpdateItemResponse)originalResponse).responseMetadata()).sdkHttpResponse(originalResponse.sdkHttpResponse()).build();
                break;
            }
            default: {
                outgoingResponse = originalResponse;
            }
        }
        return outgoingResponse;
    }

    private void checkSupportedOperation(String operationName) {
        if (!SupportedOperations.SUPPORTED_OPERATION_NAMES.contains(operationName)) {
            throw DynamoDbEncryptionTransformsException.builder().message(String.format("DynamoDbEncryptionInterceptor does not support use with unrecognized operation: %s", operationName)).build();
        }
    }

    private AwsRequest copyOverrideConfig(AwsRequest original, AwsRequest transformed) {
        Optional config = original.overrideConfiguration();
        if (!config.isPresent()) {
            return transformed;
        }
        return transformed.toBuilder().overrideConfiguration((AwsRequestOverrideConfiguration)config.get()).build();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected DynamoDbTablesEncryptionConfig config;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DynamoDbEncryptionInterceptor model) {
            this.config = model.config();
        }

        @Override
        public Builder config(DynamoDbTablesEncryptionConfig config) {
            this.config = config;
            return this;
        }

        @Override
        public DynamoDbTablesEncryptionConfig config() {
            return this.config;
        }

        @Override
        public DynamoDbEncryptionInterceptor build() {
            if (Objects.isNull(this.config())) {
                throw DynamoDbEncryptionTransformsException.builder().message("Missing value for required field `config`").build();
            }
            return new DynamoDbEncryptionInterceptor(this);
        }
    }

    public static interface Builder {
        public Builder config(DynamoDbTablesEncryptionConfig var1);

        public DynamoDbTablesEncryptionConfig config();

        public DynamoDbEncryptionInterceptor build();
    }
}

