/*
 * Decompiled with CFR 0.152.
 */
package StructuredEncryptionUtil_Compile;

import Wrappers_Compile.Option;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.function.Function;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.AuthenticateAction;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.AuthenticateSchema;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.AuthenticateSchemaContent;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchemaContent;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredData;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredDataContent;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredDataTerminal;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;

public class __default {
    private static final TypeDescriptor<__default> _TYPE = TypeDescriptor.referenceWithInitializer(__default.class, () -> null);

    public static boolean ValidSuite(AlgorithmSuiteInfo alg) {
        return alg.dtor_id().is_DBE() && AlgorithmSuites_Compile.__default.DBEAlgorithmSuite_q((AlgorithmSuiteInfo)alg);
    }

    public static boolean ValidString(DafnySequence<? extends Character> x) {
        return BigInteger.valueOf(x.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT64__LIMIT()) < 0 && UTF8.__default.Encode(x).is_Success();
    }

    public static Error E(DafnySequence<? extends Character> s) {
        return Error.create_StructuredEncryptionException(s);
    }

    public static byte ConstantTimeCompare(DafnySequence<? extends Byte> a, DafnySequence<? extends Byte> b, byte acc) {
        while (BigInteger.valueOf(a.length()).signum() != 0) {
            byte _305_x = (byte)((Byte)a.select(Helpers.toInt((BigInteger)BigInteger.ZERO)) ^ (Byte)b.select(Helpers.toInt((BigInteger)BigInteger.ZERO)));
            DafnySequence _in30 = a.drop(BigInteger.ONE);
            DafnySequence _in31 = b.drop(BigInteger.ONE);
            byte _in32 = (byte)(_305_x | acc);
            a = _in30;
            b = _in31;
            acc = _in32;
        }
        return acc;
    }

    public static boolean ConstantTimeEquals(DafnySequence<? extends Byte> a, DafnySequence<? extends Byte> b) {
        return !(__default.ConstantTimeCompare(a, b, (byte)0) != 0);
    }

    public static boolean CryptoSchemaMapIsFlat(DafnyMap<? extends DafnySequence<? extends Character>, ? extends CryptoSchema> data) {
        return ((Function<DafnyMap, Boolean>)_306_data -> Helpers.Quantifier((Iterable)_306_data.keySet().Elements(), (boolean)true, _forall_var_2_boxed0 -> {
            DafnySequence _forall_var_2 = _forall_var_2_boxed0;
            DafnySequence _307_k = _forall_var_2;
            return !_306_data.contains((Object)_307_k) || ((CryptoSchema)_306_data.get((Object)_307_k)).dtor_content().is_Action();
        })).apply(data);
    }

    public static boolean AuthSchemaIsFlat(DafnyMap<? extends DafnySequence<? extends Character>, ? extends AuthenticateSchema> data) {
        return ((Function<DafnyMap, Boolean>)_308_data -> Helpers.Quantifier((Iterable)_308_data.keySet().Elements(), (boolean)true, _forall_var_3_boxed0 -> {
            DafnySequence _forall_var_3 = _forall_var_3_boxed0;
            DafnySequence _309_k = _forall_var_3;
            return !_308_data.contains((Object)_309_k) || ((AuthenticateSchema)_308_data.get((Object)_309_k)).dtor_content().is_Action();
        })).apply(data);
    }

    public static boolean DataMapIsFlat(DafnyMap<? extends DafnySequence<? extends Character>, ? extends StructuredData> data) {
        return ((Function<DafnyMap, Boolean>)_310_data -> Helpers.Quantifier((Iterable)_310_data.keySet().Elements(), (boolean)true, _forall_var_4_boxed0 -> {
            DafnySequence _forall_var_4 = _forall_var_4_boxed0;
            DafnySequence _311_k = _forall_var_4;
            return !_310_data.contains((Object)_311_k) || ((StructuredData)_310_data.get((Object)_311_k)).dtor_content().is_Terminal();
        })).apply(data);
    }

    public static boolean IsAuthAttr(CryptoAction x) {
        return x.is_ENCRYPT__AND__SIGN() || x.is_SIGN__ONLY();
    }

    public static StructuredData ValueToData(DafnySequence<? extends Byte> value, DafnySequence<? extends Byte> typeId) {
        return StructuredData.create(StructuredDataContent.create_Terminal(StructuredDataTerminal.create(value, typeId)), (Option<DafnyMap<? extends DafnySequence<? extends Character>, ? extends StructuredDataTerminal>>)Option.create_None());
    }

    public static DafnySequence<? extends Byte> GetValue(StructuredData data) {
        return data.dtor_content().dtor_Terminal().dtor_value();
    }

    public static boolean ByteLess(byte x, byte y) {
        return Integer.compareUnsigned(x, y) < 0;
    }

    public static boolean CharLess(char x, char y) {
        return x < y;
    }

    public static BigInteger KeySize() {
        return BigInteger.valueOf(32L);
    }

    public static BigInteger NonceSize() {
        return BigInteger.valueOf(12L);
    }

    public static BigInteger AuthTagSize() {
        return BigInteger.valueOf(16L);
    }

    public static BigInteger MSGID__LEN() {
        return BigInteger.valueOf(32L);
    }

    public static DafnySequence<? extends Character> ReservedPrefix() {
        return DafnySequence.asString((String)"aws_dbe_");
    }

    public static DafnySequence<? extends Character> HeaderField() {
        return DafnySequence.concatenate(__default.ReservedPrefix(), (DafnySequence)DafnySequence.asString((String)"head"));
    }

    public static DafnySequence<? extends Character> FooterField() {
        return DafnySequence.concatenate(__default.ReservedPrefix(), (DafnySequence)DafnySequence.asString((String)"foot"));
    }

    public static DafnySequence<? extends Byte> BYTES__TYPE__ID() {
        return DafnySequence.of((byte[])new byte[]{-1, -1});
    }

    public static BigInteger TYPEID__LEN() {
        return BigInteger.valueOf(2L);
    }

    public static DafnySequence<? extends Character> ReservedCryptoContextPrefixString() {
        return DafnySequence.asString((String)"aws-crypto-");
    }

    public static DafnySequence<? extends Byte> ReservedCryptoContextPrefixUTF8() {
        return UTF8.__default.EncodeAscii((DafnySequence)DafnySequence.asString((String)"aws-crypto-"));
    }

    public static byte DbeAlgorithmFamily() {
        return 103;
    }

    public static AuthenticateSchema DoNotSign() {
        return AuthenticateSchema.create(AuthenticateSchemaContent.create_Action(AuthenticateAction.create_DO__NOT__SIGN()), (Option<DafnyMap<? extends DafnySequence<? extends Character>, ? extends AuthenticateAction>>)Option.create_None());
    }

    public static AuthenticateSchema DoSign() {
        return AuthenticateSchema.create(AuthenticateSchemaContent.create_Action(AuthenticateAction.create_SIGN()), (Option<DafnyMap<? extends DafnySequence<? extends Character>, ? extends AuthenticateAction>>)Option.create_None());
    }

    public static CryptoSchema EncryptAndSign() {
        return CryptoSchema.create(CryptoSchemaContent.create_Action(CryptoAction.create_ENCRYPT__AND__SIGN()), (Option<DafnyMap<? extends DafnySequence<? extends Character>, ? extends AuthenticateAction>>)Option.create_None());
    }

    public static CryptoSchema SignOnly() {
        return CryptoSchema.create(CryptoSchemaContent.create_Action(CryptoAction.create_SIGN__ONLY()), (Option<DafnyMap<? extends DafnySequence<? extends Character>, ? extends AuthenticateAction>>)Option.create_None());
    }

    public static CryptoSchema DoNothing() {
        return CryptoSchema.create(CryptoSchemaContent.create_Action(CryptoAction.create_DO__NOTHING()), (Option<DafnyMap<? extends DafnySequence<? extends Character>, ? extends AuthenticateAction>>)Option.create_None());
    }

    public static TypeDescriptor<__default> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "StructuredEncryptionUtil_Compile._default";
    }
}

