/*
 * Decompiled with CFR 0.152.
 */
package StructuredEncryptionHeader_Compile;

import BoundedInts_Compile.uint16;
import BoundedInts_Compile.uint8;
import StructuredEncryptionHeader_Compile.CMPEncryptedDataKey;
import StructuredEncryptionHeader_Compile.CMPEncryptedDataKeyList;
import StructuredEncryptionHeader_Compile.CMPEncryptedDataKeyListEmptyOK;
import StructuredEncryptionHeader_Compile.CMPEncryptionContext;
import StructuredEncryptionHeader_Compile.CMPUtf8Bytes;
import StructuredEncryptionHeader_Compile.Legend;
import StructuredEncryptionHeader_Compile.LegendByte;
import StructuredEncryptionHeader_Compile.PartialHeader;
import StructuredEncryptionUtil_Compile.GoodString;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import _System.nat;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.DafnySet;
import dafny.Function0;
import dafny.Function2;
import dafny.Helpers;
import dafny.Tuple2;
import dafny.Tuple3;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.HMacInput;
import software.amazon.cryptography.primitives.internaldafny.types.IAwsCryptographicPrimitivesClient;

public class __default {
    private static final TypeDescriptor<__default> _TYPE = TypeDescriptor.referenceWithInitializer(__default.class, () -> null);

    public static boolean ValidVersion(byte x) {
        return x == 1;
    }

    public static boolean ValidFlavor(byte x) {
        return DafnySequence.of((byte[])new byte[]{0, 1}).contains((Object)x);
    }

    public static boolean ValidLegendByte(byte x) {
        return DafnySequence.of((byte[])new byte[]{__default.ENCRYPT__AND__SIGN__LEGEND(), __default.SIGN__ONLY__LEGEND()}).contains((Object)x);
    }

    public static boolean ValidEncryptionContext(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> x) {
        return BigInteger.valueOf(x.size()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0 && ((Function<DafnyMap, Boolean>)_342_x -> Helpers.Quantifier((Iterable)_342_x.keySet().Elements(), (boolean)true, _forall_var_5_boxed0 -> {
            DafnySequence _forall_var_5 = _forall_var_5_boxed0;
            DafnySequence _343_k = _forall_var_5;
            return !_342_x.contains((Object)_343_k) || BigInteger.valueOf(_343_k.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0 && BigInteger.valueOf(((DafnySequence)_342_x.get((Object)_343_k)).length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0;
        })).apply(x) != false;
    }

    public static boolean ValidEncryptedDataKey(EncryptedDataKey x) {
        return BigInteger.valueOf(x.dtor_keyProviderId().length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0 && BigInteger.valueOf(x.dtor_keyProviderInfo().length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0 && BigInteger.valueOf(x.dtor_ciphertext().length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0;
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> Serialize(IAwsCryptographicPrimitivesClient client, AlgorithmSuiteInfo alg, DafnySequence<? extends Byte> commitKey, PartialHeader PartialHeader2) {
        DafnySequence<? extends Byte> _344_body = PartialHeader2.serialize();
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _345_valueOrError0 = __default.CalculateHeaderCommitment(client, alg, commitKey, _344_body);
        if (_345_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _345_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()));
        }
        DafnySequence _346_commitment = (DafnySequence)_345_valueOrError0.Extract(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        return Result.create_Success((Object)DafnySequence.concatenate(_344_body, (DafnySequence)_346_commitment));
    }

    public static Result<PartialHeader, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> Create(DafnySequence<? extends Character> tableName, CryptoSchema schema, DafnySequence<? extends Byte> msgID, EncryptionMaterials mat) {
        Outcome _347_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)StructuredEncryptionUtil_Compile.__default.ValidString(tableName), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid table name.")));
        if (_347_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _347_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _348_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.ValidEncryptionContext((DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)mat.dtor_encryptionContext()), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Encryption Context")));
        if (_348_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _348_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _349_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(mat.dtor_encryptedDataKeys().length()).signum() == 1 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"There must be at least one data key")));
        if (_349_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _349_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _350_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(mat.dtor_encryptedDataKeys().length()).compareTo(__default.UINT8__LIMIT()) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Too many data keys.")));
        if (_350_valueOrError3.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _350_valueOrError3.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _351_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)((Function<EncryptionMaterials, Boolean>)_352_mat -> Helpers.Quantifier((Iterable)_352_mat.dtor_encryptedDataKeys().UniqueElements(), (boolean)true, _forall_var_6_boxed0 -> {
            EncryptedDataKey _forall_var_6;
            EncryptedDataKey _353_x = _forall_var_6 = _forall_var_6_boxed0;
            return !_352_mat.dtor_encryptedDataKeys().contains((Object)_353_x) || __default.ValidEncryptedDataKey(_353_x);
        })).apply(mat), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Data Key")));
        if (_351_valueOrError4.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _351_valueOrError4.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _354_valueOrError5 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)schema.dtor_content().is_SchemaMap(), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Schema must be a Map")));
        if (_354_valueOrError5.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _354_valueOrError5.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _355_valueOrError6 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)StructuredEncryptionUtil_Compile.__default.CryptoSchemaMapIsFlat(schema.dtor_content().dtor_SchemaMap()), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Schema must be flat.")));
        if (_355_valueOrError6.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _355_valueOrError6.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _356_valueOrError7 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)Objects.equals(BigInteger.valueOf(mat.dtor_algorithmSuite().dtor_binaryId().length()), BigInteger.valueOf(2L)), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Algorithm Suite Binary ID")));
        if (_356_valueOrError7.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _356_valueOrError7.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _357_valueOrError8 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((Byte)mat.dtor_algorithmSuite().dtor_binaryId().select(Helpers.toInt((BigInteger)BigInteger.ZERO)) == StructuredEncryptionUtil_Compile.__default.DbeAlgorithmFamily() ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Algorithm Suite not suitable for structured encryption.")));
        if (_357_valueOrError8.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _357_valueOrError8.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _358_valueOrError9 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.ValidFlavor((Byte)mat.dtor_algorithmSuite().dtor_binaryId().select(Helpers.toInt((BigInteger)BigInteger.ONE))), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Algorithm Suite has unexpected flavor.")));
        if (_358_valueOrError9.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _358_valueOrError9.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _359_valueOrError10 = __default.MakeLegend(tableName, schema);
        if (_359_valueOrError10.IsFailure(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _359_valueOrError10.PropagateFailure(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        DafnySequence _360_legend = (DafnySequence)_359_valueOrError10.Extract(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        DafnyMap _361_storedEC = ((Function<EncryptionMaterials, DafnyMap>)_362_mat -> ((Function0<DafnyMap>)() -> {
            HashMap<DafnySequence, DafnySequence> _coll9 = new HashMap<DafnySequence, DafnySequence>();
            Iterator iterator = _362_mat.dtor_encryptionContext().keySet().Elements().iterator();
            while (iterator.hasNext()) {
                DafnySequence _compr_9_boxed0;
                DafnySequence _compr_9;
                DafnySequence _363_k = _compr_9 = (_compr_9_boxed0 = (DafnySequence)iterator.next());
                if (!_362_mat.dtor_encryptionContext().contains((Object)_363_k) || _362_mat.dtor_requiredEncryptionContextKeys().contains((Object)_363_k)) continue;
                _coll9.put(_363_k, (DafnySequence)_362_mat.dtor_encryptionContext().get((Object)_363_k));
            }
            return new DafnyMap(_coll9);
        }).apply()).apply(mat);
        Outcome _364_valueOrError11 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.ValidEncryptionContext((DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)_361_storedEC), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Encryption Context")));
        if (_364_valueOrError11.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _364_valueOrError11.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        return Result.create_Success((Object)PartialHeader.create((byte)1, (Byte)mat.dtor_algorithmSuite().dtor_binaryId().select(Helpers.toInt((BigInteger)BigInteger.ONE)), msgID, (DafnySequence<? extends Byte>)_360_legend, (DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)_361_storedEC, (DafnySequence<? extends EncryptedDataKey>)mat.dtor_encryptedDataKeys()));
    }

    public static Result<PartialHeader, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> PartialDeserialize(DafnySequence<? extends Byte> data) {
        Outcome _365_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (__default.PREFIX__LEN().compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Serialized PartialHeader too short.")));
        if (_365_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _365_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        byte _366_version = (Byte)data.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        Outcome _367_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.ValidVersion(_366_version), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Version Number")));
        if (_367_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _367_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        byte _368_flavor = (Byte)data.select(Helpers.toInt((BigInteger)BigInteger.ONE));
        Outcome _369_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.ValidFlavor(_368_flavor), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Flavor")));
        if (_369_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _369_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        DafnySequence _370_msgID = data.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)), Helpers.toInt((BigInteger)__default.PREFIX__LEN()));
        DafnySequence _371_legendData = data.drop(__default.PREFIX__LEN());
        Result<Tuple2<DafnySequence<? extends Byte>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _372_valueOrError3 = __default.GetLegend((DafnySequence<? extends Byte>)_371_legendData);
        if (_372_valueOrError3.IsFailure(Tuple2._typeDescriptor(Legend._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _372_valueOrError3.PropagateFailure(Tuple2._typeDescriptor(Legend._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Tuple2 _373_legendAndLen = (Tuple2)_372_valueOrError3.Extract(Tuple2._typeDescriptor(Legend._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        DafnySequence _374_legend = (DafnySequence)_373_legendAndLen.dtor__0();
        DafnySequence _375_contextData = _371_legendData.drop((BigInteger)_373_legendAndLen.dtor__1());
        Result<Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _376_valueOrError4 = __default.GetContext((DafnySequence<? extends Byte>)_375_contextData);
        if (_376_valueOrError4.IsFailure(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _376_valueOrError4.PropagateFailure(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Tuple2 _377_contextAndLen = (Tuple2)_376_valueOrError4.Extract(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        DafnyMap _378_encContext = (DafnyMap)_377_contextAndLen.dtor__0();
        DafnySequence _379_keysData = _375_contextData.drop((BigInteger)_377_contextAndLen.dtor__1());
        Result<Tuple2<DafnySequence<? extends EncryptedDataKey>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _380_valueOrError5 = __default.GetDataKeys((DafnySequence<? extends Byte>)_379_keysData);
        if (_380_valueOrError5.IsFailure(Tuple2._typeDescriptor(CMPEncryptedDataKeyList._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _380_valueOrError5.PropagateFailure(Tuple2._typeDescriptor(CMPEncryptedDataKeyList._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Tuple2 _381_keysAndLen = (Tuple2)_380_valueOrError5.Extract(Tuple2._typeDescriptor(CMPEncryptedDataKeyList._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        DafnySequence _382_dataKeys = (DafnySequence)_381_keysAndLen.dtor__0();
        DafnySequence _383_trailingData = _379_keysData.drop((BigInteger)_381_keysAndLen.dtor__1());
        Outcome _384_valueOrError6 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(_383_trailingData.length()).compareTo(__default.COMMITMENT__LEN()) >= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid header serialization: unexpected end of data.")));
        if (_384_valueOrError6.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _384_valueOrError6.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _385_valueOrError7 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(_383_trailingData.length()).compareTo(__default.COMMITMENT__LEN()) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid header serialization: unexpected bytes.")));
        if (_385_valueOrError7.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _385_valueOrError7.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        return Result.create_Success((Object)PartialHeader.create(_366_version, _368_flavor, (DafnySequence<? extends Byte>)_370_msgID, (DafnySequence<? extends Byte>)_374_legend, (DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)_378_encContext, (DafnySequence<? extends EncryptedDataKey>)_382_dataKeys));
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> CalculateHeaderCommitment(IAwsCryptographicPrimitivesClient client, AlgorithmSuiteInfo alg, DafnySequence<? extends Byte> commitKey, DafnySequence<? extends Byte> data) {
        HMacInput _386_input = HMacInput.create((DigestAlgorithm)alg.dtor_commitment().dtor_HKDF().dtor_hmac(), commitKey, data);
        Result _387_outputR = client.HMac(_386_input);
        Result _388_valueOrError0 = _387_outputR.MapFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), _389_e_boxed0 -> {
            Error _389_e = _389_e_boxed0;
            return software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error.create_AwsCryptographyPrimitives(_389_e);
        });
        if (_388_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _388_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()));
        }
        DafnySequence _390_output = (DafnySequence)_388_valueOrError0.Extract(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        if (BigInteger.valueOf(_390_output.length()).compareTo(__default.COMMITMENT__LEN()) < 0) {
            return Result.create_Failure((Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"HMAC did not produce enough bits")));
        }
        return Result.create_Success((Object)_390_output.take(__default.COMMITMENT__LEN()));
    }

    public static Result<Short, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> ToUInt16(BigInteger x) {
        Outcome _391_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (x.compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Value too big for 16 bits")));
        if (_391_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _391_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), uint16._typeDescriptor());
        }
        return Result.create_Success((Object)x.shortValue());
    }

    public static <__X, __Y, __Z> DafnyMap<? extends __Y, ? extends __Z> MyMap(TypeDescriptor<__X> _td___X, TypeDescriptor<__Y> _td___Y, TypeDescriptor<__Z> _td___Z, Function<__X, __Y> f, DafnyMap<? extends __X, ? extends __Z> m) {
        return ((Function2<DafnyMap, Function, DafnyMap>)(_392_m, _393_f) -> ((Function0<DafnyMap>)() -> {
            HashMap _coll10 = new HashMap();
            for (Object _compr_10_boxed0 : _392_m.keySet().Elements()) {
                Object _compr_10 = _compr_10_boxed0;
                Object _394_k = _compr_10;
                if (!_392_m.contains(_394_k)) continue;
                _coll10.put(_393_f.apply(_394_k), _392_m.get(_394_k));
            }
            return new DafnyMap(_coll10);
        }).apply()).apply(m, f);
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> MakeLegend(DafnySequence<? extends Character> tableName, CryptoSchema schema) {
        DafnyMap<? extends DafnySequence<? extends Character>, ? extends CryptoSchema> _395_data = schema.dtor_content().dtor_SchemaMap();
        Outcome _396_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)((Function<DafnyMap, Boolean>)_397_data -> Helpers.Quantifier((Iterable)_397_data.keySet().Elements(), (boolean)true, _forall_var_7_boxed0 -> {
            DafnySequence _forall_var_7 = _forall_var_7_boxed0;
            DafnySequence _398_k = _forall_var_7;
            return !_397_data.contains((Object)_398_k) || StructuredEncryptionUtil_Compile.__default.ValidString((DafnySequence<? extends Character>)_398_k);
        })).apply(_395_data), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"bad attribute name")));
        if (_396_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _396_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Legend._typeDescriptor());
        }
        DafnyMap _399_authSchema = (DafnyMap)Helpers.Let(__default.RestrictAuthAttrs(_395_data), boxed24 -> {
            DafnyMap _pat_let13_0 = boxed24;
            return (DafnyMap)Helpers.Let((Object)_pat_let13_0, boxed25 -> {
                DafnyMap _400_rawSchema = boxed25;
                return _400_rawSchema;
            });
        });
        Function _401_fn = ((Function<DafnySequence, Function>)_402_tableName -> _403_k_boxed0 -> {
            DafnySequence _403_k = _403_k_boxed0;
            return StructuredEncryptionPaths_Compile.__default.SimpleCanon((DafnySequence<? extends Character>)_402_tableName, (DafnySequence<? extends Character>)_403_k);
        }).apply(tableName);
        DafnyMap _404_canonSchema = __default.MyMap(GoodString._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), CryptoSchema._typeDescriptor(), _401_fn, _399_authSchema);
        DafnySequence _405_attrs = SortedSets.__default.SetToOrderedSequence2((TypeDescriptor)uint8._typeDescriptor(), (DafnySet)_404_canonSchema.keySet(), StructuredEncryptionUtil_Compile.__default::ByteLess);
        return __default.MakeLegend2((DafnySequence<? extends DafnySequence<? extends Byte>>)_405_attrs, _404_canonSchema, __default.EmptyLegend());
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> MakeLegend2(DafnySequence<? extends DafnySequence<? extends Byte>> attrs, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends CryptoSchema> data, DafnySequence<? extends Byte> serialized) {
        while (BigInteger.valueOf(attrs.length()).signum() != 0) {
            Outcome _406_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(serialized.length()).add(BigInteger.ONE).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Legend Too Long.")));
            if (_406_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                return _406_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Legend._typeDescriptor());
            }
            Outcome _407_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)((CryptoSchema)data.get((Object)((DafnySequence)attrs.select(Helpers.toInt((BigInteger)BigInteger.ZERO))))).dtor_content().is_Action(), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Schema must be flat")));
            if (_407_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                return _407_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Legend._typeDescriptor());
            }
            byte _408_legendChar = __default.GetActionLegend(((CryptoSchema)data.get((Object)((DafnySequence)attrs.select(Helpers.toInt((BigInteger)BigInteger.ZERO))))).dtor_content().dtor_Action());
            DafnySequence _in36 = attrs.drop(BigInteger.ONE);
            DafnyMap<? extends DafnySequence<? extends Byte>, ? extends CryptoSchema> _in37 = data;
            DafnySequence _in38 = DafnySequence.concatenate(serialized, (DafnySequence)DafnySequence.of((byte[])new byte[]{_408_legendChar}));
            attrs = _in36;
            data = _in37;
            serialized = _in38;
        }
        return Result.create_Success(serialized);
    }

    public static byte GetActionLegend(CryptoAction x) {
        CryptoAction _source4 = x;
        if (_source4.is_ENCRYPT__AND__SIGN()) {
            return __default.ENCRYPT__AND__SIGN__LEGEND();
        }
        return __default.SIGN__ONLY__LEGEND();
    }

    public static DafnyMap<? extends DafnySequence<? extends Character>, ? extends CryptoSchema> RestrictAuthAttrs(DafnyMap<? extends DafnySequence<? extends Character>, ? extends CryptoSchema> data) {
        return ((Function<DafnyMap, DafnyMap>)_409_data -> ((Function0<DafnyMap>)() -> {
            HashMap<DafnySequence, CryptoSchema> _coll11 = new HashMap<DafnySequence, CryptoSchema>();
            for (DafnySequence _compr_11_boxed0 : _409_data.keySet().Elements()) {
                DafnySequence _compr_11 = _compr_11_boxed0;
                DafnySequence _410_k = _compr_11;
                if (!_409_data.contains((Object)_410_k) || !StructuredEncryptionUtil_Compile.__default.IsAuthAttr(((CryptoSchema)_409_data.get((Object)_410_k)).dtor_content().dtor_Action())) continue;
                _coll11.put(_410_k, (CryptoSchema)_409_data.get((Object)_410_k));
            }
            return new DafnyMap(_coll11);
        }).apply()).apply(data);
    }

    public static DafnySequence<? extends Byte> SerializeLegend(DafnySequence<? extends Byte> x) {
        return DafnySequence.concatenate((DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)x.cardinalityInt())), x);
    }

    public static Result<Tuple2<DafnySequence<? extends Byte>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetLegend(DafnySequence<? extends Byte> data) {
        Outcome _411_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(2L).compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_411_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _411_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        short _412_len = StandardLibrary_mUInt_Compile.__default.SeqToUInt16((DafnySequence)data.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(2L))));
        BigInteger _413_size = BigInteger.valueOf(Short.toUnsignedLong(_412_len)).add(BigInteger.valueOf(2L));
        Outcome _414_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_413_size.compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_414_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _414_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        Outcome _415_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)((Function2<DafnySequence, BigInteger, Boolean>)(_416_data, _417_size) -> Helpers.Quantifier((Iterable)_416_data.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)), Helpers.toInt((BigInteger)_417_size)).UniqueElements(), (boolean)true, _forall_var_8_boxed0 -> {
            byte _forall_var_8;
            byte _418_x = _forall_var_8 = _forall_var_8_boxed0.byteValue();
            return !_416_data.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)), Helpers.toInt((BigInteger)_417_size)).contains((Object)_418_x) || __default.ValidLegendByte(_418_x);
        })).apply(data, _413_size), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid byte in stored legend")));
        if (_415_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _415_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        return Result.create_Success((Object)Tuple2.create((Object)data.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)), Helpers.toInt((BigInteger)_413_size)), (Object)_413_size));
    }

    public static Result<Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetContext(DafnySequence<? extends Byte> data) {
        Outcome _419_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(2L).compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_419_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _419_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), nat._typeDescriptor()));
        }
        BigInteger _420_count = BigInteger.valueOf(Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqToUInt16((DafnySequence)data.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(2L))))));
        Result<Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _421_valueOrError1 = __default.GetContext2(_420_count, data, (DafnySequence<? extends Byte>)data.drop(BigInteger.valueOf(2L)), (Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, BigInteger>)Tuple2.create((Object)DafnyMap.fromElements((Tuple2[])new Tuple2[0]), (Object)BigInteger.valueOf(2L)), (DafnySequence<? extends Byte>)DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor()));
        if (_421_valueOrError1.IsFailure(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _421_valueOrError1.PropagateFailure(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), nat._typeDescriptor()));
        }
        Tuple2 _422_context = (Tuple2)_421_valueOrError1.Extract(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        return Result.create_Success((Object)_422_context);
    }

    public static Result<Tuple3<DafnySequence<? extends Byte>, DafnySequence<? extends Byte>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetOneKVPair(DafnySequence<? extends Byte> data) {
        Outcome _423_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(2L).compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_423_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _423_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        BigInteger _424_keyLen = BigInteger.valueOf(Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqToUInt16((DafnySequence)data.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(2L))))));
        Outcome _425_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_424_keyLen.add(BigInteger.valueOf(4L)).compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_425_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _425_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        DafnySequence _426_key = data.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)), Helpers.toInt((BigInteger)_424_keyLen.add(BigInteger.valueOf(2L))));
        Outcome _427_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)UTF8.__default.ValidUTF8Seq((DafnySequence)_426_key), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid UTF8 found in header.")));
        if (_427_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _427_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        BigInteger _428_valueLen = BigInteger.valueOf(Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqToUInt16((DafnySequence)data.subsequence(Helpers.toInt((BigInteger)_424_keyLen.add(BigInteger.valueOf(2L))), Helpers.toInt((BigInteger)_424_keyLen.add(BigInteger.valueOf(4L)))))));
        BigInteger _429_kvLen = BigInteger.valueOf(2L).add(_424_keyLen).add(BigInteger.valueOf(2L)).add(_428_valueLen);
        Outcome _430_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_429_kvLen.compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_430_valueOrError3.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _430_valueOrError3.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        DafnySequence _431_value = data.subsequence(Helpers.toInt((BigInteger)_424_keyLen.add(BigInteger.valueOf(4L))), Helpers.toInt((BigInteger)_429_kvLen));
        Outcome _432_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)UTF8.__default.ValidUTF8Seq((DafnySequence)_431_value), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid UTF8 found in header.")));
        if (_432_valueOrError4.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _432_valueOrError4.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        return Result.create_Success((Object)Tuple3.create((Object)_426_key, (Object)_431_value, (Object)_429_kvLen));
    }

    public static boolean BytesLess(DafnySequence<? extends Byte> a, DafnySequence<? extends Byte> b) {
        while (!a.equals(b)) {
            if (BigInteger.valueOf(a.length()).signum() == 0) {
                return true;
            }
            if (BigInteger.valueOf(b.length()).signum() == 0) {
                return false;
            }
            if (((Byte)a.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).byteValue() != ((Byte)b.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).byteValue()) {
                return Integer.compareUnsigned(((Byte)a.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).byteValue(), ((Byte)b.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).byteValue()) < 0;
            }
            DafnySequence _in39 = a.drop(BigInteger.ONE);
            DafnySequence _in40 = b.drop(BigInteger.ONE);
            a = _in39;
            b = _in40;
        }
        return false;
    }

    public static Result<Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetContext2(BigInteger count, DafnySequence<? extends Byte> origData, DafnySequence<? extends Byte> data, Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, BigInteger> deserialized, DafnySequence<? extends Byte> prevKey) {
        while (count.signum() != 0) {
            Outcome _433_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(((DafnyMap)deserialized.dtor__0()).size()).add(BigInteger.ONE).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Too much context")));
            if (_433_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                return _433_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), nat._typeDescriptor()));
            }
            Result<Tuple3<DafnySequence<? extends Byte>, DafnySequence<? extends Byte>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _434_valueOrError1 = __default.GetOneKVPair(data);
            if (_434_valueOrError1.IsFailure(Tuple3._typeDescriptor(CMPUtf8Bytes._typeDescriptor(), CMPUtf8Bytes._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                return _434_valueOrError1.PropagateFailure(Tuple3._typeDescriptor(CMPUtf8Bytes._typeDescriptor(), CMPUtf8Bytes._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), nat._typeDescriptor()));
            }
            Tuple3 _435_kv = (Tuple3)_434_valueOrError1.Extract(Tuple3._typeDescriptor(CMPUtf8Bytes._typeDescriptor(), CMPUtf8Bytes._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
            Outcome _436_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.BytesLess(prevKey, (DafnySequence<? extends Byte>)((DafnySequence)_435_kv.dtor__0())), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Context keys out of order.")));
            if (_436_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                return _436_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), nat._typeDescriptor()));
            }
            BigInteger _in41 = count.subtract(BigInteger.ONE);
            DafnySequence<? extends Byte> _in42 = origData;
            DafnySequence _in43 = data.drop(BigInteger.valueOf(2L).add(BigInteger.valueOf(((DafnySequence)_435_kv.dtor__0()).length())).add(BigInteger.valueOf(2L)).add(BigInteger.valueOf(((DafnySequence)_435_kv.dtor__1()).length())));
            Tuple2 _in44 = Tuple2.create((Object)DafnyMap.update((DafnyMap)((DafnyMap)deserialized.dtor__0()), (Object)_435_kv.dtor__0(), (Object)_435_kv.dtor__1()), (Object)((BigInteger)deserialized.dtor__1()).add((BigInteger)_435_kv.dtor__2()));
            DafnySequence _in45 = (DafnySequence)_435_kv.dtor__0();
            count = _in41;
            origData = _in42;
            data = _in43;
            deserialized = _in44;
            prevKey = _in45;
        }
        return Result.create_Success(deserialized);
    }

    public static DafnySequence<? extends Byte> SerializeContext(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> x) {
        DafnySequence _437_keys = SortedSets.__default.SetToOrderedSequence2((TypeDescriptor)uint8._typeDescriptor(), (DafnySet)x.keySet(), StructuredEncryptionUtil_Compile.__default::ByteLess);
        return DafnySequence.concatenate((DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)x.cardinalityInt())), __default.SerializeContext2((DafnySequence<? extends DafnySequence<? extends Byte>>)_437_keys, x));
    }

    public static DafnySequence<? extends Byte> SerializeOneKVPair(DafnySequence<? extends Byte> key, DafnySequence<? extends Byte> value) {
        return DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)key.cardinalityInt())), key), (DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)value.cardinalityInt()))), value);
    }

    public static DafnySequence<? extends Byte> SerializeOneDataKey(EncryptedDataKey k) {
        return DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)k.dtor_keyProviderId().cardinalityInt())), (DafnySequence)k.dtor_keyProviderId()), (DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)k.dtor_keyProviderInfo().cardinalityInt()))), (DafnySequence)k.dtor_keyProviderInfo()), (DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)k.dtor_ciphertext().cardinalityInt()))), (DafnySequence)k.dtor_ciphertext());
    }

    public static Result<Tuple2<EncryptedDataKey, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetOneDataKey(DafnySequence<? extends Byte> data) {
        Outcome _438_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(2L).compareTo(BigInteger.valueOf(data.length())) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_438_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _438_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)EncryptedDataKey._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        BigInteger _439_provIdSize = BigInteger.valueOf(Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqToUInt16((DafnySequence)data.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(2L))))));
        Outcome _440_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_439_provIdSize.add(BigInteger.valueOf(2L)).compareTo(BigInteger.valueOf(data.length())) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_440_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _440_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)EncryptedDataKey._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        DafnySequence _441_provId = data.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)), Helpers.toInt((BigInteger)BigInteger.valueOf(2L).add(_439_provIdSize)));
        Outcome _442_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)UTF8.__default.ValidUTF8Seq((DafnySequence)_441_provId), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid UTF8 found in header.")));
        if (_442_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _442_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)EncryptedDataKey._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        BigInteger _443_part1Size = BigInteger.valueOf(2L).add(_439_provIdSize);
        Outcome _444_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_443_part1Size.add(BigInteger.valueOf(2L)).compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_444_valueOrError3.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _444_valueOrError3.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)EncryptedDataKey._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        BigInteger _445_provInfoSize = BigInteger.valueOf(Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqToUInt16((DafnySequence)data.subsequence(Helpers.toInt((BigInteger)_443_part1Size), Helpers.toInt((BigInteger)_443_part1Size.add(BigInteger.valueOf(2L)))))));
        Outcome _446_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_443_part1Size.add(_445_provInfoSize).add(BigInteger.valueOf(2L)).compareTo(BigInteger.valueOf(data.length())) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_446_valueOrError4.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _446_valueOrError4.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)EncryptedDataKey._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        DafnySequence _447_provInfo = data.subsequence(Helpers.toInt((BigInteger)_443_part1Size.add(BigInteger.valueOf(2L))), Helpers.toInt((BigInteger)_443_part1Size.add(BigInteger.valueOf(2L)).add(_445_provInfoSize)));
        BigInteger _448_part2Size = _443_part1Size.add(BigInteger.valueOf(2L)).add(_445_provInfoSize);
        Outcome _449_valueOrError5 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_448_part2Size.add(BigInteger.valueOf(2L)).compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_449_valueOrError5.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _449_valueOrError5.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)EncryptedDataKey._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        BigInteger _450_cipherSize = BigInteger.valueOf(Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqToUInt16((DafnySequence)data.subsequence(Helpers.toInt((BigInteger)_448_part2Size), Helpers.toInt((BigInteger)_448_part2Size.add(BigInteger.valueOf(2L)))))));
        Outcome _451_valueOrError6 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_448_part2Size.add(_450_cipherSize).add(BigInteger.valueOf(2L)).compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_451_valueOrError6.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _451_valueOrError6.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)EncryptedDataKey._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        DafnySequence _452_cipher = data.subsequence(Helpers.toInt((BigInteger)_448_part2Size.add(BigInteger.valueOf(2L))), Helpers.toInt((BigInteger)_448_part2Size.add(BigInteger.valueOf(2L)).add(_450_cipherSize)));
        BigInteger _453_part3Size = _448_part2Size.add(BigInteger.valueOf(2L)).add(_450_cipherSize);
        EncryptedDataKey _454_edk = EncryptedDataKey.create((DafnySequence)_441_provId, (DafnySequence)_447_provInfo, (DafnySequence)_452_cipher);
        return Result.create_Success((Object)Tuple2.create((Object)_454_edk, (Object)_453_part3Size));
    }

    public static DafnySequence<? extends Byte> SerializeContext2(DafnySequence<? extends DafnySequence<? extends Byte>> keys, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> x) {
        DafnySequence _455___accumulator = DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor());
        while (BigInteger.valueOf(keys.length()).signum() != 0) {
            _455___accumulator = DafnySequence.concatenate((DafnySequence)_455___accumulator, __default.SerializeOneKVPair((DafnySequence<? extends Byte>)((DafnySequence)keys.select(Helpers.toInt((BigInteger)BigInteger.ZERO))), (DafnySequence<? extends Byte>)((DafnySequence)x.get((Object)((DafnySequence)keys.select(Helpers.toInt((BigInteger)BigInteger.ZERO)))))));
            DafnySequence _in46 = keys.drop(BigInteger.ONE);
            DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> _in47 = x;
            keys = _in46;
            x = _in47;
        }
        return DafnySequence.concatenate((DafnySequence)_455___accumulator, (DafnySequence)DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor()));
    }

    public static DafnySequence<? extends Byte> SerializeDataKeys(DafnySequence<? extends EncryptedDataKey> x) {
        DafnySequence<? extends Byte> _456_body = __default.SerializeDataKeys2(x);
        return DafnySequence.concatenate((DafnySequence)DafnySequence.of((byte[])new byte[]{(byte)x.cardinalityInt()}), _456_body);
    }

    public static DafnySequence<? extends Byte> SerializeDataKeys2(DafnySequence<? extends EncryptedDataKey> x) {
        DafnySequence _457___accumulator = DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor());
        while (BigInteger.valueOf(x.length()).signum() != 0) {
            DafnySequence _in48;
            _457___accumulator = DafnySequence.concatenate((DafnySequence)_457___accumulator, __default.SerializeOneDataKey((EncryptedDataKey)x.select(Helpers.toInt((BigInteger)BigInteger.ZERO))));
            x = _in48 = x.drop(BigInteger.ONE);
        }
        return DafnySequence.concatenate((DafnySequence)_457___accumulator, (DafnySequence)DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor()));
    }

    public static Result<Tuple2<DafnySequence<? extends EncryptedDataKey>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetDataKeys(DafnySequence<? extends Byte> data) {
        Outcome _458_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.ONE.compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_458_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _458_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), nat._typeDescriptor()));
        }
        BigInteger _459_count = BigInteger.valueOf(Byte.toUnsignedLong((Byte)data.select(Helpers.toInt((BigInteger)BigInteger.ZERO))));
        Result<Tuple2<DafnySequence<? extends EncryptedDataKey>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _460_valueOrError1 = __default.GetDataKeys2(_459_count, _459_count, data, (DafnySequence<? extends Byte>)data.drop(BigInteger.ONE), (Tuple2<DafnySequence<? extends EncryptedDataKey>, BigInteger>)Tuple2.create((Object)DafnySequence.empty(CMPEncryptedDataKey._typeDescriptor()), (Object)BigInteger.ONE));
        if (_460_valueOrError1.IsFailure(Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _460_valueOrError1.PropagateFailure(Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), nat._typeDescriptor()));
        }
        Tuple2 _461_keys = (Tuple2)_460_valueOrError1.Extract(Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        if (BigInteger.valueOf(((DafnySequence)_461_keys.dtor__0()).length()).signum() == 0) {
            return Result.create_Failure((Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"At least one Data Key required")));
        }
        return Result.create_Success((Object)_461_keys);
    }

    public static Result<Tuple2<DafnySequence<? extends EncryptedDataKey>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetDataKeys2(BigInteger count, BigInteger origCount, DafnySequence<? extends Byte> origData, DafnySequence<? extends Byte> data, Tuple2<DafnySequence<? extends EncryptedDataKey>, BigInteger> deserialized) {
        while (count.signum() != 0) {
            if (BigInteger.valueOf(((DafnySequence)deserialized.dtor__0()).length()).compareTo(BigInteger.valueOf(255L)) >= 0) {
                return Result.create_Failure((Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Too Many Data Keys")));
            }
            Result<Tuple2<EncryptedDataKey, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _462_valueOrError0 = __default.GetOneDataKey(data);
            if (_462_valueOrError0.IsFailure(Tuple2._typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                return _462_valueOrError0.PropagateFailure(Tuple2._typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), nat._typeDescriptor()));
            }
            Tuple2 _463_edk = (Tuple2)_462_valueOrError0.Extract(Tuple2._typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
            BigInteger _in49 = count.subtract(BigInteger.ONE);
            BigInteger _in50 = origCount;
            DafnySequence<? extends Byte> _in51 = origData;
            DafnySequence _in52 = data.drop((BigInteger)_463_edk.dtor__1());
            Tuple2 _in53 = Tuple2.create((Object)DafnySequence.concatenate((DafnySequence)((DafnySequence)deserialized.dtor__0()), (DafnySequence)DafnySequence.of(CMPEncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{(EncryptedDataKey)_463_edk.dtor__0()})), (Object)((BigInteger)deserialized.dtor__1()).add((BigInteger)_463_edk.dtor__1()));
            count = _in49;
            origCount = _in50;
            origData = _in51;
            data = _in52;
            deserialized = _in53;
        }
        return Result.create_Success(deserialized);
    }

    public static BigInteger UINT8__LIMIT() {
        return BigInteger.valueOf(256L);
    }

    public static BigInteger COMMITMENT__LEN() {
        return BigInteger.valueOf(32L);
    }

    public static byte ENCRYPT__AND__SIGN__LEGEND() {
        return 101;
    }

    public static byte SIGN__ONLY__LEGEND() {
        return 115;
    }

    public static BigInteger VERSION__LEN() {
        return BigInteger.ONE;
    }

    public static BigInteger FLAVOR__LEN() {
        return BigInteger.ONE;
    }

    public static BigInteger PREFIX__LEN() {
        return __default.VERSION__LEN().add(__default.FLAVOR__LEN()).add(StructuredEncryptionUtil_Compile.__default.MSGID__LEN());
    }

    public static DafnySequence<? extends Byte> EmptyLegend() {
        return DafnySequence.empty(LegendByte._typeDescriptor());
    }

    public static TypeDescriptor<__default> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "StructuredEncryptionHeader_Compile._default";
    }
}

