/*
 * Decompiled with CFR 0.152.
 */
package StructuredEncryptionHeader_Compile;

import BoundedInts_Compile.uint8;
import StructuredEncryptionHeader_Compile.CMPEncryptedDataKey;
import StructuredEncryptionHeader_Compile.LegendByte;
import StructuredEncryptionHeader_Compile.Version;
import StructuredEncryptionHeader_Compile.__default;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.MaterialProvidersClient;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.IAwsCryptographicPrimitivesClient;

public class PartialHeader {
    public byte _version;
    public byte _flavor;
    public DafnySequence<? extends Byte> _msgID;
    public DafnySequence<? extends Byte> _legend;
    public DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> _encContext;
    public DafnySequence<? extends EncryptedDataKey> _dataKeys;
    private static final PartialHeader theDefault = PartialHeader.create(Version.defaultValue(), (byte)0, (DafnySequence<? extends Byte>)DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor()), (DafnySequence<? extends Byte>)DafnySequence.empty(LegendByte._typeDescriptor()), (DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)DafnyMap.empty(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.empty(CMPEncryptedDataKey._typeDescriptor()));
    private static final TypeDescriptor<PartialHeader> _TYPE = TypeDescriptor.referenceWithInitializer(PartialHeader.class, () -> PartialHeader.Default());

    public PartialHeader(byte version, byte flavor, DafnySequence<? extends Byte> msgID, DafnySequence<? extends Byte> legend, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encContext, DafnySequence<? extends EncryptedDataKey> dataKeys) {
        this._version = version;
        this._flavor = flavor;
        this._msgID = msgID;
        this._legend = legend;
        this._encContext = encContext;
        this._dataKeys = dataKeys;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        PartialHeader o = (PartialHeader)other;
        return this._version == o._version && this._flavor == o._flavor && Objects.equals(this._msgID, o._msgID) && Objects.equals(this._legend, o._legend) && Objects.equals(this._encContext, o._encContext) && Objects.equals(this._dataKeys, o._dataKeys);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Byte.hashCode(this._version);
        hash = (hash << 5) + hash + (long)Byte.hashCode(this._flavor);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._msgID);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._legend);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._encContext);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._dataKeys);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("StructuredEncryptionHeader_Compile.PartialHeader.PartialHeader");
        s.append("(");
        s.append(this._version);
        s.append(", ");
        s.append(this._flavor);
        s.append(", ");
        s.append(Helpers.toString(this._msgID));
        s.append(", ");
        s.append(Helpers.toString(this._legend));
        s.append(", ");
        s.append(Helpers.toString(this._encContext));
        s.append(", ");
        s.append(Helpers.toString(this._dataKeys));
        s.append(")");
        return s.toString();
    }

    public static PartialHeader Default() {
        return theDefault;
    }

    public static TypeDescriptor<PartialHeader> _typeDescriptor() {
        return _TYPE;
    }

    public static PartialHeader create(byte version, byte flavor, DafnySequence<? extends Byte> msgID, DafnySequence<? extends Byte> legend, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encContext, DafnySequence<? extends EncryptedDataKey> dataKeys) {
        return new PartialHeader(version, flavor, msgID, legend, encContext, dataKeys);
    }

    public static PartialHeader create_PartialHeader(byte version, byte flavor, DafnySequence<? extends Byte> msgID, DafnySequence<? extends Byte> legend, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encContext, DafnySequence<? extends EncryptedDataKey> dataKeys) {
        return PartialHeader.create(version, flavor, msgID, legend, encContext, dataKeys);
    }

    public boolean is_PartialHeader() {
        return true;
    }

    public byte dtor_version() {
        return this._version;
    }

    public byte dtor_flavor() {
        return this._flavor;
    }

    public DafnySequence<? extends Byte> dtor_msgID() {
        return this._msgID;
    }

    public DafnySequence<? extends Byte> dtor_legend() {
        return this._legend;
    }

    public DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> dtor_encContext() {
        return this._encContext;
    }

    public DafnySequence<? extends EncryptedDataKey> dtor_dataKeys() {
        return this._dataKeys;
    }

    public DafnySequence<? extends Byte> serialize() {
        DafnySequence<? extends Byte> _331_context = __default.SerializeContext(this.dtor_encContext());
        DafnySequence<? extends Byte> _332_keys = __default.SerializeDataKeys(this.dtor_dataKeys());
        DafnySequence<? extends Byte> _333_leg = __default.SerializeLegend(this.dtor_legend());
        return DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.of((byte[])new byte[]{this.dtor_version()}), (DafnySequence)DafnySequence.of((byte[])new byte[]{this.dtor_flavor()})), this.dtor_msgID()), _333_leg), _331_context), _332_keys);
    }

    public Result<Boolean, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> verifyCommitment(IAwsCryptographicPrimitivesClient client, AlgorithmSuiteInfo alg, DafnySequence<? extends Byte> commitKey, DafnySequence<? extends Byte> data) {
        Outcome _334_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (__default.COMMITMENT__LEN().compareTo(BigInteger.valueOf(data.length())) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Serialized header too short")));
        if (_334_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _334_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
        }
        DafnySequence _335_storedCommitment = data.drop(BigInteger.valueOf(data.length()).subtract(__default.COMMITMENT__LEN()));
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _336_valueOrError1 = __default.CalculateHeaderCommitment(client, alg, commitKey, (DafnySequence<? extends Byte>)data.take(BigInteger.valueOf(data.length()).subtract(__default.COMMITMENT__LEN())));
        if (_336_valueOrError1.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _336_valueOrError1.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
        }
        DafnySequence _337_calcCommitment = (DafnySequence)_336_valueOrError1.Extract(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        Outcome _338_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)StructuredEncryptionUtil_Compile.__default.ConstantTimeEquals((DafnySequence<? extends Byte>)_335_storedCommitment, (DafnySequence<? extends Byte>)_337_calcCommitment), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key commitment mismatch.")));
        if (_338_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _338_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
        }
        return Result.create_Success((Object)true);
    }

    public Result<AlgorithmSuiteInfo, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetAlgorithmSuite(MaterialProvidersClient matProv) {
        Result ret = null;
        Result _339_algorithmSuiteR = matProv.GetAlgorithmSuiteInfo(DafnySequence.of((byte[])new byte[]{StructuredEncryptionUtil_Compile.__default.DbeAlgorithmFamily(), this.dtor_flavor()}));
        if (_339_algorithmSuiteR.is_Success()) {
            Outcome _340_valueOrError0 = Outcome.Default();
            _340_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)StructuredEncryptionUtil_Compile.__default.ValidSuite((AlgorithmSuiteInfo)_339_algorithmSuiteR.dtor_value()), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Algorithm Suite")));
            if (_340_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                ret = _340_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), AlgorithmSuiteInfo._typeDescriptor());
                return ret;
            }
            ret = Result.create_Success((Object)_339_algorithmSuiteR.dtor_value());
            return ret;
        }
        ret = _339_algorithmSuiteR.MapFailure(AlgorithmSuiteInfo._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), _341_e_boxed0 -> {
            Error _341_e = _341_e_boxed0;
            return software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error.create_AwsCryptographyMaterialProviders(_341_e);
        });
        return ret;
    }
}

