/*
 * Decompiled with CFR 0.152.
 */
package StructuredEncryptionFooter_Compile;

import BoundedInts_Compile.uint8;
import StructuredEncryptionFooter_Compile.RecipientTag;
import StructuredEncryptionFooter_Compile.__default;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredData;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSAVerifyInput;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.HMacInput;

public class Footer {
    public DafnySequence<? extends DafnySequence<? extends Byte>> _tags;
    public Option<DafnySequence<? extends Byte>> _sig;
    private static final Footer theDefault = Footer.create((DafnySequence<? extends DafnySequence<? extends Byte>>)DafnySequence.empty(RecipientTag._typeDescriptor()), (Option<DafnySequence<? extends Byte>>)Option.Default());
    private static final TypeDescriptor<Footer> _TYPE = TypeDescriptor.referenceWithInitializer(Footer.class, () -> Footer.Default());

    public Footer(DafnySequence<? extends DafnySequence<? extends Byte>> tags, Option<DafnySequence<? extends Byte>> sig) {
        this._tags = tags;
        this._sig = sig;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Footer o = (Footer)other;
        return Objects.equals(this._tags, o._tags) && Objects.equals(this._sig, o._sig);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._tags);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._sig);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("StructuredEncryptionFooter_Compile.Footer.Footer");
        s.append("(");
        s.append(Helpers.toString(this._tags));
        s.append(", ");
        s.append(Helpers.toString(this._sig));
        s.append(")");
        return s.toString();
    }

    public static Footer Default() {
        return theDefault;
    }

    public static TypeDescriptor<Footer> _typeDescriptor() {
        return _TYPE;
    }

    public static Footer create(DafnySequence<? extends DafnySequence<? extends Byte>> tags, Option<DafnySequence<? extends Byte>> sig) {
        return new Footer(tags, sig);
    }

    public static Footer create_Footer(DafnySequence<? extends DafnySequence<? extends Byte>> tags, Option<DafnySequence<? extends Byte>> sig) {
        return Footer.create(tags, sig);
    }

    public boolean is_Footer() {
        return true;
    }

    public DafnySequence<? extends DafnySequence<? extends Byte>> dtor_tags() {
        return this._tags;
    }

    public Option<DafnySequence<? extends Byte>> dtor_sig() {
        return this._sig;
    }

    public DafnySequence<? extends Byte> serialize() {
        return DafnySequence.concatenate(__default.SerializeTags(this.dtor_tags()), __default.SerializeSig(this.dtor_sig()));
    }

    public StructuredData makeTerminal() {
        return StructuredEncryptionUtil_Compile.__default.ValueToData(this.serialize(), StructuredEncryptionUtil_Compile.__default.BYTES__TYPE__ID());
    }

    public Result<Boolean, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> validate(AtomicPrimitivesClient client, DecryptionMaterials mat, DafnySequence<? extends EncryptedDataKey> edks, DafnySequence<? extends DafnySequence<? extends Byte>> signedFields, DafnySequence<? extends DafnySequence<? extends Byte>> encFields, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends StructuredData> encData, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends StructuredData> allData, DafnySequence<? extends Byte> header) {
        Result ret = Result.Default((Object)false);
        Outcome _464_valueOrError0 = Outcome.Default();
        _464_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)Objects.equals(BigInteger.valueOf(edks.length()), BigInteger.valueOf(this.dtor_tags().length())), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"There are a different number of recipient tags in the stored header than there are in the decryption materials.")));
        if (_464_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            ret = _464_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return ret;
        }
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _466_valueOrError1 = Result.Default((Object)DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _out4 = __default.CanonHash(signedFields, encFields, encData, allData, header, (DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)mat.dtor_encryptionContext());
        _466_valueOrError1 = _out4;
        if (_466_valueOrError1.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            ret = _466_valueOrError1.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return ret;
        }
        DafnySequence _465_canonicalHash = (DafnySequence)_466_valueOrError1.Extract(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        HMacInput _467_input = HMacInput.create((DigestAlgorithm)mat.dtor_algorithmSuite().dtor_symmetricSignature().dtor_HMAC(), (DafnySequence)((DafnySequence)mat.dtor_symmetricSigningKey().dtor_value()), (DafnySequence)_465_canonicalHash);
        Result _468_hashR = client.HMac(_467_input);
        Result _470_valueOrError2 = Result.Default((Object)DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor()));
        _470_valueOrError2 = _468_hashR.MapFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), _471_e_boxed0 -> {
            Error _471_e = _471_e_boxed0;
            return software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error.create_AwsCryptographyPrimitives(_471_e);
        });
        if (_470_valueOrError2.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            ret = _470_valueOrError2.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return ret;
        }
        DafnySequence _469_hash = (DafnySequence)_470_valueOrError2.Extract(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        Outcome _472_valueOrError3 = Outcome.Default();
        _472_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)Objects.equals(BigInteger.valueOf(_469_hash.length()), BigInteger.valueOf(48L)), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Bad hash length")));
        if (_472_valueOrError3.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            ret = _472_valueOrError3.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return ret;
        }
        boolean _473_foundTag = false;
        BigInteger _hi0 = BigInteger.valueOf(this.dtor_tags().length());
        BigInteger _474_i = BigInteger.ZERO;
        while (_474_i.compareTo(_hi0) < 0) {
            if (StructuredEncryptionUtil_Compile.__default.ConstantTimeEquals((DafnySequence<? extends Byte>)_469_hash, (DafnySequence<? extends Byte>)((DafnySequence)this.dtor_tags().select(Helpers.toInt((BigInteger)_474_i))))) {
                _473_foundTag = true;
                break;
            }
            _474_i = _474_i.add(BigInteger.ONE);
        }
        Outcome _475_valueOrError4 = Outcome.Default();
        _475_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)_473_foundTag, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"No recipient tag matched.")));
        if (_475_valueOrError4.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            ret = _475_valueOrError4.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return ret;
        }
        Outcome _476_valueOrError5 = Outcome.Default();
        _476_valueOrError5 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (this.dtor_sig().is_Some() == mat.dtor_algorithmSuite().dtor_signature().is_ECDSA() ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Internal error. Signature both does and does not exist.")));
        if (_476_valueOrError5.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            ret = _476_valueOrError5.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return ret;
        }
        if (this.dtor_sig().is_Some()) {
            Result _out5;
            ECDSAVerifyInput _477_verInput = ECDSAVerifyInput.create((ECDSASignatureAlgorithm)mat.dtor_algorithmSuite().dtor_signature().dtor_ECDSA().dtor_curve(), (DafnySequence)((DafnySequence)mat.dtor_verificationKey().dtor_value()), (DafnySequence)_465_canonicalHash, (DafnySequence)((DafnySequence)this.dtor_sig().dtor_value()));
            Result _478_verR = _out5 = client.ECDSAVerify(_477_verInput);
            Result _480_valueOrError6 = Result.Default((Object)false);
            _480_valueOrError6 = _478_verR.MapFailure(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), _481_e_boxed0 -> {
                Error _481_e = _481_e_boxed0;
                return software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error.create_AwsCryptographyPrimitives(_481_e);
            });
            if (_480_valueOrError6.IsFailure(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                ret = _480_valueOrError6.PropagateFailure(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
                return ret;
            }
            boolean _479_ver = (Boolean)_480_valueOrError6.Extract(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
            Outcome _482_valueOrError7 = Outcome.Default();
            _482_valueOrError7 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)_479_ver, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Signature did not verify")));
            if (_482_valueOrError7.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                ret = _482_valueOrError7.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
                return ret;
            }
        }
        ret = Result.create_Success((Object)true);
        return ret;
    }
}

