/*
 * Decompiled with CFR 0.152.
 */
package SearchableEncryptionInfo_Compile;

import BoundedInts_Compile.uint8;
import DynamoDbEncryptionUtil_Compile.MaybeKeyId;
import DynamoDbEncryptionUtil_Compile.MaybeKeyId_KeyId;
import DynamoDbEncryptionUtil_Compile.MaybeKeyMap;
import SearchableEncryptionInfo_Compile.KeyLocation;
import SearchableEncryptionInfo_Compile.__default;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials;
import software.amazon.cryptography.keystore.internaldafny.types.Error;
import software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyInput;
import software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyOutput;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;

public class KeySource {
    public AtomicPrimitivesClient _client;
    public IKeyStoreClient _store;
    public KeyLocation _keyLoc;
    public ICryptographicMaterialsCache _cache;
    public int _cacheTTL;
    private static final KeySource theDefault = KeySource.create(null, null, KeyLocation.Default(), null, 0);
    private static final TypeDescriptor<KeySource> _TYPE = TypeDescriptor.referenceWithInitializer(KeySource.class, () -> KeySource.Default());

    public KeySource(AtomicPrimitivesClient client, IKeyStoreClient store, KeyLocation keyLoc, ICryptographicMaterialsCache cache, int cacheTTL) {
        this._client = client;
        this._store = store;
        this._keyLoc = keyLoc;
        this._cache = cache;
        this._cacheTTL = cacheTTL;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        KeySource o = (KeySource)other;
        return this._client == o._client && this._store == o._store && Objects.equals(this._keyLoc, o._keyLoc) && this._cache == o._cache && this._cacheTTL == o._cacheTTL;
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._client);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._store);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._keyLoc);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._cache);
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._cacheTTL);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("SearchableEncryptionInfo_Compile.KeySource.KeySource");
        s.append("(");
        s.append(Helpers.toString((Object)this._client));
        s.append(", ");
        s.append(Helpers.toString((Object)this._store));
        s.append(", ");
        s.append(Helpers.toString((Object)this._keyLoc));
        s.append(", ");
        s.append(Helpers.toString((Object)this._cache));
        s.append(", ");
        s.append(this._cacheTTL);
        s.append(")");
        return s.toString();
    }

    public static KeySource Default() {
        return theDefault;
    }

    public static TypeDescriptor<KeySource> _typeDescriptor() {
        return _TYPE;
    }

    public static KeySource create(AtomicPrimitivesClient client, IKeyStoreClient store, KeyLocation keyLoc, ICryptographicMaterialsCache cache, int cacheTTL) {
        return new KeySource(client, store, keyLoc, cache, cacheTTL);
    }

    public static KeySource create_KeySource(AtomicPrimitivesClient client, IKeyStoreClient store, KeyLocation keyLoc, ICryptographicMaterialsCache cache, int cacheTTL) {
        return KeySource.create(client, store, keyLoc, cache, cacheTTL);
    }

    public boolean is_KeySource() {
        return true;
    }

    public AtomicPrimitivesClient dtor_client() {
        return this._client;
    }

    public IKeyStoreClient dtor_store() {
        return this._store;
    }

    public KeyLocation dtor_keyLoc() {
        return this._keyLoc;
    }

    public ICryptographicMaterialsCache dtor_cache() {
        return this._cache;
    }

    public int dtor_cacheTTL() {
        return this._cacheTTL;
    }

    public Result<MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getKeyMap(DafnySequence<? extends DafnySequence<? extends Character>> stdNames, MaybeKeyId keyId) {
        DafnySequence<? extends Character> _999___mcc_h0;
        Result output = Result.Default((Object)MaybeKeyMap.Default());
        if (this.dtor_keyLoc().is_SingleLoc()) {
            Outcome _993_valueOrError0 = Outcome.Default();
            _993_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (boolean)keyId.is_DontUseKeyId(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"KeyID should not be supplied with a SingleKeyStore")));
            if (_993_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _993_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), MaybeKeyMap._typeDescriptor());
                return output;
            }
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _995_valueOrError1 = Result.Default((Object)DafnyMap.empty());
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out34 = this.getKeysCache(stdNames, this.dtor_keyLoc().dtor_keyId());
            _995_valueOrError1 = _out34;
            if (_995_valueOrError1.IsFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _995_valueOrError1.PropagateFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), MaybeKeyMap._typeDescriptor());
                return output;
            }
            DafnyMap _994_theMap = (DafnyMap)_995_valueOrError1.Extract(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            output = Result.create_Success((Object)MaybeKeyMap.create_Keys((DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>)_994_theMap));
            return output;
        }
        if (this.dtor_keyLoc().is_LiteralLoc()) {
            Outcome _996_valueOrError2 = Outcome.Default();
            _996_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (boolean)keyId.is_DontUseKeyId(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"KeyID should not be supplied with a LiteralKeyStore")));
            if (_996_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _996_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), MaybeKeyMap._typeDescriptor());
                return output;
            }
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _998_valueOrError3 = Result.Default((Object)DafnyMap.empty());
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out35 = this.getKeysLiteral();
            _998_valueOrError3 = _out35;
            if (_998_valueOrError3.IsFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _998_valueOrError3.PropagateFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), MaybeKeyMap._typeDescriptor());
                return output;
            }
            DafnyMap _997_theMap = (DafnyMap)_998_valueOrError3.Extract(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            output = Result.create_Success((Object)MaybeKeyMap.create_Keys((DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>)_997_theMap));
            return output;
        }
        MaybeKeyId _source13 = keyId;
        if (_source13.is_DontUseKeyId()) {
            output = Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"KeyID must not be supplied with a MultiKeyStore")));
            return output;
        }
        if (_source13.is_ShouldHaveKeyId()) {
            output = Result.create_Success((Object)MaybeKeyMap.create_ShouldHaveKeys());
            return output;
        }
        DafnySequence<? extends Character> _1000_id = _999___mcc_h0 = ((MaybeKeyId_KeyId)_source13)._value;
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1002_valueOrError4 = Result.Default((Object)DafnyMap.empty());
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out36 = this.getKeysCache(stdNames, _1000_id);
        _1002_valueOrError4 = _out36;
        if (_1002_valueOrError4.IsFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1002_valueOrError4.PropagateFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), MaybeKeyMap._typeDescriptor());
            return output;
        }
        DafnyMap _1001_theMap = (DafnyMap)_1002_valueOrError4.Extract(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        output = Result.create_Success((Object)MaybeKeyMap.create_Keys((DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>)_1001_theMap));
        return output;
    }

    public Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getKeysLiteral() {
        Result output = Result.Default((Object)DafnyMap.empty());
        output = Result.create_Success(this.dtor_keyLoc().dtor_keys());
        return output;
    }

    public Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getKeysCache(DafnySequence<? extends DafnySequence<? extends Character>> stdNames, DafnySequence<? extends Character> keyId) {
        Result output = Result.Default((Object)DafnyMap.empty());
        Result _1003_keyIdBytesR = UTF8.__default.Encode(keyId);
        Result _1005_valueOrError0 = Result.Default((Object)ValidUTF8Bytes.defaultValue());
        _1005_valueOrError0 = _1003_keyIdBytesR.MapFailure(ValidUTF8Bytes._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), _1006_e_boxed0 -> {
            DafnySequence _1006_e = _1006_e_boxed0;
            return DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)_1006_e);
        });
        if (_1005_valueOrError0.IsFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1005_valueOrError0.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())));
            return output;
        }
        DafnySequence _1004_keyIdBytes = (DafnySequence)_1005_valueOrError0.Extract(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        GetCacheEntryInput _1007_getCacheInput = GetCacheEntryInput.create((DafnySequence)_1004_keyIdBytes, (Option)Option.create_None());
        Result _out37 = this.dtor_cache().GetCacheEntry(_1007_getCacheInput);
        Result _1008_getCacheOutput = _out37;
        if (_1008_getCacheOutput.is_Failure()) {
            Result _out41;
            long _out40;
            DafnyMap _1015_keyMap;
            Result _out38;
            Result _1009_maybeRawBeaconKeyMaterials = _out38 = this.dtor_store().GetBeaconKey(GetBeaconKeyInput.create(keyId));
            Result _1011_valueOrError1 = Result.Default((Object)GetBeaconKeyOutput.Default());
            _1011_valueOrError1 = _1009_maybeRawBeaconKeyMaterials.MapFailure(GetBeaconKeyOutput._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), _1012_e_boxed0 -> {
                Error _1012_e = _1012_e_boxed0;
                return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error.create_AwsCryptographyKeyStore(_1012_e);
            });
            if (_1011_valueOrError1.IsFailure(GetBeaconKeyOutput._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _1011_valueOrError1.PropagateFailure(GetBeaconKeyOutput._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())));
                return output;
            }
            GetBeaconKeyOutput _1010_rawBeaconKeyMaterials = (GetBeaconKeyOutput)_1011_valueOrError1.Extract(GetBeaconKeyOutput._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            Option _1013_key = _1010_rawBeaconKeyMaterials.dtor_beaconKeyMaterials().dtor_beaconKey();
            Outcome _1014_valueOrError2 = Outcome.Default();
            _1014_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (boolean)_1013_key.is_Some(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"beacon key unexpectedly empty")));
            if (_1014_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _1014_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())));
                return output;
            }
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1016_valueOrError3 = Result.Default((Object)DafnyMap.empty());
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out39 = this.getAllKeys(stdNames, (DafnySequence<? extends Byte>)((DafnySequence)_1013_key.dtor_value()));
            _1016_valueOrError3 = _out39;
            if (_1016_valueOrError3.IsFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _1016_valueOrError3.PropagateFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())));
                return output;
            }
            DafnyMap _pat_let_tv2 = _1015_keyMap = (DafnyMap)_1016_valueOrError3.Extract(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            BeaconKeyMaterials _1017_beaconKeyMaterials = (BeaconKeyMaterials)Helpers.Let((Object)_1010_rawBeaconKeyMaterials.dtor_beaconKeyMaterials(), boxed30 -> {
                BeaconKeyMaterials _pat_let16_0 = boxed30;
                return (BeaconKeyMaterials)Helpers.Let((Object)_pat_let16_0, boxed31 -> {
                    BeaconKeyMaterials _1018_dt__update__tmp_h0 = boxed31;
                    return (BeaconKeyMaterials)Helpers.Let((Object)Option.create_Some((Object)_pat_let_tv2), boxed32 -> {
                        Option _pat_let17_0 = boxed32;
                        return (BeaconKeyMaterials)Helpers.Let((Object)_pat_let17_0, boxed33 -> {
                            Option _1019_dt__update_hhmacKeys_h0 = boxed33;
                            return (BeaconKeyMaterials)Helpers.Let((Object)Option.create_None(), boxed34 -> {
                                Option _pat_let18_0 = boxed34;
                                return (BeaconKeyMaterials)Helpers.Let((Object)_pat_let18_0, boxed35 -> {
                                    Option _1020_dt__update_hbeaconKey_h0 = boxed35;
                                    return BeaconKeyMaterials.create((DafnySequence)_1018_dt__update__tmp_h0.dtor_beaconKeyIdentifier(), (DafnyMap)_1018_dt__update__tmp_h0.dtor_encryptionContext(), (Option)_1020_dt__update_hbeaconKey_h0, (Option)_1019_dt__update_hhmacKeys_h0);
                                });
                            });
                        });
                    });
                });
            });
            long _1021_now = _out40 = Time.__default.CurrentRelativeTime().longValue();
            PutCacheEntryInput _1022_putCacheEntryInput = PutCacheEntryInput.create((DafnySequence)_1004_keyIdBytes, (Materials)Materials.create_BeaconKey((BeaconKeyMaterials)_1017_beaconKeyMaterials), (long)_1021_now, (long)(_1021_now + Integer.toUnsignedLong(this.dtor_cacheTTL())), (Option)Option.create_None(), (Option)Option.create_None());
            Result _1023___v0 = _out41 = this.dtor_cache().PutCacheEntry(_1022_putCacheEntryInput);
            output = Result.create_Success((Object)_1015_keyMap);
            return output;
        }
        Outcome _1024_valueOrError4 = Outcome.Default();
        _1024_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (((GetCacheEntryOutput)_1008_getCacheOutput.dtor_value()).dtor_materials().is_BeaconKey() && ((GetCacheEntryOutput)_1008_getCacheOutput.dtor_value()).dtor_materials().dtor_BeaconKey().dtor_hmacKeys().is_Some() && ((GetCacheEntryOutput)_1008_getCacheOutput.dtor_value()).dtor_materials().dtor_BeaconKey().dtor_beaconKeyIdentifier().equals(keyId) && ((GetCacheEntryOutput)_1008_getCacheOutput.dtor_value()).dtor_materials().dtor_BeaconKey().dtor_hmacKeys().is_Some() ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Material Type.")));
        if (_1024_valueOrError4.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1024_valueOrError4.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())));
            return output;
        }
        output = Result.create_Success((Object)((GetCacheEntryOutput)_1008_getCacheOutput.dtor_value()).dtor_materials().dtor_BeaconKey().dtor_hmacKeys().dtor_value());
        return output;
    }

    public Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getAllKeys(DafnySequence<? extends DafnySequence<? extends Character>> stdNames, DafnySequence<? extends Byte> key) {
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out42;
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> output = Result.Default((Object)DafnyMap.empty());
        output = _out42 = __default.GetAllKeys(this.dtor_client(), stdNames, key);
        return output;
    }
}

