/*
 * Decompiled with CFR 0.152.
 */
package SearchableEncryptionInfo_Compile;

import BaseBeacon_Compile.StandardBeacon;
import CompoundBeacon_Compile.CompoundBeacon;
import DdbVirtualFields_Compile.VirtField;
import DynamoDbEncryptionUtil_Compile.MaybeKeyMap;
import SearchableEncryptionInfo_Compile.Beacon_Compound;
import SearchableEncryptionInfo_Compile.Beacon_Standard;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue;

public abstract class Beacon {
    private static final Beacon theDefault = Beacon.create_Standard(StandardBeacon.Default());
    private static final TypeDescriptor<Beacon> _TYPE = TypeDescriptor.referenceWithInitializer(Beacon.class, () -> Beacon.Default());

    public static Beacon Default() {
        return theDefault;
    }

    public static TypeDescriptor<Beacon> _typeDescriptor() {
        return _TYPE;
    }

    public static Beacon create_Standard(StandardBeacon std) {
        return new Beacon_Standard(std);
    }

    public static Beacon create_Compound(CompoundBeacon cmp) {
        return new Beacon_Compound(cmp);
    }

    public boolean is_Standard() {
        return this instanceof Beacon_Standard;
    }

    public boolean is_Compound() {
        return this instanceof Beacon_Compound;
    }

    public StandardBeacon dtor_std() {
        Beacon d = this;
        return ((Beacon_Standard)d)._std;
    }

    public CompoundBeacon dtor_cmp() {
        Beacon d = this;
        return ((Beacon_Compound)d)._cmp;
    }

    public boolean isEncrypted() {
        if (this.is_Standard()) {
            return true;
        }
        return this.dtor_cmp().isEncrypted();
    }

    public Result<Option<DafnySequence<? extends Character>>, Error> hash(DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> item, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> vf, MaybeKeyMap keys) {
        if (this.is_Standard()) {
            Outcome _1025_valueOrError0 = __default.Need(Error._typeDescriptor(), (boolean)keys.is_Keys(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Need key for beacon "), this.dtor_std().dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" but no keyId found in query."))));
            if (_1025_valueOrError0.IsFailure(Error._typeDescriptor())) {
                return _1025_valueOrError0.PropagateFailure(Error._typeDescriptor(), Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
            }
            if (keys.dtor_value().contains(this.dtor_std().dtor_base().dtor_name())) {
                return this.dtor_std().getHash(item, vf, (DafnySequence<? extends Byte>)((DafnySequence)keys.dtor_value().get(this.dtor_std().dtor_base().dtor_name())));
            }
            return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Internal error. Beacon "), this.dtor_std().dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" has no key."))));
        }
        return this.dtor_cmp().hash(item, vf, keys);
    }

    public Result<Option<AttributeValue>, Error> naked(DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> item, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> vf) {
        if (this.is_Standard()) {
            return this.dtor_std().getNaked(item, vf);
        }
        Result<Option<DafnySequence<? extends Character>>, Error> _1026_valueOrError0 = this.dtor_cmp().getNaked(item, vf);
        if (_1026_valueOrError0.IsFailure(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            return _1026_valueOrError0.PropagateFailure(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), Option._typeDescriptor((TypeDescriptor)AttributeValue._typeDescriptor()));
        }
        Option _1027_str = (Option)_1026_valueOrError0.Extract(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        if (_1027_str.is_None()) {
            return Result.create_Success((Object)Option.create_None());
        }
        return Result.create_Success((Object)Option.create_Some((Object)DdbVirtualFields_Compile.__default.DS((DafnySequence<? extends Character>)((DafnySequence)_1027_str.dtor_value()))));
    }

    public Result<Option<AttributeValue>, Error> attrHash(DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> item, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> vf, MaybeKeyMap keys) {
        if (keys.is_DontUseKeys()) {
            return this.naked(item, vf);
        }
        Result<Option<DafnySequence<? extends Character>>, Error> _1028_valueOrError0 = this.hash(item, vf, keys);
        if (_1028_valueOrError0.IsFailure(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            return _1028_valueOrError0.PropagateFailure(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), Option._typeDescriptor((TypeDescriptor)AttributeValue._typeDescriptor()));
        }
        Option _1029_str = (Option)_1028_valueOrError0.Extract(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        if (_1029_str.is_None()) {
            return Result.create_Success((Object)Option.create_None());
        }
        return Result.create_Success((Object)Option.create_Some((Object)DdbVirtualFields_Compile.__default.DS((DafnySequence<? extends Character>)((DafnySequence)_1029_str.dtor_value()))));
    }

    public DafnySequence<? extends Character> getName() {
        if (this.is_Standard()) {
            return this.dtor_std().dtor_base().dtor_name();
        }
        return this.dtor_cmp().dtor_base().dtor_name();
    }

    public DafnySequence<? extends Character> getBeaconName() {
        if (this.is_Standard()) {
            return this.dtor_std().dtor_base().dtor_beaconName();
        }
        return this.dtor_cmp().dtor_base().dtor_beaconName();
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> GetFields(DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> virtualFields) {
        if (this.is_Standard()) {
            return this.dtor_std().GetFields(virtualFields);
        }
        return this.dtor_cmp().GetFields(virtualFields);
    }

    public Result<AttributeValue, Error> GetBeaconValue(AttributeValue value, MaybeKeyMap keys, boolean forEquality) {
        if (keys.is_DontUseKeys()) {
            return Result.create_Success((Object)value);
        }
        if (this.is_Standard()) {
            Outcome _1030_valueOrError0 = __default.Need(Error._typeDescriptor(), (!keys.is_ShouldHaveKeys() ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Need KeyId because of beacon "), this.dtor_std().dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" but no KeyId found in query"))));
            if (_1030_valueOrError0.IsFailure(Error._typeDescriptor())) {
                return _1030_valueOrError0.PropagateFailure(Error._typeDescriptor(), AttributeValue._typeDescriptor());
            }
            DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>> _1031_keys = keys.dtor_value();
            if (_1031_keys.contains(this.dtor_std().dtor_base().dtor_name())) {
                return this.dtor_std().GetBeaconValue(value, (DafnySequence<? extends Byte>)((DafnySequence)_1031_keys.get(this.dtor_std().dtor_base().dtor_name())));
            }
            return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Internal error. Beacon "), this.dtor_std().dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" has no key."))));
        }
        return this.dtor_cmp().GetBeaconValue(value, keys, forEquality);
    }
}

