/*
 * Decompiled with CFR 0.152.
 */
package SearchConfigToInfo_Compile;

import BaseBeacon_Compile.BeaconBase;
import BaseBeacon_Compile.ValidStandardBeacon;
import CompoundBeacon_Compile.BeaconPart;
import CompoundBeacon_Compile.Constructor;
import CompoundBeacon_Compile.ConstructorPart;
import CompoundBeacon_Compile.ValidCompoundBeacon;
import DdbVirtualFields_Compile.VirtField;
import DdbVirtualFields_Compile.VirtualFieldMap;
import SearchableEncryptionInfo_Compile.Beacon;
import SearchableEncryptionInfo_Compile.BeaconMap;
import SearchableEncryptionInfo_Compile.BeaconVersion;
import SearchableEncryptionInfo_Compile.KeyLocation;
import SearchableEncryptionInfo_Compile.KeySource;
import SearchableEncryptionInfo_Compile.SearchInfo;
import SearchableEncryptionInfo_Compile.ValidBeaconVersion;
import SearchableEncryptionInfo_Compile.ValidSearchInfo;
import TermLoc_Compile.Selector;
import TermLoc_Compile.TermLoc;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.DafnySet;
import dafny.Function0;
import dafny.Function2;
import dafny.Helpers;
import dafny.Tuple2;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.BeaconKeySource;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.CompoundBeacon;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.DynamoDbTableEncryptionConfig;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.EncryptedPart;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.SearchConfig;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.SignedPart;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.StandardBeacon;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualField;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.materialproviders.internaldafny.MaterialProvidersClient;
import software.amazon.cryptography.materialproviders.internaldafny.types.CacheType;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateCryptographicMaterialsCacheInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.DefaultCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.MaterialProvidersConfig;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_ICryptographicMaterialsCache;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.CryptoConfig;
import software.amazon.cryptography.primitives.internaldafny.types.Error;

public class __default {
    private static final TypeDescriptor<__default> _TYPE = TypeDescriptor.referenceWithInitializer(__default.class, () -> null);

    public static Result<Option<SearchInfo>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> Convert(DynamoDbTableEncryptionConfig outer) {
        Result output = Result.Default((Object)Option.Default());
        if (outer.dtor_search().is_None()) {
            output = Result.create_Success((Object)Option.create_None());
            return output;
        }
        Outcome _1056_valueOrError0 = Outcome.Default();
        _1056_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (((SearchConfig)outer.dtor_search().dtor_value()).dtor_writeVersion() == 1 ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"writeVersion must be '1'.")));
        if (_1056_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1056_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), Option._typeDescriptor(ValidSearchInfo._typeDescriptor()));
            return output;
        }
        Outcome _1057_valueOrError1 = Outcome.Default();
        _1057_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (boolean)Objects.equals(BigInteger.valueOf(((SearchConfig)outer.dtor_search().dtor_value()).dtor_versions().length()), BigInteger.ONE), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"search config must be have exactly one version.")));
        if (_1057_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1057_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), Option._typeDescriptor(ValidSearchInfo._typeDescriptor()));
            return output;
        }
        Result<BeaconVersion, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1059_valueOrError2 = null;
        Result<BeaconVersion, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out52 = __default.ConvertVersion(outer, (software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.BeaconVersion)((SearchConfig)outer.dtor_search().dtor_value()).dtor_versions().select(Helpers.toInt((BigInteger)BigInteger.ZERO)));
        _1059_valueOrError2 = _out52;
        if (_1059_valueOrError2.IsFailure(ValidBeaconVersion._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1059_valueOrError2.PropagateFailure(ValidBeaconVersion._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), Option._typeDescriptor(ValidSearchInfo._typeDescriptor()));
            return output;
        }
        BeaconVersion _1058_version = (BeaconVersion)_1059_valueOrError2.Extract(ValidBeaconVersion._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        SearchInfo _1060_info = SearchableEncryptionInfo_Compile.__default.MakeSearchInfo(_1058_version);
        output = Result.create_Success((Object)Option.create_Some((Object)_1060_info));
        return output;
    }

    public static Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> ShouldDeleteKeyField(DynamoDbTableEncryptionConfig outer, DafnySequence<? extends Character> keyFieldName) {
        if (!outer.dtor_attributeActionsOnEncrypt().contains(keyFieldName)) {
            return Result.create_Success((Object)true);
        }
        CryptoAction _source15 = (CryptoAction)outer.dtor_attributeActionsOnEncrypt().get(keyFieldName);
        if (_source15.is_ENCRYPT__AND__SIGN()) {
            return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Beacon key field name "), keyFieldName), (DafnySequence)DafnySequence.asString((String)" is configured as ENCRYPT_AND_SIGN which is not allowed."))));
        }
        if (_source15.is_SIGN__ONLY()) {
            return Result.create_Success((Object)false);
        }
        return Result.create_Success((Object)true);
    }

    public static Result<KeySource, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> MakeKeySource(DynamoDbTableEncryptionConfig outer, IKeyStoreClient keyStore, BeaconKeySource config, AtomicPrimitivesClient client) {
        Result _out54;
        Result _out53;
        Result output = null;
        Result _1061_mplR = _out53 = software.amazon.cryptography.materialproviders.internaldafny.__default.MaterialProviders((MaterialProvidersConfig)software.amazon.cryptography.materialproviders.internaldafny.__default.DefaultMaterialProvidersConfig());
        Result _1063_valueOrError0 = null;
        _1063_valueOrError0 = _1061_mplR.MapFailure(MaterialProvidersClient._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), _1064_e_boxed0 -> {
            software.amazon.cryptography.materialproviders.internaldafny.types.Error _1064_e = _1064_e_boxed0;
            return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error.create_AwsCryptographyMaterialProviders(_1064_e);
        });
        if (_1063_valueOrError0.IsFailure(MaterialProvidersClient._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1063_valueOrError0.PropagateFailure(MaterialProvidersClient._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), KeySource._typeDescriptor());
            return output;
        }
        MaterialProvidersClient _1062_mpl = (MaterialProvidersClient)_1063_valueOrError0.Extract(MaterialProvidersClient._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        CacheType _1065_cacheType = config.is_multi() ? (config.dtor_multi().dtor_cache().is_Some() ? (CacheType)config.dtor_multi().dtor_cache().dtor_value() : CacheType.create_Default((DefaultCache)DefaultCache.create((int)1000))) : CacheType.create_Default((DefaultCache)DefaultCache.create((int)1));
        CreateCryptographicMaterialsCacheInput _1066_input = CreateCryptographicMaterialsCacheInput.create((CacheType)_1065_cacheType);
        Result _1067_maybeCache = _out54 = _1062_mpl.CreateCryptographicMaterialsCache(_1066_input);
        Result _1069_valueOrError1 = null;
        _1069_valueOrError1 = _1067_maybeCache.MapFailure(_Companion_ICryptographicMaterialsCache._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), _1070_e_boxed0 -> {
            software.amazon.cryptography.materialproviders.internaldafny.types.Error _1070_e = _1070_e_boxed0;
            return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error.create_AwsCryptographyMaterialProviders(_1070_e);
        });
        if (_1069_valueOrError1.IsFailure(_Companion_ICryptographicMaterialsCache._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1069_valueOrError1.PropagateFailure(_Companion_ICryptographicMaterialsCache._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), KeySource._typeDescriptor());
            return output;
        }
        ICryptographicMaterialsCache _1068_cache = (ICryptographicMaterialsCache)_1069_valueOrError1.Extract(_Companion_ICryptographicMaterialsCache._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        if (config.is_multi()) {
            Outcome _1071_valueOrError2 = Outcome.Default();
            _1071_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Integer.signum(config.dtor_multi().dtor_cacheTTL()) == 1 ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Beacon Cache TTL must be at least 1.")));
            if (_1071_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _1071_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), KeySource._typeDescriptor());
                return output;
            }
            Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1073_valueOrError3 = Result.Default((Object)false);
            _1073_valueOrError3 = __default.ShouldDeleteKeyField(outer, config.dtor_multi().dtor_keyFieldName());
            if (_1073_valueOrError3.IsFailure(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _1073_valueOrError3.PropagateFailure(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), KeySource._typeDescriptor());
                return output;
            }
            boolean _1072_deleteKey = (Boolean)_1073_valueOrError3.Extract(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            output = Result.create_Success((Object)KeySource.create(client, keyStore, KeyLocation.create_MultiLoc(config.dtor_multi().dtor_keyFieldName(), _1072_deleteKey), _1068_cache, config.dtor_multi().dtor_cacheTTL()));
        } else {
            Outcome _1074_valueOrError4 = Outcome.Default();
            _1074_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Integer.signum(config.dtor_single().dtor_cacheTTL()) == 1 ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Beacon Cache TTL must be at least 1.")));
            if (_1074_valueOrError4.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _1074_valueOrError4.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), KeySource._typeDescriptor());
                return output;
            }
            output = Result.create_Success((Object)KeySource.create(client, keyStore, KeyLocation.create_SingleLoc(config.dtor_single().dtor_keyId()), _1068_cache, config.dtor_single().dtor_cacheTTL()));
        }
        return output;
    }

    public static Result<BeaconVersion, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> ConvertVersion(DynamoDbTableEncryptionConfig outer, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.BeaconVersion config) {
        Result<BeaconVersion, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out57;
        Result _out55;
        Result<BeaconVersion, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> output = null;
        Outcome _1075_valueOrError0 = Outcome.Default();
        _1075_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (config.dtor_version() == 1 ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Version number in BeaconVersion must be '1'.")));
        if (_1075_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1075_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ValidBeaconVersion._typeDescriptor());
            return output;
        }
        Outcome _1076_valueOrError1 = Outcome.Default();
        _1076_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(config.dtor_standardBeacons().length()).signum() == 1 ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"At least one standard beacon must be configured.")));
        if (_1076_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1076_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ValidBeaconVersion._typeDescriptor());
            return output;
        }
        Result _1077_maybePrimitives = _out55 = software.amazon.cryptography.primitives.internaldafny.__default.AtomicPrimitives((CryptoConfig)software.amazon.cryptography.primitives.internaldafny.__default.DefaultCryptoConfig());
        Result _1079_valueOrError2 = null;
        _1079_valueOrError2 = _1077_maybePrimitives.MapFailure(AtomicPrimitivesClient._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), _1080_e_boxed0 -> {
            Error _1080_e = _1080_e_boxed0;
            return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error.create_AwsCryptographyPrimitives(_1080_e);
        });
        if (_1079_valueOrError2.IsFailure(AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1079_valueOrError2.PropagateFailure(AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ValidBeaconVersion._typeDescriptor());
            return output;
        }
        AtomicPrimitivesClient _1078_primitives = (AtomicPrimitivesClient)_1079_valueOrError2.Extract(AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        Result<KeySource, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1082_valueOrError3 = null;
        Result<KeySource, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out56 = __default.MakeKeySource(outer, config.dtor_keyStore(), config.dtor_keySource(), _1078_primitives);
        _1082_valueOrError3 = _out56;
        if (_1082_valueOrError3.IsFailure(KeySource._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1082_valueOrError3.PropagateFailure(KeySource._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ValidBeaconVersion._typeDescriptor());
            return output;
        }
        KeySource _1081_source = (KeySource)_1082_valueOrError3.Extract(KeySource._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        output = _out57 = __default.ConvertVersionWithSource(outer, config, _1081_source);
        return output;
    }

    public static Result<BeaconVersion, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> ConvertVersionWithSource(DynamoDbTableEncryptionConfig outer, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.BeaconVersion config, KeySource source) {
        Result output = null;
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1084_valueOrError0 = Result.Default((Object)DafnyMap.empty());
        _1084_valueOrError0 = __default.ConvertVirtualFields(outer, config.dtor_virtualFields());
        if (_1084_valueOrError0.IsFailure(VirtualFieldMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1084_valueOrError0.PropagateFailure(VirtualFieldMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ValidBeaconVersion._typeDescriptor());
            return output;
        }
        DafnyMap _1083_virtualFields = (DafnyMap)_1084_valueOrError0.Extract(VirtualFieldMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1086_valueOrError1 = null;
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out58 = __default.ConvertBeacons(outer, source.dtor_client(), (DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField>)_1083_virtualFields, config.dtor_standardBeacons(), config.dtor_compoundBeacons());
        _1086_valueOrError1 = _out58;
        if (_1086_valueOrError1.IsFailure(BeaconMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1086_valueOrError1.PropagateFailure(BeaconMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ValidBeaconVersion._typeDescriptor());
            return output;
        }
        DafnyMap _1085_beacons = (DafnyMap)_1086_valueOrError1.Extract(BeaconMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        if (source.dtor_keyLoc().is_MultiLoc()) {
            DafnySequence<? extends Character> _1087_name = source.dtor_keyLoc().dtor_keyName();
            if (_1085_beacons.contains(_1087_name)) {
                output = Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"A beacon key field name of "), _1087_name), (DafnySequence)DafnySequence.asString((String)" was configured, but there's also a beacon of that name."))));
                return output;
            }
            if (_1083_virtualFields.contains(_1087_name)) {
                output = Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"A beacon key field name of "), _1087_name), (DafnySequence)DafnySequence.asString((String)" was configured, but there's also a virtual field of that name."))));
                return output;
            }
        }
        output = SearchableEncryptionInfo_Compile.__default.MakeBeaconVersion(config.dtor_version(), source, (DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon>)_1085_beacons, (DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField>)_1083_virtualFields, outer.dtor_attributeActionsOnEncrypt());
        return output;
    }

    public static Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> ConvertVirtualFields(DynamoDbTableEncryptionConfig outer, Option<DafnySequence<? extends VirtualField>> vf) {
        if (vf.is_None()) {
            return Result.create_Success((Object)DafnyMap.fromElements((Tuple2[])new Tuple2[0]));
        }
        return __default.AddVirtualFields((DafnySequence<? extends VirtualField>)((DafnySequence)vf.dtor_value()), outer, (DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField>)DafnyMap.fromElements((Tuple2[])new Tuple2[0]));
    }

    public static boolean IsSigned(DynamoDbTableEncryptionConfig outer, DafnySequence<? extends Selector> loc) {
        DynamoDbTableEncryptionConfig _pat_let_tv3 = outer;
        DynamoDbTableEncryptionConfig _pat_let_tv4 = outer;
        return (Boolean)Helpers.Let(((Selector)loc.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_key(), boxed36 -> {
            DafnySequence _pat_let19_0 = boxed36;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let19_0, boxed37 -> {
                DafnySequence _1088_name = boxed37;
                return _pat_let_tv3.dtor_attributeActionsOnEncrypt().contains((Object)_1088_name) && !Objects.equals((CryptoAction)_pat_let_tv4.dtor_attributeActionsOnEncrypt().get((Object)_1088_name), CryptoAction.create_DO__NOTHING());
            }));
        });
    }

    public static boolean IsSignOnly(DynamoDbTableEncryptionConfig outer, DafnySequence<? extends Selector> loc) {
        DynamoDbTableEncryptionConfig _pat_let_tv5 = outer;
        DynamoDbTableEncryptionConfig _pat_let_tv6 = outer;
        return (Boolean)Helpers.Let(((Selector)loc.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_key(), boxed38 -> {
            DafnySequence _pat_let20_0 = boxed38;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let20_0, boxed39 -> {
                DafnySequence _1089_name = boxed39;
                return _pat_let_tv5.dtor_attributeActionsOnEncrypt().contains((Object)_1089_name) && Objects.equals((CryptoAction)_pat_let_tv6.dtor_attributeActionsOnEncrypt().get((Object)_1089_name), CryptoAction.create_SIGN__ONLY());
            }));
        });
    }

    public static boolean IsEncrypted(DynamoDbTableEncryptionConfig outer, DafnySequence<? extends Selector> loc) {
        DynamoDbTableEncryptionConfig _pat_let_tv7 = outer;
        DynamoDbTableEncryptionConfig _pat_let_tv8 = outer;
        return (Boolean)Helpers.Let(((Selector)loc.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_key(), boxed40 -> {
            DafnySequence _pat_let21_0 = boxed40;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let21_0, boxed41 -> {
                DafnySequence _1090_name = boxed41;
                return _pat_let_tv7.dtor_attributeActionsOnEncrypt().contains((Object)_1090_name) && Objects.equals((CryptoAction)_pat_let_tv8.dtor_attributeActionsOnEncrypt().get((Object)_1090_name), CryptoAction.create_ENCRYPT__AND__SIGN());
            }));
        });
    }

    public static boolean IsEncryptedV(DynamoDbTableEncryptionConfig outer, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> virtualFields, DafnySequence<? extends Selector> loc) {
        return __default.IsEncrypted(outer, loc) || virtualFields.contains(((Selector)loc.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_key()) && ((VirtField)virtualFields.get(((Selector)loc.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_key())).examine(((Function<DynamoDbTableEncryptionConfig, Function>)_1091_outer -> _1092_t_boxed0 -> {
            DafnySequence _1092_t = _1092_t_boxed0;
            return __default.IsEncrypted(_1091_outer, (DafnySequence<? extends Selector>)_1092_t);
        }).apply(outer));
    }

    public static Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> BeaconNameAllowed(DynamoDbTableEncryptionConfig outer, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> virtualFields, DafnySequence<? extends Character> name, DafnySequence<? extends Character> context, boolean isSignedBeacon) {
        if (outer.dtor_attributeActionsOnEncrypt().contains(name) && !Objects.equals((CryptoAction)outer.dtor_attributeActionsOnEncrypt().get(name), CryptoAction.create_ENCRYPT__AND__SIGN())) {
            return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(name, (DafnySequence)DafnySequence.asString((String)" not allowed as a ")), context), (DafnySequence)DafnySequence.asString((String)" because it is already an unencrypted attribute."))));
        }
        if (isSignedBeacon && outer.dtor_attributeActionsOnEncrypt().contains(name)) {
            return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(name, (DafnySequence)DafnySequence.asString((String)" not allowed as a ")), context), (DafnySequence)DafnySequence.asString((String)" because a fully signed beacon cannot have the same name as an existing attribute."))));
        }
        if (outer.dtor_allowedUnsignedAttributes().is_Some() && ((DafnySequence)outer.dtor_allowedUnsignedAttributes().dtor_value()).contains(name)) {
            return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(name, (DafnySequence)DafnySequence.asString((String)" not allowed as a ")), context), (DafnySequence)DafnySequence.asString((String)" because it is already an allowed unauthenticated attribute."))));
        }
        if (outer.dtor_allowedUnsignedAttributePrefix().is_Some() && ((DafnySequence)outer.dtor_allowedUnsignedAttributePrefix().dtor_value()).isPrefixOf(name)) {
            return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(name, (DafnySequence)DafnySequence.asString((String)" not allowed as a ")), context), (DafnySequence)DafnySequence.asString((String)" because it begins with the allowed unauthenticated prefix."))));
        }
        if (DynamoDbEncryptionUtil_Compile.__default.ReservedPrefix().isPrefixOf(name)) {
            return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(name, (DafnySequence)DafnySequence.asString((String)" not allowed as a ")), context), (DafnySequence)DafnySequence.asString((String)" because it begins with the reserved prefix."))));
        }
        return Result.create_Success((Object)true);
    }

    public static Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> VirtualFieldNameAllowed(DynamoDbTableEncryptionConfig outer, DafnySequence<? extends Character> name) {
        if (outer.dtor_attributeActionsOnEncrypt().contains(name)) {
            return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate(name, (DafnySequence)DafnySequence.asString((String)" not allowed as a Virtual Field because it is already a configured attribute."))));
        }
        if (outer.dtor_allowedUnsignedAttributes().is_Some() && ((DafnySequence)outer.dtor_allowedUnsignedAttributes().dtor_value()).contains(name)) {
            return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate(name, (DafnySequence)DafnySequence.asString((String)" not allowed as a Virtual Field because it is already an allowed unauthenticated attribute."))));
        }
        if (outer.dtor_allowedUnsignedAttributePrefix().is_Some() && ((DafnySequence)outer.dtor_allowedUnsignedAttributePrefix().dtor_value()).isPrefixOf(name)) {
            return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate(name, (DafnySequence)DafnySequence.asString((String)" not allowed as a Virtual Field because it begins with the allowed unauthenticated prefix."))));
        }
        if (DynamoDbEncryptionUtil_Compile.__default.ReservedPrefix().isPrefixOf(name)) {
            return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate(name, (DafnySequence)DafnySequence.asString((String)" not allowed as a Virtual Field because it begins with the reserved prefix."))));
        }
        return Result.create_Success((Object)true);
    }

    public static Option<DafnySequence<? extends Character>> FindVirtualFieldWithThisLocation(DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> fields, DafnySet<? extends DafnySequence<? extends Selector>> locs) {
        DafnySet _1093_badNames = ((Function2<DafnyMap, DafnySet, DafnySet>)(_1094_fields, _1095_locs) -> ((Function0<DafnySet>)() -> {
            ArrayList<DafnySequence> _coll27 = new ArrayList<DafnySequence>();
            for (DafnySequence _compr_27_boxed0 : _1094_fields.keySet().Elements()) {
                DafnySequence _compr_27 = _compr_27_boxed0;
                DafnySequence _1096_b = _compr_27;
                if (!_1094_fields.contains((Object)_1096_b) || !((VirtField)_1094_fields.get((Object)_1096_b)).GetLocs().equals(_1095_locs)) continue;
                _coll27.add(_1096_b);
            }
            return new DafnySet(_coll27);
        }).apply()).apply(fields, locs);
        if (BigInteger.valueOf(_1093_badNames.size()).signum() == 0) {
            return Option.create_None();
        }
        DafnySequence _1097_badSeq = SortedSets.__default.SetToOrderedSequence2((TypeDescriptor)TypeDescriptor.CHAR, (DafnySet)_1093_badNames, DynamoDbEncryptionUtil_Compile.__default::CharLess);
        return Option.create_Some((Object)((DafnySequence)_1097_badSeq.select(Helpers.toInt((BigInteger)BigInteger.ZERO))));
    }

    public static boolean ExistsConstructorWithTheseRequired(DafnySequence<? extends Constructor> cons, DafnySet<? extends BeaconPart> locs) {
        return __default.SeqCount(Constructor._typeDescriptor(), ((Function<DafnySet, Function>)_1098_locs -> _1099_c_boxed0 -> {
            Constructor _1099_c = _1099_c_boxed0;
            return _1099_c.getReqParts().equals(_1098_locs);
        }).apply(locs), cons).signum() == 1;
    }

    public static DafnySequence<? extends Character> getPartsString(Constructor c) {
        DafnySequence _1100_req = Seq_Compile.__default.Filter(ConstructorPart._typeDescriptor(), _1101_p_boxed0 -> {
            ConstructorPart _1101_p = _1101_p_boxed0;
            return _1101_p.dtor_required();
        }, c.dtor_parts());
        DafnySequence _1102_names = Seq_Compile.__default.Map(ConstructorPart._typeDescriptor(), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), _1103_p_boxed0 -> {
            ConstructorPart _1103_p = _1103_p_boxed0;
            return _1103_p.dtor_part().getName();
        }, (DafnySequence)_1100_req);
        if (BigInteger.valueOf(_1102_names.length()).signum() == 0) {
            return DafnySequence.asString((String)"");
        }
        return StandardLibrary_Compile.__default.Join((TypeDescriptor)TypeDescriptor.CHAR, (DafnySequence)_1102_names, (DafnySequence)DafnySequence.asString((String)", "));
    }

    public static Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> AddVirtualFields(DafnySequence<? extends VirtualField> vf, DynamoDbTableEncryptionConfig outer, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> converted) {
        while (BigInteger.valueOf(vf.length()).signum() != 0) {
            Outcome _1104_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (!converted.contains(((VirtualField)vf.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name()) ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Duplicate VirtualField name : "), ((VirtualField)vf.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name())));
            if (_1104_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                return _1104_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), VirtualFieldMap._typeDescriptor());
            }
            Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1105_valueOrError1 = __default.VirtualFieldNameAllowed(outer, ((VirtualField)vf.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name());
            if (_1105_valueOrError1.IsFailure(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                return _1105_valueOrError1.PropagateFailure(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), VirtualFieldMap._typeDescriptor());
            }
            boolean _1106___v0 = (Boolean)_1105_valueOrError1.Extract(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            Result<VirtField, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1107_valueOrError2 = DdbVirtualFields_Compile.__default.ParseVirtualFieldConfig((VirtualField)vf.select(Helpers.toInt((BigInteger)BigInteger.ZERO)));
            if (_1107_valueOrError2.IsFailure(VirtField._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                return _1107_valueOrError2.PropagateFailure(VirtField._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), VirtualFieldMap._typeDescriptor());
            }
            VirtField _1108_newField = (VirtField)_1107_valueOrError2.Extract(VirtField._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            Outcome _1109_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (!_1108_newField.examine(((Function<DynamoDbTableEncryptionConfig, Function>)_1110_outer -> _1111_t_boxed0 -> {
                DafnySequence _1111_t = _1111_t_boxed0;
                return !__default.IsSigned(_1110_outer, (DafnySequence<? extends Selector>)_1111_t);
            }).apply(outer)) ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"VirtualField "), ((VirtualField)vf.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name()), (DafnySequence)DafnySequence.asString((String)" must be defined on signed fields."))));
            if (_1109_valueOrError3.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                return _1109_valueOrError3.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), VirtualFieldMap._typeDescriptor());
            }
            Option<DafnySequence<? extends Character>> _1112_badField = __default.FindVirtualFieldWithThisLocation(converted, _1108_newField.GetLocs());
            if (_1112_badField.is_Some()) {
                return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Virtual field "), ((VirtualField)vf.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name()), (DafnySequence)DafnySequence.asString((String)" is defined on the same locations as ")), (DafnySequence)((DafnySequence)_1112_badField.dtor_value())), (DafnySequence)DafnySequence.asString((String)"."))));
            }
            DafnySequence _in157 = vf.drop(BigInteger.ONE);
            DynamoDbTableEncryptionConfig _in158 = outer;
            DafnyMap _in159 = DafnyMap.update(converted, ((VirtualField)vf.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name(), (Object)_1108_newField);
            vf = _in157;
            outer = _in158;
            converted = _in159;
        }
        return Result.create_Success(converted);
    }

    public static Option<DafnySequence<? extends Character>> FindBeaconWithThisLocation(DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon> beacons, DafnySequence<? extends Selector> loc) {
        DafnySet _1113_badNames = ((Function2<DafnyMap, DafnySequence, DafnySet>)(_1114_beacons, _1115_loc) -> ((Function0<DafnySet>)() -> {
            ArrayList<DafnySequence> _coll28 = new ArrayList<DafnySequence>();
            for (DafnySequence _compr_28_boxed0 : _1114_beacons.keySet().Elements()) {
                DafnySequence _compr_28 = _compr_28_boxed0;
                DafnySequence _1116_b = _compr_28;
                if (!_1114_beacons.contains((Object)_1116_b) || !((Beacon)_1114_beacons.get((Object)_1116_b)).is_Standard() || !((Beacon)_1114_beacons.get((Object)_1116_b)).dtor_std().dtor_loc().equals(_1115_loc)) continue;
                _coll28.add(_1116_b);
            }
            return new DafnySet(_coll28);
        }).apply()).apply(beacons, loc);
        if (BigInteger.valueOf(_1113_badNames.size()).signum() == 0) {
            return Option.create_None();
        }
        DafnySequence _1117_badSeq = SortedSets.__default.SetToOrderedSequence2((TypeDescriptor)TypeDescriptor.CHAR, (DafnySet)_1113_badNames, DynamoDbEncryptionUtil_Compile.__default::CharLess);
        return Option.create_Some((Object)((DafnySequence)_1117_badSeq.select(Helpers.toInt((BigInteger)BigInteger.ZERO))));
    }

    public static Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> AddStandardBeacons(DafnySequence<? extends StandardBeacon> beacons, DynamoDbTableEncryptionConfig outer, AtomicPrimitivesClient client, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> virtualFields, DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon> converted) {
        Result _out59;
        Result output = null;
        if (BigInteger.valueOf(beacons.length()).signum() == 0) {
            output = Result.create_Success(converted);
            return output;
        }
        Outcome _1118_valueOrError0 = Outcome.Default();
        _1118_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (!converted.contains(((StandardBeacon)beacons.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name()) ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Duplicate StandardBeacon name : "), ((StandardBeacon)beacons.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name())));
        if (_1118_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1118_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), BeaconMap._typeDescriptor());
            return output;
        }
        Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1120_valueOrError1 = Result.Default((Object)false);
        _1120_valueOrError1 = __default.BeaconNameAllowed(outer, virtualFields, ((StandardBeacon)beacons.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name(), (DafnySequence<? extends Character>)DafnySequence.asString((String)"StandardBeacon"), false);
        if (_1120_valueOrError1.IsFailure(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1120_valueOrError1.PropagateFailure(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), BeaconMap._typeDescriptor());
            return output;
        }
        boolean _1119___v1 = (Boolean)_1120_valueOrError1.Extract(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        DafnySequence<? extends Character> _1121_locString = __default.GetLocStr(((StandardBeacon)beacons.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name(), ((StandardBeacon)beacons.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_loc());
        Result<BaseBeacon_Compile.StandardBeacon, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1123_valueOrError2 = null;
        _1123_valueOrError2 = BaseBeacon_Compile.__default.MakeStandardBeacon(client, ((StandardBeacon)beacons.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name(), (byte)((StandardBeacon)beacons.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_length(), _1121_locString);
        if (_1123_valueOrError2.IsFailure(ValidStandardBeacon._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1123_valueOrError2.PropagateFailure(ValidStandardBeacon._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), BeaconMap._typeDescriptor());
            return output;
        }
        BaseBeacon_Compile.StandardBeacon _1122_newBeacon = (BaseBeacon_Compile.StandardBeacon)_1123_valueOrError2.Extract(ValidStandardBeacon._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        Outcome _1124_valueOrError3 = Outcome.Default();
        _1124_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (boolean)__default.IsEncryptedV(outer, virtualFields, _1122_newBeacon.dtor_loc()), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"StandardBeacon "), ((StandardBeacon)beacons.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name()), (DafnySequence)DafnySequence.asString((String)" not defined on an encrypted field."))));
        if (_1124_valueOrError3.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1124_valueOrError3.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), BeaconMap._typeDescriptor());
            return output;
        }
        Option<DafnySequence<? extends Character>> _1125_badBeacon = __default.FindBeaconWithThisLocation(converted, _1122_newBeacon.dtor_loc());
        if (_1125_badBeacon.is_Some()) {
            output = Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Beacon "), ((StandardBeacon)beacons.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name()), (DafnySequence)DafnySequence.asString((String)" is defined on location ")), TermLoc_Compile.__default.TermLocToString(_1122_newBeacon.dtor_loc())), (DafnySequence)DafnySequence.asString((String)", but beacon ")), (DafnySequence)((DafnySequence)_1125_badBeacon.dtor_value())), (DafnySequence)DafnySequence.asString((String)" is already defined on that location."))));
            return output;
        }
        Option<DafnySequence<? extends Character>> _1126_badField = __default.FindVirtualFieldWithThisLocation(virtualFields, (DafnySet<? extends DafnySequence<? extends Selector>>)DafnySet.of((Object[])new DafnySequence[]{_1122_newBeacon.dtor_loc()}));
        if (_1126_badField.is_Some()) {
            output = Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Beacon "), ((StandardBeacon)beacons.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name()), (DafnySequence)DafnySequence.asString((String)" is defined on location ")), TermLoc_Compile.__default.TermLocToString(_1122_newBeacon.dtor_loc())), (DafnySequence)DafnySequence.asString((String)", but virtual field ")), (DafnySequence)((DafnySequence)_1126_badField.dtor_value())), (DafnySequence)DafnySequence.asString((String)" is already defined on that single location."))));
            return output;
        }
        output = _out59 = __default.AddStandardBeacons((DafnySequence<? extends StandardBeacon>)beacons.drop(BigInteger.ONE), outer, client, virtualFields, (DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon>)DafnyMap.update(converted, ((StandardBeacon)beacons.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name(), (Object)Beacon.create_Standard(_1122_newBeacon)));
        return output;
    }

    public static Result<DafnySequence<? extends Selector>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> GetLoc(DafnySequence<? extends Character> name, Option<DafnySequence<? extends Character>> loc) {
        if (loc.is_None()) {
            return Result.create_Success(TermLoc_Compile.__default.TermLocMap(name));
        }
        return TermLoc_Compile.__default.MakeTermLoc((DafnySequence<? extends Character>)((DafnySequence)loc.dtor_value()));
    }

    public static DafnySequence<? extends Character> GetLocStr(DafnySequence<? extends Character> name, Option<DafnySequence<? extends Character>> loc) {
        if (loc.is_None()) {
            return name;
        }
        return (DafnySequence)loc.dtor_value();
    }

    public static Result<DafnySequence<? extends BeaconPart>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> AddSignedParts(DafnySequence<? extends SignedPart> parts, DynamoDbTableEncryptionConfig outer, BigInteger origSize, DafnySequence<? extends BeaconPart> converted) {
        while (BigInteger.valueOf(parts.length()).signum() != 0) {
            Result<DafnySequence<? extends Selector>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1127_valueOrError0 = __default.GetLoc(((SignedPart)parts.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name(), ((SignedPart)parts.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_loc());
            if (_1127_valueOrError0.IsFailure(TermLoc._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                return _1127_valueOrError0.PropagateFailure(TermLoc._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(BeaconPart._typeDescriptor()));
            }
            DafnySequence _1128_loc = (DafnySequence)_1127_valueOrError0.Extract(TermLoc._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            BeaconPart _1129_newPart = BeaconPart.create_Signed(((SignedPart)parts.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_prefix(), ((SignedPart)parts.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name(), (DafnySequence<? extends Selector>)_1128_loc);
            Outcome _1130_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (boolean)__default.IsSignOnly(outer, _1129_newPart.dtor_loc()), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Signed Part "), _1129_newPart.dtor_name()), (DafnySequence)DafnySequence.asString((String)" is built from ")), __default.GetLocStr(((SignedPart)parts.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name(), ((SignedPart)parts.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_loc())), (DafnySequence)DafnySequence.asString((String)" which is not SIGN_ONLY."))));
            if (_1130_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                return _1130_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(BeaconPart._typeDescriptor()));
            }
            DafnySequence _in160 = parts.drop(BigInteger.ONE);
            DynamoDbTableEncryptionConfig _in161 = outer;
            BigInteger _in162 = origSize;
            DafnySequence _in163 = DafnySequence.concatenate(converted, (DafnySequence)DafnySequence.of(BeaconPart._typeDescriptor(), (Object[])new BeaconPart[]{_1129_newPart}));
            parts = _in160;
            outer = _in161;
            origSize = _in162;
            converted = _in163;
        }
        return Result.create_Success(converted);
    }

    public static Result<DafnySequence<? extends BeaconPart>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> AddEncryptedParts(DafnySequence<? extends EncryptedPart> parts, DafnySequence<? extends BeaconPart> converted, DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon> std) {
        while (true) {
            if (BigInteger.valueOf(parts.length()).signum() == 0) {
                return Result.create_Success(converted);
            }
            if (!std.contains(((EncryptedPart)parts.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name()) || !((Beacon)std.get(((EncryptedPart)parts.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name())).is_Standard()) break;
            BeaconPart _1131_newPart = BeaconPart.create_Encrypted(((EncryptedPart)parts.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_prefix(), ((Beacon)std.get(((EncryptedPart)parts.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name())).dtor_std());
            DafnySequence _in164 = parts.drop(BigInteger.ONE);
            DafnySequence _in165 = DafnySequence.concatenate(converted, (DafnySequence)DafnySequence.of(BeaconPart._typeDescriptor(), (Object[])new BeaconPart[]{_1131_newPart}));
            DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon> _in166 = std;
            parts = _in164;
            converted = _in165;
            std = _in166;
        }
        return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Encrypted part needs standard beacon "), ((EncryptedPart)parts.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name()), (DafnySequence)DafnySequence.asString((String)" which is not configured."))));
    }

    public static Result<DafnySequence<? extends Constructor>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> MakeDefaultConstructor(DafnySequence<? extends BeaconPart> parts, DafnySequence<? extends ConstructorPart> converted) {
        while (BigInteger.valueOf(parts.length()).signum() != 0) {
            DafnySequence _in167 = parts.drop(BigInteger.ONE);
            DafnySequence _in168 = DafnySequence.concatenate(converted, (DafnySequence)DafnySequence.of(ConstructorPart._typeDescriptor(), (Object[])new ConstructorPart[]{ConstructorPart.create((BeaconPart)parts.select(Helpers.toInt((BigInteger)BigInteger.ZERO)), true)}));
            parts = _in167;
            converted = _in168;
        }
        return Result.create_Success((Object)DafnySequence.of(Constructor._typeDescriptor(), (Object[])new Constructor[]{Constructor.create(converted)}));
    }

    public static <__T> DafnySequence<? extends __T> MyFilter(TypeDescriptor<__T> _td___T, Function<__T, Boolean> f, DafnySequence<? extends __T> xs) {
        DafnySequence _1132___accumulator = DafnySequence.empty(_td___T);
        while (BigInteger.valueOf(xs.length()).signum() != 0) {
            _1132___accumulator = DafnySequence.concatenate((DafnySequence)_1132___accumulator, (DafnySequence)(f.apply(xs.select(Helpers.toInt((BigInteger)BigInteger.ZERO))) != false ? DafnySequence.of(_td___T, (Object[])new Object[]{xs.select(Helpers.toInt((BigInteger)BigInteger.ZERO))}) : DafnySequence.empty(_td___T)));
            Function<__T, Boolean> _in169 = f;
            DafnySequence _in170 = xs.drop(BigInteger.ONE);
            f = _in169;
            xs = _in170;
        }
        return DafnySequence.concatenate((DafnySequence)_1132___accumulator, (DafnySequence)DafnySequence.empty(_td___T));
    }

    public static <__T> BigInteger SeqCount(TypeDescriptor<__T> _td___T, Function<__T, Boolean> f, DafnySequence<? extends __T> xs) {
        BigInteger _1133___accumulator = BigInteger.ZERO;
        while (BigInteger.valueOf(xs.length()).signum() != 0) {
            _1133___accumulator = _1133___accumulator.add(f.apply(xs.select(Helpers.toInt((BigInteger)BigInteger.ZERO))) != false ? BigInteger.ONE : BigInteger.ZERO);
            Function<__T, Boolean> _in171 = f;
            DafnySequence _in172 = xs.drop(BigInteger.ONE);
            f = _in171;
            xs = _in172;
        }
        return BigInteger.ZERO.add(_1133___accumulator);
    }

    public static Result<DafnySequence<? extends ConstructorPart>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> MakeConstructor2(DafnySequence<? extends software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.ConstructorPart> c, DafnySequence<? extends BeaconPart> parts, BigInteger origSize, DafnySequence<? extends ConstructorPart> converted) {
        while (BigInteger.valueOf(c.length()).signum() != 0) {
            DafnySequence<? extends BeaconPart> _1134_thePart = __default.MyFilter(BeaconPart._typeDescriptor(), ((Function<DafnySequence, Function>)_1135_c -> _1136_p_boxed0 -> {
                BeaconPart _1136_p = _1136_p_boxed0;
                return _1136_p.getName().equals(((software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.ConstructorPart)_1135_c.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name());
            }).apply(c), parts);
            Outcome _1137_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(_1134_thePart.length()).signum() == 1 ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Constructor refers to part name "), ((software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.ConstructorPart)c.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name()), (DafnySequence)DafnySequence.asString((String)" but there is no part by that name."))));
            if (_1137_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                return _1137_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(ConstructorPart._typeDescriptor()));
            }
            ConstructorPart _1138_newPart = ConstructorPart.create((BeaconPart)_1134_thePart.select(Helpers.toInt((BigInteger)BigInteger.ZERO)), ((software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.ConstructorPart)c.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_required());
            DafnySequence _in173 = c.drop(BigInteger.ONE);
            DafnySequence<? extends BeaconPart> _in174 = parts;
            BigInteger _in175 = origSize;
            DafnySequence _in176 = DafnySequence.concatenate(converted, (DafnySequence)DafnySequence.of(ConstructorPart._typeDescriptor(), (Object[])new ConstructorPart[]{_1138_newPart}));
            c = _in173;
            parts = _in174;
            origSize = _in175;
            converted = _in176;
        }
        return Result.create_Success(converted);
    }

    public static Result<Constructor, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> MakeConstructor(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Constructor c, DafnySequence<? extends BeaconPart> parts) {
        Result<DafnySequence<? extends ConstructorPart>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1139_valueOrError0 = __default.MakeConstructor2(c.dtor_parts(), parts, BigInteger.valueOf(c.dtor_parts().length()), (DafnySequence<? extends ConstructorPart>)DafnySequence.empty(ConstructorPart._typeDescriptor()));
        if (_1139_valueOrError0.IsFailure(DafnySequence._typeDescriptor(ConstructorPart._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            return _1139_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor(ConstructorPart._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), Constructor._typeDescriptor());
        }
        DafnySequence _1140_newParts = (DafnySequence)_1139_valueOrError0.Extract(DafnySequence._typeDescriptor(ConstructorPart._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        return Result.create_Success((Object)Constructor.create((DafnySequence<? extends ConstructorPart>)_1140_newParts));
    }

    public static Result<DafnySequence<? extends Constructor>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> AddConstructors2(DafnySequence<? extends software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Constructor> constructors, DafnySequence<? extends Character> name, DafnySequence<? extends BeaconPart> parts, BigInteger origSize, DafnySequence<? extends Constructor> converted) {
        while (BigInteger.valueOf(constructors.length()).signum() != 0) {
            Outcome _1141_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(((software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Constructor)constructors.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_parts().length()).signum() == 1 ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Every constructor must have at least one part.")));
            if (_1141_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                return _1141_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(Constructor._typeDescriptor()));
            }
            Outcome _1142_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (__default.SeqCount(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.ConstructorPart._typeDescriptor(), _1143_p_boxed0 -> {
                software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.ConstructorPart _1143_p = _1143_p_boxed0;
                return _1143_p.dtor_required();
            }, ((software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Constructor)constructors.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_parts()).signum() == 1 ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"A Constructor for beacon "), name), (DafnySequence)DafnySequence.asString((String)" lacks any required parts"))));
            if (_1142_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                return _1142_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(Constructor._typeDescriptor()));
            }
            Result<Constructor, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1144_valueOrError2 = __default.MakeConstructor((software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Constructor)constructors.select(Helpers.toInt((BigInteger)BigInteger.ZERO)), parts);
            if (_1144_valueOrError2.IsFailure(Constructor._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                return _1144_valueOrError2.PropagateFailure(Constructor._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(Constructor._typeDescriptor()));
            }
            Constructor _1145_c = (Constructor)_1144_valueOrError2.Extract(Constructor._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            if (__default.ExistsConstructorWithTheseRequired(converted, _1145_c.getReqParts())) {
                DafnySequence<? extends Character> _1146_p = __default.getPartsString(_1145_c);
                return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Multiple constructors for "), name), (DafnySequence)DafnySequence.asString((String)" have the same set of required parts : ")), _1146_p)));
            }
            DafnySequence _in177 = constructors.drop(BigInteger.ONE);
            DafnySequence<? extends Character> _in178 = name;
            DafnySequence<? extends BeaconPart> _in179 = parts;
            BigInteger _in180 = origSize;
            DafnySequence _in181 = DafnySequence.concatenate(converted, (DafnySequence)DafnySequence.of(Constructor._typeDescriptor(), (Object[])new Constructor[]{_1145_c}));
            constructors = _in177;
            name = _in178;
            parts = _in179;
            origSize = _in180;
            converted = _in181;
        }
        return Result.create_Success(converted);
    }

    public static Result<DafnySequence<? extends Constructor>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> AddConstructors(Option<DafnySequence<? extends software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Constructor>> constructors, DafnySequence<? extends Character> name, DafnySequence<? extends BeaconPart> parts) {
        if (constructors.is_None()) {
            return __default.MakeDefaultConstructor(parts, (DafnySequence<? extends ConstructorPart>)DafnySequence.empty(ConstructorPart._typeDescriptor()));
        }
        return __default.AddConstructors2((DafnySequence<? extends software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Constructor>)((DafnySequence)constructors.dtor_value()), name, parts, BigInteger.valueOf(((DafnySequence)constructors.dtor_value()).length()), (DafnySequence<? extends Constructor>)DafnySequence.empty(Constructor._typeDescriptor()));
    }

    public static Result<CompoundBeacon_Compile.CompoundBeacon, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> CreateCompoundBeacon(CompoundBeacon beacon, DynamoDbTableEncryptionConfig outer, AtomicPrimitivesClient client, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> virtualFields, DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon> converted) {
        DafnySequence _1147_signed = beacon.dtor_signed().is_Some() ? (DafnySequence)beacon.dtor_signed().dtor_value() : DafnySequence.empty(SignedPart._typeDescriptor());
        DafnySequence _1148_encrypted = beacon.dtor_encrypted().is_Some() ? (DafnySequence)beacon.dtor_encrypted().dtor_value() : DafnySequence.empty(EncryptedPart._typeDescriptor());
        boolean _1149_isSignedBeacon = BigInteger.valueOf(_1148_encrypted.length()).signum() == 0;
        Outcome _1150_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (!converted.contains(beacon.dtor_name()) ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Duplicate CompoundBeacon name : "), beacon.dtor_name())));
        if (_1150_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            return _1150_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ValidCompoundBeacon._typeDescriptor());
        }
        Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1151_valueOrError1 = __default.BeaconNameAllowed(outer, virtualFields, beacon.dtor_name(), (DafnySequence<? extends Character>)DafnySequence.asString((String)"CompoundBeacon"), _1149_isSignedBeacon);
        if (_1151_valueOrError1.IsFailure(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            return _1151_valueOrError1.PropagateFailure(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ValidCompoundBeacon._typeDescriptor());
        }
        boolean _1152___v2 = (Boolean)_1151_valueOrError1.Extract(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        Result<DafnySequence<? extends BeaconPart>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1153_valueOrError2 = __default.AddSignedParts((DafnySequence<? extends SignedPart>)_1147_signed, outer, BigInteger.valueOf(_1147_signed.length()), (DafnySequence<? extends BeaconPart>)DafnySequence.empty(BeaconPart._typeDescriptor()));
        if (_1153_valueOrError2.IsFailure(DafnySequence._typeDescriptor(BeaconPart._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            return _1153_valueOrError2.PropagateFailure(DafnySequence._typeDescriptor(BeaconPart._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ValidCompoundBeacon._typeDescriptor());
        }
        DafnySequence _1154_parts = (DafnySequence)_1153_valueOrError2.Extract(DafnySequence._typeDescriptor(BeaconPart._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        BigInteger _1155_numNon = BigInteger.valueOf(_1154_parts.length());
        Result<DafnySequence<? extends BeaconPart>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1156_valueOrError3 = __default.AddEncryptedParts((DafnySequence<? extends EncryptedPart>)_1148_encrypted, (DafnySequence<? extends BeaconPart>)_1154_parts, converted);
        if (_1156_valueOrError3.IsFailure(DafnySequence._typeDescriptor(BeaconPart._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            return _1156_valueOrError3.PropagateFailure(DafnySequence._typeDescriptor(BeaconPart._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ValidCompoundBeacon._typeDescriptor());
        }
        DafnySequence _1157_parts = (DafnySequence)_1156_valueOrError3.Extract(DafnySequence._typeDescriptor(BeaconPart._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        Outcome _1158_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(_1157_parts.length()).signum() == 1 ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"For beacon "), beacon.dtor_name()), (DafnySequence)DafnySequence.asString((String)" no parts were supplied."))));
        if (_1158_valueOrError4.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            return _1158_valueOrError4.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ValidCompoundBeacon._typeDescriptor());
        }
        Outcome _1159_valueOrError5 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (beacon.dtor_constructors().is_None() || BigInteger.valueOf(((DafnySequence)beacon.dtor_constructors().dtor_value()).length()).signum() == 1 ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"For beacon "), beacon.dtor_name()), (DafnySequence)DafnySequence.asString((String)" an empty constructor list was supplied."))));
        if (_1159_valueOrError5.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            return _1159_valueOrError5.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ValidCompoundBeacon._typeDescriptor());
        }
        Result<DafnySequence<? extends Constructor>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1160_valueOrError6 = __default.AddConstructors(beacon.dtor_constructors(), beacon.dtor_name(), (DafnySequence<? extends BeaconPart>)_1157_parts);
        if (_1160_valueOrError6.IsFailure(DafnySequence._typeDescriptor(Constructor._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            return _1160_valueOrError6.PropagateFailure(DafnySequence._typeDescriptor(Constructor._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ValidCompoundBeacon._typeDescriptor());
        }
        DafnySequence _1161_constructors = (DafnySequence)_1160_valueOrError6.Extract(DafnySequence._typeDescriptor(Constructor._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        DafnySequence _1162_beaconName = _1149_isSignedBeacon ? beacon.dtor_name() : DafnySequence.concatenate(DynamoDbEncryptionUtil_Compile.__default.BeaconPrefix(), beacon.dtor_name());
        Outcome _1163_valueOrError7 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (boolean)software.amazon.cryptography.services.dynamodb.internaldafny.types.__default.IsValid__AttributeName((DafnySequence)_1162_beaconName), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)_1162_beaconName, (DafnySequence)DafnySequence.asString((String)" is not a valid attribute name."))));
        if (_1163_valueOrError7.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            return _1163_valueOrError7.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ValidCompoundBeacon._typeDescriptor());
        }
        return CompoundBeacon_Compile.__default.MakeCompoundBeacon(BeaconBase.create(client, beacon.dtor_name(), (DafnySequence<? extends Character>)_1162_beaconName), ((Character)beacon.dtor_split().select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue(), (DafnySequence<? extends BeaconPart>)_1157_parts, _1155_numNon, (DafnySequence<? extends Constructor>)_1161_constructors);
    }

    public static Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> AddCompoundBeacons(DafnySequence<? extends CompoundBeacon> beacons, DynamoDbTableEncryptionConfig outer, AtomicPrimitivesClient client, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> virtualFields, DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon> converted) {
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out60;
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> output = null;
        if (BigInteger.valueOf(beacons.length()).signum() == 0) {
            output = Result.create_Success(converted);
            return output;
        }
        Result<CompoundBeacon_Compile.CompoundBeacon, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1165_valueOrError0 = null;
        _1165_valueOrError0 = __default.CreateCompoundBeacon((CompoundBeacon)beacons.select(Helpers.toInt((BigInteger)BigInteger.ZERO)), outer, client, virtualFields, converted);
        if (_1165_valueOrError0.IsFailure(CompoundBeacon_Compile.CompoundBeacon._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1165_valueOrError0.PropagateFailure(CompoundBeacon_Compile.CompoundBeacon._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), BeaconMap._typeDescriptor());
            return output;
        }
        CompoundBeacon_Compile.CompoundBeacon _1164_newBeacon = (CompoundBeacon_Compile.CompoundBeacon)_1165_valueOrError0.Extract(CompoundBeacon_Compile.CompoundBeacon._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        output = _out60 = __default.AddCompoundBeacons((DafnySequence<? extends CompoundBeacon>)beacons.drop(BigInteger.ONE), outer, client, virtualFields, (DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon>)DafnyMap.update(converted, ((CompoundBeacon)beacons.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_name(), (Object)Beacon.create_Compound(_1164_newBeacon)));
        return output;
    }

    public static Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> ConvertBeacons(DynamoDbTableEncryptionConfig outer, AtomicPrimitivesClient client, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> virtualFields, DafnySequence<? extends StandardBeacon> standard, Option<DafnySequence<? extends CompoundBeacon>> compound) {
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out62;
        Object output = null;
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1167_valueOrError0 = null;
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out61 = __default.AddStandardBeacons(standard, outer, client, virtualFields, (DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon>)DafnyMap.fromElements((Tuple2[])new Tuple2[0]));
        _1167_valueOrError0 = _out61;
        if (_1167_valueOrError0.IsFailure(BeaconMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1167_valueOrError0.PropagateFailure(BeaconMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), BeaconMap._typeDescriptor());
            return output;
        }
        DafnyMap _1166_std = (DafnyMap)_1167_valueOrError0.Extract(BeaconMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        output = compound.is_Some() ? (_out62 = __default.AddCompoundBeacons((DafnySequence<? extends CompoundBeacon>)((DafnySequence)compound.dtor_value()), outer, client, virtualFields, (DafnyMap<? extends DafnySequence<? extends Character>, ? extends Beacon>)_1166_std)) : Result.create_Success((Object)_1166_std);
        return output;
    }

    public static TypeDescriptor<__default> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "SearchConfigToInfo_Compile._default";
    }
}

