/*
 * Decompiled with CFR 0.152.
 */
package DynamoDbNormalizeNumber_Compile;

import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import _System.nat;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.Tuple2;
import dafny.Tuple3;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;

public class __default {
    private static final TypeDescriptor<__default> _TYPE = TypeDescriptor.referenceWithInitializer(__default.class, () -> null);

    public static DafnySequence<? extends Character> SkipLeadingZeros(DafnySequence<? extends Character> val) {
        while (BigInteger.ONE.compareTo(BigInteger.valueOf(val.length())) < 0 && ((Character)val.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue() == '0' && ((Character)val.select(Helpers.toInt((BigInteger)BigInteger.ONE))).charValue() != '.') {
            DafnySequence _in0;
            val = _in0 = val.drop(BigInteger.ONE);
        }
        return val;
    }

    public static DafnySequence<? extends Character> SkipTrailingZeros(DafnySequence<? extends Character> val) {
        while (BigInteger.ONE.compareTo(BigInteger.valueOf(val.length())) < 0 && ((Character)val.select(Helpers.toInt((BigInteger)BigInteger.valueOf(val.length()).subtract(BigInteger.ONE)))).charValue() == '0') {
            DafnySequence _in1;
            if (((Character)val.select(Helpers.toInt((BigInteger)BigInteger.valueOf(val.length()).subtract(BigInteger.valueOf(2L))))).charValue() == '.') {
                return val.take(BigInteger.valueOf(val.length()).subtract(BigInteger.valueOf(2L)));
            }
            val = _in1 = val.take(BigInteger.valueOf(val.length()).subtract(BigInteger.ONE));
        }
        return val;
    }

    public static DafnySequence<? extends Character> SkipAllTrailingZeros(DafnySequence<? extends Character> val) {
        while (BigInteger.valueOf(val.length()).signum() == 1 && ((Character)val.select(Helpers.toInt((BigInteger)BigInteger.valueOf(val.length()).subtract(BigInteger.ONE)))).charValue() == '0') {
            DafnySequence _in2;
            val = _in2 = val.take(BigInteger.valueOf(val.length()).subtract(BigInteger.ONE));
        }
        return val;
    }

    public static boolean IsDecimalDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    public static Result<BigInteger, DafnySequence<? extends Character>> StrToIntInner(DafnySequence<? extends Character> s, BigInteger acc) {
        while (true) {
            if (BigInteger.valueOf(s.length()).signum() == 0) {
                return Result.create_Success((Object)acc);
            }
            if (!__default.IsDecimalDigit(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue())) break;
            DafnySequence _in3 = s.drop(BigInteger.ONE);
            BigInteger _in4 = acc.multiply(BigInteger.valueOf(10L)).add(BigInteger.valueOf(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue())).subtract(BigInteger.valueOf(48L));
            s = _in3;
            acc = _in4;
        }
        return Result.create_Failure((Object)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"The character '"), (DafnySequence)s.take(BigInteger.ONE)), (DafnySequence)DafnySequence.asString((String)"' is not a valid decimal digit.")));
    }

    public static Result<BigInteger, DafnySequence<? extends Character>> StrToInt(DafnySequence<? extends Character> s) {
        if (BigInteger.valueOf(s.length()).signum() == 0) {
            return Result.create_Failure((Object)DafnySequence.asString((String)"An empty string is not a valid number."));
        }
        if (((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue() == '-') {
            Outcome _20_valueOrError0 = Wrappers_Compile.__default.Need((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (BigInteger.ONE.compareTo(BigInteger.valueOf(s.length())) < 0 ? 1 : 0) != 0, (Object)DafnySequence.asString((String)"An empty string is not a valid number."));
            if (_20_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                return _20_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), TypeDescriptor.BIG_INTEGER);
            }
            Result<BigInteger, DafnySequence<? extends Character>> _21_valueOrError1 = __default.StrToIntInner((DafnySequence<? extends Character>)s.drop(BigInteger.ONE), BigInteger.ZERO);
            if (_21_valueOrError1.IsFailure(nat._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                return _21_valueOrError1.PropagateFailure(nat._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), TypeDescriptor.BIG_INTEGER);
            }
            BigInteger _22_x = (BigInteger)_21_valueOrError1.Extract(nat._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            return Result.create_Success((Object)BigInteger.ZERO.subtract(_22_x));
        }
        if (((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue() == '+') {
            Outcome _23_valueOrError2 = Wrappers_Compile.__default.Need((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (BigInteger.ONE.compareTo(BigInteger.valueOf(s.length())) < 0 ? 1 : 0) != 0, (Object)DafnySequence.asString((String)"An empty string is not a valid number."));
            if (_23_valueOrError2.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                return _23_valueOrError2.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), TypeDescriptor.BIG_INTEGER);
            }
            return __default.StrToIntInner((DafnySequence<? extends Character>)s.drop(BigInteger.ONE), BigInteger.ZERO);
        }
        return __default.StrToIntInner(s, BigInteger.ZERO);
    }

    public static DafnySequence<? extends Character> Zeros(BigInteger n) {
        return DafnySequence.Create((TypeDescriptor)TypeDescriptor.CHAR, (BigInteger)n, _24_i_boxed0 -> {
            BigInteger _24_i = _24_i_boxed0;
            return Character.valueOf('0');
        });
    }

    public static BigInteger CountDigits(DafnySequence<? extends Character> s) {
        BigInteger _25___accumulator = BigInteger.ZERO;
        while (true) {
            DafnySequence _in5;
            if (BigInteger.valueOf(s.length()).signum() == 0) {
                return BigInteger.ZERO.add(_25___accumulator);
            }
            if (!__default.IsDecimalDigit(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue())) break;
            _25___accumulator = _25___accumulator.add(BigInteger.ONE);
            s = _in5 = s.drop(BigInteger.ONE);
        }
        return BigInteger.ZERO.add(_25___accumulator);
    }

    public static boolean IsE(char ch) {
        return ch == 'e' || ch == 'E';
    }

    public static Result<Tuple3<DafnySequence<? extends Character>, BigInteger, BigInteger>, DafnySequence<? extends Character>> ParseNumber(DafnySequence<? extends Character> n) {
        BigInteger _26_preDot = __default.CountDigits(n);
        if (Objects.equals(BigInteger.valueOf(n.length()), _26_preDot)) {
            return Result.create_Success((Object)Tuple3.create(n, (Object)BigInteger.valueOf(n.length()), (Object)BigInteger.ZERO));
        }
        if (((Character)n.select(Helpers.toInt((BigInteger)_26_preDot))).charValue() == '.') {
            BigInteger _27_postDot = __default.CountDigits((DafnySequence<? extends Character>)n.drop(_26_preDot.add(BigInteger.ONE)));
            Outcome _28_valueOrError0 = Wrappers_Compile.__default.Need((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (_26_preDot.add(_27_postDot).signum() == 1 ? 1 : 0) != 0, (Object)DafnySequence.asString((String)"Number needs digits either before or after the decimal point."));
            if (_28_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                return _28_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
            }
            BigInteger _29_len = _26_preDot.add(_27_postDot).add(BigInteger.ONE);
            if (Objects.equals(_29_len, BigInteger.valueOf(n.length()))) {
                return Result.create_Success((Object)Tuple3.create((Object)DafnySequence.concatenate((DafnySequence)n.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)_26_preDot)), (DafnySequence)n.drop(_26_preDot.add(BigInteger.ONE))), (Object)_26_preDot, (Object)BigInteger.ZERO));
            }
            if (__default.IsE(((Character)n.select(Helpers.toInt((BigInteger)_29_len))).charValue())) {
                Result<BigInteger, DafnySequence<? extends Character>> _30_valueOrError1 = __default.StrToInt((DafnySequence<? extends Character>)n.drop(_29_len.add(BigInteger.ONE)));
                if (_30_valueOrError1.IsFailure(TypeDescriptor.BIG_INTEGER, DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                    return _30_valueOrError1.PropagateFailure(TypeDescriptor.BIG_INTEGER, DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
                }
                BigInteger _31_exp = (BigInteger)_30_valueOrError1.Extract(TypeDescriptor.BIG_INTEGER, DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
                return Result.create_Success((Object)Tuple3.create((Object)DafnySequence.concatenate((DafnySequence)n.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)_26_preDot)), (DafnySequence)n.subsequence(Helpers.toInt((BigInteger)_26_preDot.add(BigInteger.ONE)), Helpers.toInt((BigInteger)_29_len))), (Object)_26_preDot, (Object)_31_exp));
            }
            return Result.create_Failure((Object)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Invalid Character in number at '"), (DafnySequence)n.drop(_29_len)), (DafnySequence)DafnySequence.asString((String)"'.")));
        }
        if (_26_preDot.signum() == 0) {
            return Result.create_Failure((Object)DafnySequence.asString((String)"Number needs digits either before or after the decimal point."));
        }
        if (__default.IsE(((Character)n.select(Helpers.toInt((BigInteger)_26_preDot))).charValue())) {
            Result<BigInteger, DafnySequence<? extends Character>> _32_valueOrError2 = __default.StrToInt((DafnySequence<? extends Character>)n.drop(_26_preDot.add(BigInteger.ONE)));
            if (_32_valueOrError2.IsFailure(TypeDescriptor.BIG_INTEGER, DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                return _32_valueOrError2.PropagateFailure(TypeDescriptor.BIG_INTEGER, DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
            }
            BigInteger _33_exp = (BigInteger)_32_valueOrError2.Extract(TypeDescriptor.BIG_INTEGER, DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            return Result.create_Success((Object)Tuple3.create((Object)n.take(_26_preDot), (Object)_26_preDot, (Object)_33_exp));
        }
        return Result.create_Failure((Object)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Invalid Character in number at '"), (DafnySequence)n.drop(_26_preDot)), (DafnySequence)DafnySequence.asString((String)"'.")));
    }

    public static BigInteger CountZeros(DafnySequence<? extends Character> value) {
        BigInteger _34___accumulator = BigInteger.ZERO;
        while (BigInteger.valueOf(value.length()).signum() != 0 && ((Character)value.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue() == '0') {
            DafnySequence _in6;
            _34___accumulator = _34___accumulator.add(BigInteger.ONE);
            value = _in6 = value.drop(BigInteger.ONE);
        }
        return BigInteger.ZERO.add(_34___accumulator);
    }

    public static Tuple2<DafnySequence<? extends Character>, BigInteger> NormalizeValue(DafnySequence<? extends Character> value, BigInteger pos) {
        while (true) {
            if (BigInteger.valueOf(value.length()).signum() == 0) {
                return Tuple2.create(value, (Object)pos);
            }
            if (((Character)value.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue() == '0' && pos.signum() == 1) {
                DafnySequence _in7 = value.drop(BigInteger.ONE);
                BigInteger _in8 = pos.subtract(BigInteger.ONE);
                value = _in7;
                pos = _in8;
                continue;
            }
            if (((Character)value.select(Helpers.toInt((BigInteger)BigInteger.valueOf(value.length()).subtract(BigInteger.ONE)))).charValue() != '0' || pos.compareTo(BigInteger.valueOf(value.length())) >= 0) break;
            DafnySequence _in9 = value.take(BigInteger.valueOf(value.length()).subtract(BigInteger.ONE));
            BigInteger _in10 = pos;
            value = _in9;
            pos = _in10;
        }
        return Tuple2.create((Object)value, (Object)pos);
    }

    public static Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> NormalizePositive(DafnySequence<? extends Character> n) {
        Result<Tuple3<DafnySequence<? extends Character>, BigInteger, BigInteger>, DafnySequence<? extends Character>> _35_valueOrError0 = __default.ParseNumber(n);
        if (_35_valueOrError0.IsFailure(Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _35_valueOrError0.PropagateFailure(Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        Tuple3 _let_tmp_rhs0 = (Tuple3)_35_valueOrError0.Extract(Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        DafnySequence _36_value = (DafnySequence)_let_tmp_rhs0.dtor__0();
        BigInteger _37_pos = (BigInteger)_let_tmp_rhs0.dtor__1();
        BigInteger _38_exp = (BigInteger)_let_tmp_rhs0.dtor__2();
        Tuple2<DafnySequence<? extends Character>, BigInteger> _let_tmp_rhs1 = __default.NormalizeValue((DafnySequence<? extends Character>)_36_value, _37_pos);
        DafnySequence _39_value = (DafnySequence)_let_tmp_rhs1.dtor__0();
        BigInteger _40_pos = (BigInteger)_let_tmp_rhs1.dtor__1();
        DafnySequence<? extends Character> _41_digitsOfPrecision = __default.SkipAllTrailingZeros(__default.SkipLeadingZeros((DafnySequence<? extends Character>)_39_value));
        Outcome _42_valueOrError1 = Wrappers_Compile.__default.Need((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (BigInteger.valueOf(_41_digitsOfPrecision.length()).compareTo(BigInteger.valueOf(38L)) <= 0 ? 1 : 0) != 0, (Object)DafnySequence.asString((String)"Attempting to store more than 38 significant digits in a Number."));
        if (_42_valueOrError1.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _42_valueOrError1.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        BigInteger _43_newPos = _40_pos.add(_38_exp);
        if (BigInteger.valueOf(_41_digitsOfPrecision.length()).signum() == 0) {
            return Result.create_Success((Object)DafnySequence.asString((String)"0"));
        }
        if (_43_newPos.signum() != 1) {
            Outcome _44_valueOrError2 = Wrappers_Compile.__default.Need((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (_43_newPos.subtract(__default.CountZeros((DafnySequence<? extends Character>)_39_value)).compareTo(BigInteger.valueOf(-129L)) >= 0 ? 1 : 0) != 0, (Object)DafnySequence.asString((String)"Attempting to store a number with magnitude smaller than supported range."));
            if (_44_valueOrError2.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                return _44_valueOrError2.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            }
            return Result.create_Success((Object)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"0."), __default.Zeros(BigInteger.ZERO.subtract(_43_newPos))), (DafnySequence)_39_value));
        }
        if (_43_newPos.compareTo(BigInteger.valueOf(_39_value.length())) >= 0) {
            Outcome _45_valueOrError3 = Wrappers_Compile.__default.Need((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (_43_newPos.subtract(__default.CountZeros((DafnySequence<? extends Character>)_39_value)).compareTo(BigInteger.valueOf(126L)) <= 0 ? 1 : 0) != 0, (Object)DafnySequence.asString((String)"Attempting to store a number with magnitude larger than supported range."));
            if (_45_valueOrError3.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                return _45_valueOrError3.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            }
            return Result.create_Success((Object)DafnySequence.concatenate((DafnySequence)_39_value, __default.Zeros(_43_newPos.subtract(BigInteger.valueOf(_39_value.length())))));
        }
        return Result.create_Success((Object)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)_39_value.take(_43_newPos), (DafnySequence)DafnySequence.asString((String)".")), (DafnySequence)_39_value.drop(_43_newPos)));
    }

    public static DafnySequence<? extends Character> TrimZerosFromValidNumber(DafnySequence<? extends Character> n) {
        DafnySequence<? extends Character> _46_n = __default.SkipLeadingZeros(n);
        if (_46_n.contains((Object)Character.valueOf('.'))) {
            return __default.SkipTrailingZeros(_46_n);
        }
        return _46_n;
    }

    public static Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> NormalizeNumber2(DafnySequence<? extends Character> n) {
        Outcome _47_valueOrError0 = Wrappers_Compile.__default.Need((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (BigInteger.valueOf(n.length()).signum() == 1 ? 1 : 0) != 0, (Object)DafnySequence.asString((String)"An empty string is not a valid number."));
        if (_47_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _47_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        Tuple2 _let_tmp_rhs2 = ((Character)n.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue() == '-' ? Tuple2.create((Object)true, (Object)n.drop(BigInteger.ONE)) : (((Character)n.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue() == '+' ? Tuple2.create((Object)false, (Object)n.drop(BigInteger.ONE)) : Tuple2.create((Object)false, n));
        boolean _48_neg = (Boolean)_let_tmp_rhs2.dtor__0();
        DafnySequence _49_n = (DafnySequence)_let_tmp_rhs2.dtor__1();
        Outcome _50_valueOrError1 = Wrappers_Compile.__default.Need((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (BigInteger.valueOf(_49_n.length()).signum() == 1 ? 1 : 0) != 0, (Object)DafnySequence.asString((String)"An empty string is not a valid number."));
        if (_50_valueOrError1.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _50_valueOrError1.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _51_valueOrError2 = __default.NormalizePositive((DafnySequence<? extends Character>)_49_n);
        if (_51_valueOrError2.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _51_valueOrError2.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        DafnySequence _52_n = (DafnySequence)_51_valueOrError2.Extract(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        DafnySequence<? extends Character> _53_n = __default.TrimZerosFromValidNumber((DafnySequence<? extends Character>)_52_n);
        if (_48_neg && !_53_n.equals((Object)DafnySequence.asString((String)"0"))) {
            return Result.create_Success((Object)DafnySequence.concatenate((DafnySequence)DafnySequence.of((char[])new char[]{'-'}), _53_n));
        }
        return Result.create_Success(_53_n);
    }

    public static Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> NormalizeNumber(DafnySequence<? extends Character> n) {
        Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _54_ret = __default.NormalizeNumber2(n);
        if (_54_ret.is_Success()) {
            return _54_ret;
        }
        return Result.create_Failure((Object)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)((DafnySequence)_54_ret.dtor_error()), (DafnySequence)DafnySequence.asString((String)" when parsing '")), n), (DafnySequence)DafnySequence.asString((String)"'.")));
    }

    public static TypeDescriptor<__default> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "DynamoDbNormalizeNumber_Compile._default";
    }
}

