/*
 * Decompiled with CFR 0.152.
 */
package CompoundBeacon_Compile;

import BaseBeacon_Compile.BeaconBase;
import BaseBeacon_Compile.StandardBeacon;
import CompoundBeacon_Compile.BeaconPart;
import CompoundBeacon_Compile.BeaconPart_Encrypted;
import CompoundBeacon_Compile.BeaconPart_Signed;
import CompoundBeacon_Compile.Constructor;
import CompoundBeacon_Compile.ConstructorPart;
import DdbVirtualFields_Compile.VirtField;
import DynamoDbEncryptionUtil_Compile.MaybeKeyMap;
import TermLoc_Compile.Selector;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Function;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue;

public class CompoundBeacon {
    public BeaconBase _base;
    public char _split;
    public DafnySequence<? extends BeaconPart> _parts;
    public BigInteger _numSigned;
    public DafnySequence<? extends Constructor> _construct;
    private static final CompoundBeacon theDefault = CompoundBeacon.create(BeaconBase.Default(), 'D', (DafnySequence<? extends BeaconPart>)DafnySequence.empty(BeaconPart._typeDescriptor()), BigInteger.ZERO, (DafnySequence<? extends Constructor>)DafnySequence.empty(Constructor._typeDescriptor()));
    private static final TypeDescriptor<CompoundBeacon> _TYPE = TypeDescriptor.referenceWithInitializer(CompoundBeacon.class, () -> CompoundBeacon.Default());

    public CompoundBeacon(BeaconBase base, char split, DafnySequence<? extends BeaconPart> parts, BigInteger numSigned, DafnySequence<? extends Constructor> construct) {
        this._base = base;
        this._split = split;
        this._parts = parts;
        this._numSigned = numSigned;
        this._construct = construct;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        CompoundBeacon o = (CompoundBeacon)other;
        return Objects.equals(this._base, o._base) && this._split == o._split && Objects.equals(this._parts, o._parts) && Objects.equals(this._numSigned, o._numSigned) && Objects.equals(this._construct, o._construct);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._base);
        hash = (hash << 5) + hash + (long)Character.hashCode(this._split);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._parts);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._numSigned);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._construct);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("CompoundBeacon_Compile.CompoundBeacon.CompoundBeacon");
        s.append("(");
        s.append(Helpers.toString((Object)this._base));
        s.append(", ");
        s.append(this._split);
        s.append(", ");
        s.append(Helpers.toString(this._parts));
        s.append(", ");
        s.append(Helpers.toString((Object)this._numSigned));
        s.append(", ");
        s.append(Helpers.toString(this._construct));
        s.append(")");
        return s.toString();
    }

    public static CompoundBeacon Default() {
        return theDefault;
    }

    public static TypeDescriptor<CompoundBeacon> _typeDescriptor() {
        return _TYPE;
    }

    public static CompoundBeacon create(BeaconBase base, char split, DafnySequence<? extends BeaconPart> parts, BigInteger numSigned, DafnySequence<? extends Constructor> construct) {
        return new CompoundBeacon(base, split, parts, numSigned, construct);
    }

    public static CompoundBeacon create_CompoundBeacon(BeaconBase base, char split, DafnySequence<? extends BeaconPart> parts, BigInteger numSigned, DafnySequence<? extends Constructor> construct) {
        return CompoundBeacon.create(base, split, parts, numSigned, construct);
    }

    public boolean is_CompoundBeacon() {
        return true;
    }

    public BeaconBase dtor_base() {
        return this._base;
    }

    public char dtor_split() {
        return this._split;
    }

    public DafnySequence<? extends BeaconPart> dtor_parts() {
        return this._parts;
    }

    public BigInteger dtor_numSigned() {
        return this._numSigned;
    }

    public DafnySequence<? extends Constructor> dtor_construct() {
        return this._construct;
    }

    public boolean isEncrypted() {
        return this.dtor_numSigned().compareTo(BigInteger.valueOf(this.dtor_parts().length())) < 0;
    }

    public Result<BeaconPart, Error> getPartFromPrefix(DafnySequence<? extends Character> value) {
        return this.partFromPrefix(this.dtor_parts(), value);
    }

    public Result<BeaconPart, Error> partFromPrefix(DafnySequence<? extends BeaconPart> p, DafnySequence<? extends Character> value) {
        CompoundBeacon _this = this;
        while (BigInteger.valueOf(p.length()).signum() != 0) {
            if (((BeaconPart)p.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_prefix().isPrefixOf(value)) {
                return Result.create_Success((Object)((BeaconPart)p.select(Helpers.toInt((BigInteger)BigInteger.ZERO))));
            }
            CompoundBeacon _in101 = _this;
            DafnySequence _in102 = p.drop(BigInteger.ONE);
            DafnySequence<? extends Character> _in103 = value;
            _this = _in101;
            p = _in102;
            value = _in103;
        }
        return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Value "), value), (DafnySequence)DafnySequence.asString((String)" for beacon ")), _this.dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" does not match the prefix of any configured part."))));
    }

    public Result<DafnySequence<? extends DafnySequence<? extends Character>>, Error> SkipSignedPieces(DafnySequence<? extends DafnySequence<? extends Character>> pieces) {
        CompoundBeacon _this = this;
        while (BigInteger.valueOf(pieces.length()).signum() != 0) {
            Result<BeaconPart, Error> _926_valueOrError0 = _this.partFromPrefix(_this.dtor_parts(), (DafnySequence<? extends Character>)((DafnySequence)pieces.select(Helpers.toInt((BigInteger)BigInteger.ZERO))));
            if (_926_valueOrError0.IsFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor())) {
                return _926_valueOrError0.PropagateFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
            }
            BeaconPart _927_p = (BeaconPart)_926_valueOrError0.Extract(BeaconPart._typeDescriptor(), Error._typeDescriptor());
            if (_927_p.is_Encrypted()) {
                return Result.create_Success(pieces);
            }
            CompoundBeacon _in104 = _this;
            DafnySequence _in105 = pieces.drop(BigInteger.ONE);
            _this = _in104;
            pieces = _in105;
        }
        return Result.create_Success(pieces);
    }

    public Result<Boolean, Error> IsLessThanComparable(DafnySequence<? extends DafnySequence<? extends Character>> pieces) {
        Result<DafnySequence<? extends DafnySequence<? extends Character>>, Error> _928_valueOrError0 = this.SkipSignedPieces(pieces);
        if (_928_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            return _928_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
        }
        DafnySequence _929_rest = (DafnySequence)_928_valueOrError0.Extract(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        if (BigInteger.valueOf(_929_rest.length()).signum() == 0) {
            return Result.create_Success((Object)true);
        }
        if (!Objects.equals(BigInteger.valueOf(_929_rest.length()), BigInteger.ONE)) {
            return Result.create_Success((Object)false);
        }
        Result<BeaconPart, Error> _930_valueOrError1 = this.partFromPrefix(this.dtor_parts(), (DafnySequence<? extends Character>)((DafnySequence)_929_rest.select(Helpers.toInt((BigInteger)BigInteger.ZERO))));
        if (_930_valueOrError1.IsFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor())) {
            return _930_valueOrError1.PropagateFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
        }
        BeaconPart _931_p = (BeaconPart)_930_valueOrError1.Extract(BeaconPart._typeDescriptor(), Error._typeDescriptor());
        return Result.create_Success((Object)_931_p.dtor_prefix().equals((Object)((DafnySequence)_929_rest.select(Helpers.toInt((BigInteger)BigInteger.ZERO)))));
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> GetFields(DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> virtualFields) {
        return Seq_Compile.__default.Flatten((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (DafnySequence)Seq_Compile.__default.Map(BeaconPart._typeDescriptor(), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), (Function)((Function<DafnyMap, Function>)_932_virtualFields -> _933_p_boxed0 -> {
            BeaconPart _933_p = _933_p_boxed0;
            return _933_p.GetFields((DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField>)_932_virtualFields);
        }).apply(virtualFields), this.dtor_parts()));
    }

    public Result<DafnySequence<? extends Character>, Error> FindAndCalcPart(DafnySequence<? extends Character> value, MaybeKeyMap keys) {
        Result<BeaconPart, Error> _934_valueOrError0 = this.partFromPrefix(this.dtor_parts(), value);
        if (_934_valueOrError0.IsFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor())) {
            return _934_valueOrError0.PropagateFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        BeaconPart _935_part = (BeaconPart)_934_valueOrError0.Extract(BeaconPart._typeDescriptor(), Error._typeDescriptor());
        return this.PartValueCalc((DafnySequence<? extends Character>)value.drop(BigInteger.valueOf(_935_part.dtor_prefix().length())), keys, _935_part);
    }

    public Result<Boolean, Error> justPrefix(DafnySequence<? extends Character> value) {
        Result<BeaconPart, Error> _936_valueOrError0 = this.partFromPrefix(this.dtor_parts(), value);
        if (_936_valueOrError0.IsFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor())) {
            return _936_valueOrError0.PropagateFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
        }
        BeaconPart _937_part = (BeaconPart)_936_valueOrError0.Extract(BeaconPart._typeDescriptor(), Error._typeDescriptor());
        return Result.create_Success((Object)value.equals(_937_part.dtor_prefix()));
    }

    public Result<AttributeValue, Error> GetBeaconValue(AttributeValue value, MaybeKeyMap keys, boolean forEquality) {
        if (!value.is_S()) {
            return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"CompoundBeacon "), this.dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" can only be queried as a string, not as ")), DynamoDbEncryptionUtil_Compile.__default.AttrTypeToStr(value))));
        }
        DafnySequence _938_parts = StandardLibrary_Compile.__default.Split((TypeDescriptor)TypeDescriptor.CHAR, (DafnySequence)value.dtor_S(), (Object)Character.valueOf(this.dtor_split()));
        Result _939_valueOrError0 = Seq_Compile.__default.MapWithResult((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), (Function)((Function<MaybeKeyMap, Function>)_940_keys -> _941_s_boxed0 -> {
            DafnySequence _941_s = _941_s_boxed0;
            return this.FindAndCalcPart((DafnySequence<? extends Character>)_941_s, (MaybeKeyMap)_940_keys);
        }).apply(keys), (DafnySequence)_938_parts);
        if (_939_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            return _939_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), AttributeValue._typeDescriptor());
        }
        DafnySequence _942_beaconParts = (DafnySequence)_939_valueOrError0.Extract(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        Result<Boolean, Error> _943_valueOrError1 = this.justPrefix((DafnySequence<? extends Character>)((DafnySequence)Seq_Compile.__default.Last((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (DafnySequence)_938_parts)));
        if (_943_valueOrError1.IsFailure(TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            return _943_valueOrError1.PropagateFailure(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), AttributeValue._typeDescriptor());
        }
        boolean _944_lastIsPrefix = (Boolean)_943_valueOrError1.Extract(TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        if (!forEquality && _944_lastIsPrefix) {
            DafnySequence _945_result = StandardLibrary_Compile.__default.Join((TypeDescriptor)TypeDescriptor.CHAR, (DafnySequence)DafnySequence.concatenate((DafnySequence)_942_beaconParts.take(BigInteger.valueOf(_938_parts.length()).subtract(BigInteger.ONE)), (DafnySequence)DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object[])new DafnySequence[]{(DafnySequence)Seq_Compile.__default.Last((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (DafnySequence)_938_parts)})), (DafnySequence)DafnySequence.of((char[])new char[]{this.dtor_split()}));
            return Result.create_Success((Object)AttributeValue.create_S((DafnySequence)_945_result));
        }
        DafnySequence _946_result = StandardLibrary_Compile.__default.Join((TypeDescriptor)TypeDescriptor.CHAR, (DafnySequence)_942_beaconParts, (DafnySequence)DafnySequence.of((char[])new char[]{this.dtor_split()}));
        return Result.create_Success((Object)AttributeValue.create_S((DafnySequence)_946_result));
    }

    public Result<Option<DafnySequence<? extends Character>>, Error> TryConstructor(DafnySequence<? extends ConstructorPart> consFields, DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> item, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> vf, MaybeKeyMap keys, DafnySequence<? extends Character> acc) {
        CompoundBeacon _this = this;
        while (true) {
            if (BigInteger.valueOf(consFields.length()).signum() == 0) {
                if (BigInteger.valueOf(acc.length()).signum() == 0) {
                    return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Internal Error : Empty beacon created.")));
                }
                return Result.create_Success((Object)Option.create_Some(acc));
            }
            BeaconPart _947_part = ((ConstructorPart)consFields.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_part();
            Result<Option<DafnySequence<? extends Character>>, Error> _948_valueOrError0 = _947_part.getString(item, vf);
            if (_948_valueOrError0.IsFailure(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
                return _948_valueOrError0.PropagateFailure(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
            }
            Option _949_strValue = (Option)_948_valueOrError0.Extract(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
            if (_949_strValue.is_Some()) {
                Result<DafnySequence<? extends Character>, Error> _951_valueOrError2;
                Outcome _950_valueOrError1 = __default.Need(Error._typeDescriptor(), (!((DafnySequence)_949_strValue.dtor_value()).contains((Object)Character.valueOf(_this.dtor_split())) ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Part "), _947_part.getName()), (DafnySequence)DafnySequence.asString((String)" for beacon ")), _this.dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" has value '")), (DafnySequence)((DafnySequence)_949_strValue.dtor_value())), (DafnySequence)DafnySequence.asString((String)"' which contains the split character ")), (DafnySequence)DafnySequence.of((char[])new char[]{_this.dtor_split()})), (DafnySequence)DafnySequence.asString((String)"'."))));
                if (_950_valueOrError1.IsFailure(Error._typeDescriptor())) {
                    return _950_valueOrError1.PropagateFailure(Error._typeDescriptor(), Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
                }
                Result<DafnySequence<? extends Character>, Error> result = _951_valueOrError2 = keys.is_DontUseKeys() ? Result.create_Success((Object)DafnySequence.concatenate(_947_part.dtor_prefix(), (DafnySequence)((DafnySequence)_949_strValue.dtor_value()))) : _this.PartValueCalc((DafnySequence<? extends Character>)((DafnySequence)_949_strValue.dtor_value()), keys, _947_part);
                if (_951_valueOrError2.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                    return _951_valueOrError2.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
                }
                DafnySequence _952_val = (DafnySequence)_951_valueOrError2.Extract(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
                if (BigInteger.valueOf(acc.length()).signum() == 0) {
                    CompoundBeacon _in106 = _this;
                    DafnySequence _in107 = consFields.drop(BigInteger.ONE);
                    DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> _in108 = item;
                    DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> _in109 = vf;
                    MaybeKeyMap _in110 = keys;
                    DafnySequence _in111 = _952_val;
                    _this = _in106;
                    consFields = _in107;
                    item = _in108;
                    vf = _in109;
                    keys = _in110;
                    acc = _in111;
                    continue;
                }
                CompoundBeacon _in112 = _this;
                DafnySequence _in113 = consFields.drop(BigInteger.ONE);
                DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> _in114 = item;
                DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> _in115 = vf;
                MaybeKeyMap _in116 = keys;
                DafnySequence _in117 = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(acc, (DafnySequence)DafnySequence.of((char[])new char[]{_this.dtor_split()})), (DafnySequence)_952_val);
                _this = _in112;
                consFields = _in113;
                item = _in114;
                vf = _in115;
                keys = _in116;
                acc = _in117;
                continue;
            }
            if (((ConstructorPart)consFields.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_required()) {
                return Result.create_Success((Object)Option.create_None());
            }
            CompoundBeacon _in118 = _this;
            DafnySequence _in119 = consFields.drop(BigInteger.ONE);
            DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> _in120 = item;
            DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> _in121 = vf;
            MaybeKeyMap _in122 = keys;
            DafnySequence _in123 = acc;
            _this = _in118;
            consFields = _in119;
            item = _in120;
            vf = _in121;
            keys = _in122;
            acc = _in123;
        }
    }

    public Result<Option<DafnySequence<? extends Character>>, Error> TryConstructors(DafnySequence<? extends Constructor> construct, DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> item, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> vf, MaybeKeyMap keys) {
        CompoundBeacon _this = this;
        while (BigInteger.valueOf(construct.length()).signum() != 0) {
            Result<Option<DafnySequence<? extends Character>>, Error> _953_valueOrError0 = _this.TryConstructor(((Constructor)construct.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_parts(), item, vf, keys, (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_953_valueOrError0.IsFailure(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
                return _953_valueOrError0.PropagateFailure(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
            }
            Option _954_x = (Option)_953_valueOrError0.Extract(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
            if (_954_x.is_Some()) {
                return Result.create_Success((Object)_954_x);
            }
            CompoundBeacon _in124 = _this;
            DafnySequence _in125 = construct.drop(BigInteger.ONE);
            DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> _in126 = item;
            DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> _in127 = vf;
            MaybeKeyMap _in128 = keys;
            _this = _in124;
            construct = _in125;
            item = _in126;
            vf = _in127;
            keys = _in128;
        }
        return Result.create_Success((Object)Option.create_None());
    }

    public Result<Option<DafnySequence<? extends Character>>, Error> hash(DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> item, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> vf, MaybeKeyMap keys) {
        return this.TryConstructors(this.dtor_construct(), item, vf, keys);
    }

    public Result<Option<DafnySequence<? extends Character>>, Error> getNaked(DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> item, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> vf) {
        return this.TryConstructors(this.dtor_construct(), item, vf, MaybeKeyMap.create_DontUseKeys());
    }

    public Result<BeaconPart, Error> findPart(DafnySequence<? extends Character> val) {
        DafnySequence _955_thePart = Seq_Compile.__default.Filter(BeaconPart._typeDescriptor(), (Function)((Function<DafnySequence, Function>)_956_val -> _957_x_boxed0 -> {
            BeaconPart _957_x = _957_x_boxed0;
            return _957_x.dtor_prefix().isPrefixOf(_956_val);
        }).apply(val), this.dtor_parts());
        if (BigInteger.valueOf(_955_thePart.length()).signum() == 0) {
            return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"No part found in beacon "), this.dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" match prefix ")), val)));
        }
        if (BigInteger.valueOf(_955_thePart.length()).compareTo(BigInteger.ONE) > 0) {
            return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Internal error. Multiple parts for beacon "), this.dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" matched prefix of ")), val)));
        }
        return Result.create_Success((Object)((BeaconPart)_955_thePart.select(Helpers.toInt((BigInteger)BigInteger.ZERO))));
    }

    public Result<DafnySequence<? extends Character>, Error> getPart(DafnySequence<? extends Character> val, DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>> keys) {
        DafnySequence _958_pieces = StandardLibrary_Compile.__default.Split((TypeDescriptor)TypeDescriptor.CHAR, val, (Object)Character.valueOf(this.dtor_split()));
        return this.calcParts((DafnySequence<? extends DafnySequence<? extends Character>>)_958_pieces, keys, (DafnySequence<? extends Character>)DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
    }

    public Result<DafnySequence<? extends Character>, Error> calcPart(DafnySequence<? extends Character> piece, DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>> keys) {
        Result<BeaconPart, Error> _959_valueOrError0 = this.findPart(piece);
        if (_959_valueOrError0.IsFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor())) {
            return _959_valueOrError0.PropagateFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        BeaconPart _960_thePart = (BeaconPart)_959_valueOrError0.Extract(BeaconPart._typeDescriptor(), Error._typeDescriptor());
        return this.PartValueCalc(piece, MaybeKeyMap.create_Keys(keys), _960_thePart);
    }

    public Result<DafnySequence<? extends Character>, Error> calcParts(DafnySequence<? extends DafnySequence<? extends Character>> pieces, DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>> keys, DafnySequence<? extends Character> acc) {
        CompoundBeacon _this = this;
        while (BigInteger.valueOf(pieces.length()).signum() != 0) {
            Result<DafnySequence<? extends Character>, Error> _961_valueOrError0 = _this.calcPart((DafnySequence<? extends Character>)((DafnySequence)pieces.select(Helpers.toInt((BigInteger)BigInteger.ZERO))), keys);
            if (_961_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                return _961_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            }
            DafnySequence _962_theBeacon = (DafnySequence)_961_valueOrError0.Extract(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            if (BigInteger.valueOf(acc.length()).signum() == 0) {
                CompoundBeacon _in129 = _this;
                DafnySequence _in130 = pieces.drop(BigInteger.ONE);
                DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>> _in131 = keys;
                DafnySequence _in132 = _962_theBeacon;
                _this = _in129;
                pieces = _in130;
                keys = _in131;
                acc = _in132;
                continue;
            }
            CompoundBeacon _in133 = _this;
            DafnySequence _in134 = pieces.drop(BigInteger.ONE);
            DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>> _in135 = keys;
            DafnySequence _in136 = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)acc, (DafnySequence)DafnySequence.of((char[])new char[]{_this.dtor_split()})), (DafnySequence)_962_theBeacon);
            _this = _in133;
            pieces = _in134;
            keys = _in135;
            acc = _in136;
        }
        return Result.create_Success(acc);
    }

    public static boolean OkPrefixStringPair(DafnySequence<? extends Character> x, DafnySequence<? extends Character> y) {
        return !x.isPrefixOf(y) && !y.isPrefixOf(x);
    }

    public boolean OkPrefixPair(BigInteger pos1, BigInteger pos2) {
        return Objects.equals(pos1, pos2) || CompoundBeacon.OkPrefixStringPair(((BeaconPart)this.dtor_parts().select(Helpers.toInt((BigInteger)pos1))).dtor_prefix(), ((BeaconPart)this.dtor_parts().select(Helpers.toInt((BigInteger)pos2))).dtor_prefix());
    }

    public Result<Boolean, Error> CheckOnePrefixPart(BigInteger pos1, BigInteger pos2) {
        if (!this.OkPrefixPair(pos1, pos2)) {
            return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Compound beacon "), this.dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" defines part ")), ((BeaconPart)this.dtor_parts().select(Helpers.toInt((BigInteger)pos1))).getName()), (DafnySequence)DafnySequence.asString((String)" with prefix ")), ((BeaconPart)this.dtor_parts().select(Helpers.toInt((BigInteger)pos1))).dtor_prefix()), (DafnySequence)DafnySequence.asString((String)" which is incompatible with part ")), ((BeaconPart)this.dtor_parts().select(Helpers.toInt((BigInteger)pos2))).getName()), (DafnySequence)DafnySequence.asString((String)" which has a prefix of ")), ((BeaconPart)this.dtor_parts().select(Helpers.toInt((BigInteger)pos2))).dtor_prefix()), (DafnySequence)DafnySequence.asString((String)"."))));
        }
        return Result.create_Success((Object)true);
    }

    public Result<Boolean, Error> CheckOnePrefix(BigInteger pos) {
        DafnySequence _963_partNumbers = DafnySequence.Create((TypeDescriptor)TypeDescriptor.BIG_INTEGER, (BigInteger)BigInteger.valueOf(this.dtor_parts().length()), _964_i_boxed0 -> {
            BigInteger _964_i = _964_i_boxed0;
            return _964_i;
        });
        Result _965_valueOrError0 = Seq_Compile.__default.MapWithResult((TypeDescriptor)TypeDescriptor.BIG_INTEGER, (TypeDescriptor)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), (Function)((Function<BigInteger, Function>)_966_pos -> _967_p_boxed0 -> {
            BigInteger _967_p = _967_p_boxed0;
            return this.CheckOnePrefixPart((BigInteger)_966_pos, _967_p);
        }).apply(pos), (DafnySequence)DafnySequence.Create((TypeDescriptor)TypeDescriptor.BIG_INTEGER, (BigInteger)BigInteger.valueOf(this.dtor_parts().length()), _968_i_boxed0 -> {
            BigInteger _968_i = _968_i_boxed0;
            return _968_i;
        }));
        if (_965_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BOOLEAN), Error._typeDescriptor())) {
            return _965_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BOOLEAN), Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
        }
        DafnySequence _969___v1 = (DafnySequence)_965_valueOrError0.Extract(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BOOLEAN), Error._typeDescriptor());
        return Result.create_Success((Object)true);
    }

    public Result<Boolean, Error> ValidPrefixSetResultPos(BigInteger index) {
        CompoundBeacon _this = this;
        while (BigInteger.valueOf(_this.dtor_parts().length()).compareTo(index) > 0) {
            Result<Boolean, Error> _970_valueOrError0 = _this.CheckOnePrefix(index);
            if (_970_valueOrError0.IsFailure(TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
                return _970_valueOrError0.PropagateFailure(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            }
            boolean _971___v2 = (Boolean)_970_valueOrError0.Extract(TypeDescriptor.BOOLEAN, Error._typeDescriptor());
            CompoundBeacon _in137 = _this;
            BigInteger _in138 = index.add(BigInteger.ONE);
            _this = _in137;
            index = _in138;
        }
        return Result.create_Success((Object)true);
    }

    public Result<Boolean, Error> ValidPrefixSetResult() {
        Result<Boolean, Error> _972_valueOrError0 = this.ValidPrefixSetResultPos(BigInteger.ZERO);
        if (_972_valueOrError0.IsFailure(TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            return _972_valueOrError0.PropagateFailure(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
        }
        boolean _973___v3 = (Boolean)_972_valueOrError0.Extract(TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        if (Helpers.Quantifier((Iterable)Helpers.IntegerRange((BigInteger)BigInteger.ZERO, (BigInteger)BigInteger.valueOf(this.dtor_parts().length())), (boolean)true, _forall_var_12_boxed0 -> {
            BigInteger _forall_var_12 = _forall_var_12_boxed0;
            BigInteger _974_x = _forall_var_12;
            if (_974_x.signum() != -1) {
                return Helpers.Quantifier((Iterable)Helpers.IntegerRange((BigInteger)BigInteger.ZERO, (BigInteger)BigInteger.valueOf(this.dtor_parts().length())), (boolean)true, _forall_var_13_boxed0 -> {
                    BigInteger _forall_var_13 = _forall_var_13_boxed0;
                    BigInteger _975_y = _forall_var_13;
                    if (_975_y.signum() != -1) {
                        return _974_x.signum() == -1 || _974_x.compareTo(BigInteger.valueOf(this.dtor_parts().length())) >= 0 || _974_x.compareTo(_975_y) >= 0 || _975_y.compareTo(BigInteger.valueOf(this.dtor_parts().length())) >= 0 || this.OkPrefixPair(_974_x, _975_y);
                    }
                    return true;
                });
            }
            return true;
        })) {
            return Result.create_Success((Object)true);
        }
        return Result.create_Failure((Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Internal Error")));
    }

    public Result<DafnySequence<? extends Character>, Error> PartValueCalc(DafnySequence<? extends Character> data, MaybeKeyMap keys, BeaconPart part) {
        Outcome _976_valueOrError0 = __default.Need(Error._typeDescriptor(), (!data.contains((Object)Character.valueOf(this.dtor_split())) ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Value '"), data), (DafnySequence)DafnySequence.asString((String)"' for beacon part ")), part.getName()), (DafnySequence)DafnySequence.asString((String)" contains the split character '")), (DafnySequence)DafnySequence.of((char[])new char[]{this.dtor_split()})), (DafnySequence)DafnySequence.asString((String)"'."))));
        if (_976_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _976_valueOrError0.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        BeaconPart _source12 = part;
        if (_source12.is_Encrypted()) {
            StandardBeacon _978___mcc_h1;
            DafnySequence<? extends Character> _977___mcc_h0 = ((BeaconPart_Encrypted)_source12)._prefix;
            StandardBeacon _979_b = _978___mcc_h1 = ((BeaconPart_Encrypted)_source12)._beacon;
            DafnySequence<? extends Character> _980_p = _977___mcc_h0;
            Outcome _981_valueOrError1 = __default.Need(Error._typeDescriptor(), (boolean)keys.is_Keys(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Need KeyId for beacon "), _979_b.dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" but no KeyId found in query."))));
            if (_981_valueOrError1.IsFailure(Error._typeDescriptor())) {
                return _981_valueOrError1.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            }
            Result<DafnySequence<? extends Character>, Error> _982_valueOrError2 = _979_b.hashStr(data, keys.dtor_value());
            if (_982_valueOrError2.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                return _982_valueOrError2.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            }
            DafnySequence _983_hash = (DafnySequence)_982_valueOrError2.Extract(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            return Result.create_Success((Object)DafnySequence.concatenate(part.dtor_prefix(), (DafnySequence)_983_hash));
        }
        DafnySequence<? extends Character> _984___mcc_h4 = ((BeaconPart_Signed)_source12)._prefix;
        DafnySequence<? extends Character> _985___mcc_h5 = ((BeaconPart_Signed)_source12)._name;
        DafnySequence<? extends Selector> _986___mcc_h6 = ((BeaconPart_Signed)_source12)._loc;
        BeaconPart _987_Signed = part;
        return Result.create_Success((Object)DafnySequence.concatenate(part.dtor_prefix(), data));
    }
}

