/*
 * Decompiled with CFR 0.152.
 */
package BaseBeacon_Compile;

import BaseBeacon_Compile.BeaconBase;
import BaseBeacon_Compile.StandardBeacon;
import TermLoc_Compile.Selector;
import TermLoc_Compile.TermLoc;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;

public class __default {
    private static final TypeDescriptor<__default> _TYPE = TypeDescriptor.referenceWithInitializer(__default.class, () -> null);

    public static Result<StandardBeacon, Error> MakeStandardBeacon(AtomicPrimitivesClient client, DafnySequence<? extends Character> name, byte length, DafnySequence<? extends Character> loc) {
        Result<DafnySequence<? extends Selector>, Error> _874_valueOrError0 = TermLoc_Compile.__default.MakeTermLoc(loc);
        if (_874_valueOrError0.IsFailure(TermLoc._typeDescriptor(), Error._typeDescriptor())) {
            return _874_valueOrError0.PropagateFailure(TermLoc._typeDescriptor(), Error._typeDescriptor(), StandardBeacon._typeDescriptor());
        }
        DafnySequence _875_termLoc = (DafnySequence)_874_valueOrError0.Extract(TermLoc._typeDescriptor(), Error._typeDescriptor());
        DafnySequence _876_beaconName = DafnySequence.concatenate(DynamoDbEncryptionUtil_Compile.__default.BeaconPrefix(), name);
        Outcome _877_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), (boolean)software.amazon.cryptography.services.dynamodb.internaldafny.types.__default.IsValid__AttributeName((DafnySequence)_876_beaconName), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)_876_beaconName, (DafnySequence)DafnySequence.asString((String)" is not a valid attribute name."))));
        if (_877_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _877_valueOrError1.PropagateFailure(Error._typeDescriptor(), StandardBeacon._typeDescriptor());
        }
        return Result.create_Success((Object)StandardBeacon.create(BeaconBase.create(client, name, (DafnySequence<? extends Character>)_876_beaconName), length, (DafnySequence<? extends Selector>)_875_termLoc));
    }

    public static BigInteger CharsFromBeaconLength(byte bits) {
        return BigInteger.valueOf(Byte.toUnsignedLong(Helpers.divideUnsignedByte((byte)((byte)(bits + 3)), (byte)4)));
    }

    public static byte TopBits(byte bits) {
        byte _878_x = Helpers.remainderUnsignedByte((byte)bits, (byte)4);
        if (!(_878_x != 0)) {
            return 4;
        }
        return _878_x;
    }

    public static BigInteger BytesFromBeaconLength(byte bits) {
        return BigInteger.valueOf(Byte.toUnsignedLong(Helpers.divideUnsignedByte((byte)((byte)(bits + 7)), (byte)8)));
    }

    public static byte TruncateNibble(byte nibble, byte length) {
        if (length == 4) {
            return nibble;
        }
        if (length == 3) {
            return Helpers.remainderUnsignedByte((byte)nibble, (byte)8);
        }
        if (length == 2) {
            return Helpers.remainderUnsignedByte((byte)nibble, (byte)4);
        }
        return Helpers.remainderUnsignedByte((byte)nibble, (byte)2);
    }

    public static DafnySequence<? extends Character> BytesToHex(DafnySequence<? extends Byte> bytes, byte bits) {
        BigInteger _879_numBytes = __default.BytesFromBeaconLength(bits);
        BigInteger _880_numChars = __default.CharsFromBeaconLength(bits);
        byte _881_topBits = __default.TopBits(bits);
        DafnySequence _882_bytes = bytes.drop(BigInteger.valueOf(8L).subtract(_879_numBytes));
        if (Objects.equals(_880_numChars, BigInteger.valueOf(2L).multiply(_879_numBytes))) {
            byte _883_topNibble = Helpers.divideUnsignedByte((byte)((Byte)_882_bytes.select(Helpers.toInt((BigInteger)BigInteger.ZERO))), (byte)16);
            byte _884_bottomNibble = Helpers.remainderUnsignedByte((byte)((Byte)_882_bytes.select(Helpers.toInt((BigInteger)BigInteger.ZERO))), (byte)16);
            return DafnySequence.concatenate((DafnySequence)DafnySequence.of((char[])new char[]{HexStrings_Compile.__default.HexChar((byte)__default.TruncateNibble(_883_topNibble, _881_topBits)), HexStrings_Compile.__default.HexChar((byte)_884_bottomNibble)}), (DafnySequence)HexStrings_Compile.__default.ToHexString((DafnySequence)_882_bytes.drop(BigInteger.ONE)));
        }
        return DafnySequence.concatenate((DafnySequence)DafnySequence.of((char[])new char[]{HexStrings_Compile.__default.HexChar((byte)__default.TruncateNibble(Helpers.remainderUnsignedByte((byte)((Byte)_882_bytes.select(Helpers.toInt((BigInteger)BigInteger.ZERO))), (byte)16), _881_topBits))}), (DafnySequence)HexStrings_Compile.__default.ToHexString((DafnySequence)_882_bytes.drop(BigInteger.ONE)));
    }

    public static TypeDescriptor<__default> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "BaseBeacon_Compile._default";
    }
}

