// Class DynamoDbItemEncryptorConfig
// Dafny class DynamoDbItemEncryptorConfig compiled into Java
package software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.internaldafny.types;

import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.*;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.*;
import DynamoDbEncryptionUtil_Compile.*;
import DynamoDbNormalizeNumber_Compile.*;
import DynamoToStruct_Compile.*;
import DynamoDbEncryptionBranchKeyIdSupplier_Compile.*;
import AwsCryptographyDbEncryptionSdkDynamoDbOperations_Compile.*;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.*;
import StructuredEncryptionUtil_Compile.*;
import Sets_Compile.*;
import StructuredEncryptionPaths_Compile.*;
import StructuredEncryptionHeader_Compile.*;
import StructuredEncryptionFooter_Compile.*;
import StructuredEncryptionCrypt_Compile.*;
import Maps_Compile.*;
import AwsCryptographyDbEncryptionSdkStructuredEncryptionOperations_Compile.*;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.*;
import TermLoc_Compile.*;
import DdbVirtualFields_Compile.*;
import BaseBeacon_Compile.*;
import CompoundBeacon_Compile.*;
import SearchableEncryptionInfo_Compile.*;
import SearchConfigToInfo_Compile.*;
import DynamoDbUpdateExpr_Compile.*;
import DynamoDBFilterExpr_Compile.*;
import DynamoDBSupport_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class DynamoDbItemEncryptorConfig {
  public dafny.DafnySequence<? extends Character> _logicalTableName;
  public dafny.DafnySequence<? extends Character> _partitionKeyName;
  public Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>> _sortKeyName;
  public dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction> _attributeActionsOnEncrypt;
  public Wrappers_Compile.Option<dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>> _allowedUnsignedAttributes;
  public Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>> _allowedUnsignedAttributePrefix;
  public Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId> _algorithmSuiteId;
  public Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring> _keyring;
  public Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager> _cmm;
  public Wrappers_Compile.Option<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.LegacyOverride> _legacyOverride;
  public Wrappers_Compile.Option<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.PlaintextOverride> _plaintextOverride;
  public DynamoDbItemEncryptorConfig (dafny.DafnySequence<? extends Character> logicalTableName, dafny.DafnySequence<? extends Character> partitionKeyName, Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>> sortKeyName, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction> attributeActionsOnEncrypt, Wrappers_Compile.Option<dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>> allowedUnsignedAttributes, Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>> allowedUnsignedAttributePrefix, Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId> algorithmSuiteId, Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring> keyring, Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager> cmm, Wrappers_Compile.Option<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.LegacyOverride> legacyOverride, Wrappers_Compile.Option<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.PlaintextOverride> plaintextOverride) {
    this._logicalTableName = logicalTableName;
    this._partitionKeyName = partitionKeyName;
    this._sortKeyName = sortKeyName;
    this._attributeActionsOnEncrypt = attributeActionsOnEncrypt;
    this._allowedUnsignedAttributes = allowedUnsignedAttributes;
    this._allowedUnsignedAttributePrefix = allowedUnsignedAttributePrefix;
    this._algorithmSuiteId = algorithmSuiteId;
    this._keyring = keyring;
    this._cmm = cmm;
    this._legacyOverride = legacyOverride;
    this._plaintextOverride = plaintextOverride;
  }

  @Override
  public boolean equals(Object other) {
    if (this == other) return true;
    if (other == null) return false;
    if (getClass() != other.getClass()) return false;
    DynamoDbItemEncryptorConfig o = (DynamoDbItemEncryptorConfig)other;
    return true && java.util.Objects.equals(this._logicalTableName, o._logicalTableName) && java.util.Objects.equals(this._partitionKeyName, o._partitionKeyName) && java.util.Objects.equals(this._sortKeyName, o._sortKeyName) && java.util.Objects.equals(this._attributeActionsOnEncrypt, o._attributeActionsOnEncrypt) && java.util.Objects.equals(this._allowedUnsignedAttributes, o._allowedUnsignedAttributes) && java.util.Objects.equals(this._allowedUnsignedAttributePrefix, o._allowedUnsignedAttributePrefix) && java.util.Objects.equals(this._algorithmSuiteId, o._algorithmSuiteId) && java.util.Objects.equals(this._keyring, o._keyring) && java.util.Objects.equals(this._cmm, o._cmm) && java.util.Objects.equals(this._legacyOverride, o._legacyOverride) && java.util.Objects.equals(this._plaintextOverride, o._plaintextOverride);
  }
  @Override
  public int hashCode() {
    long hash = 5381;
    hash = ((hash << 5) + hash) + 0;
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._logicalTableName);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._partitionKeyName);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._sortKeyName);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._attributeActionsOnEncrypt);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._allowedUnsignedAttributes);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._allowedUnsignedAttributePrefix);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._algorithmSuiteId);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._keyring);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._cmm);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._legacyOverride);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._plaintextOverride);
    return (int)hash;
  }

  @Override
  public String toString() {
    StringBuilder s = new StringBuilder();
    s.append("software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.internaldafny.types_Compile.DynamoDbItemEncryptorConfig.DynamoDbItemEncryptorConfig");
    s.append("(");
    s.append(dafny.Helpers.toString(this._logicalTableName));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._partitionKeyName));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._sortKeyName));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._attributeActionsOnEncrypt));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._allowedUnsignedAttributes));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._allowedUnsignedAttributePrefix));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._algorithmSuiteId));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._keyring));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._cmm));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._legacyOverride));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._plaintextOverride));
    s.append(")");
    return s.toString();
  }

  private static final DynamoDbItemEncryptorConfig theDefault = software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.internaldafny.types.DynamoDbItemEncryptorConfig.create(dafny.DafnySequence.<Character> empty(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<Character> empty(dafny.TypeDescriptor.CHAR), Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>Default(), dafny.DafnyMap.<dafny.DafnySequence<? extends Character>,software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction> empty(), Wrappers_Compile.Option.<dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>>Default(), Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>Default(), Wrappers_Compile.Option.<software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId>Default(), Wrappers_Compile.Option.<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring>Default(), Wrappers_Compile.Option.<software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager>Default(), Wrappers_Compile.Option.<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.LegacyOverride>Default(), Wrappers_Compile.Option.<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.PlaintextOverride>Default());
  public static DynamoDbItemEncryptorConfig Default() {
    return theDefault;
  }
  private static final dafny.TypeDescriptor<DynamoDbItemEncryptorConfig> _TYPE = dafny.TypeDescriptor.<DynamoDbItemEncryptorConfig>referenceWithInitializer(DynamoDbItemEncryptorConfig.class, () -> Default());
  public static dafny.TypeDescriptor<DynamoDbItemEncryptorConfig> _typeDescriptor() {
    return (dafny.TypeDescriptor<DynamoDbItemEncryptorConfig>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  public static DynamoDbItemEncryptorConfig create(dafny.DafnySequence<? extends Character> logicalTableName, dafny.DafnySequence<? extends Character> partitionKeyName, Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>> sortKeyName, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction> attributeActionsOnEncrypt, Wrappers_Compile.Option<dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>> allowedUnsignedAttributes, Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>> allowedUnsignedAttributePrefix, Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId> algorithmSuiteId, Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring> keyring, Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager> cmm, Wrappers_Compile.Option<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.LegacyOverride> legacyOverride, Wrappers_Compile.Option<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.PlaintextOverride> plaintextOverride) {
    return new DynamoDbItemEncryptorConfig(logicalTableName, partitionKeyName, sortKeyName, attributeActionsOnEncrypt, allowedUnsignedAttributes, allowedUnsignedAttributePrefix, algorithmSuiteId, keyring, cmm, legacyOverride, plaintextOverride);
  }
  public static DynamoDbItemEncryptorConfig create_DynamoDbItemEncryptorConfig(dafny.DafnySequence<? extends Character> logicalTableName, dafny.DafnySequence<? extends Character> partitionKeyName, Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>> sortKeyName, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction> attributeActionsOnEncrypt, Wrappers_Compile.Option<dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>> allowedUnsignedAttributes, Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>> allowedUnsignedAttributePrefix, Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId> algorithmSuiteId, Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring> keyring, Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager> cmm, Wrappers_Compile.Option<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.LegacyOverride> legacyOverride, Wrappers_Compile.Option<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.PlaintextOverride> plaintextOverride) {
    return create(logicalTableName, partitionKeyName, sortKeyName, attributeActionsOnEncrypt, allowedUnsignedAttributes, allowedUnsignedAttributePrefix, algorithmSuiteId, keyring, cmm, legacyOverride, plaintextOverride);
  }
  public boolean is_DynamoDbItemEncryptorConfig() { return true; }
  public dafny.DafnySequence<? extends Character> dtor_logicalTableName() {
    return this._logicalTableName;
  }
  public dafny.DafnySequence<? extends Character> dtor_partitionKeyName() {
    return this._partitionKeyName;
  }
  public Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>> dtor_sortKeyName() {
    return this._sortKeyName;
  }
  public dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction> dtor_attributeActionsOnEncrypt() {
    return this._attributeActionsOnEncrypt;
  }
  public Wrappers_Compile.Option<dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>> dtor_allowedUnsignedAttributes() {
    return this._allowedUnsignedAttributes;
  }
  public Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>> dtor_allowedUnsignedAttributePrefix() {
    return this._allowedUnsignedAttributePrefix;
  }
  public Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId> dtor_algorithmSuiteId() {
    return this._algorithmSuiteId;
  }
  public Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring> dtor_keyring() {
    return this._keyring;
  }
  public Wrappers_Compile.Option<software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager> dtor_cmm() {
    return this._cmm;
  }
  public Wrappers_Compile.Option<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.LegacyOverride> dtor_legacyOverride() {
    return this._legacyOverride;
  }
  public Wrappers_Compile.Option<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.PlaintextOverride> dtor_plaintextOverride() {
    return this._plaintextOverride;
  }
}
