// Class __default
// Dafny class __default compiled into Java
package StructuredEncryptionHeader_Compile;

import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.*;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.*;
import DynamoDbEncryptionUtil_Compile.*;
import DynamoDbNormalizeNumber_Compile.*;
import DynamoToStruct_Compile.*;
import DynamoDbEncryptionBranchKeyIdSupplier_Compile.*;
import AwsCryptographyDbEncryptionSdkDynamoDbOperations_Compile.*;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.*;
import StructuredEncryptionUtil_Compile.*;
import Sets_Compile.*;
import StructuredEncryptionPaths_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class __default {
  public __default() {
  }
  public static boolean ValidVersion(byte x) {
    return (x) == ((byte) 1);
  }
  public static boolean ValidFlavor(byte x) {
    return (dafny.DafnySequence.of((byte) 0, (byte) 1)).contains(x);
  }
  public static boolean ValidLegendByte(byte x) {
    return (dafny.DafnySequence.of(__default.ENCRYPT__AND__SIGN__LEGEND(), __default.SIGN__ONLY__LEGEND())).contains(x);
  }
  public static boolean ValidEncryptionContext(dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>> x) {
    return ((java.math.BigInteger.valueOf((x).size())).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0) && (((java.util.function.Function<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, Boolean>)(_342_x) -> dafny.Helpers.Quantifier((_342_x).keySet().Elements(), true, ((_forall_var_5_boxed0) -> {
      dafny.DafnySequence<? extends java.lang.Byte> _forall_var_5 = ((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)(_forall_var_5_boxed0));
      if (true) {
        dafny.DafnySequence<? extends java.lang.Byte> _343_k = (dafny.DafnySequence<? extends java.lang.Byte>)_forall_var_5;
        return !((_342_x).<dafny.DafnySequence<? extends java.lang.Byte>>contains(_343_k)) || (((java.math.BigInteger.valueOf((_343_k).length())).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0) && ((java.math.BigInteger.valueOf((((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)((_342_x).get(_343_k)))).length())).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0));
      } else {
        return true;
      }
    }))).apply(x));
  }
  public static boolean ValidEncryptedDataKey(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey x) {
    return (((java.math.BigInteger.valueOf(((x).dtor_keyProviderId()).length())).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0) && ((java.math.BigInteger.valueOf(((x).dtor_keyProviderInfo()).length())).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0)) && ((java.math.BigInteger.valueOf(((x).dtor_ciphertext()).length())).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0);
  }
  public static Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> Serialize(software.amazon.cryptography.primitives.internaldafny.types.IAwsCryptographicPrimitivesClient client, software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo alg, dafny.DafnySequence<? extends java.lang.Byte> commitKey, PartialHeader PartialHeader)
  {
    dafny.DafnySequence<? extends java.lang.Byte> _344_body = (PartialHeader).serialize();
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _345_valueOrError0 = __default.CalculateHeaderCommitment(client, alg, commitKey, _344_body);
    if ((_345_valueOrError0).IsFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
      return (_345_valueOrError0).<dafny.DafnySequence<? extends java.lang.Byte>>PropagateFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()));
    } else {
      dafny.DafnySequence<? extends java.lang.Byte> _346_commitment = (_345_valueOrError0).Extract(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
      return Wrappers_Compile.Result.<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>create_Success(dafny.DafnySequence.<java.lang.Byte>concatenate(_344_body, _346_commitment));
    }
  }
  public static Wrappers_Compile.Result<PartialHeader, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> Create(dafny.DafnySequence<? extends Character> tableName, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema schema, dafny.DafnySequence<? extends java.lang.Byte> msgID, software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials mat)
  {
    Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _347_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), StructuredEncryptionUtil_Compile.__default.ValidString(tableName), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Invalid table name.")));
    if ((_347_valueOrError0).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
      return (_347_valueOrError0).<PartialHeader>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
    } else {
      Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _348_valueOrError1 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), __default.ValidEncryptionContext((mat).dtor_encryptionContext()), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Invalid Encryption Context")));
      if ((_348_valueOrError1).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
        return (_348_valueOrError1).<PartialHeader>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
      } else {
        Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _349_valueOrError2 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (java.math.BigInteger.valueOf(((mat).dtor_encryptedDataKeys()).length())).signum() == 1, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("There must be at least one data key")));
        if ((_349_valueOrError2).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
          return (_349_valueOrError2).<PartialHeader>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        } else {
          Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _350_valueOrError3 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (java.math.BigInteger.valueOf(((mat).dtor_encryptedDataKeys()).length())).compareTo(__default.UINT8__LIMIT()) < 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Too many data keys.")));
          if ((_350_valueOrError3).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return (_350_valueOrError3).<PartialHeader>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
          } else {
            Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _351_valueOrError4 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials, Boolean>)(_352_mat) -> dafny.Helpers.Quantifier(((_352_mat).dtor_encryptedDataKeys()).UniqueElements(), true, ((_forall_var_6_boxed0) -> {
              software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey _forall_var_6 = ((software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey)(java.lang.Object)(_forall_var_6_boxed0));
              if (true) {
                software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey _353_x = (software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey)_forall_var_6;
                return !(((_352_mat).dtor_encryptedDataKeys()).contains(_353_x)) || (__default.ValidEncryptedDataKey(_353_x));
              } else {
                return true;
              }
            }))).apply(mat), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Invalid Data Key")));
            if ((_351_valueOrError4).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
              return (_351_valueOrError4).<PartialHeader>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
            } else {
              Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _354_valueOrError5 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((schema).dtor_content()).is_SchemaMap(), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Schema must be a Map")));
              if ((_354_valueOrError5).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                return (_354_valueOrError5).<PartialHeader>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
              } else {
                Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _355_valueOrError6 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), StructuredEncryptionUtil_Compile.__default.CryptoSchemaMapIsFlat(((schema).dtor_content()).dtor_SchemaMap()), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Schema must be flat.")));
                if ((_355_valueOrError6).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                  return (_355_valueOrError6).<PartialHeader>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
                } else {
                  Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _356_valueOrError7 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), java.util.Objects.equals(java.math.BigInteger.valueOf((((mat).dtor_algorithmSuite()).dtor_binaryId()).length()), java.math.BigInteger.valueOf(2L)), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Invalid Algorithm Suite Binary ID")));
                  if ((_356_valueOrError7).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                    return (_356_valueOrError7).<PartialHeader>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
                  } else {
                    Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _357_valueOrError8 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (((byte)(java.lang.Object)((((mat).dtor_algorithmSuite()).dtor_binaryId()).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO)))))) == (StructuredEncryptionUtil_Compile.__default.DbeAlgorithmFamily()), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Algorithm Suite not suitable for structured encryption.")));
                    if ((_357_valueOrError8).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                      return (_357_valueOrError8).<PartialHeader>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
                    } else {
                      Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _358_valueOrError9 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), __default.ValidFlavor(((byte)(java.lang.Object)((((mat).dtor_algorithmSuite()).dtor_binaryId()).select(dafny.Helpers.toInt((java.math.BigInteger.ONE)))))), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Algorithm Suite has unexpected flavor.")));
                      if ((_358_valueOrError9).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                        return (_358_valueOrError9).<PartialHeader>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
                      } else {
                        Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _359_valueOrError10 = __default.MakeLegend(tableName, schema);
                        if ((_359_valueOrError10).IsFailure(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                          return (_359_valueOrError10).<PartialHeader>PropagateFailure(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
                        } else {
                          dafny.DafnySequence<? extends java.lang.Byte> _360_legend = (_359_valueOrError10).Extract(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
                          dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>> _361_storedEC = ((java.util.function.Function<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials, dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>>)(_362_mat) -> ((dafny.Function0<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>>)(() -> {
                            java.util.HashMap<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>> _coll9 = new java.util.HashMap<>();
                            for (dafny.DafnySequence<? extends java.lang.Byte> _compr_9_boxed0 : ((_362_mat).dtor_encryptionContext()).keySet().Elements()) {
                              dafny.DafnySequence<? extends java.lang.Byte> _compr_9 = ((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)(_compr_9_boxed0));
                              if (true) {
                                dafny.DafnySequence<? extends java.lang.Byte> _363_k = (dafny.DafnySequence<? extends java.lang.Byte>)_compr_9;
                                if ((((_362_mat).dtor_encryptionContext()).<dafny.DafnySequence<? extends java.lang.Byte>>contains(_363_k)) && (!((_362_mat).dtor_requiredEncryptionContextKeys()).contains(_363_k))) {
                                  _coll9.put(_363_k,((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)(((_362_mat).dtor_encryptionContext()).get(_363_k))));
                                }
                              }
                            }
                            return new dafny.DafnyMap<dafny.DafnySequence<? extends java.lang.Byte>,dafny.DafnySequence<? extends java.lang.Byte>>(_coll9);
                          })).apply()).apply(mat);
                          Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _364_valueOrError11 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), __default.ValidEncryptionContext(_361_storedEC), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Invalid Encryption Context")));
                          if ((_364_valueOrError11).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                            return (_364_valueOrError11).<PartialHeader>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
                          } else {
                            return Wrappers_Compile.Result.<PartialHeader, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>create_Success(StructuredEncryptionHeader_Compile.PartialHeader.create((byte) 1, ((byte)(java.lang.Object)((((mat).dtor_algorithmSuite()).dtor_binaryId()).select(dafny.Helpers.toInt((java.math.BigInteger.ONE))))), msgID, _360_legend, _361_storedEC, (mat).dtor_encryptedDataKeys()));
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  public static Wrappers_Compile.Result<PartialHeader, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> PartialDeserialize(dafny.DafnySequence<? extends java.lang.Byte> data) {
    Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _365_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (__default.PREFIX__LEN()).compareTo(java.math.BigInteger.valueOf((data).length())) <= 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Serialized PartialHeader too short.")));
    if ((_365_valueOrError0).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
      return (_365_valueOrError0).<PartialHeader>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
    } else {
      byte _366_version = ((byte)(java.lang.Object)((data).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO)))));
      Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _367_valueOrError1 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), __default.ValidVersion(_366_version), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Invalid Version Number")));
      if ((_367_valueOrError1).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
        return (_367_valueOrError1).<PartialHeader>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
      } else {
        byte _368_flavor = ((byte)(java.lang.Object)((data).select(dafny.Helpers.toInt((java.math.BigInteger.ONE)))));
        Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _369_valueOrError2 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), __default.ValidFlavor(_368_flavor), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Invalid Flavor")));
        if ((_369_valueOrError2).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
          return (_369_valueOrError2).<PartialHeader>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        } else {
          dafny.DafnySequence<? extends java.lang.Byte> _370_msgID = (data).subsequence(dafny.Helpers.toInt((java.math.BigInteger.valueOf(2L))), dafny.Helpers.toInt((__default.PREFIX__LEN())));
          dafny.DafnySequence<? extends java.lang.Byte> _371_legendData = (data).drop(__default.PREFIX__LEN());
          Wrappers_Compile.Result<dafny.Tuple2<dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _372_valueOrError3 = __default.GetLegend(_371_legendData);
          if ((_372_valueOrError3).IsFailure(dafny.Tuple2.<dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>_typeDescriptor(Legend._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return (_372_valueOrError3).<PartialHeader>PropagateFailure(dafny.Tuple2.<dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>_typeDescriptor(Legend._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
          } else {
            dafny.Tuple2<dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger> _373_legendAndLen = (_372_valueOrError3).Extract(dafny.Tuple2.<dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>_typeDescriptor(Legend._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
            dafny.DafnySequence<? extends java.lang.Byte> _374_legend = (_373_legendAndLen).dtor__0();
            dafny.DafnySequence<? extends java.lang.Byte> _375_contextData = (_371_legendData).drop((_373_legendAndLen).dtor__1());
            Wrappers_Compile.Result<dafny.Tuple2<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _376_valueOrError4 = __default.GetContext(_375_contextData);
            if ((_376_valueOrError4).IsFailure(dafny.Tuple2.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>_typeDescriptor(CMPEncryptionContext._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
              return (_376_valueOrError4).<PartialHeader>PropagateFailure(dafny.Tuple2.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>_typeDescriptor(CMPEncryptionContext._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
            } else {
              dafny.Tuple2<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger> _377_contextAndLen = (_376_valueOrError4).Extract(dafny.Tuple2.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>_typeDescriptor(CMPEncryptionContext._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
              dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>> _378_encContext = (_377_contextAndLen).dtor__0();
              dafny.DafnySequence<? extends java.lang.Byte> _379_keysData = (_375_contextData).drop((_377_contextAndLen).dtor__1());
              Wrappers_Compile.Result<dafny.Tuple2<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _380_valueOrError5 = __default.GetDataKeys(_379_keysData);
              if ((_380_valueOrError5).IsFailure(dafny.Tuple2.<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>_typeDescriptor(CMPEncryptedDataKeyList._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                return (_380_valueOrError5).<PartialHeader>PropagateFailure(dafny.Tuple2.<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>_typeDescriptor(CMPEncryptedDataKeyList._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
              } else {
                dafny.Tuple2<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger> _381_keysAndLen = (_380_valueOrError5).Extract(dafny.Tuple2.<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>_typeDescriptor(CMPEncryptedDataKeyList._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
                dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey> _382_dataKeys = (_381_keysAndLen).dtor__0();
                dafny.DafnySequence<? extends java.lang.Byte> _383_trailingData = (_379_keysData).drop((_381_keysAndLen).dtor__1());
                Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _384_valueOrError6 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (java.math.BigInteger.valueOf((_383_trailingData).length())).compareTo(__default.COMMITMENT__LEN()) >= 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Invalid header serialization: unexpected end of data.")));
                if ((_384_valueOrError6).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                  return (_384_valueOrError6).<PartialHeader>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
                } else {
                  Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _385_valueOrError7 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (java.math.BigInteger.valueOf((_383_trailingData).length())).compareTo(__default.COMMITMENT__LEN()) <= 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Invalid header serialization: unexpected bytes.")));
                  if ((_385_valueOrError7).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                    return (_385_valueOrError7).<PartialHeader>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
                  } else {
                    return Wrappers_Compile.Result.<PartialHeader, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>create_Success(StructuredEncryptionHeader_Compile.PartialHeader.create(_366_version, _368_flavor, _370_msgID, _374_legend, _378_encContext, _382_dataKeys));
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  public static Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> CalculateHeaderCommitment(software.amazon.cryptography.primitives.internaldafny.types.IAwsCryptographicPrimitivesClient client, software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo alg, dafny.DafnySequence<? extends java.lang.Byte> commitKey, dafny.DafnySequence<? extends java.lang.Byte> data)
  {
    software.amazon.cryptography.primitives.internaldafny.types.HMacInput _386_input = software.amazon.cryptography.primitives.internaldafny.types.HMacInput.create((((alg).dtor_commitment()).dtor_HKDF()).dtor_hmac(), commitKey, data);
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.primitives.internaldafny.types.Error> _387_outputR = (client).HMac(_386_input);
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _388_valueOrError0 = (_387_outputR).<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>MapFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.primitives.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.primitives.internaldafny.types.Error, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>)(_389_e_boxed0) -> {
      software.amazon.cryptography.primitives.internaldafny.types.Error _389_e = ((software.amazon.cryptography.primitives.internaldafny.types.Error)(java.lang.Object)(_389_e_boxed0));
      return software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error.create_AwsCryptographyPrimitives(_389_e);
    }));
    if ((_388_valueOrError0).IsFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
      return (_388_valueOrError0).<dafny.DafnySequence<? extends java.lang.Byte>>PropagateFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()));
    } else {
      dafny.DafnySequence<? extends java.lang.Byte> _390_output = (_388_valueOrError0).Extract(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
      if ((java.math.BigInteger.valueOf((_390_output).length())).compareTo(__default.COMMITMENT__LEN()) < 0) {
        return Wrappers_Compile.Result.<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>create_Failure(StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("HMAC did not produce enough bits")));
      } else {
        return Wrappers_Compile.Result.<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>create_Success((_390_output).take(__default.COMMITMENT__LEN()));
      }
    }
  }
  public static Wrappers_Compile.Result<java.lang.Short, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> ToUInt16(java.math.BigInteger x) {
    Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _391_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (x).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Value too big for 16 bits")));
    if ((_391_valueOrError0).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
      return (_391_valueOrError0).<java.lang.Short>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), BoundedInts_Compile.uint16._typeDescriptor());
    } else {
      return Wrappers_Compile.Result.<java.lang.Short, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>create_Success((x).shortValue());
    }
  }
  public static <__X, __Y, __Z> dafny.DafnyMap<? extends __Y, ? extends __Z> MyMap(dafny.TypeDescriptor<__X> _td___X, dafny.TypeDescriptor<__Y> _td___Y, dafny.TypeDescriptor<__Z> _td___Z, java.util.function.Function<__X, __Y> f, dafny.DafnyMap<? extends __X, ? extends __Z> m)
  {
    return ((dafny.Function2<dafny.DafnyMap<? extends __X, ? extends __Z>, java.util.function.Function<__X, __Y>, dafny.DafnyMap<? extends __Y, ? extends __Z>>)(_392_m, _393_f) -> ((dafny.Function0<dafny.DafnyMap<? extends __Y, ? extends __Z>>)(() -> {
      java.util.HashMap<__Y, __Z> _coll10 = new java.util.HashMap<>();
      for (__X _compr_10_boxed0 : (_392_m).keySet().Elements()) {
        __X _compr_10 = ((__X)(java.lang.Object)(_compr_10_boxed0));
        if (true) {
          __X _394_k = (__X)_compr_10;
          if ((_392_m).<__X>contains(_394_k)) {
            _coll10.put(((__Y)(java.lang.Object)((_393_f).apply(_394_k))),((__Z)(java.lang.Object)((_392_m).get(_394_k))));
          }
        }
      }
      return new dafny.DafnyMap<__Y,__Z>(_coll10);
    })).apply()).apply(m, f);
  }
  public static Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> MakeLegend(dafny.DafnySequence<? extends Character> tableName, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema schema)
  {
    dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema> _395_data = ((schema).dtor_content()).dtor_SchemaMap();
    Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _396_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema>, Boolean>)(_397_data) -> dafny.Helpers.Quantifier((_397_data).keySet().Elements(), true, ((_forall_var_7_boxed0) -> {
      dafny.DafnySequence<? extends Character> _forall_var_7 = ((dafny.DafnySequence<? extends Character>)(java.lang.Object)(_forall_var_7_boxed0));
      if (true) {
        dafny.DafnySequence<? extends Character> _398_k = (dafny.DafnySequence<? extends Character>)_forall_var_7;
        return !((_397_data).<dafny.DafnySequence<? extends Character>>contains(_398_k)) || (StructuredEncryptionUtil_Compile.__default.ValidString(_398_k));
      } else {
        return true;
      }
    }))).apply(_395_data), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("bad attribute name")));
    if ((_396_valueOrError0).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
      return (_396_valueOrError0).<dafny.DafnySequence<? extends java.lang.Byte>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Legend._typeDescriptor());
    } else {
      dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema> _399_authSchema = ((dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema>)(java.lang.Object)(dafny.Helpers.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema>, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema>>Let(__default.RestrictAuthAttrs(_395_data), boxed24 -> {
        dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema> _pat_let13_0 = ((dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema>)(java.lang.Object)(boxed24));
        return ((dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema>)(java.lang.Object)(dafny.Helpers.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema>, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema>>Let(_pat_let13_0, boxed25 -> {
          dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema> _400_rawSchema = ((dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema>)(java.lang.Object)(boxed25));
          return _400_rawSchema;
        }
        )));
      }
      )));
      java.util.function.Function<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>> _401_fn = ((java.util.function.Function<dafny.DafnySequence<? extends Character>, java.util.function.Function<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>>)(_402_tableName) -> ((java.util.function.Function<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>)(_403_k_boxed0) -> {
        dafny.DafnySequence<? extends Character> _403_k = ((dafny.DafnySequence<? extends Character>)(java.lang.Object)(_403_k_boxed0));
        return StructuredEncryptionPaths_Compile.__default.SimpleCanon(_402_tableName, _403_k);
      })).apply(tableName);
      dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema> _404_canonSchema = __default.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema>MyMap(StructuredEncryptionUtil_Compile.GoodString._typeDescriptor(), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema._typeDescriptor(), _401_fn, _399_authSchema);
      dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> _405_attrs = SortedSets.__default.<java.lang.Byte>SetToOrderedSequence2(BoundedInts_Compile.uint8._typeDescriptor(), (_404_canonSchema).keySet(), StructuredEncryptionUtil_Compile.__default::ByteLess);
      return __default.MakeLegend2(_405_attrs, _404_canonSchema, __default.EmptyLegend());
    }
  }
  public static Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> MakeLegend2(dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> attrs, dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema> data, dafny.DafnySequence<? extends java.lang.Byte> serialized)
  {
    TAIL_CALL_START: while (true) {
      if ((java.math.BigInteger.valueOf((attrs).length())).signum() == 0) {
        return Wrappers_Compile.Result.<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>create_Success(serialized);
      } else {
        Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _406_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((java.math.BigInteger.valueOf((serialized).length())).add(java.math.BigInteger.ONE)).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Legend Too Long.")));
        if ((_406_valueOrError0).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
          return (_406_valueOrError0).<dafny.DafnySequence<? extends java.lang.Byte>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Legend._typeDescriptor());
        } else {
          Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _407_valueOrError1 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((((software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema)(java.lang.Object)((data).get(((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)((attrs).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))))))).dtor_content()).is_Action(), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Schema must be flat")));
          if ((_407_valueOrError1).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return (_407_valueOrError1).<dafny.DafnySequence<? extends java.lang.Byte>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Legend._typeDescriptor());
          } else {
            byte _408_legendChar = __default.GetActionLegend(((((software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema)(java.lang.Object)((data).get(((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)((attrs).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))))))).dtor_content()).dtor_Action());
            dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> _in36 = (attrs).drop(java.math.BigInteger.ONE);
            dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema> _in37 = data;
            dafny.DafnySequence<? extends java.lang.Byte> _in38 = dafny.DafnySequence.<java.lang.Byte>concatenate(serialized, dafny.DafnySequence.of(_408_legendChar));
            attrs = _in36;
            data = _in37;
            serialized = _in38;
            continue TAIL_CALL_START;
          }
        }
      }
    }
  }
  public static byte GetActionLegend(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction x) {
    software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction _source4 = x;
    if (_source4.is_ENCRYPT__AND__SIGN()) {
      return __default.ENCRYPT__AND__SIGN__LEGEND();
    } else {
      return __default.SIGN__ONLY__LEGEND();
    }
  }
  public static dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema> RestrictAuthAttrs(dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema> data) {
    return ((java.util.function.Function<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema>, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema>>)(_409_data) -> ((dafny.Function0<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema>>)(() -> {
      java.util.HashMap<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema> _coll11 = new java.util.HashMap<>();
      for (dafny.DafnySequence<? extends Character> _compr_11_boxed0 : (_409_data).keySet().Elements()) {
        dafny.DafnySequence<? extends Character> _compr_11 = ((dafny.DafnySequence<? extends Character>)(java.lang.Object)(_compr_11_boxed0));
        if (true) {
          dafny.DafnySequence<? extends Character> _410_k = (dafny.DafnySequence<? extends Character>)_compr_11;
          if (((_409_data).<dafny.DafnySequence<? extends Character>>contains(_410_k)) && (StructuredEncryptionUtil_Compile.__default.IsAuthAttr(((((software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema)(java.lang.Object)((_409_data).get(_410_k)))).dtor_content()).dtor_Action()))) {
            _coll11.put(_410_k,((software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema)(java.lang.Object)((_409_data).get(_410_k))));
          }
        }
      }
      return new dafny.DafnyMap<dafny.DafnySequence<? extends Character>,software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoSchema>(_coll11);
    })).apply()).apply(data);
  }
  public static dafny.DafnySequence<? extends java.lang.Byte> SerializeLegend(dafny.DafnySequence<? extends java.lang.Byte> x) {
    return dafny.DafnySequence.<java.lang.Byte>concatenate(StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short) (x).cardinalityInt()), x);
  }
  public static Wrappers_Compile.Result<dafny.Tuple2<dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetLegend(dafny.DafnySequence<? extends java.lang.Byte> data) {
    Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _411_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (java.math.BigInteger.valueOf(2L)).compareTo(java.math.BigInteger.valueOf((data).length())) <= 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Unexpected end of header data.")));
    if ((_411_valueOrError0).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
      return (_411_valueOrError0).<dafny.Tuple2<dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>_typeDescriptor(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), dafny.TypeDescriptor.BIG_INTEGER));
    } else {
      short _412_len = StandardLibrary_mUInt_Compile.__default.SeqToUInt16((data).subsequence(dafny.Helpers.toInt((java.math.BigInteger.ZERO)), dafny.Helpers.toInt((java.math.BigInteger.valueOf(2L)))));
      java.math.BigInteger _413_size = (java.math.BigInteger.valueOf(java.lang.Short.toUnsignedLong(_412_len))).add(java.math.BigInteger.valueOf(2L));
      Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _414_valueOrError1 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_413_size).compareTo(java.math.BigInteger.valueOf((data).length())) <= 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Unexpected end of header data.")));
      if ((_414_valueOrError1).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
        return (_414_valueOrError1).<dafny.Tuple2<dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>_typeDescriptor(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), dafny.TypeDescriptor.BIG_INTEGER));
      } else {
        Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _415_valueOrError2 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((dafny.Function2<dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger, Boolean>)(_416_data, _417_size) -> dafny.Helpers.Quantifier(((_416_data).subsequence(dafny.Helpers.toInt((java.math.BigInteger.valueOf(2L))), dafny.Helpers.toInt((_417_size)))).UniqueElements(), true, ((_forall_var_8_boxed0) -> {
          byte _forall_var_8 = ((byte)(java.lang.Object)(_forall_var_8_boxed0));
          if (true) {
            byte _418_x = (byte)_forall_var_8;
            return !(((_416_data).subsequence(dafny.Helpers.toInt((java.math.BigInteger.valueOf(2L))), dafny.Helpers.toInt((_417_size)))).contains(_418_x)) || (__default.ValidLegendByte(_418_x));
          } else {
            return true;
          }
        }))).apply(data, _413_size), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Invalid byte in stored legend")));
        if ((_415_valueOrError2).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
          return (_415_valueOrError2).<dafny.Tuple2<dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>_typeDescriptor(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), dafny.TypeDescriptor.BIG_INTEGER));
        } else {
          return Wrappers_Compile.Result.<dafny.Tuple2<dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>create_Success(dafny.Tuple2.<dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>create((data).subsequence(dafny.Helpers.toInt((java.math.BigInteger.valueOf(2L))), dafny.Helpers.toInt((_413_size))), _413_size));
        }
      }
    }
  }
  public static Wrappers_Compile.Result<dafny.Tuple2<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetContext(dafny.DafnySequence<? extends java.lang.Byte> data) {
    Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _419_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (java.math.BigInteger.valueOf(2L)).compareTo(java.math.BigInteger.valueOf((data).length())) <= 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Unexpected end of header data.")));
    if ((_419_valueOrError0).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
      return (_419_valueOrError0).<dafny.Tuple2<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>_typeDescriptor(CMPEncryptionContext._typeDescriptor(), _System.nat._typeDescriptor()));
    } else {
      java.math.BigInteger _420_count = java.math.BigInteger.valueOf(java.lang.Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqToUInt16((data).subsequence(dafny.Helpers.toInt((java.math.BigInteger.ZERO)), dafny.Helpers.toInt((java.math.BigInteger.valueOf(2L)))))));
      Wrappers_Compile.Result<dafny.Tuple2<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _421_valueOrError1 = __default.GetContext2(_420_count, data, (data).drop(java.math.BigInteger.valueOf(2L)), dafny.Tuple2.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>create(dafny.DafnyMap.fromElements(), java.math.BigInteger.valueOf(2L)), dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor()));
      if ((_421_valueOrError1).IsFailure(dafny.Tuple2.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>_typeDescriptor(CMPEncryptionContext._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
        return (_421_valueOrError1).<dafny.Tuple2<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>>PropagateFailure(dafny.Tuple2.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>_typeDescriptor(CMPEncryptionContext._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>_typeDescriptor(CMPEncryptionContext._typeDescriptor(), _System.nat._typeDescriptor()));
      } else {
        dafny.Tuple2<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger> _422_context = (_421_valueOrError1).Extract(dafny.Tuple2.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>_typeDescriptor(CMPEncryptionContext._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        return Wrappers_Compile.Result.<dafny.Tuple2<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>create_Success(_422_context);
      }
    }
  }
  public static Wrappers_Compile.Result<dafny.Tuple3<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetOneKVPair(dafny.DafnySequence<? extends java.lang.Byte> data) {
    Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _423_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (java.math.BigInteger.valueOf(2L)).compareTo(java.math.BigInteger.valueOf((data).length())) <= 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Unexpected end of header data.")));
    if ((_423_valueOrError0).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
      return (_423_valueOrError0).<dafny.Tuple3<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple3.<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>_typeDescriptor(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), dafny.TypeDescriptor.BIG_INTEGER));
    } else {
      java.math.BigInteger _424_keyLen = java.math.BigInteger.valueOf(java.lang.Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqToUInt16((data).subsequence(dafny.Helpers.toInt((java.math.BigInteger.ZERO)), dafny.Helpers.toInt((java.math.BigInteger.valueOf(2L)))))));
      Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _425_valueOrError1 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((_424_keyLen).add(java.math.BigInteger.valueOf(4L))).compareTo(java.math.BigInteger.valueOf((data).length())) <= 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Unexpected end of header data.")));
      if ((_425_valueOrError1).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
        return (_425_valueOrError1).<dafny.Tuple3<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple3.<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>_typeDescriptor(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), dafny.TypeDescriptor.BIG_INTEGER));
      } else {
        dafny.DafnySequence<? extends java.lang.Byte> _426_key = (data).subsequence(dafny.Helpers.toInt((java.math.BigInteger.valueOf(2L))), dafny.Helpers.toInt(((_424_keyLen).add(java.math.BigInteger.valueOf(2L)))));
        Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _427_valueOrError2 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), UTF8.__default.ValidUTF8Seq(_426_key), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Invalid UTF8 found in header.")));
        if ((_427_valueOrError2).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
          return (_427_valueOrError2).<dafny.Tuple3<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple3.<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>_typeDescriptor(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), dafny.TypeDescriptor.BIG_INTEGER));
        } else {
          java.math.BigInteger _428_valueLen = java.math.BigInteger.valueOf(java.lang.Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqToUInt16((data).subsequence(dafny.Helpers.toInt(((_424_keyLen).add(java.math.BigInteger.valueOf(2L)))), dafny.Helpers.toInt(((_424_keyLen).add(java.math.BigInteger.valueOf(4L))))))));
          java.math.BigInteger _429_kvLen = (((java.math.BigInteger.valueOf(2L)).add(_424_keyLen)).add(java.math.BigInteger.valueOf(2L))).add(_428_valueLen);
          Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _430_valueOrError3 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_429_kvLen).compareTo(java.math.BigInteger.valueOf((data).length())) <= 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Unexpected end of header data.")));
          if ((_430_valueOrError3).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return (_430_valueOrError3).<dafny.Tuple3<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple3.<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>_typeDescriptor(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), dafny.TypeDescriptor.BIG_INTEGER));
          } else {
            dafny.DafnySequence<? extends java.lang.Byte> _431_value = (data).subsequence(dafny.Helpers.toInt(((_424_keyLen).add(java.math.BigInteger.valueOf(4L)))), dafny.Helpers.toInt((_429_kvLen)));
            Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _432_valueOrError4 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), UTF8.__default.ValidUTF8Seq(_431_value), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Invalid UTF8 found in header.")));
            if ((_432_valueOrError4).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
              return (_432_valueOrError4).<dafny.Tuple3<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple3.<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>_typeDescriptor(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), dafny.TypeDescriptor.BIG_INTEGER));
            } else {
              return Wrappers_Compile.Result.<dafny.Tuple3<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>create_Success(dafny.Tuple3.<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>create(_426_key, _431_value, _429_kvLen));
            }
          }
        }
      }
    }
  }
  public static boolean BytesLess(dafny.DafnySequence<? extends java.lang.Byte> a, dafny.DafnySequence<? extends java.lang.Byte> b)
  {
    TAIL_CALL_START: while (true) {
      if ((a).equals(b)) {
        return false;
      } else if ((java.math.BigInteger.valueOf((a).length())).signum() == 0) {
        return true;
      } else if ((java.math.BigInteger.valueOf((b).length())).signum() == 0) {
        return false;
      } else if ((((byte)(java.lang.Object)((a).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO)))))) != (((byte)(java.lang.Object)((b).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))))) {
        return java.lang.Integer.compareUnsigned(((byte)(java.lang.Object)((a).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))), ((byte)(java.lang.Object)((b).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO)))))) < 0;
      } else {
        dafny.DafnySequence<? extends java.lang.Byte> _in39 = (a).drop(java.math.BigInteger.ONE);
        dafny.DafnySequence<? extends java.lang.Byte> _in40 = (b).drop(java.math.BigInteger.ONE);
        a = _in39;
        b = _in40;
        continue TAIL_CALL_START;
      }
    }
  }
  public static Wrappers_Compile.Result<dafny.Tuple2<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetContext2(java.math.BigInteger count, dafny.DafnySequence<? extends java.lang.Byte> origData, dafny.DafnySequence<? extends java.lang.Byte> data, dafny.Tuple2<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger> deserialized, dafny.DafnySequence<? extends java.lang.Byte> prevKey)
  {
    TAIL_CALL_START: while (true) {
      if ((count).signum() == 0) {
        return Wrappers_Compile.Result.<dafny.Tuple2<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>create_Success(deserialized);
      } else {
        Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _433_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((java.math.BigInteger.valueOf(((deserialized).dtor__0()).size())).add(java.math.BigInteger.ONE)).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Too much context")));
        if ((_433_valueOrError0).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
          return (_433_valueOrError0).<dafny.Tuple2<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>_typeDescriptor(CMPEncryptionContext._typeDescriptor(), _System.nat._typeDescriptor()));
        } else {
          Wrappers_Compile.Result<dafny.Tuple3<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _434_valueOrError1 = __default.GetOneKVPair(data);
          if ((_434_valueOrError1).IsFailure(dafny.Tuple3.<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>_typeDescriptor(CMPUtf8Bytes._typeDescriptor(), CMPUtf8Bytes._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return (_434_valueOrError1).<dafny.Tuple2<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>>PropagateFailure(dafny.Tuple3.<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>_typeDescriptor(CMPUtf8Bytes._typeDescriptor(), CMPUtf8Bytes._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>_typeDescriptor(CMPEncryptionContext._typeDescriptor(), _System.nat._typeDescriptor()));
          } else {
            dafny.Tuple3<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger> _435_kv = (_434_valueOrError1).Extract(dafny.Tuple3.<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>, java.math.BigInteger>_typeDescriptor(CMPUtf8Bytes._typeDescriptor(), CMPUtf8Bytes._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
            Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _436_valueOrError2 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), __default.BytesLess(prevKey, (_435_kv).dtor__0()), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Context keys out of order.")));
            if ((_436_valueOrError2).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
              return (_436_valueOrError2).<dafny.Tuple2<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>_typeDescriptor(CMPEncryptionContext._typeDescriptor(), _System.nat._typeDescriptor()));
            } else {
              java.math.BigInteger _in41 = (count).subtract(java.math.BigInteger.ONE);
              dafny.DafnySequence<? extends java.lang.Byte> _in42 = origData;
              dafny.DafnySequence<? extends java.lang.Byte> _in43 = (data).drop((((java.math.BigInteger.valueOf(2L)).add(java.math.BigInteger.valueOf(((_435_kv).dtor__0()).length()))).add(java.math.BigInteger.valueOf(2L))).add(java.math.BigInteger.valueOf(((_435_kv).dtor__1()).length())));
              dafny.Tuple2<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger> _in44 = dafny.Tuple2.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, java.math.BigInteger>create(dafny.DafnyMap.<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends java.lang.Byte>>update((deserialized).dtor__0(), (_435_kv).dtor__0(), (_435_kv).dtor__1()), ((deserialized).dtor__1()).add((_435_kv).dtor__2()));
              dafny.DafnySequence<? extends java.lang.Byte> _in45 = (_435_kv).dtor__0();
              count = _in41;
              origData = _in42;
              data = _in43;
              deserialized = _in44;
              prevKey = _in45;
              continue TAIL_CALL_START;
            }
          }
        }
      }
    }
  }
  public static dafny.DafnySequence<? extends java.lang.Byte> SerializeContext(dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>> x) {
    dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> _437_keys = SortedSets.__default.<java.lang.Byte>SetToOrderedSequence2(BoundedInts_Compile.uint8._typeDescriptor(), (x).keySet(), StructuredEncryptionUtil_Compile.__default::ByteLess);
    return dafny.DafnySequence.<java.lang.Byte>concatenate(StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short) (x).cardinalityInt()), __default.SerializeContext2(_437_keys, x));
  }
  public static dafny.DafnySequence<? extends java.lang.Byte> SerializeOneKVPair(dafny.DafnySequence<? extends java.lang.Byte> key, dafny.DafnySequence<? extends java.lang.Byte> value)
  {
    return dafny.DafnySequence.<java.lang.Byte>concatenate(dafny.DafnySequence.<java.lang.Byte>concatenate(dafny.DafnySequence.<java.lang.Byte>concatenate(StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short) (key).cardinalityInt()), key), StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short) (value).cardinalityInt())), value);
  }
  public static dafny.DafnySequence<? extends java.lang.Byte> SerializeOneDataKey(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey k) {
    return dafny.DafnySequence.<java.lang.Byte>concatenate(dafny.DafnySequence.<java.lang.Byte>concatenate(dafny.DafnySequence.<java.lang.Byte>concatenate(dafny.DafnySequence.<java.lang.Byte>concatenate(dafny.DafnySequence.<java.lang.Byte>concatenate(StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short) ((k).dtor_keyProviderId()).cardinalityInt()), (k).dtor_keyProviderId()), StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short) ((k).dtor_keyProviderInfo()).cardinalityInt())), (k).dtor_keyProviderInfo()), StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short) ((k).dtor_ciphertext()).cardinalityInt())), (k).dtor_ciphertext());
  }
  public static Wrappers_Compile.Result<dafny.Tuple2<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetOneDataKey(dafny.DafnySequence<? extends java.lang.Byte> data) {
    Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _438_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (java.math.BigInteger.valueOf(2L)).compareTo(java.math.BigInteger.valueOf((data).length())) < 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Unexpected end of header data.")));
    if ((_438_valueOrError0).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
      return (_438_valueOrError0).<dafny.Tuple2<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>_typeDescriptor(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey._typeDescriptor(), dafny.TypeDescriptor.BIG_INTEGER));
    } else {
      java.math.BigInteger _439_provIdSize = java.math.BigInteger.valueOf(java.lang.Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqToUInt16((data).subsequence(dafny.Helpers.toInt((java.math.BigInteger.ZERO)), dafny.Helpers.toInt((java.math.BigInteger.valueOf(2L)))))));
      Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _440_valueOrError1 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((_439_provIdSize).add(java.math.BigInteger.valueOf(2L))).compareTo(java.math.BigInteger.valueOf((data).length())) < 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Unexpected end of header data.")));
      if ((_440_valueOrError1).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
        return (_440_valueOrError1).<dafny.Tuple2<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>_typeDescriptor(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey._typeDescriptor(), dafny.TypeDescriptor.BIG_INTEGER));
      } else {
        dafny.DafnySequence<? extends java.lang.Byte> _441_provId = (data).subsequence(dafny.Helpers.toInt((java.math.BigInteger.valueOf(2L))), dafny.Helpers.toInt(((java.math.BigInteger.valueOf(2L)).add(_439_provIdSize))));
        Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _442_valueOrError2 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), UTF8.__default.ValidUTF8Seq(_441_provId), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Invalid UTF8 found in header.")));
        if ((_442_valueOrError2).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
          return (_442_valueOrError2).<dafny.Tuple2<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>_typeDescriptor(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey._typeDescriptor(), dafny.TypeDescriptor.BIG_INTEGER));
        } else {
          java.math.BigInteger _443_part1Size = (java.math.BigInteger.valueOf(2L)).add(_439_provIdSize);
          Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _444_valueOrError3 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((_443_part1Size).add(java.math.BigInteger.valueOf(2L))).compareTo(java.math.BigInteger.valueOf((data).length())) <= 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Unexpected end of header data.")));
          if ((_444_valueOrError3).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return (_444_valueOrError3).<dafny.Tuple2<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>_typeDescriptor(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey._typeDescriptor(), dafny.TypeDescriptor.BIG_INTEGER));
          } else {
            java.math.BigInteger _445_provInfoSize = java.math.BigInteger.valueOf(java.lang.Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqToUInt16((data).subsequence(dafny.Helpers.toInt((_443_part1Size)), dafny.Helpers.toInt(((_443_part1Size).add(java.math.BigInteger.valueOf(2L))))))));
            Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _446_valueOrError4 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (((_443_part1Size).add(_445_provInfoSize)).add(java.math.BigInteger.valueOf(2L))).compareTo(java.math.BigInteger.valueOf((data).length())) < 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Unexpected end of header data.")));
            if ((_446_valueOrError4).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
              return (_446_valueOrError4).<dafny.Tuple2<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>_typeDescriptor(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey._typeDescriptor(), dafny.TypeDescriptor.BIG_INTEGER));
            } else {
              dafny.DafnySequence<? extends java.lang.Byte> _447_provInfo = (data).subsequence(dafny.Helpers.toInt(((_443_part1Size).add(java.math.BigInteger.valueOf(2L)))), dafny.Helpers.toInt((((_443_part1Size).add(java.math.BigInteger.valueOf(2L))).add(_445_provInfoSize))));
              java.math.BigInteger _448_part2Size = ((_443_part1Size).add(java.math.BigInteger.valueOf(2L))).add(_445_provInfoSize);
              Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _449_valueOrError5 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((_448_part2Size).add(java.math.BigInteger.valueOf(2L))).compareTo(java.math.BigInteger.valueOf((data).length())) <= 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Unexpected end of header data.")));
              if ((_449_valueOrError5).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                return (_449_valueOrError5).<dafny.Tuple2<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>_typeDescriptor(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey._typeDescriptor(), dafny.TypeDescriptor.BIG_INTEGER));
              } else {
                java.math.BigInteger _450_cipherSize = java.math.BigInteger.valueOf(java.lang.Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqToUInt16((data).subsequence(dafny.Helpers.toInt((_448_part2Size)), dafny.Helpers.toInt(((_448_part2Size).add(java.math.BigInteger.valueOf(2L))))))));
                Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _451_valueOrError6 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (((_448_part2Size).add(_450_cipherSize)).add(java.math.BigInteger.valueOf(2L))).compareTo(java.math.BigInteger.valueOf((data).length())) <= 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Unexpected end of header data.")));
                if ((_451_valueOrError6).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                  return (_451_valueOrError6).<dafny.Tuple2<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>_typeDescriptor(software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey._typeDescriptor(), dafny.TypeDescriptor.BIG_INTEGER));
                } else {
                  dafny.DafnySequence<? extends java.lang.Byte> _452_cipher = (data).subsequence(dafny.Helpers.toInt(((_448_part2Size).add(java.math.BigInteger.valueOf(2L)))), dafny.Helpers.toInt((((_448_part2Size).add(java.math.BigInteger.valueOf(2L))).add(_450_cipherSize))));
                  java.math.BigInteger _453_part3Size = ((_448_part2Size).add(java.math.BigInteger.valueOf(2L))).add(_450_cipherSize);
                  software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey _454_edk = software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey.create(_441_provId, _447_provInfo, _452_cipher);
                  return Wrappers_Compile.Result.<dafny.Tuple2<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>create_Success(dafny.Tuple2.<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>create(_454_edk, _453_part3Size));
                }
              }
            }
          }
        }
      }
    }
  }
  public static dafny.DafnySequence<? extends java.lang.Byte> SerializeContext2(dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> keys, dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>> x)
  {
    dafny.DafnySequence<? extends java.lang.Byte> _455___accumulator = dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor());
    TAIL_CALL_START: while (true) {
      if ((java.math.BigInteger.valueOf((keys).length())).signum() == 0) {
        return dafny.DafnySequence.<java.lang.Byte>concatenate(_455___accumulator, dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor()));
      } else {
        _455___accumulator = dafny.DafnySequence.<java.lang.Byte>concatenate(_455___accumulator, __default.SerializeOneKVPair(((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)((keys).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))), ((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)((x).get(((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)((keys).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))))))));
        dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> _in46 = (keys).drop(java.math.BigInteger.ONE);
        dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends dafny.DafnySequence<? extends java.lang.Byte>> _in47 = x;
        keys = _in46;
        x = _in47;
        continue TAIL_CALL_START;
      }
    }
  }
  public static dafny.DafnySequence<? extends java.lang.Byte> SerializeDataKeys(dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey> x) {
    dafny.DafnySequence<? extends java.lang.Byte> _456_body = __default.SerializeDataKeys2(x);
    return dafny.DafnySequence.<java.lang.Byte>concatenate(dafny.DafnySequence.of((byte) (x).cardinalityInt()), _456_body);
  }
  public static dafny.DafnySequence<? extends java.lang.Byte> SerializeDataKeys2(dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey> x) {
    dafny.DafnySequence<? extends java.lang.Byte> _457___accumulator = dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor());
    TAIL_CALL_START: while (true) {
      if ((java.math.BigInteger.valueOf((x).length())).signum() == 0) {
        return dafny.DafnySequence.<java.lang.Byte>concatenate(_457___accumulator, dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor()));
      } else {
        _457___accumulator = dafny.DafnySequence.<java.lang.Byte>concatenate(_457___accumulator, __default.SerializeOneDataKey(((software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey)(java.lang.Object)((x).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO)))))));
        dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey> _in48 = (x).drop(java.math.BigInteger.ONE);
        x = _in48;
        continue TAIL_CALL_START;
      }
    }
  }
  public static Wrappers_Compile.Result<dafny.Tuple2<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetDataKeys(dafny.DafnySequence<? extends java.lang.Byte> data) {
    Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _458_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (java.math.BigInteger.ONE).compareTo(java.math.BigInteger.valueOf((data).length())) <= 0, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Unexpected end of header data.")));
    if ((_458_valueOrError0).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
      return (_458_valueOrError0).<dafny.Tuple2<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>_typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), _System.nat._typeDescriptor()));
    } else {
      java.math.BigInteger _459_count = java.math.BigInteger.valueOf(java.lang.Byte.toUnsignedLong(((byte)(java.lang.Object)((data).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO)))))));
      Wrappers_Compile.Result<dafny.Tuple2<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _460_valueOrError1 = __default.GetDataKeys2(_459_count, _459_count, data, (data).drop(java.math.BigInteger.ONE), dafny.Tuple2.<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>create(dafny.DafnySequence.<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey> empty(CMPEncryptedDataKey._typeDescriptor()), java.math.BigInteger.ONE));
      if ((_460_valueOrError1).IsFailure(dafny.Tuple2.<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>_typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
        return (_460_valueOrError1).<dafny.Tuple2<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>>PropagateFailure(dafny.Tuple2.<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>_typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>_typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), _System.nat._typeDescriptor()));
      } else {
        dafny.Tuple2<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger> _461_keys = (_460_valueOrError1).Extract(dafny.Tuple2.<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>_typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        if ((java.math.BigInteger.valueOf(((_461_keys).dtor__0()).length())).signum() == 0) {
          return Wrappers_Compile.Result.<dafny.Tuple2<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>create_Failure(StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("At least one Data Key required")));
        } else {
          return Wrappers_Compile.Result.<dafny.Tuple2<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>create_Success(_461_keys);
        }
      }
    }
  }
  public static Wrappers_Compile.Result<dafny.Tuple2<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetDataKeys2(java.math.BigInteger count, java.math.BigInteger origCount, dafny.DafnySequence<? extends java.lang.Byte> origData, dafny.DafnySequence<? extends java.lang.Byte> data, dafny.Tuple2<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger> deserialized)
  {
    TAIL_CALL_START: while (true) {
      if ((count).signum() == 0) {
        return Wrappers_Compile.Result.<dafny.Tuple2<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>create_Success(deserialized);
      } else if ((java.math.BigInteger.valueOf(((deserialized).dtor__0()).length())).compareTo(java.math.BigInteger.valueOf(255L)) >= 0) {
        return Wrappers_Compile.Result.<dafny.Tuple2<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>create_Failure(StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Too Many Data Keys")));
      } else {
        Wrappers_Compile.Result<dafny.Tuple2<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _462_valueOrError0 = __default.GetOneDataKey(data);
        if ((_462_valueOrError0).IsFailure(dafny.Tuple2.<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>_typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
          return (_462_valueOrError0).<dafny.Tuple2<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>>PropagateFailure(dafny.Tuple2.<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>_typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.Tuple2.<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>_typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), _System.nat._typeDescriptor()));
        } else {
          dafny.Tuple2<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger> _463_edk = (_462_valueOrError0).Extract(dafny.Tuple2.<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey, java.math.BigInteger>_typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), _System.nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
          java.math.BigInteger _in49 = (count).subtract(java.math.BigInteger.ONE);
          java.math.BigInteger _in50 = origCount;
          dafny.DafnySequence<? extends java.lang.Byte> _in51 = origData;
          dafny.DafnySequence<? extends java.lang.Byte> _in52 = (data).drop((_463_edk).dtor__1());
          dafny.Tuple2<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger> _in53 = dafny.Tuple2.<dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>, java.math.BigInteger>create(dafny.DafnySequence.<software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey>concatenate((deserialized).dtor__0(), dafny.DafnySequence.of(CMPEncryptedDataKey._typeDescriptor(), (_463_edk).dtor__0())), ((deserialized).dtor__1()).add((_463_edk).dtor__1()));
          count = _in49;
          origCount = _in50;
          origData = _in51;
          data = _in52;
          deserialized = _in53;
          continue TAIL_CALL_START;
        }
      }
    }
  }
  public static java.math.BigInteger UINT8__LIMIT()
  {
    return java.math.BigInteger.valueOf(256L);
  }
  public static java.math.BigInteger COMMITMENT__LEN()
  {
    return java.math.BigInteger.valueOf(32L);
  }
  public static byte ENCRYPT__AND__SIGN__LEGEND()
  {
    return (byte) 101;
  }
  public static byte SIGN__ONLY__LEGEND()
  {
    return (byte) 115;
  }
  public static java.math.BigInteger VERSION__LEN()
  {
    return java.math.BigInteger.ONE;
  }
  public static java.math.BigInteger FLAVOR__LEN()
  {
    return java.math.BigInteger.ONE;
  }
  public static java.math.BigInteger PREFIX__LEN()
  {
    return ((__default.VERSION__LEN()).add(__default.FLAVOR__LEN())).add(StructuredEncryptionUtil_Compile.__default.MSGID__LEN());
  }
  public static dafny.DafnySequence<? extends java.lang.Byte> EmptyLegend()
  {
    return dafny.DafnySequence.<java.lang.Byte> empty(LegendByte._typeDescriptor());
  }
  private static final dafny.TypeDescriptor<__default> _TYPE = dafny.TypeDescriptor.<__default>referenceWithInitializer(__default.class, () -> (__default) null);
  public static dafny.TypeDescriptor<__default> _typeDescriptor() {
    return (dafny.TypeDescriptor<__default>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  @Override
  public java.lang.String toString() {
    return "StructuredEncryptionHeader_Compile._default";
  }
}
