// Class Footer
// Dafny class Footer compiled into Java
package StructuredEncryptionFooter_Compile;

import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.*;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.*;
import DynamoDbEncryptionUtil_Compile.*;
import DynamoDbNormalizeNumber_Compile.*;
import DynamoToStruct_Compile.*;
import DynamoDbEncryptionBranchKeyIdSupplier_Compile.*;
import AwsCryptographyDbEncryptionSdkDynamoDbOperations_Compile.*;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.*;
import StructuredEncryptionUtil_Compile.*;
import Sets_Compile.*;
import StructuredEncryptionPaths_Compile.*;
import StructuredEncryptionHeader_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class Footer {
  public dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> _tags;
  public Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>> _sig;
  public Footer (dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> tags, Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>> sig) {
    this._tags = tags;
    this._sig = sig;
  }

  @Override
  public boolean equals(Object other) {
    if (this == other) return true;
    if (other == null) return false;
    if (getClass() != other.getClass()) return false;
    Footer o = (Footer)other;
    return true && java.util.Objects.equals(this._tags, o._tags) && java.util.Objects.equals(this._sig, o._sig);
  }
  @Override
  public int hashCode() {
    long hash = 5381;
    hash = ((hash << 5) + hash) + 0;
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._tags);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._sig);
    return (int)hash;
  }

  @Override
  public String toString() {
    StringBuilder s = new StringBuilder();
    s.append("StructuredEncryptionFooter_Compile.Footer.Footer");
    s.append("(");
    s.append(dafny.Helpers.toString(this._tags));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._sig));
    s.append(")");
    return s.toString();
  }

  private static final Footer theDefault = StructuredEncryptionFooter_Compile.Footer.create(dafny.DafnySequence.<dafny.DafnySequence<? extends java.lang.Byte>> empty(RecipientTag._typeDescriptor()), Wrappers_Compile.Option.<dafny.DafnySequence<? extends java.lang.Byte>>Default());
  public static Footer Default() {
    return theDefault;
  }
  private static final dafny.TypeDescriptor<Footer> _TYPE = dafny.TypeDescriptor.<Footer>referenceWithInitializer(Footer.class, () -> Default());
  public static dafny.TypeDescriptor<Footer> _typeDescriptor() {
    return (dafny.TypeDescriptor<Footer>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  public static Footer create(dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> tags, Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>> sig) {
    return new Footer(tags, sig);
  }
  public static Footer create_Footer(dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> tags, Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>> sig) {
    return create(tags, sig);
  }
  public boolean is_Footer() { return true; }
  public dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> dtor_tags() {
    return this._tags;
  }
  public Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>> dtor_sig() {
    return this._sig;
  }
  public dafny.DafnySequence<? extends java.lang.Byte> serialize() {
    return dafny.DafnySequence.<java.lang.Byte>concatenate(__default.SerializeTags((this).dtor_tags()), __default.SerializeSig((this).dtor_sig()));
  }
  public software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredData makeTerminal() {
    return StructuredEncryptionUtil_Compile.__default.ValueToData((this).serialize(), StructuredEncryptionUtil_Compile.__default.BYTES__TYPE__ID());
  }
  public Wrappers_Compile.Result<Boolean, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> validate(software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient client, software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials mat, dafny.DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey> edks, dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> signedFields, dafny.DafnySequence<? extends dafny.DafnySequence<? extends java.lang.Byte>> encFields, dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredData> encData, dafny.DafnyMap<? extends dafny.DafnySequence<? extends java.lang.Byte>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredData> allData, dafny.DafnySequence<? extends java.lang.Byte> header)
  {
    Wrappers_Compile.Result<Boolean, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> ret = Wrappers_Compile.Result.<Boolean, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Default(false);
    Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _464_valueOrError0 = Wrappers_Compile.Outcome.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Default();
    _464_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), java.util.Objects.equals(java.math.BigInteger.valueOf((edks).length()), java.math.BigInteger.valueOf(((this).dtor_tags()).length())), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("There are a different number of recipient tags in the stored header than there are in the decryption materials.")));
    if ((_464_valueOrError0).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
      ret = (_464_valueOrError0).<Boolean>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.TypeDescriptor.BOOLEAN);
      return ret;
    }
    dafny.DafnySequence<? extends java.lang.Byte> _465_canonicalHash;
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _466_valueOrError1 = Wrappers_Compile.Result.<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Default(dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor()));
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _out4;
    _out4 = __default.CanonHash(signedFields, encFields, encData, allData, header, (mat).dtor_encryptionContext());
    _466_valueOrError1 = _out4;
    if ((_466_valueOrError1).IsFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
      ret = (_466_valueOrError1).<Boolean>PropagateFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.TypeDescriptor.BOOLEAN);
      return ret;
    }
    _465_canonicalHash = (_466_valueOrError1).Extract(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
    software.amazon.cryptography.primitives.internaldafny.types.HMacInput _467_input;
    _467_input = software.amazon.cryptography.primitives.internaldafny.types.HMacInput.create((((mat).dtor_algorithmSuite()).dtor_symmetricSignature()).dtor_HMAC(), ((mat).dtor_symmetricSigningKey()).dtor_value(), _465_canonicalHash);
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.primitives.internaldafny.types.Error> _468_hashR;
    _468_hashR = (client).HMac(_467_input);
    dafny.DafnySequence<? extends java.lang.Byte> _469_hash;
    Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _470_valueOrError2 = Wrappers_Compile.Result.<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Default(dafny.DafnySequence.<java.lang.Byte> empty(BoundedInts_Compile.uint8._typeDescriptor()));
    _470_valueOrError2 = (_468_hashR).<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>MapFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.primitives.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.primitives.internaldafny.types.Error, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>)(_471_e_boxed0) -> {
      software.amazon.cryptography.primitives.internaldafny.types.Error _471_e = ((software.amazon.cryptography.primitives.internaldafny.types.Error)(java.lang.Object)(_471_e_boxed0));
      return software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error.create_AwsCryptographyPrimitives(_471_e);
    }));
    if ((_470_valueOrError2).IsFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
      ret = (_470_valueOrError2).<Boolean>PropagateFailure(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.TypeDescriptor.BOOLEAN);
      return ret;
    }
    _469_hash = (_470_valueOrError2).Extract(dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
    Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _472_valueOrError3 = Wrappers_Compile.Outcome.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Default();
    _472_valueOrError3 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), java.util.Objects.equals(java.math.BigInteger.valueOf((_469_hash).length()), java.math.BigInteger.valueOf(48L)), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Bad hash length")));
    if ((_472_valueOrError3).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
      ret = (_472_valueOrError3).<Boolean>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.TypeDescriptor.BOOLEAN);
      return ret;
    }
    boolean _473_foundTag;
    _473_foundTag = false;
    goto_0: {
      java.math.BigInteger _hi0 = java.math.BigInteger.valueOf(((this).dtor_tags()).length());
      for (java.math.BigInteger _474_i = java.math.BigInteger.ZERO; _474_i.compareTo(_hi0) < 0; _474_i = _474_i.add(java.math.BigInteger.ONE)) {
        continue_0: {
          if (StructuredEncryptionUtil_Compile.__default.ConstantTimeEquals(_469_hash, ((dafny.DafnySequence<? extends java.lang.Byte>)(java.lang.Object)(((this).dtor_tags()).select(dafny.Helpers.toInt((_474_i))))))) {
            _473_foundTag = true;
            break goto_0;
          }
        }
      }
    }
    Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _475_valueOrError4 = Wrappers_Compile.Outcome.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Default();
    _475_valueOrError4 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), _473_foundTag, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("No recipient tag matched.")));
    if ((_475_valueOrError4).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
      ret = (_475_valueOrError4).<Boolean>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.TypeDescriptor.BOOLEAN);
      return ret;
    }
    Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _476_valueOrError5 = Wrappers_Compile.Outcome.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Default();
    _476_valueOrError5 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (((this).dtor_sig()).is_Some()) == ((((mat).dtor_algorithmSuite()).dtor_signature()).is_ECDSA()), StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Internal error. Signature both does and does not exist.")));
    if ((_476_valueOrError5).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
      ret = (_476_valueOrError5).<Boolean>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.TypeDescriptor.BOOLEAN);
      return ret;
    }
    if (((this).dtor_sig()).is_Some()) {
      software.amazon.cryptography.primitives.internaldafny.types.ECDSAVerifyInput _477_verInput;
      _477_verInput = software.amazon.cryptography.primitives.internaldafny.types.ECDSAVerifyInput.create(((((mat).dtor_algorithmSuite()).dtor_signature()).dtor_ECDSA()).dtor_curve(), ((mat).dtor_verificationKey()).dtor_value(), _465_canonicalHash, ((this).dtor_sig()).dtor_value());
      Wrappers_Compile.Result<Boolean, software.amazon.cryptography.primitives.internaldafny.types.Error> _478_verR;
      Wrappers_Compile.Result<Boolean, software.amazon.cryptography.primitives.internaldafny.types.Error> _out5;
      _out5 = (client).ECDSAVerify(_477_verInput);
      _478_verR = _out5;
      boolean _479_ver;
      Wrappers_Compile.Result<Boolean, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _480_valueOrError6 = Wrappers_Compile.Result.<Boolean, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Default(false);
      _480_valueOrError6 = (_478_verR).<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>MapFailure(dafny.TypeDescriptor.BOOLEAN, software.amazon.cryptography.primitives.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.primitives.internaldafny.types.Error, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>)(_481_e_boxed0) -> {
        software.amazon.cryptography.primitives.internaldafny.types.Error _481_e = ((software.amazon.cryptography.primitives.internaldafny.types.Error)(java.lang.Object)(_481_e_boxed0));
        return software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error.create_AwsCryptographyPrimitives(_481_e);
      }));
      if ((_480_valueOrError6).IsFailure(dafny.TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
        ret = (_480_valueOrError6).<Boolean>PropagateFailure(dafny.TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.TypeDescriptor.BOOLEAN);
        return ret;
      }
      _479_ver = (_480_valueOrError6).Extract(dafny.TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
      Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _482_valueOrError7 = Wrappers_Compile.Outcome.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Default();
      _482_valueOrError7 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), _479_ver, StructuredEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Signature did not verify")));
      if ((_482_valueOrError7).IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
        ret = (_482_valueOrError7).<Boolean>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), dafny.TypeDescriptor.BOOLEAN);
        return ret;
      }
    }
    ret = Wrappers_Compile.Result.<Boolean, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error>create_Success(true);
    return ret;
  }
}
