// Class KeySource
// Dafny class KeySource compiled into Java
package SearchableEncryptionInfo_Compile;

import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.*;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.*;
import DynamoDbEncryptionUtil_Compile.*;
import DynamoDbNormalizeNumber_Compile.*;
import DynamoToStruct_Compile.*;
import DynamoDbEncryptionBranchKeyIdSupplier_Compile.*;
import AwsCryptographyDbEncryptionSdkDynamoDbOperations_Compile.*;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.*;
import StructuredEncryptionUtil_Compile.*;
import Sets_Compile.*;
import StructuredEncryptionPaths_Compile.*;
import StructuredEncryptionHeader_Compile.*;
import StructuredEncryptionFooter_Compile.*;
import StructuredEncryptionCrypt_Compile.*;
import Maps_Compile.*;
import AwsCryptographyDbEncryptionSdkStructuredEncryptionOperations_Compile.*;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.*;
import TermLoc_Compile.*;
import DdbVirtualFields_Compile.*;
import BaseBeacon_Compile.*;
import CompoundBeacon_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class KeySource {
  public software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient _client;
  public software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient _store;
  public KeyLocation _keyLoc;
  public software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache _cache;
  public int _cacheTTL;
  public KeySource (software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient client, software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient store, KeyLocation keyLoc, software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache cache, int cacheTTL) {
    this._client = client;
    this._store = store;
    this._keyLoc = keyLoc;
    this._cache = cache;
    this._cacheTTL = cacheTTL;
  }

  @Override
  public boolean equals(Object other) {
    if (this == other) return true;
    if (other == null) return false;
    if (getClass() != other.getClass()) return false;
    KeySource o = (KeySource)other;
    return true && this._client == o._client && this._store == o._store && java.util.Objects.equals(this._keyLoc, o._keyLoc) && this._cache == o._cache && this._cacheTTL == o._cacheTTL;
  }
  @Override
  public int hashCode() {
    long hash = 5381;
    hash = ((hash << 5) + hash) + 0;
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._client);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._store);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._keyLoc);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._cache);
    hash = ((hash << 5) + hash) + java.lang.Integer.hashCode(this._cacheTTL);
    return (int)hash;
  }

  @Override
  public String toString() {
    StringBuilder s = new StringBuilder();
    s.append("SearchableEncryptionInfo_Compile.KeySource.KeySource");
    s.append("(");
    s.append(dafny.Helpers.toString(this._client));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._store));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._keyLoc));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._cache));
    s.append(", ");
    s.append(this._cacheTTL);
    s.append(")");
    return s.toString();
  }

  private static final KeySource theDefault = SearchableEncryptionInfo_Compile.KeySource.create(null, null, KeyLocation.Default(), null, 0);
  public static KeySource Default() {
    return theDefault;
  }
  private static final dafny.TypeDescriptor<KeySource> _TYPE = dafny.TypeDescriptor.<KeySource>referenceWithInitializer(KeySource.class, () -> Default());
  public static dafny.TypeDescriptor<KeySource> _typeDescriptor() {
    return (dafny.TypeDescriptor<KeySource>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  public static KeySource create(software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient client, software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient store, KeyLocation keyLoc, software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache cache, int cacheTTL) {
    return new KeySource(client, store, keyLoc, cache, cacheTTL);
  }
  public static KeySource create_KeySource(software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient client, software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient store, KeyLocation keyLoc, software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache cache, int cacheTTL) {
    return create(client, store, keyLoc, cache, cacheTTL);
  }
  public boolean is_KeySource() { return true; }
  public software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient dtor_client() {
    return this._client;
  }
  public software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient dtor_store() {
    return this._store;
  }
  public KeyLocation dtor_keyLoc() {
    return this._keyLoc;
  }
  public software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache dtor_cache() {
    return this._cache;
  }
  public int dtor_cacheTTL() {
    return this._cacheTTL;
  }
  public Wrappers_Compile.Result<DynamoDbEncryptionUtil_Compile.MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getKeyMap(dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> stdNames, DynamoDbEncryptionUtil_Compile.MaybeKeyId keyId)
  {
    Wrappers_Compile.Result<DynamoDbEncryptionUtil_Compile.MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> output = Wrappers_Compile.Result.<DynamoDbEncryptionUtil_Compile.MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default(DynamoDbEncryptionUtil_Compile.MaybeKeyMap.Default());
    if(true) {
      if (((this).dtor_keyLoc()).is_SingleLoc()) {
        Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _993_valueOrError0 = Wrappers_Compile.Outcome.<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default();
        _993_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (keyId).is_DontUseKeyId(), DynamoDbEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("KeyID should not be supplied with a SingleKeyStore")));
        if ((_993_valueOrError0).IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
          output = (_993_valueOrError0).<DynamoDbEncryptionUtil_Compile.MaybeKeyMap>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DynamoDbEncryptionUtil_Compile.MaybeKeyMap._typeDescriptor());
          return output;
        }
        dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>> _994_theMap;
        Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _995_valueOrError1 = Wrappers_Compile.Result.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>,dafny.DafnySequence<? extends java.lang.Byte>> empty());
        Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out34;
        _out34 = (this).getKeysCache(stdNames, ((this).dtor_keyLoc()).dtor_keyId());
        _995_valueOrError1 = _out34;
        if ((_995_valueOrError1).IsFailure(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
          output = (_995_valueOrError1).<DynamoDbEncryptionUtil_Compile.MaybeKeyMap>PropagateFailure(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DynamoDbEncryptionUtil_Compile.MaybeKeyMap._typeDescriptor());
          return output;
        }
        _994_theMap = (_995_valueOrError1).Extract(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        output = Wrappers_Compile.Result.<DynamoDbEncryptionUtil_Compile.MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(DynamoDbEncryptionUtil_Compile.MaybeKeyMap.create_Keys(_994_theMap));
        return output;
      } else if (((this).dtor_keyLoc()).is_LiteralLoc()) {
        Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _996_valueOrError2 = Wrappers_Compile.Outcome.<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default();
        _996_valueOrError2 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (keyId).is_DontUseKeyId(), DynamoDbEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("KeyID should not be supplied with a LiteralKeyStore")));
        if ((_996_valueOrError2).IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
          output = (_996_valueOrError2).<DynamoDbEncryptionUtil_Compile.MaybeKeyMap>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DynamoDbEncryptionUtil_Compile.MaybeKeyMap._typeDescriptor());
          return output;
        }
        dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>> _997_theMap;
        Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _998_valueOrError3 = Wrappers_Compile.Result.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>,dafny.DafnySequence<? extends java.lang.Byte>> empty());
        Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out35;
        _out35 = (this).getKeysLiteral();
        _998_valueOrError3 = _out35;
        if ((_998_valueOrError3).IsFailure(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
          output = (_998_valueOrError3).<DynamoDbEncryptionUtil_Compile.MaybeKeyMap>PropagateFailure(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DynamoDbEncryptionUtil_Compile.MaybeKeyMap._typeDescriptor());
          return output;
        }
        _997_theMap = (_998_valueOrError3).Extract(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        output = Wrappers_Compile.Result.<DynamoDbEncryptionUtil_Compile.MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(DynamoDbEncryptionUtil_Compile.MaybeKeyMap.create_Keys(_997_theMap));
        return output;
      } else {
        DynamoDbEncryptionUtil_Compile.MaybeKeyId _source13 = keyId;
        if (_source13.is_DontUseKeyId()) {
          output = Wrappers_Compile.Result.<DynamoDbEncryptionUtil_Compile.MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Failure(DynamoDbEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("KeyID must not be supplied with a MultiKeyStore")));
          return output;
        } else if (_source13.is_ShouldHaveKeyId()) {
          output = Wrappers_Compile.Result.<DynamoDbEncryptionUtil_Compile.MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(DynamoDbEncryptionUtil_Compile.MaybeKeyMap.create_ShouldHaveKeys());
          return output;
        } else {
          dafny.DafnySequence<? extends Character> _999___mcc_h0 = ((DynamoDbEncryptionUtil_Compile.MaybeKeyId_KeyId)_source13)._value;
          dafny.DafnySequence<? extends Character> _1000_id = _999___mcc_h0;
          dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>> _1001_theMap;
          Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1002_valueOrError4 = Wrappers_Compile.Result.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>,dafny.DafnySequence<? extends java.lang.Byte>> empty());
          Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out36;
          _out36 = (this).getKeysCache(stdNames, _1000_id);
          _1002_valueOrError4 = _out36;
          if ((_1002_valueOrError4).IsFailure(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = (_1002_valueOrError4).<DynamoDbEncryptionUtil_Compile.MaybeKeyMap>PropagateFailure(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DynamoDbEncryptionUtil_Compile.MaybeKeyMap._typeDescriptor());
            return output;
          }
          _1001_theMap = (_1002_valueOrError4).Extract(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
          output = Wrappers_Compile.Result.<DynamoDbEncryptionUtil_Compile.MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(DynamoDbEncryptionUtil_Compile.MaybeKeyMap.create_Keys(_1001_theMap));
          return output;
        }
      }
    }
    return output;
  }
  public Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getKeysLiteral()
  {
    Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> output = Wrappers_Compile.Result.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>,dafny.DafnySequence<? extends java.lang.Byte>> empty());
    output = Wrappers_Compile.Result.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(((this).dtor_keyLoc()).dtor_keys());
    return output;
  }
  public Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getKeysCache(dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> stdNames, dafny.DafnySequence<? extends Character> keyId)
  {
    Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> output = Wrappers_Compile.Result.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>,dafny.DafnySequence<? extends java.lang.Byte>> empty());
    if(true) {
      Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, dafny.DafnySequence<? extends Character>> _1003_keyIdBytesR;
      _1003_keyIdBytesR = UTF8.__default.Encode(keyId);
      dafny.DafnySequence<? extends java.lang.Byte> _1004_keyIdBytes;
      Wrappers_Compile.Result<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1005_valueOrError0 = Wrappers_Compile.Result.<dafny.DafnySequence<? extends java.lang.Byte>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default(UTF8.ValidUTF8Bytes.defaultValue());
      _1005_valueOrError0 = (_1003_keyIdBytesR).<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>MapFailure(UTF8.ValidUTF8Bytes._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>)(_1006_e_boxed0) -> {
        dafny.DafnySequence<? extends Character> _1006_e = ((dafny.DafnySequence<? extends Character>)(java.lang.Object)(_1006_e_boxed0));
        return DynamoDbEncryptionUtil_Compile.__default.E(_1006_e);
      }));
      if ((_1005_valueOrError0).IsFailure(UTF8.ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
        output = (_1005_valueOrError0).<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>>PropagateFailure(UTF8.ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())));
        return output;
      }
      _1004_keyIdBytes = (_1005_valueOrError0).Extract(UTF8.ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
      software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput _1007_getCacheInput;
      _1007_getCacheInput = software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput.create(_1004_keyIdBytes, Wrappers_Compile.Option.<java.lang.Long>create_None());
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1008_getCacheOutput;
      Wrappers_Compile.Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out37;
      _out37 = ((this).dtor_cache()).GetCacheEntry(_1007_getCacheInput);
      _1008_getCacheOutput = _out37;
      if ((_1008_getCacheOutput).is_Failure()) {
        Wrappers_Compile.Result<software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _1009_maybeRawBeaconKeyMaterials;
        Wrappers_Compile.Result<software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _out38;
        _out38 = ((this).dtor_store()).GetBeaconKey(software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyInput.create(keyId));
        _1009_maybeRawBeaconKeyMaterials = _out38;
        software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyOutput _1010_rawBeaconKeyMaterials;
        Wrappers_Compile.Result<software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyOutput, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1011_valueOrError1 = Wrappers_Compile.Result.<software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyOutput, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default(software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyOutput.Default());
        _1011_valueOrError1 = (_1009_maybeRawBeaconKeyMaterials).<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>MapFailure(software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyOutput._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.keystore.internaldafny.types.Error, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>)(_1012_e_boxed0) -> {
          software.amazon.cryptography.keystore.internaldafny.types.Error _1012_e = ((software.amazon.cryptography.keystore.internaldafny.types.Error)(java.lang.Object)(_1012_e_boxed0));
          return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error.create_AwsCryptographyKeyStore(_1012_e);
        }));
        if ((_1011_valueOrError1).IsFailure(software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyOutput._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
          output = (_1011_valueOrError1).<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>>PropagateFailure(software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyOutput._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())));
          return output;
        }
        _1010_rawBeaconKeyMaterials = (_1011_valueOrError1).Extract(software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyOutput._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>> _1013_key;
        _1013_key = ((_1010_rawBeaconKeyMaterials).dtor_beaconKeyMaterials()).dtor_beaconKey();
        Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1014_valueOrError2 = Wrappers_Compile.Outcome.<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default();
        _1014_valueOrError2 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (_1013_key).is_Some(), DynamoDbEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("beacon key unexpectedly empty")));
        if ((_1014_valueOrError2).IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
          output = (_1014_valueOrError2).<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())));
          return output;
        }
        dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>> _1015_keyMap;
        Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1016_valueOrError3 = Wrappers_Compile.Result.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>,dafny.DafnySequence<? extends java.lang.Byte>> empty());
        Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out39;
        _out39 = (this).getAllKeys(stdNames, (_1013_key).dtor_value());
        _1016_valueOrError3 = _out39;
        if ((_1016_valueOrError3).IsFailure(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
          output = (_1016_valueOrError3).<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>>PropagateFailure(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())));
          return output;
        }
        _1015_keyMap = (_1016_valueOrError3).Extract(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>> _pat_let_tv2 = _1015_keyMap;
        software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials _1017_beaconKeyMaterials;
        _1017_beaconKeyMaterials = ((software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials)(java.lang.Object)(dafny.Helpers.<software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials, software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials>Let((_1010_rawBeaconKeyMaterials).dtor_beaconKeyMaterials(), boxed30 -> {
          software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials _pat_let16_0 = ((software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials)(java.lang.Object)(boxed30));
          return ((software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials)(java.lang.Object)(dafny.Helpers.<software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials, software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials>Let(_pat_let16_0, boxed31 -> {
            software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials _1018_dt__update__tmp_h0 = ((software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials)(java.lang.Object)(boxed31));
            return ((software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials)(java.lang.Object)(dafny.Helpers.<Wrappers_Compile.Option<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>>, software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials>Let(Wrappers_Compile.Option.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>>create_Some(_pat_let_tv2), boxed32 -> {
              Wrappers_Compile.Option<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>> _pat_let17_0 = ((Wrappers_Compile.Option<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>>)(java.lang.Object)(boxed32));
              return ((software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials)(java.lang.Object)(dafny.Helpers.<Wrappers_Compile.Option<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>>, software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials>Let(_pat_let17_0, boxed33 -> {
                Wrappers_Compile.Option<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>> _1019_dt__update_hhmacKeys_h0 = ((Wrappers_Compile.Option<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>>)(java.lang.Object)(boxed33));
                return ((software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials)(java.lang.Object)(dafny.Helpers.<Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials>Let(Wrappers_Compile.Option.<dafny.DafnySequence<? extends java.lang.Byte>>create_None(), boxed34 -> {
                  Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>> _pat_let18_0 = ((Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>>)(java.lang.Object)(boxed34));
                  return ((software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials)(java.lang.Object)(dafny.Helpers.<Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials>Let(_pat_let18_0, boxed35 -> {
                    Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>> _1020_dt__update_hbeaconKey_h0 = ((Wrappers_Compile.Option<dafny.DafnySequence<? extends java.lang.Byte>>)(java.lang.Object)(boxed35));
                    return software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials.create((_1018_dt__update__tmp_h0).dtor_beaconKeyIdentifier(), (_1018_dt__update__tmp_h0).dtor_encryptionContext(), _1020_dt__update_hbeaconKey_h0, _1019_dt__update_hhmacKeys_h0);
                  }
                  )));
                }
                )));
              }
              )));
            }
            )));
          }
          )));
        }
        )));
        long _1021_now;
        long _out40;
        _out40 = Time.__default.CurrentRelativeTime();
        _1021_now = _out40;
        software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput _1022_putCacheEntryInput;
        _1022_putCacheEntryInput = software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput.create(_1004_keyIdBytes, software.amazon.cryptography.materialproviders.internaldafny.types.Materials.create_BeaconKey(_1017_beaconKeyMaterials), _1021_now, (long)  ((_1021_now) + (java.lang.Integer.toUnsignedLong((this).dtor_cacheTTL()))), Wrappers_Compile.Option.<java.lang.Integer>create_None(), Wrappers_Compile.Option.<java.lang.Integer>create_None());
        Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1023___v0;
        Wrappers_Compile.Result<dafny.Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out41;
        _out41 = ((this).dtor_cache()).PutCacheEntry(_1022_putCacheEntryInput);
        _1023___v0 = _out41;
        output = Wrappers_Compile.Result.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(_1015_keyMap);
        return output;
      } else {
        Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1024_valueOrError4 = Wrappers_Compile.Outcome.<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default();
        _1024_valueOrError4 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ((((((_1008_getCacheOutput).dtor_value()).dtor_materials()).is_BeaconKey()) && ((((((_1008_getCacheOutput).dtor_value()).dtor_materials()).dtor_BeaconKey()).dtor_hmacKeys()).is_Some())) && ((((((_1008_getCacheOutput).dtor_value()).dtor_materials()).dtor_BeaconKey()).dtor_beaconKeyIdentifier()).equals(keyId))) && ((((((_1008_getCacheOutput).dtor_value()).dtor_materials()).dtor_BeaconKey()).dtor_hmacKeys()).is_Some()), DynamoDbEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Invalid Material Type.")));
        if ((_1024_valueOrError4).IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
          output = (_1024_valueOrError4).<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends java.lang.Byte>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<java.lang.Byte>_typeDescriptor(BoundedInts_Compile.uint8._typeDescriptor())));
          return output;
        }
        output = Wrappers_Compile.Result.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success((((((_1008_getCacheOutput).dtor_value()).dtor_materials()).dtor_BeaconKey()).dtor_hmacKeys()).dtor_value());
        return output;
      }
    }
    return output;
  }
  public Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getAllKeys(dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> stdNames, dafny.DafnySequence<? extends java.lang.Byte> key)
  {
    Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> output = Wrappers_Compile.Result.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>,dafny.DafnySequence<? extends java.lang.Byte>> empty());
    if(true) {
      Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out42;
      _out42 = __default.GetAllKeys((this).dtor_client(), stdNames, key);
      output = _out42;
    }
    return output;
  }
}
