// Class BeaconVersion
// Dafny class BeaconVersion compiled into Java
package SearchableEncryptionInfo_Compile;

import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.*;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.*;
import DynamoDbEncryptionUtil_Compile.*;
import DynamoDbNormalizeNumber_Compile.*;
import DynamoToStruct_Compile.*;
import DynamoDbEncryptionBranchKeyIdSupplier_Compile.*;
import AwsCryptographyDbEncryptionSdkDynamoDbOperations_Compile.*;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.*;
import StructuredEncryptionUtil_Compile.*;
import Sets_Compile.*;
import StructuredEncryptionPaths_Compile.*;
import StructuredEncryptionHeader_Compile.*;
import StructuredEncryptionFooter_Compile.*;
import StructuredEncryptionCrypt_Compile.*;
import Maps_Compile.*;
import AwsCryptographyDbEncryptionSdkStructuredEncryptionOperations_Compile.*;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.*;
import TermLoc_Compile.*;
import DdbVirtualFields_Compile.*;
import BaseBeacon_Compile.*;
import CompoundBeacon_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class BeaconVersion {
  public long _version;
  public KeySource _keySource;
  public dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends DdbVirtualFields_Compile.VirtField> _virtualFields;
  public dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends Beacon> _beacons;
  public dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> _beaconNames;
  public dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> _stdNames;
  public dafny.DafnySet<? extends dafny.DafnySequence<? extends Character>> _encryptedFields;
  public BeaconVersion (long version, KeySource keySource, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends DdbVirtualFields_Compile.VirtField> virtualFields, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends Beacon> beacons, dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> beaconNames, dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> stdNames, dafny.DafnySet<? extends dafny.DafnySequence<? extends Character>> encryptedFields) {
    this._version = version;
    this._keySource = keySource;
    this._virtualFields = virtualFields;
    this._beacons = beacons;
    this._beaconNames = beaconNames;
    this._stdNames = stdNames;
    this._encryptedFields = encryptedFields;
  }

  @Override
  public boolean equals(Object other) {
    if (this == other) return true;
    if (other == null) return false;
    if (getClass() != other.getClass()) return false;
    BeaconVersion o = (BeaconVersion)other;
    return true && this._version == o._version && java.util.Objects.equals(this._keySource, o._keySource) && java.util.Objects.equals(this._virtualFields, o._virtualFields) && java.util.Objects.equals(this._beacons, o._beacons) && java.util.Objects.equals(this._beaconNames, o._beaconNames) && java.util.Objects.equals(this._stdNames, o._stdNames) && java.util.Objects.equals(this._encryptedFields, o._encryptedFields);
  }
  @Override
  public int hashCode() {
    long hash = 5381;
    hash = ((hash << 5) + hash) + 0;
    hash = ((hash << 5) + hash) + java.lang.Long.hashCode(this._version);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._keySource);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._virtualFields);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._beacons);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._beaconNames);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._stdNames);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._encryptedFields);
    return (int)hash;
  }

  @Override
  public String toString() {
    StringBuilder s = new StringBuilder();
    s.append("SearchableEncryptionInfo_Compile.BeaconVersion.BeaconVersion");
    s.append("(");
    s.append(this._version);
    s.append(", ");
    s.append(dafny.Helpers.toString(this._keySource));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._virtualFields));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._beacons));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._beaconNames));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._stdNames));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._encryptedFields));
    s.append(")");
    return s.toString();
  }

  private static final BeaconVersion theDefault = SearchableEncryptionInfo_Compile.BeaconVersion.create(VersionNumber.Witness, KeySource.Default(), dafny.DafnyMap.<dafny.DafnySequence<? extends Character>,DdbVirtualFields_Compile.VirtField> empty(), dafny.DafnyMap.<dafny.DafnySequence<? extends Character>,Beacon> empty(), dafny.DafnySequence.<dafny.DafnySequence<? extends Character>> empty(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), dafny.DafnySequence.<dafny.DafnySequence<? extends Character>> empty(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), dafny.DafnySet.<dafny.DafnySequence<? extends Character>> empty());
  public static BeaconVersion Default() {
    return theDefault;
  }
  private static final dafny.TypeDescriptor<BeaconVersion> _TYPE = dafny.TypeDescriptor.<BeaconVersion>referenceWithInitializer(BeaconVersion.class, () -> Default());
  public static dafny.TypeDescriptor<BeaconVersion> _typeDescriptor() {
    return (dafny.TypeDescriptor<BeaconVersion>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  public static BeaconVersion create(long version, KeySource keySource, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends DdbVirtualFields_Compile.VirtField> virtualFields, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends Beacon> beacons, dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> beaconNames, dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> stdNames, dafny.DafnySet<? extends dafny.DafnySequence<? extends Character>> encryptedFields) {
    return new BeaconVersion(version, keySource, virtualFields, beacons, beaconNames, stdNames, encryptedFields);
  }
  public static BeaconVersion create_BeaconVersion(long version, KeySource keySource, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends DdbVirtualFields_Compile.VirtField> virtualFields, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends Beacon> beacons, dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> beaconNames, dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> stdNames, dafny.DafnySet<? extends dafny.DafnySequence<? extends Character>> encryptedFields) {
    return create(version, keySource, virtualFields, beacons, beaconNames, stdNames, encryptedFields);
  }
  public boolean is_BeaconVersion() { return true; }
  public long dtor_version() {
    return this._version;
  }
  public KeySource dtor_keySource() {
    return this._keySource;
  }
  public dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends DdbVirtualFields_Compile.VirtField> dtor_virtualFields() {
    return this._virtualFields;
  }
  public dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends Beacon> dtor_beacons() {
    return this._beacons;
  }
  public dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> dtor_beaconNames() {
    return this._beaconNames;
  }
  public dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> dtor_stdNames() {
    return this._stdNames;
  }
  public dafny.DafnySet<? extends dafny.DafnySequence<? extends Character>> dtor_encryptedFields() {
    return this._encryptedFields;
  }
  public boolean IsBeacon(dafny.DafnySequence<? extends Character> field) {
    return ((this).dtor_beacons()).<dafny.DafnySequence<? extends Character>>contains(field);
  }
  public boolean IsVirtualField(dafny.DafnySequence<? extends Character> field) {
    return ((this).dtor_virtualFields()).<dafny.DafnySequence<? extends Character>>contains(field);
  }
  public dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> GetFields(dafny.DafnySequence<? extends Character> field) {
    if ((this).IsBeacon(field)) {
      return dafny.DafnySequence.<dafny.DafnySequence<? extends Character>>concatenate((((Beacon)(java.lang.Object)(((this).dtor_beacons()).get(field)))).GetFields((this).dtor_virtualFields()), dafny.DafnySequence.of(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("aws_dbe_b_"), field)));
    } else {
      return dafny.DafnySequence.of(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), field);
    }
  }
  public Wrappers_Compile.Result<DynamoDbEncryptionUtil_Compile.MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getKeyMap(DynamoDbEncryptionUtil_Compile.MaybeKeyId keyId)
  {
    Wrappers_Compile.Result<DynamoDbEncryptionUtil_Compile.MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> output = Wrappers_Compile.Result.<DynamoDbEncryptionUtil_Compile.MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default(DynamoDbEncryptionUtil_Compile.MaybeKeyMap.Default());
    if(true) {
      Wrappers_Compile.Result<DynamoDbEncryptionUtil_Compile.MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out46;
      _out46 = ((this).dtor_keySource()).getKeyMap((this).dtor_stdNames(), keyId);
      output = _out46;
    }
    return output;
  }
  public dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> ListSignedBeacons() {
    return Seq_Compile.__default.<dafny.DafnySequence<? extends Character>>Filter(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), ((java.util.function.Function<dafny.DafnySequence<? extends Character>, Boolean>)(_1032_s_boxed0) -> {
      dafny.DafnySequence<? extends Character> _1032_s = ((dafny.DafnySequence<? extends Character>)(java.lang.Object)(_1032_s_boxed0));
      return __default.IsBeaconOfType(((Beacon)(java.lang.Object)(((this).dtor_beacons()).get(_1032_s))), SearchableEncryptionInfo_Compile.BeaconType.create_SignedBeacon());
    }), (this).dtor_beaconNames());
  }
  public Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> GeneratePlainBeacons(dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> item)
  {
    Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> output = Wrappers_Compile.Result.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>,software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> empty());
    if(true) {
      output = (this).GenerateBeacons2((this).dtor_beaconNames(), item, DynamoDbEncryptionUtil_Compile.MaybeKeyMap.create_DontUseKeys(), SearchableEncryptionInfo_Compile.BeaconType.create_AnyBeacon(), dafny.DafnyMap.fromElements());
    }
    return output;
  }
  public Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> GenerateSignedBeacons(dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> item)
  {
    Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> output = Wrappers_Compile.Result.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>,software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> empty());
    if(true) {
      output = (this).GenerateBeacons2((this).dtor_beaconNames(), item, DynamoDbEncryptionUtil_Compile.MaybeKeyMap.create_DontUseKeys(), SearchableEncryptionInfo_Compile.BeaconType.create_SignedBeacon(), dafny.DafnyMap.fromElements());
    }
    return output;
  }
  public Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> GenerateEncryptedBeacons(dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> item, DynamoDbEncryptionUtil_Compile.MaybeKeyId keyId)
  {
    Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> output = Wrappers_Compile.Result.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default(dafny.DafnyMap.<dafny.DafnySequence<? extends Character>,software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> empty());
    if(true) {
      DynamoDbEncryptionUtil_Compile.MaybeKeyMap _1033_hmacKeys;
      Wrappers_Compile.Result<DynamoDbEncryptionUtil_Compile.MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1034_valueOrError0 = Wrappers_Compile.Result.<DynamoDbEncryptionUtil_Compile.MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Default(DynamoDbEncryptionUtil_Compile.MaybeKeyMap.Default());
      Wrappers_Compile.Result<DynamoDbEncryptionUtil_Compile.MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out47;
      _out47 = (this).getKeyMap(keyId);
      _1034_valueOrError0 = _out47;
      if ((_1034_valueOrError0).IsFailure(DynamoDbEncryptionUtil_Compile.MaybeKeyMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
        output = (_1034_valueOrError0).<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>>PropagateFailure(DynamoDbEncryptionUtil_Compile.MaybeKeyMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>_typeDescriptor(software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeName._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue._typeDescriptor()));
        return output;
      }
      _1033_hmacKeys = (_1034_valueOrError0).Extract(DynamoDbEncryptionUtil_Compile.MaybeKeyMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
      output = (this).GenerateBeacons2((this).dtor_beaconNames(), item, _1033_hmacKeys, SearchableEncryptionInfo_Compile.BeaconType.create_EncryptedBeacon(), dafny.DafnyMap.fromElements());
    }
    return output;
  }
  public Wrappers_Compile.Result<Wrappers_Compile.Option<software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> GenerateBeacon(dafny.DafnySequence<? extends Character> name, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> item, DynamoDbEncryptionUtil_Compile.MaybeKeyMap keys)
  {
    return (((Beacon)(java.lang.Object)(((this).dtor_beacons()).get(name)))).attrHash(item, (this).dtor_virtualFields(), keys);
  }
  public Wrappers_Compile.Result<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> GenerateBeacons2(dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> names, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> item, DynamoDbEncryptionUtil_Compile.MaybeKeyMap keys, BeaconType bType, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> acc)
  {
    BeaconVersion _this = this;
    TAIL_CALL_START: while (true) {
      if ((java.math.BigInteger.valueOf((names).length())).signum() == 0) {
        return Wrappers_Compile.Result.<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(acc);
      } else if (__default.IsBeaconOfType(((Beacon)(java.lang.Object)(((_this).dtor_beacons()).get(((dafny.DafnySequence<? extends Character>)(java.lang.Object)((names).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO)))))))), bType)) {
        Wrappers_Compile.Result<Wrappers_Compile.Option<software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1035_valueOrError0 = (_this).GenerateBeacon(((dafny.DafnySequence<? extends Character>)(java.lang.Object)((names).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))), item, keys);
        if ((_1035_valueOrError0).IsFailure(Wrappers_Compile.Option.<software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>_typeDescriptor(software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
          return (_1035_valueOrError0).<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>>PropagateFailure(Wrappers_Compile.Option.<software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>_typeDescriptor(software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>_typeDescriptor(software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeName._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue._typeDescriptor()));
        } else {
          Wrappers_Compile.Option<software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> _1036_value = (_1035_valueOrError0).Extract(Wrappers_Compile.Option.<software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>_typeDescriptor(software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
          if ((_1036_value).is_Some()) {
            BeaconVersion _in139 = _this;
            dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> _in140 = (names).drop(java.math.BigInteger.ONE);
            dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> _in141 = item;
            DynamoDbEncryptionUtil_Compile.MaybeKeyMap _in142 = keys;
            BeaconType _in143 = bType;
            dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> _in144 = dafny.DafnyMap.<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>update(acc, (((Beacon)(java.lang.Object)(((_this).dtor_beacons()).get(((dafny.DafnySequence<? extends Character>)(java.lang.Object)((names).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))))))).getBeaconName(), (_1036_value).dtor_value());
            _this = _in139;
            names = _in140;
            item = _in141;
            keys = _in142;
            bType = _in143;
            acc = _in144;
            continue TAIL_CALL_START;
          } else {
            BeaconVersion _in145 = _this;
            dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> _in146 = (names).drop(java.math.BigInteger.ONE);
            dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> _in147 = item;
            DynamoDbEncryptionUtil_Compile.MaybeKeyMap _in148 = keys;
            BeaconType _in149 = bType;
            dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> _in150 = acc;
            _this = _in145;
            names = _in146;
            item = _in147;
            keys = _in148;
            bType = _in149;
            acc = _in150;
            continue TAIL_CALL_START;
          }
        }
      } else {
        BeaconVersion _in151 = _this;
        dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> _in152 = (names).drop(java.math.BigInteger.ONE);
        dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> _in153 = item;
        DynamoDbEncryptionUtil_Compile.MaybeKeyMap _in154 = keys;
        BeaconType _in155 = bType;
        dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> _in156 = acc;
        _this = _in151;
        names = _in152;
        item = _in153;
        keys = _in154;
        bType = _in155;
        acc = _in156;
        continue TAIL_CALL_START;
      }
    }
  }
}
