// Class CompoundBeacon
// Dafny class CompoundBeacon compiled into Java
package CompoundBeacon_Compile;

import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.*;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.*;
import DynamoDbEncryptionUtil_Compile.*;
import DynamoDbNormalizeNumber_Compile.*;
import DynamoToStruct_Compile.*;
import DynamoDbEncryptionBranchKeyIdSupplier_Compile.*;
import AwsCryptographyDbEncryptionSdkDynamoDbOperations_Compile.*;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.*;
import StructuredEncryptionUtil_Compile.*;
import Sets_Compile.*;
import StructuredEncryptionPaths_Compile.*;
import StructuredEncryptionHeader_Compile.*;
import StructuredEncryptionFooter_Compile.*;
import StructuredEncryptionCrypt_Compile.*;
import Maps_Compile.*;
import AwsCryptographyDbEncryptionSdkStructuredEncryptionOperations_Compile.*;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.*;
import TermLoc_Compile.*;
import DdbVirtualFields_Compile.*;
import BaseBeacon_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class CompoundBeacon {
  public BaseBeacon_Compile.BeaconBase _base;
  public char _split;
  public dafny.DafnySequence<? extends BeaconPart> _parts;
  public java.math.BigInteger _numSigned;
  public dafny.DafnySequence<? extends Constructor> _construct;
  public CompoundBeacon (BaseBeacon_Compile.BeaconBase base, char split, dafny.DafnySequence<? extends BeaconPart> parts, java.math.BigInteger numSigned, dafny.DafnySequence<? extends Constructor> construct) {
    this._base = base;
    this._split = split;
    this._parts = parts;
    this._numSigned = numSigned;
    this._construct = construct;
  }

  @Override
  public boolean equals(Object other) {
    if (this == other) return true;
    if (other == null) return false;
    if (getClass() != other.getClass()) return false;
    CompoundBeacon o = (CompoundBeacon)other;
    return true && java.util.Objects.equals(this._base, o._base) && this._split == o._split && java.util.Objects.equals(this._parts, o._parts) && java.util.Objects.equals(this._numSigned, o._numSigned) && java.util.Objects.equals(this._construct, o._construct);
  }
  @Override
  public int hashCode() {
    long hash = 5381;
    hash = ((hash << 5) + hash) + 0;
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._base);
    hash = ((hash << 5) + hash) + Character.hashCode(this._split);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._parts);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._numSigned);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._construct);
    return (int)hash;
  }

  @Override
  public String toString() {
    StringBuilder s = new StringBuilder();
    s.append("CompoundBeacon_Compile.CompoundBeacon.CompoundBeacon");
    s.append("(");
    s.append(dafny.Helpers.toString(this._base));
    s.append(", ");
    s.append(this._split);
    s.append(", ");
    s.append(dafny.Helpers.toString(this._parts));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._numSigned));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._construct));
    s.append(")");
    return s.toString();
  }

  private static final CompoundBeacon theDefault = CompoundBeacon_Compile.CompoundBeacon.create(BaseBeacon_Compile.BeaconBase.Default(), 'D', dafny.DafnySequence.<BeaconPart> empty(BeaconPart._typeDescriptor()), java.math.BigInteger.ZERO, dafny.DafnySequence.<Constructor> empty(Constructor._typeDescriptor()));
  public static CompoundBeacon Default() {
    return theDefault;
  }
  private static final dafny.TypeDescriptor<CompoundBeacon> _TYPE = dafny.TypeDescriptor.<CompoundBeacon>referenceWithInitializer(CompoundBeacon.class, () -> Default());
  public static dafny.TypeDescriptor<CompoundBeacon> _typeDescriptor() {
    return (dafny.TypeDescriptor<CompoundBeacon>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  public static CompoundBeacon create(BaseBeacon_Compile.BeaconBase base, char split, dafny.DafnySequence<? extends BeaconPart> parts, java.math.BigInteger numSigned, dafny.DafnySequence<? extends Constructor> construct) {
    return new CompoundBeacon(base, split, parts, numSigned, construct);
  }
  public static CompoundBeacon create_CompoundBeacon(BaseBeacon_Compile.BeaconBase base, char split, dafny.DafnySequence<? extends BeaconPart> parts, java.math.BigInteger numSigned, dafny.DafnySequence<? extends Constructor> construct) {
    return create(base, split, parts, numSigned, construct);
  }
  public boolean is_CompoundBeacon() { return true; }
  public BaseBeacon_Compile.BeaconBase dtor_base() {
    return this._base;
  }
  public char dtor_split() {
    return this._split;
  }
  public dafny.DafnySequence<? extends BeaconPart> dtor_parts() {
    return this._parts;
  }
  public java.math.BigInteger dtor_numSigned() {
    return this._numSigned;
  }
  public dafny.DafnySequence<? extends Constructor> dtor_construct() {
    return this._construct;
  }
  public boolean isEncrypted() {
    return ((this).dtor_numSigned()).compareTo(java.math.BigInteger.valueOf(((this).dtor_parts()).length())) < 0;
  }
  public Wrappers_Compile.Result<BeaconPart, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getPartFromPrefix(dafny.DafnySequence<? extends Character> value) {
    return (this).partFromPrefix((this).dtor_parts(), value);
  }
  public Wrappers_Compile.Result<BeaconPart, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> partFromPrefix(dafny.DafnySequence<? extends BeaconPart> p, dafny.DafnySequence<? extends Character> value)
  {
    CompoundBeacon _this = this;
    TAIL_CALL_START: while (true) {
      if ((java.math.BigInteger.valueOf((p).length())).signum() == 0) {
        return Wrappers_Compile.Result.<BeaconPart, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Failure(DynamoDbEncryptionUtil_Compile.__default.E(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("Value "), value), dafny.DafnySequence.asString(" for beacon ")), ((_this).dtor_base()).dtor_name()), dafny.DafnySequence.asString(" does not match the prefix of any configured part."))));
      } else if (((((BeaconPart)(java.lang.Object)((p).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO)))))).dtor_prefix()).isPrefixOf(value)) {
        return Wrappers_Compile.Result.<BeaconPart, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(((BeaconPart)(java.lang.Object)((p).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))));
      } else {
        CompoundBeacon _in101 = _this;
        dafny.DafnySequence<? extends BeaconPart> _in102 = (p).drop(java.math.BigInteger.ONE);
        dafny.DafnySequence<? extends Character> _in103 = value;
        _this = _in101;
        p = _in102;
        value = _in103;
        continue TAIL_CALL_START;
      }
    }
  }
  public Wrappers_Compile.Result<dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> SkipSignedPieces(dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> pieces) {
    CompoundBeacon _this = this;
    TAIL_CALL_START: while (true) {
      if ((java.math.BigInteger.valueOf((pieces).length())).signum() == 0) {
        return Wrappers_Compile.Result.<dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(pieces);
      } else {
        Wrappers_Compile.Result<BeaconPart, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _926_valueOrError0 = (_this).partFromPrefix((_this).dtor_parts(), ((dafny.DafnySequence<? extends Character>)(java.lang.Object)((pieces).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))));
        if ((_926_valueOrError0).IsFailure(BeaconPart._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
          return (_926_valueOrError0).<dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>>PropagateFailure(BeaconPart._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.DafnySequence.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)));
        } else {
          BeaconPart _927_p = (_926_valueOrError0).Extract(BeaconPart._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
          if ((_927_p).is_Encrypted()) {
            return Wrappers_Compile.Result.<dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(pieces);
          } else {
            CompoundBeacon _in104 = _this;
            dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> _in105 = (pieces).drop(java.math.BigInteger.ONE);
            _this = _in104;
            pieces = _in105;
            continue TAIL_CALL_START;
          }
        }
      }
    }
  }
  public Wrappers_Compile.Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> IsLessThanComparable(dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> pieces) {
    Wrappers_Compile.Result<dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _928_valueOrError0 = (this).SkipSignedPieces(pieces);
    if ((_928_valueOrError0).IsFailure(dafny.DafnySequence.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
      return (_928_valueOrError0).<Boolean>PropagateFailure(dafny.DafnySequence.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.TypeDescriptor.BOOLEAN);
    } else {
      dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> _929_rest = (_928_valueOrError0).Extract(dafny.DafnySequence.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
      if ((java.math.BigInteger.valueOf((_929_rest).length())).signum() == 0) {
        return Wrappers_Compile.Result.<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(true);
      } else if (!java.util.Objects.equals(java.math.BigInteger.valueOf((_929_rest).length()), java.math.BigInteger.ONE)) {
        return Wrappers_Compile.Result.<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(false);
      } else {
        Wrappers_Compile.Result<BeaconPart, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _930_valueOrError1 = (this).partFromPrefix((this).dtor_parts(), ((dafny.DafnySequence<? extends Character>)(java.lang.Object)((_929_rest).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))));
        if ((_930_valueOrError1).IsFailure(BeaconPart._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
          return (_930_valueOrError1).<Boolean>PropagateFailure(BeaconPart._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.TypeDescriptor.BOOLEAN);
        } else {
          BeaconPart _931_p = (_930_valueOrError1).Extract(BeaconPart._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
          return Wrappers_Compile.Result.<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(((_931_p).dtor_prefix()).equals(((dafny.DafnySequence<? extends Character>)(java.lang.Object)((_929_rest).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO)))))));
        }
      }
    }
  }
  public dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> GetFields(dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends DdbVirtualFields_Compile.VirtField> virtualFields) {
    return Seq_Compile.__default.<dafny.DafnySequence<? extends Character>>Flatten(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), Seq_Compile.__default.<BeaconPart, dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>>Map(BeaconPart._typeDescriptor(), dafny.DafnySequence.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), ((java.util.function.Function<dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends DdbVirtualFields_Compile.VirtField>, java.util.function.Function<BeaconPart, dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>>>)(_932_virtualFields) -> ((java.util.function.Function<BeaconPart, dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>>)(_933_p_boxed0) -> {
      BeaconPart _933_p = ((BeaconPart)(java.lang.Object)(_933_p_boxed0));
      return (_933_p).GetFields(_932_virtualFields);
    })).apply(virtualFields), (this).dtor_parts()));
  }
  public Wrappers_Compile.Result<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> FindAndCalcPart(dafny.DafnySequence<? extends Character> value, DynamoDbEncryptionUtil_Compile.MaybeKeyMap keys)
  {
    Wrappers_Compile.Result<BeaconPart, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _934_valueOrError0 = (this).partFromPrefix((this).dtor_parts(), value);
    if ((_934_valueOrError0).IsFailure(BeaconPart._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
      return (_934_valueOrError0).<dafny.DafnySequence<? extends Character>>PropagateFailure(BeaconPart._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR));
    } else {
      BeaconPart _935_part = (_934_valueOrError0).Extract(BeaconPart._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
      return (this).PartValueCalc((value).drop(java.math.BigInteger.valueOf(((_935_part).dtor_prefix()).length())), keys, _935_part);
    }
  }
  public Wrappers_Compile.Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> justPrefix(dafny.DafnySequence<? extends Character> value) {
    Wrappers_Compile.Result<BeaconPart, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _936_valueOrError0 = (this).partFromPrefix((this).dtor_parts(), value);
    if ((_936_valueOrError0).IsFailure(BeaconPart._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
      return (_936_valueOrError0).<Boolean>PropagateFailure(BeaconPart._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.TypeDescriptor.BOOLEAN);
    } else {
      BeaconPart _937_part = (_936_valueOrError0).Extract(BeaconPart._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
      return Wrappers_Compile.Result.<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success((value).equals((_937_part).dtor_prefix()));
    }
  }
  public Wrappers_Compile.Result<software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> GetBeaconValue(software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue value, DynamoDbEncryptionUtil_Compile.MaybeKeyMap keys, boolean forEquality)
  {
    if (!((value).is_S())) {
      return Wrappers_Compile.Result.<software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Failure(DynamoDbEncryptionUtil_Compile.__default.E(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("CompoundBeacon "), ((this).dtor_base()).dtor_name()), dafny.DafnySequence.asString(" can only be queried as a string, not as ")), DynamoDbEncryptionUtil_Compile.__default.AttrTypeToStr(value))));
    } else {
      dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> _938_parts = StandardLibrary_Compile.__default.<Character>Split(dafny.TypeDescriptor.CHAR, (value).dtor_S(), (this).dtor_split());
      Wrappers_Compile.Result<dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _939_valueOrError0 = Seq_Compile.__default.<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends Character>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>MapWithResult(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<DynamoDbEncryptionUtil_Compile.MaybeKeyMap, java.util.function.Function<dafny.DafnySequence<? extends Character>, Wrappers_Compile.Result<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>>>)(_940_keys) -> ((java.util.function.Function<dafny.DafnySequence<? extends Character>, Wrappers_Compile.Result<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>>)(_941_s_boxed0) -> {
        dafny.DafnySequence<? extends Character> _941_s = ((dafny.DafnySequence<? extends Character>)(java.lang.Object)(_941_s_boxed0));
        return (this).FindAndCalcPart(_941_s, _940_keys);
      })).apply(keys), _938_parts);
      if ((_939_valueOrError0).IsFailure(dafny.DafnySequence.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
        return (_939_valueOrError0).<software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>PropagateFailure(dafny.DafnySequence.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue._typeDescriptor());
      } else {
        dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> _942_beaconParts = (_939_valueOrError0).Extract(dafny.DafnySequence.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        Wrappers_Compile.Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _943_valueOrError1 = (this).justPrefix(Seq_Compile.__default.<dafny.DafnySequence<? extends Character>>Last(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), _938_parts));
        if ((_943_valueOrError1).IsFailure(dafny.TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
          return (_943_valueOrError1).<software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue>PropagateFailure(dafny.TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue._typeDescriptor());
        } else {
          boolean _944_lastIsPrefix = (_943_valueOrError1).Extract(dafny.TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
          if ((!(forEquality)) && (_944_lastIsPrefix)) {
            dafny.DafnySequence<? extends Character> _945_result = StandardLibrary_Compile.__default.<Character>Join(dafny.TypeDescriptor.CHAR, dafny.DafnySequence.<dafny.DafnySequence<? extends Character>>concatenate((_942_beaconParts).take((java.math.BigInteger.valueOf((_938_parts).length())).subtract(java.math.BigInteger.ONE)), dafny.DafnySequence.of(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), Seq_Compile.__default.<dafny.DafnySequence<? extends Character>>Last(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), _938_parts))), dafny.DafnySequence.of((this).dtor_split()));
            return Wrappers_Compile.Result.<software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue.create_S(_945_result));
          } else {
            dafny.DafnySequence<? extends Character> _946_result = StandardLibrary_Compile.__default.<Character>Join(dafny.TypeDescriptor.CHAR, _942_beaconParts, dafny.DafnySequence.of((this).dtor_split()));
            return Wrappers_Compile.Result.<software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue.create_S(_946_result));
          }
        }
      }
    }
  }
  public Wrappers_Compile.Result<Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> TryConstructor(dafny.DafnySequence<? extends ConstructorPart> consFields, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> item, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends DdbVirtualFields_Compile.VirtField> vf, DynamoDbEncryptionUtil_Compile.MaybeKeyMap keys, dafny.DafnySequence<? extends Character> acc)
  {
    CompoundBeacon _this = this;
    TAIL_CALL_START: while (true) {
      if ((java.math.BigInteger.valueOf((consFields).length())).signum() == 0) {
        if ((java.math.BigInteger.valueOf((acc).length())).signum() == 0) {
          return Wrappers_Compile.Result.<Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Failure(DynamoDbEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Internal Error : Empty beacon created.")));
        } else {
          return Wrappers_Compile.Result.<Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>create_Some(acc));
        }
      } else {
        BeaconPart _947_part = (((ConstructorPart)(java.lang.Object)((consFields).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO)))))).dtor_part();
        Wrappers_Compile.Result<Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _948_valueOrError0 = (_947_part).getString(item, vf);
        if ((_948_valueOrError0).IsFailure(Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
          return (_948_valueOrError0).<Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>>>PropagateFailure(Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)));
        } else {
          Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>> _949_strValue = (_948_valueOrError0).Extract(Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
          if ((_949_strValue).is_Some()) {
            Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _950_valueOrError1 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), !((_949_strValue).dtor_value()).contains((_this).dtor_split()), DynamoDbEncryptionUtil_Compile.__default.E(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("Part "), (_947_part).getName()), dafny.DafnySequence.asString(" for beacon ")), ((_this).dtor_base()).dtor_name()), dafny.DafnySequence.asString(" has value '")), (_949_strValue).dtor_value()), dafny.DafnySequence.asString("' which contains the split character ")), dafny.DafnySequence.of((_this).dtor_split())), dafny.DafnySequence.asString("'."))));
            if ((_950_valueOrError1).IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
              return (_950_valueOrError1).<Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)));
            } else {
              Wrappers_Compile.Result<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _951_valueOrError2 = (((keys).is_DontUseKeys()) ? (Wrappers_Compile.Result.<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(dafny.DafnySequence.<Character>concatenate((_947_part).dtor_prefix(), (_949_strValue).dtor_value()))) : ((_this).PartValueCalc((_949_strValue).dtor_value(), keys, _947_part)));
              if ((_951_valueOrError2).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                return (_951_valueOrError2).<Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>>>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)));
              } else {
                dafny.DafnySequence<? extends Character> _952_val = (_951_valueOrError2).Extract(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
                if ((java.math.BigInteger.valueOf((acc).length())).signum() == 0) {
                  CompoundBeacon _in106 = _this;
                  dafny.DafnySequence<? extends ConstructorPart> _in107 = (consFields).drop(java.math.BigInteger.ONE);
                  dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> _in108 = item;
                  dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends DdbVirtualFields_Compile.VirtField> _in109 = vf;
                  DynamoDbEncryptionUtil_Compile.MaybeKeyMap _in110 = keys;
                  dafny.DafnySequence<? extends Character> _in111 = _952_val;
                  _this = _in106;
                  consFields = _in107;
                  item = _in108;
                  vf = _in109;
                  keys = _in110;
                  acc = _in111;
                  continue TAIL_CALL_START;
                } else {
                  CompoundBeacon _in112 = _this;
                  dafny.DafnySequence<? extends ConstructorPart> _in113 = (consFields).drop(java.math.BigInteger.ONE);
                  dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> _in114 = item;
                  dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends DdbVirtualFields_Compile.VirtField> _in115 = vf;
                  DynamoDbEncryptionUtil_Compile.MaybeKeyMap _in116 = keys;
                  dafny.DafnySequence<? extends Character> _in117 = dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(acc, dafny.DafnySequence.of((_this).dtor_split())), _952_val);
                  _this = _in112;
                  consFields = _in113;
                  item = _in114;
                  vf = _in115;
                  keys = _in116;
                  acc = _in117;
                  continue TAIL_CALL_START;
                }
              }
            }
          } else if ((((ConstructorPart)(java.lang.Object)((consFields).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO)))))).dtor_required()) {
            return Wrappers_Compile.Result.<Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>create_None());
          } else {
            CompoundBeacon _in118 = _this;
            dafny.DafnySequence<? extends ConstructorPart> _in119 = (consFields).drop(java.math.BigInteger.ONE);
            dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> _in120 = item;
            dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends DdbVirtualFields_Compile.VirtField> _in121 = vf;
            DynamoDbEncryptionUtil_Compile.MaybeKeyMap _in122 = keys;
            dafny.DafnySequence<? extends Character> _in123 = acc;
            _this = _in118;
            consFields = _in119;
            item = _in120;
            vf = _in121;
            keys = _in122;
            acc = _in123;
            continue TAIL_CALL_START;
          }
        }
      }
    }
  }
  public Wrappers_Compile.Result<Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> TryConstructors(dafny.DafnySequence<? extends Constructor> construct, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> item, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends DdbVirtualFields_Compile.VirtField> vf, DynamoDbEncryptionUtil_Compile.MaybeKeyMap keys)
  {
    CompoundBeacon _this = this;
    TAIL_CALL_START: while (true) {
      if ((java.math.BigInteger.valueOf((construct).length())).signum() == 0) {
        return Wrappers_Compile.Result.<Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>create_None());
      } else {
        Wrappers_Compile.Result<Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _953_valueOrError0 = (_this).TryConstructor((((Constructor)(java.lang.Object)((construct).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO)))))).dtor_parts(), item, vf, keys, dafny.DafnySequence.asString(""));
        if ((_953_valueOrError0).IsFailure(Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
          return (_953_valueOrError0).<Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>>>PropagateFailure(Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)));
        } else {
          Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>> _954_x = (_953_valueOrError0).Extract(Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>_typeDescriptor(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR)), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
          if ((_954_x).is_Some()) {
            return Wrappers_Compile.Result.<Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(_954_x);
          } else {
            CompoundBeacon _in124 = _this;
            dafny.DafnySequence<? extends Constructor> _in125 = (construct).drop(java.math.BigInteger.ONE);
            dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> _in126 = item;
            dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends DdbVirtualFields_Compile.VirtField> _in127 = vf;
            DynamoDbEncryptionUtil_Compile.MaybeKeyMap _in128 = keys;
            _this = _in124;
            construct = _in125;
            item = _in126;
            vf = _in127;
            keys = _in128;
            continue TAIL_CALL_START;
          }
        }
      }
    }
  }
  public Wrappers_Compile.Result<Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> hash(dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> item, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends DdbVirtualFields_Compile.VirtField> vf, DynamoDbEncryptionUtil_Compile.MaybeKeyMap keys)
  {
    return (this).TryConstructors((this).dtor_construct(), item, vf, keys);
  }
  public Wrappers_Compile.Result<Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getNaked(dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> item, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends DdbVirtualFields_Compile.VirtField> vf)
  {
    return (this).TryConstructors((this).dtor_construct(), item, vf, DynamoDbEncryptionUtil_Compile.MaybeKeyMap.create_DontUseKeys());
  }
  public Wrappers_Compile.Result<BeaconPart, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> findPart(dafny.DafnySequence<? extends Character> val) {
    dafny.DafnySequence<? extends BeaconPart> _955_thePart = Seq_Compile.__default.<BeaconPart>Filter(BeaconPart._typeDescriptor(), ((java.util.function.Function<dafny.DafnySequence<? extends Character>, java.util.function.Function<BeaconPart, Boolean>>)(_956_val) -> ((java.util.function.Function<BeaconPart, Boolean>)(_957_x_boxed0) -> {
      BeaconPart _957_x = ((BeaconPart)(java.lang.Object)(_957_x_boxed0));
      return ((_957_x).dtor_prefix()).isPrefixOf(_956_val);
    })).apply(val), (this).dtor_parts());
    if ((java.math.BigInteger.valueOf((_955_thePart).length())).signum() == 0) {
      return Wrappers_Compile.Result.<BeaconPart, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Failure(DynamoDbEncryptionUtil_Compile.__default.E(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("No part found in beacon "), ((this).dtor_base()).dtor_name()), dafny.DafnySequence.asString(" match prefix ")), val)));
    } else if ((java.math.BigInteger.valueOf((_955_thePart).length())).compareTo(java.math.BigInteger.ONE) > 0) {
      return Wrappers_Compile.Result.<BeaconPart, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Failure(DynamoDbEncryptionUtil_Compile.__default.E(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("Internal error. Multiple parts for beacon "), ((this).dtor_base()).dtor_name()), dafny.DafnySequence.asString(" matched prefix of ")), val)));
    } else {
      return Wrappers_Compile.Result.<BeaconPart, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(((BeaconPart)(java.lang.Object)((_955_thePart).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))));
    }
  }
  public Wrappers_Compile.Result<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getPart(dafny.DafnySequence<? extends Character> val, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>> keys)
  {
    dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> _958_pieces = StandardLibrary_Compile.__default.<Character>Split(dafny.TypeDescriptor.CHAR, val, (this).dtor_split());
    return (this).calcParts(_958_pieces, keys, dafny.DafnySequence.<Character> empty(dafny.TypeDescriptor.CHAR));
  }
  public Wrappers_Compile.Result<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> calcPart(dafny.DafnySequence<? extends Character> piece, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>> keys)
  {
    Wrappers_Compile.Result<BeaconPart, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _959_valueOrError0 = (this).findPart(piece);
    if ((_959_valueOrError0).IsFailure(BeaconPart._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
      return (_959_valueOrError0).<dafny.DafnySequence<? extends Character>>PropagateFailure(BeaconPart._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR));
    } else {
      BeaconPart _960_thePart = (_959_valueOrError0).Extract(BeaconPart._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
      return (this).PartValueCalc(piece, DynamoDbEncryptionUtil_Compile.MaybeKeyMap.create_Keys(keys), _960_thePart);
    }
  }
  public Wrappers_Compile.Result<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> calcParts(dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> pieces, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>> keys, dafny.DafnySequence<? extends Character> acc)
  {
    CompoundBeacon _this = this;
    TAIL_CALL_START: while (true) {
      if ((java.math.BigInteger.valueOf((pieces).length())).signum() == 0) {
        return Wrappers_Compile.Result.<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(acc);
      } else {
        Wrappers_Compile.Result<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _961_valueOrError0 = (_this).calcPart(((dafny.DafnySequence<? extends Character>)(java.lang.Object)((pieces).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))), keys);
        if ((_961_valueOrError0).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
          return (_961_valueOrError0).<dafny.DafnySequence<? extends Character>>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR));
        } else {
          dafny.DafnySequence<? extends Character> _962_theBeacon = (_961_valueOrError0).Extract(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
          if ((java.math.BigInteger.valueOf((acc).length())).signum() == 0) {
            CompoundBeacon _in129 = _this;
            dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> _in130 = (pieces).drop(java.math.BigInteger.ONE);
            dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>> _in131 = keys;
            dafny.DafnySequence<? extends Character> _in132 = _962_theBeacon;
            _this = _in129;
            pieces = _in130;
            keys = _in131;
            acc = _in132;
            continue TAIL_CALL_START;
          } else {
            CompoundBeacon _in133 = _this;
            dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> _in134 = (pieces).drop(java.math.BigInteger.ONE);
            dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends dafny.DafnySequence<? extends java.lang.Byte>> _in135 = keys;
            dafny.DafnySequence<? extends Character> _in136 = dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(acc, dafny.DafnySequence.of((_this).dtor_split())), _962_theBeacon);
            _this = _in133;
            pieces = _in134;
            keys = _in135;
            acc = _in136;
            continue TAIL_CALL_START;
          }
        }
      }
    }
  }
  public static boolean OkPrefixStringPair(dafny.DafnySequence<? extends Character> x, dafny.DafnySequence<? extends Character> y)
  {
    return (!((x).isPrefixOf(y))) && (!((y).isPrefixOf(x)));
  }
  public boolean OkPrefixPair(java.math.BigInteger pos1, java.math.BigInteger pos2)
  {
    return (java.util.Objects.equals(pos1, pos2)) || (CompoundBeacon.OkPrefixStringPair((((BeaconPart)(java.lang.Object)(((this).dtor_parts()).select(dafny.Helpers.toInt((pos1)))))).dtor_prefix(), (((BeaconPart)(java.lang.Object)(((this).dtor_parts()).select(dafny.Helpers.toInt((pos2)))))).dtor_prefix()));
  }
  public Wrappers_Compile.Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> CheckOnePrefixPart(java.math.BigInteger pos1, java.math.BigInteger pos2)
  {
    if (!((this).OkPrefixPair(pos1, pos2))) {
      return Wrappers_Compile.Result.<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Failure(DynamoDbEncryptionUtil_Compile.__default.E(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("Compound beacon "), ((this).dtor_base()).dtor_name()), dafny.DafnySequence.asString(" defines part ")), (((BeaconPart)(java.lang.Object)(((this).dtor_parts()).select(dafny.Helpers.toInt((pos1)))))).getName()), dafny.DafnySequence.asString(" with prefix ")), (((BeaconPart)(java.lang.Object)(((this).dtor_parts()).select(dafny.Helpers.toInt((pos1)))))).dtor_prefix()), dafny.DafnySequence.asString(" which is incompatible with part ")), (((BeaconPart)(java.lang.Object)(((this).dtor_parts()).select(dafny.Helpers.toInt((pos2)))))).getName()), dafny.DafnySequence.asString(" which has a prefix of ")), (((BeaconPart)(java.lang.Object)(((this).dtor_parts()).select(dafny.Helpers.toInt((pos2)))))).dtor_prefix()), dafny.DafnySequence.asString("."))));
    } else {
      return Wrappers_Compile.Result.<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(true);
    }
  }
  public Wrappers_Compile.Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> CheckOnePrefix(java.math.BigInteger pos) {
    dafny.DafnySequence<? extends java.math.BigInteger> _963_partNumbers = dafny.DafnySequence.Create(dafny.TypeDescriptor.BIG_INTEGER, java.math.BigInteger.valueOf(((this).dtor_parts()).length()), ((java.util.function.Function<java.math.BigInteger, java.math.BigInteger>)(_964_i_boxed0) -> {
      java.math.BigInteger _964_i = ((java.math.BigInteger)(java.lang.Object)(_964_i_boxed0));
      return _964_i;
    }));
    Wrappers_Compile.Result<dafny.DafnySequence<? extends Boolean>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _965_valueOrError0 = Seq_Compile.__default.<java.math.BigInteger, Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>MapWithResult(dafny.TypeDescriptor.BIG_INTEGER, dafny.TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<java.math.BigInteger, java.util.function.Function<java.math.BigInteger, Wrappers_Compile.Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>>>)(_966_pos) -> ((java.util.function.Function<java.math.BigInteger, Wrappers_Compile.Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>>)(_967_p_boxed0) -> {
      java.math.BigInteger _967_p = ((java.math.BigInteger)(java.lang.Object)(_967_p_boxed0));
      return (this).CheckOnePrefixPart(_966_pos, _967_p);
    })).apply(pos), dafny.DafnySequence.Create(dafny.TypeDescriptor.BIG_INTEGER, java.math.BigInteger.valueOf(((this).dtor_parts()).length()), ((java.util.function.Function<java.math.BigInteger, java.math.BigInteger>)(_968_i_boxed0) -> {
      java.math.BigInteger _968_i = ((java.math.BigInteger)(java.lang.Object)(_968_i_boxed0));
      return _968_i;
    })));
    if ((_965_valueOrError0).IsFailure(dafny.DafnySequence.<Boolean>_typeDescriptor(dafny.TypeDescriptor.BOOLEAN), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
      return (_965_valueOrError0).<Boolean>PropagateFailure(dafny.DafnySequence.<Boolean>_typeDescriptor(dafny.TypeDescriptor.BOOLEAN), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.TypeDescriptor.BOOLEAN);
    } else {
      dafny.DafnySequence<? extends Boolean> _969___v1 = (_965_valueOrError0).Extract(dafny.DafnySequence.<Boolean>_typeDescriptor(dafny.TypeDescriptor.BOOLEAN), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
      return Wrappers_Compile.Result.<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(true);
    }
  }
  public Wrappers_Compile.Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> ValidPrefixSetResultPos(java.math.BigInteger index) {
    CompoundBeacon _this = this;
    TAIL_CALL_START: while (true) {
      if ((java.math.BigInteger.valueOf(((_this).dtor_parts()).length())).compareTo(index) <= 0) {
        return Wrappers_Compile.Result.<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(true);
      } else {
        Wrappers_Compile.Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _970_valueOrError0 = (_this).CheckOnePrefix(index);
        if ((_970_valueOrError0).IsFailure(dafny.TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
          return (_970_valueOrError0).<Boolean>PropagateFailure(dafny.TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.TypeDescriptor.BOOLEAN);
        } else {
          boolean _971___v2 = (_970_valueOrError0).Extract(dafny.TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
          CompoundBeacon _in137 = _this;
          java.math.BigInteger _in138 = (index).add(java.math.BigInteger.ONE);
          _this = _in137;
          index = _in138;
          continue TAIL_CALL_START;
        }
      }
    }
  }
  public Wrappers_Compile.Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> ValidPrefixSetResult() {
    Wrappers_Compile.Result<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _972_valueOrError0 = (this).ValidPrefixSetResultPos(java.math.BigInteger.ZERO);
    if ((_972_valueOrError0).IsFailure(dafny.TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
      return (_972_valueOrError0).<Boolean>PropagateFailure(dafny.TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.TypeDescriptor.BOOLEAN);
    } else {
      boolean _973___v3 = (_972_valueOrError0).Extract(dafny.TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
      if (dafny.Helpers.Quantifier(dafny.Helpers.IntegerRange(java.math.BigInteger.ZERO, java.math.BigInteger.valueOf(((this).dtor_parts()).length())), true, ((_forall_var_12_boxed0) -> {
        java.math.BigInteger _forall_var_12 = ((java.math.BigInteger)(java.lang.Object)(_forall_var_12_boxed0));
        if (true) {
          java.math.BigInteger _974_x = (java.math.BigInteger)_forall_var_12;
          if ((_974_x).signum() != -1) {
            return dafny.Helpers.Quantifier(dafny.Helpers.IntegerRange(java.math.BigInteger.ZERO, java.math.BigInteger.valueOf(((this).dtor_parts()).length())), true, ((_forall_var_13_boxed0) -> {
              java.math.BigInteger _forall_var_13 = ((java.math.BigInteger)(java.lang.Object)(_forall_var_13_boxed0));
              if (true) {
                java.math.BigInteger _975_y = (java.math.BigInteger)_forall_var_13;
                if ((_975_y).signum() != -1) {
                  return !((((_974_x).signum() != -1) && ((_974_x).compareTo(java.math.BigInteger.valueOf(((this).dtor_parts()).length())) < 0)) && (((_974_x).compareTo(_975_y) < 0) && ((_975_y).compareTo(java.math.BigInteger.valueOf(((this).dtor_parts()).length())) < 0))) || ((this).OkPrefixPair(_974_x, _975_y));
                } else {
                  return true;
                }
              } else {
                return true;
              }
            }));
          } else {
            return true;
          }
        } else {
          return true;
        }
      }))) {
        return Wrappers_Compile.Result.<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(true);
      } else {
        return Wrappers_Compile.Result.<Boolean, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Failure(DynamoDbEncryptionUtil_Compile.__default.E(dafny.DafnySequence.asString("Internal Error")));
      }
    }
  }
  public Wrappers_Compile.Result<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> PartValueCalc(dafny.DafnySequence<? extends Character> data, DynamoDbEncryptionUtil_Compile.MaybeKeyMap keys, BeaconPart part)
  {
    Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _976_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), !(data).contains((this).dtor_split()), DynamoDbEncryptionUtil_Compile.__default.E(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("Value '"), data), dafny.DafnySequence.asString("' for beacon part ")), (part).getName()), dafny.DafnySequence.asString(" contains the split character '")), dafny.DafnySequence.of((this).dtor_split())), dafny.DafnySequence.asString("'."))));
    if ((_976_valueOrError0).IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
      return (_976_valueOrError0).<dafny.DafnySequence<? extends Character>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR));
    } else {
      BeaconPart _source12 = part;
      if (_source12.is_Encrypted()) {
        dafny.DafnySequence<? extends Character> _977___mcc_h0 = ((CompoundBeacon_Compile.BeaconPart_Encrypted)_source12)._prefix;
        BaseBeacon_Compile.StandardBeacon _978___mcc_h1 = ((CompoundBeacon_Compile.BeaconPart_Encrypted)_source12)._beacon;
        BaseBeacon_Compile.StandardBeacon _979_b = _978___mcc_h1;
        dafny.DafnySequence<? extends Character> _980_p = _977___mcc_h0;
        Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _981_valueOrError1 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (keys).is_Keys(), DynamoDbEncryptionUtil_Compile.__default.E(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.asString("Need KeyId for beacon "), ((_979_b).dtor_base()).dtor_name()), dafny.DafnySequence.asString(" but no KeyId found in query."))));
        if ((_981_valueOrError1).IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
          return (_981_valueOrError1).<dafny.DafnySequence<? extends Character>>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR));
        } else {
          Wrappers_Compile.Result<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _982_valueOrError2 = (_979_b).hashStr(data, (keys).dtor_value());
          if ((_982_valueOrError2).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            return (_982_valueOrError2).<dafny.DafnySequence<? extends Character>>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR));
          } else {
            dafny.DafnySequence<? extends Character> _983_hash = (_982_valueOrError2).Extract(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            return Wrappers_Compile.Result.<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(dafny.DafnySequence.<Character>concatenate((part).dtor_prefix(), _983_hash));
          }
        }
      } else {
        dafny.DafnySequence<? extends Character> _984___mcc_h4 = ((CompoundBeacon_Compile.BeaconPart_Signed)_source12)._prefix;
        dafny.DafnySequence<? extends Character> _985___mcc_h5 = ((CompoundBeacon_Compile.BeaconPart_Signed)_source12)._name;
        dafny.DafnySequence<? extends TermLoc_Compile.Selector> _986___mcc_h6 = ((CompoundBeacon_Compile.BeaconPart_Signed)_source12)._loc;
        BeaconPart _987_Signed = part;
        return Wrappers_Compile.Result.<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(dafny.DafnySequence.<Character>concatenate((part).dtor_prefix(), data));
      }
    }
  }
}
