// Class BeaconPart
// Dafny class BeaconPart compiled into Java
package CompoundBeacon_Compile;

import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.*;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.*;
import DynamoDbEncryptionUtil_Compile.*;
import DynamoDbNormalizeNumber_Compile.*;
import DynamoToStruct_Compile.*;
import DynamoDbEncryptionBranchKeyIdSupplier_Compile.*;
import AwsCryptographyDbEncryptionSdkDynamoDbOperations_Compile.*;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.*;
import StructuredEncryptionUtil_Compile.*;
import Sets_Compile.*;
import StructuredEncryptionPaths_Compile.*;
import StructuredEncryptionHeader_Compile.*;
import StructuredEncryptionFooter_Compile.*;
import StructuredEncryptionCrypt_Compile.*;
import Maps_Compile.*;
import AwsCryptographyDbEncryptionSdkStructuredEncryptionOperations_Compile.*;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.*;
import TermLoc_Compile.*;
import DdbVirtualFields_Compile.*;
import BaseBeacon_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public abstract class BeaconPart {
  public BeaconPart() { }

  private static final BeaconPart theDefault = CompoundBeacon_Compile.BeaconPart.create_Encrypted(dafny.DafnySequence.<Character> empty(dafny.TypeDescriptor.CHAR), BaseBeacon_Compile.StandardBeacon.Default());
  public static BeaconPart Default() {
    return theDefault;
  }
  private static final dafny.TypeDescriptor<BeaconPart> _TYPE = dafny.TypeDescriptor.<BeaconPart>referenceWithInitializer(BeaconPart.class, () -> Default());
  public static dafny.TypeDescriptor<BeaconPart> _typeDescriptor() {
    return (dafny.TypeDescriptor<BeaconPart>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  public static BeaconPart create_Encrypted(dafny.DafnySequence<? extends Character> prefix, BaseBeacon_Compile.StandardBeacon beacon) {
    return new BeaconPart_Encrypted(prefix, beacon);
  }
  public static BeaconPart create_Signed(dafny.DafnySequence<? extends Character> prefix, dafny.DafnySequence<? extends Character> name, dafny.DafnySequence<? extends TermLoc_Compile.Selector> loc) {
    return new BeaconPart_Signed(prefix, name, loc);
  }
  public boolean is_Encrypted() { return this instanceof BeaconPart_Encrypted; }
  public boolean is_Signed() { return this instanceof BeaconPart_Signed; }
  public dafny.DafnySequence<? extends Character> dtor_prefix() {
    BeaconPart d = this;
    if (d instanceof BeaconPart_Encrypted) { return ((BeaconPart_Encrypted)d)._prefix; }
    return ((BeaconPart_Signed)d)._prefix;
  }
  public BaseBeacon_Compile.StandardBeacon dtor_beacon() {
    BeaconPart d = this;
    return ((BeaconPart_Encrypted)d)._beacon;
  }
  public dafny.DafnySequence<? extends Character> dtor_name() {
    BeaconPart d = this;
    return ((BeaconPart_Signed)d)._name;
  }
  public dafny.DafnySequence<? extends TermLoc_Compile.Selector> dtor_loc() {
    BeaconPart d = this;
    return ((BeaconPart_Signed)d)._loc;
  }
  public dafny.DafnySequence<? extends Character> getPrefix() {
    BeaconPart _source8 = this;
    if (_source8.is_Encrypted()) {
      dafny.DafnySequence<? extends Character> _885___mcc_h0 = ((CompoundBeacon_Compile.BeaconPart_Encrypted)_source8)._prefix;
      BaseBeacon_Compile.StandardBeacon _886___mcc_h1 = ((CompoundBeacon_Compile.BeaconPart_Encrypted)_source8)._beacon;
      BaseBeacon_Compile.StandardBeacon _887_b = _886___mcc_h1;
      dafny.DafnySequence<? extends Character> _888_p = _885___mcc_h0;
      return _888_p;
    } else {
      dafny.DafnySequence<? extends Character> _889___mcc_h2 = ((CompoundBeacon_Compile.BeaconPart_Signed)_source8)._prefix;
      dafny.DafnySequence<? extends Character> _890___mcc_h3 = ((CompoundBeacon_Compile.BeaconPart_Signed)_source8)._name;
      dafny.DafnySequence<? extends TermLoc_Compile.Selector> _891___mcc_h4 = ((CompoundBeacon_Compile.BeaconPart_Signed)_source8)._loc;
      dafny.DafnySequence<? extends TermLoc_Compile.Selector> _892_l = _891___mcc_h4;
      dafny.DafnySequence<? extends Character> _893_n = _890___mcc_h3;
      dafny.DafnySequence<? extends Character> _894_p = _889___mcc_h2;
      return _894_p;
    }
  }
  public dafny.DafnySequence<? extends Character> getName() {
    BeaconPart _source9 = this;
    if (_source9.is_Encrypted()) {
      dafny.DafnySequence<? extends Character> _895___mcc_h0 = ((CompoundBeacon_Compile.BeaconPart_Encrypted)_source9)._prefix;
      BaseBeacon_Compile.StandardBeacon _896___mcc_h1 = ((CompoundBeacon_Compile.BeaconPart_Encrypted)_source9)._beacon;
      BaseBeacon_Compile.StandardBeacon _897_b = _896___mcc_h1;
      dafny.DafnySequence<? extends Character> _898_p = _895___mcc_h0;
      return ((_897_b).dtor_base()).dtor_name();
    } else {
      dafny.DafnySequence<? extends Character> _899___mcc_h2 = ((CompoundBeacon_Compile.BeaconPart_Signed)_source9)._prefix;
      dafny.DafnySequence<? extends Character> _900___mcc_h3 = ((CompoundBeacon_Compile.BeaconPart_Signed)_source9)._name;
      dafny.DafnySequence<? extends TermLoc_Compile.Selector> _901___mcc_h4 = ((CompoundBeacon_Compile.BeaconPart_Signed)_source9)._loc;
      dafny.DafnySequence<? extends TermLoc_Compile.Selector> _902_l = _901___mcc_h4;
      dafny.DafnySequence<? extends Character> _903_n = _900___mcc_h3;
      dafny.DafnySequence<? extends Character> _904_p = _899___mcc_h2;
      return _903_n;
    }
  }
  public Wrappers_Compile.Result<Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getString(dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue> item, dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends DdbVirtualFields_Compile.VirtField> vf)
  {
    BeaconPart _source10 = this;
    if (_source10.is_Encrypted()) {
      dafny.DafnySequence<? extends Character> _905___mcc_h0 = ((CompoundBeacon_Compile.BeaconPart_Encrypted)_source10)._prefix;
      BaseBeacon_Compile.StandardBeacon _906___mcc_h1 = ((CompoundBeacon_Compile.BeaconPart_Encrypted)_source10)._beacon;
      BaseBeacon_Compile.StandardBeacon _907_b = _906___mcc_h1;
      dafny.DafnySequence<? extends Character> _908_p = _905___mcc_h0;
      return DdbVirtualFields_Compile.__default.VirtToString((_907_b).dtor_loc(), item, vf);
    } else {
      dafny.DafnySequence<? extends Character> _909___mcc_h2 = ((CompoundBeacon_Compile.BeaconPart_Signed)_source10)._prefix;
      dafny.DafnySequence<? extends Character> _910___mcc_h3 = ((CompoundBeacon_Compile.BeaconPart_Signed)_source10)._name;
      dafny.DafnySequence<? extends TermLoc_Compile.Selector> _911___mcc_h4 = ((CompoundBeacon_Compile.BeaconPart_Signed)_source10)._loc;
      dafny.DafnySequence<? extends TermLoc_Compile.Selector> _912_l = _911___mcc_h4;
      dafny.DafnySequence<? extends Character> _913_n = _910___mcc_h3;
      dafny.DafnySequence<? extends Character> _914_p = _909___mcc_h2;
      return DdbVirtualFields_Compile.__default.VirtToString(_912_l, item, vf);
    }
  }
  public dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>> GetFields(dafny.DafnyMap<? extends dafny.DafnySequence<? extends Character>, ? extends DdbVirtualFields_Compile.VirtField> virtualFields) {
    BeaconPart _source11 = this;
    if (_source11.is_Encrypted()) {
      dafny.DafnySequence<? extends Character> _915___mcc_h0 = ((CompoundBeacon_Compile.BeaconPart_Encrypted)_source11)._prefix;
      BaseBeacon_Compile.StandardBeacon _916___mcc_h1 = ((CompoundBeacon_Compile.BeaconPart_Encrypted)_source11)._beacon;
      BaseBeacon_Compile.StandardBeacon _917_b = _916___mcc_h1;
      dafny.DafnySequence<? extends Character> _918_p = _915___mcc_h0;
      return (_917_b).GetFields(virtualFields);
    } else {
      dafny.DafnySequence<? extends Character> _919___mcc_h2 = ((CompoundBeacon_Compile.BeaconPart_Signed)_source11)._prefix;
      dafny.DafnySequence<? extends Character> _920___mcc_h3 = ((CompoundBeacon_Compile.BeaconPart_Signed)_source11)._name;
      dafny.DafnySequence<? extends TermLoc_Compile.Selector> _921___mcc_h4 = ((CompoundBeacon_Compile.BeaconPart_Signed)_source11)._loc;
      dafny.DafnySequence<? extends TermLoc_Compile.Selector> _922_l = _921___mcc_h4;
      dafny.DafnySequence<? extends Character> _923_n = _920___mcc_h3;
      dafny.DafnySequence<? extends Character> _924_p = _919___mcc_h2;
      if ((virtualFields).<dafny.DafnySequence<? extends Character>>contains((((TermLoc_Compile.Selector)(java.lang.Object)(((this).dtor_loc()).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO)))))).dtor_key())) {
        return (((DdbVirtualFields_Compile.VirtField)(java.lang.Object)((virtualFields).get((((TermLoc_Compile.Selector)(java.lang.Object)(((this).dtor_loc()).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO)))))).dtor_key())))).GetFields();
      } else {
        return dafny.DafnySequence.of(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), (((TermLoc_Compile.Selector)(java.lang.Object)(((this).dtor_loc()).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO)))))).dtor_key());
      }
    }
  }
}
