// Class __default
// Dafny class __default compiled into Java
package BaseBeacon_Compile;

import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.*;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.*;
import DynamoDbEncryptionUtil_Compile.*;
import DynamoDbNormalizeNumber_Compile.*;
import DynamoToStruct_Compile.*;
import DynamoDbEncryptionBranchKeyIdSupplier_Compile.*;
import AwsCryptographyDbEncryptionSdkDynamoDbOperations_Compile.*;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.*;
import StructuredEncryptionUtil_Compile.*;
import Sets_Compile.*;
import StructuredEncryptionPaths_Compile.*;
import StructuredEncryptionHeader_Compile.*;
import StructuredEncryptionFooter_Compile.*;
import StructuredEncryptionCrypt_Compile.*;
import Maps_Compile.*;
import AwsCryptographyDbEncryptionSdkStructuredEncryptionOperations_Compile.*;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.*;
import TermLoc_Compile.*;
import DdbVirtualFields_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class __default {
  public __default() {
  }
  public static Wrappers_Compile.Result<StandardBeacon, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> MakeStandardBeacon(software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient client, dafny.DafnySequence<? extends Character> name, byte length, dafny.DafnySequence<? extends Character> loc)
  {
    Wrappers_Compile.Result<dafny.DafnySequence<? extends TermLoc_Compile.Selector>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _874_valueOrError0 = TermLoc_Compile.__default.MakeTermLoc(loc);
    if ((_874_valueOrError0).IsFailure(TermLoc_Compile.TermLoc._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
      return (_874_valueOrError0).<StandardBeacon>PropagateFailure(TermLoc_Compile.TermLoc._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), StandardBeacon._typeDescriptor());
    } else {
      dafny.DafnySequence<? extends TermLoc_Compile.Selector> _875_termLoc = (_874_valueOrError0).Extract(TermLoc_Compile.TermLoc._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
      dafny.DafnySequence<? extends Character> _876_beaconName = dafny.DafnySequence.<Character>concatenate(DynamoDbEncryptionUtil_Compile.__default.BeaconPrefix(), name);
      Wrappers_Compile.Outcome<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _877_valueOrError1 = Wrappers_Compile.__default.<software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.__default.IsValid__AttributeName(_876_beaconName), DynamoDbEncryptionUtil_Compile.__default.E(dafny.DafnySequence.<Character>concatenate(_876_beaconName, dafny.DafnySequence.asString(" is not a valid attribute name."))));
      if ((_877_valueOrError1).IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
        return (_877_valueOrError1).<StandardBeacon>PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), StandardBeacon._typeDescriptor());
      } else {
        return Wrappers_Compile.Result.<StandardBeacon, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error>create_Success(BaseBeacon_Compile.StandardBeacon.create(BaseBeacon_Compile.BeaconBase.create(client, name, _876_beaconName), length, _875_termLoc));
      }
    }
  }
  public static java.math.BigInteger CharsFromBeaconLength(byte bits) {
    return java.math.BigInteger.valueOf(java.lang.Byte.toUnsignedLong(dafny.Helpers.divideUnsignedByte((byte) (byte)  ((byte)(((bits)) + ((byte) 3))), (byte) 4)));
  }
  public static byte TopBits(byte bits) {
    byte _878_x = dafny.Helpers.remainderUnsignedByte((bits), (byte) 4);
    if (((_878_x) == 0 ? 0 : 1) == 0) {
      return (byte) 4;
    } else {
      return _878_x;
    }
  }
  public static java.math.BigInteger BytesFromBeaconLength(byte bits) {
    return java.math.BigInteger.valueOf(java.lang.Byte.toUnsignedLong(dafny.Helpers.divideUnsignedByte((byte) (byte)  ((byte)(((bits)) + ((byte) 7))), (byte) 8)));
  }
  public static byte TruncateNibble(byte nibble, byte length)
  {
    if ((length) == ((byte) 4)) {
      return nibble;
    } else if ((length) == ((byte) 3)) {
      return dafny.Helpers.remainderUnsignedByte(nibble, (byte) 8);
    } else if ((length) == ((byte) 2)) {
      return dafny.Helpers.remainderUnsignedByte(nibble, (byte) 4);
    } else {
      return dafny.Helpers.remainderUnsignedByte(nibble, (byte) 2);
    }
  }
  public static dafny.DafnySequence<? extends Character> BytesToHex(dafny.DafnySequence<? extends java.lang.Byte> bytes, byte bits)
  {
    java.math.BigInteger _879_numBytes = __default.BytesFromBeaconLength(bits);
    java.math.BigInteger _880_numChars = __default.CharsFromBeaconLength(bits);
    byte _881_topBits = __default.TopBits(bits);
    dafny.DafnySequence<? extends java.lang.Byte> _882_bytes = (bytes).drop((java.math.BigInteger.valueOf(8L)).subtract(_879_numBytes));
    if (java.util.Objects.equals(_880_numChars, (java.math.BigInteger.valueOf(2L)).multiply(_879_numBytes))) {
      byte _883_topNibble = dafny.Helpers.divideUnsignedByte(((byte)(java.lang.Object)((_882_bytes).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))), (byte) 16);
      byte _884_bottomNibble = dafny.Helpers.remainderUnsignedByte(((byte)(java.lang.Object)((_882_bytes).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))), (byte) 16);
      return dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.of(HexStrings_Compile.__default.HexChar(__default.TruncateNibble(_883_topNibble, _881_topBits)), HexStrings_Compile.__default.HexChar(_884_bottomNibble)), HexStrings_Compile.__default.ToHexString((_882_bytes).drop(java.math.BigInteger.ONE)));
    } else {
      return dafny.DafnySequence.<Character>concatenate(dafny.DafnySequence.of(HexStrings_Compile.__default.HexChar(__default.TruncateNibble(dafny.Helpers.remainderUnsignedByte(((byte)(java.lang.Object)((_882_bytes).select(dafny.Helpers.toInt((java.math.BigInteger.ZERO))))), (byte) 16), _881_topBits))), HexStrings_Compile.__default.ToHexString((_882_bytes).drop(java.math.BigInteger.ONE)));
    }
  }
  private static final dafny.TypeDescriptor<__default> _TYPE = dafny.TypeDescriptor.<__default>referenceWithInitializer(__default.class, () -> (__default) null);
  public static dafny.TypeDescriptor<__default> _typeDescriptor() {
    return (dafny.TypeDescriptor<__default>) (dafny.TypeDescriptor<?>) _TYPE;
  }
  @Override
  public java.lang.String toString() {
    return "BaseBeacon_Compile._default";
  }
}
