/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of user access logging settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserAccessLoggingSettingsSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<UserAccessLoggingSettingsSummary.Builder, UserAccessLoggingSettingsSummary> {
    private static final SdkField<String> KINESIS_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kinesisStreamArn").getter(getter(UserAccessLoggingSettingsSummary::kinesisStreamArn))
            .setter(setter(Builder::kinesisStreamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kinesisStreamArn").build()).build();

    private static final SdkField<String> USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("userAccessLoggingSettingsArn")
            .getter(getter(UserAccessLoggingSettingsSummary::userAccessLoggingSettingsArn))
            .setter(setter(Builder::userAccessLoggingSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAccessLoggingSettingsArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KINESIS_STREAM_ARN_FIELD,
            USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kinesisStreamArn;

    private final String userAccessLoggingSettingsArn;

    private UserAccessLoggingSettingsSummary(BuilderImpl builder) {
        this.kinesisStreamArn = builder.kinesisStreamArn;
        this.userAccessLoggingSettingsArn = builder.userAccessLoggingSettingsArn;
    }

    /**
     * <p>
     * The ARN of the Kinesis stream.
     * </p>
     * 
     * @return The ARN of the Kinesis stream.
     */
    public final String kinesisStreamArn() {
        return kinesisStreamArn;
    }

    /**
     * <p>
     * The ARN of the user access logging settings.
     * </p>
     * 
     * @return The ARN of the user access logging settings.
     */
    public final String userAccessLoggingSettingsArn() {
        return userAccessLoggingSettingsArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(userAccessLoggingSettingsArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserAccessLoggingSettingsSummary)) {
            return false;
        }
        UserAccessLoggingSettingsSummary other = (UserAccessLoggingSettingsSummary) obj;
        return Objects.equals(kinesisStreamArn(), other.kinesisStreamArn())
                && Objects.equals(userAccessLoggingSettingsArn(), other.userAccessLoggingSettingsArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserAccessLoggingSettingsSummary").add("KinesisStreamArn", kinesisStreamArn())
                .add("UserAccessLoggingSettingsArn", userAccessLoggingSettingsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kinesisStreamArn":
            return Optional.ofNullable(clazz.cast(kinesisStreamArn()));
        case "userAccessLoggingSettingsArn":
            return Optional.ofNullable(clazz.cast(userAccessLoggingSettingsArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserAccessLoggingSettingsSummary, T> g) {
        return obj -> g.apply((UserAccessLoggingSettingsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserAccessLoggingSettingsSummary> {
        /**
         * <p>
         * The ARN of the Kinesis stream.
         * </p>
         * 
         * @param kinesisStreamArn
         *        The ARN of the Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamArn(String kinesisStreamArn);

        /**
         * <p>
         * The ARN of the user access logging settings.
         * </p>
         * 
         * @param userAccessLoggingSettingsArn
         *        The ARN of the user access logging settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAccessLoggingSettingsArn(String userAccessLoggingSettingsArn);
    }

    static final class BuilderImpl implements Builder {
        private String kinesisStreamArn;

        private String userAccessLoggingSettingsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UserAccessLoggingSettingsSummary model) {
            kinesisStreamArn(model.kinesisStreamArn);
            userAccessLoggingSettingsArn(model.userAccessLoggingSettingsArn);
        }

        public final String getKinesisStreamArn() {
            return kinesisStreamArn;
        }

        public final void setKinesisStreamArn(String kinesisStreamArn) {
            this.kinesisStreamArn = kinesisStreamArn;
        }

        @Override
        public final Builder kinesisStreamArn(String kinesisStreamArn) {
            this.kinesisStreamArn = kinesisStreamArn;
            return this;
        }

        public final String getUserAccessLoggingSettingsArn() {
            return userAccessLoggingSettingsArn;
        }

        public final void setUserAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
        }

        @Override
        public final Builder userAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
            return this;
        }

        @Override
        public UserAccessLoggingSettingsSummary build() {
            return new UserAccessLoggingSettingsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
