/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIdentityProviderRequest extends WorkSpacesWebRequest implements
        ToCopyableBuilder<UpdateIdentityProviderRequest.Builder, UpdateIdentityProviderRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateIdentityProviderRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> IDENTITY_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityProviderArn").getter(getter(UpdateIdentityProviderRequest::identityProviderArn))
            .setter(setter(Builder::identityProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("identityProviderArn").build())
            .build();

    private static final SdkField<Map<String, String>> IDENTITY_PROVIDER_DETAILS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("identityProviderDetails")
            .getter(getter(UpdateIdentityProviderRequest::identityProviderDetails))
            .setter(setter(Builder::identityProviderDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderDetails").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> IDENTITY_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityProviderName").getter(getter(UpdateIdentityProviderRequest::identityProviderName))
            .setter(setter(Builder::identityProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderName").build())
            .build();

    private static final SdkField<String> IDENTITY_PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityProviderType").getter(getter(UpdateIdentityProviderRequest::identityProviderTypeAsString))
            .setter(setter(Builder::identityProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            IDENTITY_PROVIDER_ARN_FIELD, IDENTITY_PROVIDER_DETAILS_FIELD, IDENTITY_PROVIDER_NAME_FIELD,
            IDENTITY_PROVIDER_TYPE_FIELD));

    private final String clientToken;

    private final String identityProviderArn;

    private final Map<String, String> identityProviderDetails;

    private final String identityProviderName;

    private final String identityProviderType;

    private UpdateIdentityProviderRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.identityProviderArn = builder.identityProviderArn;
        this.identityProviderDetails = builder.identityProviderDetails;
        this.identityProviderName = builder.identityProviderName;
        this.identityProviderType = builder.identityProviderType;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the AWS SDK.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, subsequent retries with the same client token return the result from the
     *         original successful request. </p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the AWS SDK.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ARN of the identity provider.
     * </p>
     * 
     * @return The ARN of the identity provider.
     */
    public final String identityProviderArn() {
        return identityProviderArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdentityProviderDetails property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIdentityProviderDetails() {
        return identityProviderDetails != null && !(identityProviderDetails instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The details of the identity provider. The following list describes the provider detail keys for each identity
     * provider type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Google and Login with Amazon:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For Facebook:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>api_version</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For Sign in with Apple:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>team_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>key_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private_key</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For OIDC providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attributes_request_method</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oidc_issuer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For SAML providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MetadataFile</code> OR <code>MetadataURL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IDPSignout</code> (boolean) <i>optional</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentityProviderDetails} method.
     * </p>
     * 
     * @return The details of the identity provider. The following list describes the provider detail keys for each
     *         identity provider type. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For Google and Login with Amazon:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>client_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client_secret</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>authorize_scopes</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For Facebook:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>client_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client_secret</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>authorize_scopes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>api_version</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For Sign in with Apple:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>client_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>team_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>key_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private_key</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>authorize_scopes</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For OIDC providers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>client_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client_secret</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attributes_request_method</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oidc_issuer</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>authorize_scopes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
     *         key</i>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
     *         key</i>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
     *         key</i>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
     *         key</i>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For SAML providers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MetadataFile</code> OR <code>MetadataURL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IDPSignout</code> (boolean) <i>optional</i>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final Map<String, String> identityProviderDetails() {
        return identityProviderDetails;
    }

    /**
     * <p>
     * The name of the identity provider.
     * </p>
     * 
     * @return The name of the identity provider.
     */
    public final String identityProviderName() {
        return identityProviderName;
    }

    /**
     * <p>
     * The type of the identity provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityProviderType} will return {@link IdentityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #identityProviderTypeAsString}.
     * </p>
     * 
     * @return The type of the identity provider.
     * @see IdentityProviderType
     */
    public final IdentityProviderType identityProviderType() {
        return IdentityProviderType.fromValue(identityProviderType);
    }

    /**
     * <p>
     * The type of the identity provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityProviderType} will return {@link IdentityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #identityProviderTypeAsString}.
     * </p>
     * 
     * @return The type of the identity provider.
     * @see IdentityProviderType
     */
    public final String identityProviderTypeAsString() {
        return identityProviderType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentityProviderDetails() ? identityProviderDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdentityProviderRequest)) {
            return false;
        }
        UpdateIdentityProviderRequest other = (UpdateIdentityProviderRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(identityProviderArn(), other.identityProviderArn())
                && hasIdentityProviderDetails() == other.hasIdentityProviderDetails()
                && Objects.equals(identityProviderDetails(), other.identityProviderDetails())
                && Objects.equals(identityProviderName(), other.identityProviderName())
                && Objects.equals(identityProviderTypeAsString(), other.identityProviderTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIdentityProviderRequest").add("ClientToken", clientToken())
                .add("IdentityProviderArn", identityProviderArn())
                .add("IdentityProviderDetails", identityProviderDetails() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IdentityProviderName", identityProviderName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IdentityProviderType", identityProviderTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "identityProviderArn":
            return Optional.ofNullable(clazz.cast(identityProviderArn()));
        case "identityProviderDetails":
            return Optional.ofNullable(clazz.cast(identityProviderDetails()));
        case "identityProviderName":
            return Optional.ofNullable(clazz.cast(identityProviderName()));
        case "identityProviderType":
            return Optional.ofNullable(clazz.cast(identityProviderTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIdentityProviderRequest, T> g) {
        return obj -> g.apply((UpdateIdentityProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateIdentityProviderRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully, subsequent retries with the same client token return the result from the original
         * successful request.
         * </p>
         * <p>
         * If you do not specify a client token, one is automatically generated by the AWS SDK.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully, subsequent retries with the same client token return the
         *        result from the original successful request. </p>
         *        <p>
         *        If you do not specify a client token, one is automatically generated by the AWS SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ARN of the identity provider.
         * </p>
         * 
         * @param identityProviderArn
         *        The ARN of the identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderArn(String identityProviderArn);

        /**
         * <p>
         * The details of the identity provider. The following list describes the provider detail keys for each identity
         * provider type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For Google and Login with Amazon:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>client_id</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client_secret</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>authorize_scopes</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For Facebook:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>client_id</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client_secret</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>authorize_scopes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>api_version</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For Sign in with Apple:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>client_id</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>team_id</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key_id</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private_key</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>authorize_scopes</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For OIDC providers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>client_id</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client_secret</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attributes_request_method</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oidc_issuer</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>authorize_scopes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
         * key</i>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
         * key</i>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For SAML providers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MetadataFile</code> OR <code>MetadataURL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IDPSignout</code> (boolean) <i>optional</i>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param identityProviderDetails
         *        The details of the identity provider. The following list describes the provider detail keys for each
         *        identity provider type. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For Google and Login with Amazon:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>client_id</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client_secret</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>authorize_scopes</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        For Facebook:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>client_id</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client_secret</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>authorize_scopes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>api_version</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        For Sign in with Apple:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>client_id</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>team_id</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>key_id</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private_key</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>authorize_scopes</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        For OIDC providers:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>client_id</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client_secret</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attributes_request_method</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oidc_issuer</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>authorize_scopes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>authorize_url</code> <i>if not available from discovery URL specified by
         *        <code>oidc_issuer</code> key</i>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
         *        key</i>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attributes_url</code> <i>if not available from discovery URL specified by
         *        <code>oidc_issuer</code> key</i>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
         *        key</i>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        For SAML providers:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MetadataFile</code> OR <code>MetadataURL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IDPSignout</code> (boolean) <i>optional</i>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderDetails(Map<String, String> identityProviderDetails);

        /**
         * <p>
         * The name of the identity provider.
         * </p>
         * 
         * @param identityProviderName
         *        The name of the identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderName(String identityProviderName);

        /**
         * <p>
         * The type of the identity provider.
         * </p>
         * 
         * @param identityProviderType
         *        The type of the identity provider.
         * @see IdentityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderType
         */
        Builder identityProviderType(String identityProviderType);

        /**
         * <p>
         * The type of the identity provider.
         * </p>
         * 
         * @param identityProviderType
         *        The type of the identity provider.
         * @see IdentityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderType
         */
        Builder identityProviderType(IdentityProviderType identityProviderType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesWebRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String identityProviderArn;

        private Map<String, String> identityProviderDetails = DefaultSdkAutoConstructMap.getInstance();

        private String identityProviderName;

        private String identityProviderType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdentityProviderRequest model) {
            super(model);
            clientToken(model.clientToken);
            identityProviderArn(model.identityProviderArn);
            identityProviderDetails(model.identityProviderDetails);
            identityProviderName(model.identityProviderName);
            identityProviderType(model.identityProviderType);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getIdentityProviderArn() {
            return identityProviderArn;
        }

        public final void setIdentityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
        }

        @Override
        public final Builder identityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
            return this;
        }

        public final Map<String, String> getIdentityProviderDetails() {
            if (identityProviderDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return identityProviderDetails;
        }

        public final void setIdentityProviderDetails(Map<String, String> identityProviderDetails) {
            this.identityProviderDetails = IdentityProviderDetailsCopier.copy(identityProviderDetails);
        }

        @Override
        public final Builder identityProviderDetails(Map<String, String> identityProviderDetails) {
            this.identityProviderDetails = IdentityProviderDetailsCopier.copy(identityProviderDetails);
            return this;
        }

        public final String getIdentityProviderName() {
            return identityProviderName;
        }

        public final void setIdentityProviderName(String identityProviderName) {
            this.identityProviderName = identityProviderName;
        }

        @Override
        public final Builder identityProviderName(String identityProviderName) {
            this.identityProviderName = identityProviderName;
            return this;
        }

        public final String getIdentityProviderType() {
            return identityProviderType;
        }

        public final void setIdentityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
        }

        @Override
        public final Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        @Override
        public final Builder identityProviderType(IdentityProviderType identityProviderType) {
            this.identityProviderType(identityProviderType == null ? null : identityProviderType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIdentityProviderRequest build() {
            return new UpdateIdentityProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
