/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.Compute;
import software.amazon.awssdk.services.workspaces.model.ComputeListCopier;
import software.amazon.awssdk.services.workspaces.model.OperatingSystemName;
import software.amazon.awssdk.services.workspaces.model.OperatingSystemNameListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationLicenseType;
import software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkSpaceApplication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkSpaceApplication> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(WorkSpaceApplication.getter(WorkSpaceApplication::applicationId)).setter(WorkSpaceApplication.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Created").getter(WorkSpaceApplication.getter(WorkSpaceApplication::created)).setter(WorkSpaceApplication.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(WorkSpaceApplication.getter(WorkSpaceApplication::description)).setter(WorkSpaceApplication.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseType").getter(WorkSpaceApplication.getter(WorkSpaceApplication::licenseTypeAsString)).setter(WorkSpaceApplication.setter(Builder::licenseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(WorkSpaceApplication.getter(WorkSpaceApplication::name)).setter(WorkSpaceApplication.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(WorkSpaceApplication.getter(WorkSpaceApplication::owner)).setter(WorkSpaceApplication.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(WorkSpaceApplication.getter(WorkSpaceApplication::stateAsString)).setter(WorkSpaceApplication.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_COMPUTE_TYPE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedComputeTypeNames").getter(WorkSpaceApplication.getter(WorkSpaceApplication::supportedComputeTypeNamesAsStrings)).setter(WorkSpaceApplication.setter(Builder::supportedComputeTypeNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedComputeTypeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_OPERATING_SYSTEM_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedOperatingSystemNames").getter(WorkSpaceApplication.getter(WorkSpaceApplication::supportedOperatingSystemNamesAsStrings)).setter(WorkSpaceApplication.setter(Builder::supportedOperatingSystemNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedOperatingSystemNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CREATED_FIELD, DESCRIPTION_FIELD, LICENSE_TYPE_FIELD, NAME_FIELD, OWNER_FIELD, STATE_FIELD, SUPPORTED_COMPUTE_TYPE_NAMES_FIELD, SUPPORTED_OPERATING_SYSTEM_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final Instant created;
    private final String description;
    private final String licenseType;
    private final String name;
    private final String owner;
    private final String state;
    private final List<String> supportedComputeTypeNames;
    private final List<String> supportedOperatingSystemNames;

    private WorkSpaceApplication(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.created = builder.created;
        this.description = builder.description;
        this.licenseType = builder.licenseType;
        this.name = builder.name;
        this.owner = builder.owner;
        this.state = builder.state;
        this.supportedComputeTypeNames = builder.supportedComputeTypeNames;
        this.supportedOperatingSystemNames = builder.supportedOperatingSystemNames;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final Instant created() {
        return this.created;
    }

    public final String description() {
        return this.description;
    }

    public final WorkSpaceApplicationLicenseType licenseType() {
        return WorkSpaceApplicationLicenseType.fromValue(this.licenseType);
    }

    public final String licenseTypeAsString() {
        return this.licenseType;
    }

    public final String name() {
        return this.name;
    }

    public final String owner() {
        return this.owner;
    }

    public final WorkSpaceApplicationState state() {
        return WorkSpaceApplicationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final List<Compute> supportedComputeTypeNames() {
        return ComputeListCopier.copyStringToEnum(this.supportedComputeTypeNames);
    }

    public final boolean hasSupportedComputeTypeNames() {
        return this.supportedComputeTypeNames != null && !(this.supportedComputeTypeNames instanceof SdkAutoConstructList);
    }

    public final List<String> supportedComputeTypeNamesAsStrings() {
        return this.supportedComputeTypeNames;
    }

    public final List<OperatingSystemName> supportedOperatingSystemNames() {
        return OperatingSystemNameListCopier.copyStringToEnum(this.supportedOperatingSystemNames);
    }

    public final boolean hasSupportedOperatingSystemNames() {
        return this.supportedOperatingSystemNames != null && !(this.supportedOperatingSystemNames instanceof SdkAutoConstructList);
    }

    public final List<String> supportedOperatingSystemNamesAsStrings() {
        return this.supportedOperatingSystemNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedComputeTypeNames() ? this.supportedComputeTypeNamesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedOperatingSystemNames() ? this.supportedOperatingSystemNamesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkSpaceApplication)) {
            return false;
        }
        WorkSpaceApplication other = (WorkSpaceApplication)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.licenseTypeAsString(), other.licenseTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasSupportedComputeTypeNames() == other.hasSupportedComputeTypeNames() && Objects.equals(this.supportedComputeTypeNamesAsStrings(), other.supportedComputeTypeNamesAsStrings()) && this.hasSupportedOperatingSystemNames() == other.hasSupportedOperatingSystemNames() && Objects.equals(this.supportedOperatingSystemNamesAsStrings(), other.supportedOperatingSystemNamesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"WorkSpaceApplication").add("ApplicationId", (Object)this.applicationId()).add("Created", (Object)this.created()).add("Description", (Object)this.description()).add("LicenseType", (Object)this.licenseTypeAsString()).add("Name", (Object)this.name()).add("Owner", (Object)this.owner()).add("State", (Object)this.stateAsString()).add("SupportedComputeTypeNames", this.hasSupportedComputeTypeNames() ? this.supportedComputeTypeNamesAsStrings() : null).add("SupportedOperatingSystemNames", this.hasSupportedOperatingSystemNames() ? this.supportedOperatingSystemNamesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LicenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseTypeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "SupportedComputeTypeNames": {
                return Optional.ofNullable(clazz.cast(this.supportedComputeTypeNamesAsStrings()));
            }
            case "SupportedOperatingSystemNames": {
                return Optional.ofNullable(clazz.cast(this.supportedOperatingSystemNamesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkSpaceApplication, T> g) {
        return obj -> g.apply((WorkSpaceApplication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private Instant created;
        private String description;
        private String licenseType;
        private String name;
        private String owner;
        private String state;
        private List<String> supportedComputeTypeNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedOperatingSystemNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkSpaceApplication model) {
            this.applicationId(model.applicationId);
            this.created(model.created);
            this.description(model.description);
            this.licenseType(model.licenseType);
            this.name(model.name);
            this.owner(model.owner);
            this.state(model.state);
            this.supportedComputeTypeNamesWithStrings(model.supportedComputeTypeNames);
            this.supportedOperatingSystemNamesWithStrings(model.supportedOperatingSystemNames);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(WorkSpaceApplicationLicenseType licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkSpaceApplicationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Collection<String> getSupportedComputeTypeNames() {
            if (this.supportedComputeTypeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedComputeTypeNames;
        }

        public final void setSupportedComputeTypeNames(Collection<String> supportedComputeTypeNames) {
            this.supportedComputeTypeNames = ComputeListCopier.copy(supportedComputeTypeNames);
        }

        @Override
        public final Builder supportedComputeTypeNamesWithStrings(Collection<String> supportedComputeTypeNames) {
            this.supportedComputeTypeNames = ComputeListCopier.copy(supportedComputeTypeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedComputeTypeNamesWithStrings(String ... supportedComputeTypeNames) {
            this.supportedComputeTypeNamesWithStrings(Arrays.asList(supportedComputeTypeNames));
            return this;
        }

        @Override
        public final Builder supportedComputeTypeNames(Collection<Compute> supportedComputeTypeNames) {
            this.supportedComputeTypeNames = ComputeListCopier.copyEnumToString(supportedComputeTypeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedComputeTypeNames(Compute ... supportedComputeTypeNames) {
            this.supportedComputeTypeNames(Arrays.asList(supportedComputeTypeNames));
            return this;
        }

        public final Collection<String> getSupportedOperatingSystemNames() {
            if (this.supportedOperatingSystemNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedOperatingSystemNames;
        }

        public final void setSupportedOperatingSystemNames(Collection<String> supportedOperatingSystemNames) {
            this.supportedOperatingSystemNames = OperatingSystemNameListCopier.copy(supportedOperatingSystemNames);
        }

        @Override
        public final Builder supportedOperatingSystemNamesWithStrings(Collection<String> supportedOperatingSystemNames) {
            this.supportedOperatingSystemNames = OperatingSystemNameListCopier.copy(supportedOperatingSystemNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedOperatingSystemNamesWithStrings(String ... supportedOperatingSystemNames) {
            this.supportedOperatingSystemNamesWithStrings(Arrays.asList(supportedOperatingSystemNames));
            return this;
        }

        @Override
        public final Builder supportedOperatingSystemNames(Collection<OperatingSystemName> supportedOperatingSystemNames) {
            this.supportedOperatingSystemNames = OperatingSystemNameListCopier.copyEnumToString(supportedOperatingSystemNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedOperatingSystemNames(OperatingSystemName ... supportedOperatingSystemNames) {
            this.supportedOperatingSystemNames(Arrays.asList(supportedOperatingSystemNames));
            return this;
        }

        public WorkSpaceApplication build() {
            return new WorkSpaceApplication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkSpaceApplication> {
        public Builder applicationId(String var1);

        public Builder created(Instant var1);

        public Builder description(String var1);

        public Builder licenseType(String var1);

        public Builder licenseType(WorkSpaceApplicationLicenseType var1);

        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder state(String var1);

        public Builder state(WorkSpaceApplicationState var1);

        public Builder supportedComputeTypeNamesWithStrings(Collection<String> var1);

        public Builder supportedComputeTypeNamesWithStrings(String ... var1);

        public Builder supportedComputeTypeNames(Collection<Compute> var1);

        public Builder supportedComputeTypeNames(Compute ... var1);

        public Builder supportedOperatingSystemNamesWithStrings(Collection<String> var1);

        public Builder supportedOperatingSystemNamesWithStrings(String ... var1);

        public Builder supportedOperatingSystemNames(Collection<OperatingSystemName> var1);

        public Builder supportedOperatingSystemNames(OperatingSystemName ... var1);
    }
}

