/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OperatingSystemName {
    AMAZON_LINUX_2("AMAZON_LINUX_2"),
    UBUNTU_18_04("UBUNTU_18_04"),
    UBUNTU_20_04("UBUNTU_20_04"),
    UBUNTU_22_04("UBUNTU_22_04"),
    UNKNOWN("UNKNOWN"),
    WINDOWS_10("WINDOWS_10"),
    WINDOWS_11("WINDOWS_11"),
    WINDOWS_7("WINDOWS_7"),
    WINDOWS_SERVER_2016("WINDOWS_SERVER_2016"),
    WINDOWS_SERVER_2019("WINDOWS_SERVER_2019"),
    WINDOWS_SERVER_2022("WINDOWS_SERVER_2022"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OperatingSystemName> VALUE_MAP;
    private final String value;

    private OperatingSystemName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperatingSystemName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperatingSystemName> knownValues() {
        EnumSet<OperatingSystemName> knownValues = EnumSet.allOf(OperatingSystemName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OperatingSystemName.class, OperatingSystemName::toString);
    }
}

