/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.ApplicationAssociatedResourceType;
import software.amazon.awssdk.services.workspaces.model.ApplicationAssociatedResourceTypeListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicationAssociationsRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, DescribeApplicationAssociationsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeApplicationAssociationsRequest.getter(DescribeApplicationAssociationsRequest::maxResults)).setter(DescribeApplicationAssociationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeApplicationAssociationsRequest.getter(DescribeApplicationAssociationsRequest::nextToken)).setter(DescribeApplicationAssociationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(DescribeApplicationAssociationsRequest.getter(DescribeApplicationAssociationsRequest::applicationId)).setter(DescribeApplicationAssociationsRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedResourceTypes").getter(DescribeApplicationAssociationsRequest.getter(DescribeApplicationAssociationsRequest::associatedResourceTypesAsStrings)).setter(DescribeApplicationAssociationsRequest.setter(Builder::associatedResourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, APPLICATION_ID_FIELD, ASSOCIATED_RESOURCE_TYPES_FIELD));
    private final Integer maxResults;
    private final String nextToken;
    private final String applicationId;
    private final List<String> associatedResourceTypes;

    private DescribeApplicationAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.applicationId = builder.applicationId;
        this.associatedResourceTypes = builder.associatedResourceTypes;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final List<ApplicationAssociatedResourceType> associatedResourceTypes() {
        return ApplicationAssociatedResourceTypeListCopier.copyStringToEnum(this.associatedResourceTypes);
    }

    public final boolean hasAssociatedResourceTypes() {
        return this.associatedResourceTypes != null && !(this.associatedResourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> associatedResourceTypesAsStrings() {
        return this.associatedResourceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedResourceTypes() ? this.associatedResourceTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationAssociationsRequest)) {
            return false;
        }
        DescribeApplicationAssociationsRequest other = (DescribeApplicationAssociationsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.applicationId(), other.applicationId()) && this.hasAssociatedResourceTypes() == other.hasAssociatedResourceTypes() && Objects.equals(this.associatedResourceTypesAsStrings(), other.associatedResourceTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeApplicationAssociationsRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ApplicationId", (Object)this.applicationId()).add("AssociatedResourceTypes", this.hasAssociatedResourceTypes() ? this.associatedResourceTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "AssociatedResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationAssociationsRequest, T> g) {
        return obj -> g.apply((DescribeApplicationAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private String applicationId;
        private List<String> associatedResourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationAssociationsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.applicationId(model.applicationId);
            this.associatedResourceTypesWithStrings(model.associatedResourceTypes);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Collection<String> getAssociatedResourceTypes() {
            if (this.associatedResourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedResourceTypes;
        }

        public final void setAssociatedResourceTypes(Collection<String> associatedResourceTypes) {
            this.associatedResourceTypes = ApplicationAssociatedResourceTypeListCopier.copy(associatedResourceTypes);
        }

        @Override
        public final Builder associatedResourceTypesWithStrings(Collection<String> associatedResourceTypes) {
            this.associatedResourceTypes = ApplicationAssociatedResourceTypeListCopier.copy(associatedResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResourceTypesWithStrings(String ... associatedResourceTypes) {
            this.associatedResourceTypesWithStrings(Arrays.asList(associatedResourceTypes));
            return this;
        }

        @Override
        public final Builder associatedResourceTypes(Collection<ApplicationAssociatedResourceType> associatedResourceTypes) {
            this.associatedResourceTypes = ApplicationAssociatedResourceTypeListCopier.copyEnumToString(associatedResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResourceTypes(ApplicationAssociatedResourceType ... associatedResourceTypes) {
            this.associatedResourceTypes(Arrays.asList(associatedResourceTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeApplicationAssociationsRequest build() {
            return new DescribeApplicationAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApplicationAssociationsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder applicationId(String var1);

        public Builder associatedResourceTypesWithStrings(Collection<String> var1);

        public Builder associatedResourceTypesWithStrings(String ... var1);

        public Builder associatedResourceTypes(Collection<ApplicationAssociatedResourceType> var1);

        public Builder associatedResourceTypes(ApplicationAssociatedResourceType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

