/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a standby WorkSpace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StandbyWorkspace implements SdkPojo, Serializable,
        ToCopyableBuilder<StandbyWorkspace.Builder, StandbyWorkspace> {
    private static final SdkField<String> PRIMARY_WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryWorkspaceId").getter(getter(StandbyWorkspace::primaryWorkspaceId))
            .setter(setter(Builder::primaryWorkspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryWorkspaceId").build())
            .build();

    private static final SdkField<String> VOLUME_ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeEncryptionKey").getter(getter(StandbyWorkspace::volumeEncryptionKey))
            .setter(setter(Builder::volumeEncryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeEncryptionKey").build())
            .build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(StandbyWorkspace::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(StandbyWorkspace::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_WORKSPACE_ID_FIELD,
            VOLUME_ENCRYPTION_KEY_FIELD, DIRECTORY_ID_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String primaryWorkspaceId;

    private final String volumeEncryptionKey;

    private final String directoryId;

    private final List<Tag> tags;

    private StandbyWorkspace(BuilderImpl builder) {
        this.primaryWorkspaceId = builder.primaryWorkspaceId;
        this.volumeEncryptionKey = builder.volumeEncryptionKey;
        this.directoryId = builder.directoryId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the standby WorkSpace.
     * </p>
     * 
     * @return The identifier of the standby WorkSpace.
     */
    public final String primaryWorkspaceId() {
        return primaryWorkspaceId;
    }

    /**
     * <p>
     * The volume encryption key of the standby WorkSpace.
     * </p>
     * 
     * @return The volume encryption key of the standby WorkSpace.
     */
    public final String volumeEncryptionKey() {
        return volumeEncryptionKey;
    }

    /**
     * <p>
     * The identifier of the directory for the standby WorkSpace.
     * </p>
     * 
     * @return The identifier of the directory for the standby WorkSpace.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the standby WorkSpace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the standby WorkSpace.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primaryWorkspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandbyWorkspace)) {
            return false;
        }
        StandbyWorkspace other = (StandbyWorkspace) obj;
        return Objects.equals(primaryWorkspaceId(), other.primaryWorkspaceId())
                && Objects.equals(volumeEncryptionKey(), other.volumeEncryptionKey())
                && Objects.equals(directoryId(), other.directoryId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StandbyWorkspace").add("PrimaryWorkspaceId", primaryWorkspaceId())
                .add("VolumeEncryptionKey", volumeEncryptionKey()).add("DirectoryId", directoryId())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryWorkspaceId":
            return Optional.ofNullable(clazz.cast(primaryWorkspaceId()));
        case "VolumeEncryptionKey":
            return Optional.ofNullable(clazz.cast(volumeEncryptionKey()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StandbyWorkspace, T> g) {
        return obj -> g.apply((StandbyWorkspace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StandbyWorkspace> {
        /**
         * <p>
         * The identifier of the standby WorkSpace.
         * </p>
         * 
         * @param primaryWorkspaceId
         *        The identifier of the standby WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryWorkspaceId(String primaryWorkspaceId);

        /**
         * <p>
         * The volume encryption key of the standby WorkSpace.
         * </p>
         * 
         * @param volumeEncryptionKey
         *        The volume encryption key of the standby WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeEncryptionKey(String volumeEncryptionKey);

        /**
         * <p>
         * The identifier of the directory for the standby WorkSpace.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory for the standby WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The tags associated with the standby WorkSpace.
         * </p>
         * 
         * @param tags
         *        The tags associated with the standby WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the standby WorkSpace.
         * </p>
         * 
         * @param tags
         *        The tags associated with the standby WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the standby WorkSpace.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.workspaces.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String primaryWorkspaceId;

        private String volumeEncryptionKey;

        private String directoryId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StandbyWorkspace model) {
            primaryWorkspaceId(model.primaryWorkspaceId);
            volumeEncryptionKey(model.volumeEncryptionKey);
            directoryId(model.directoryId);
            tags(model.tags);
        }

        public final String getPrimaryWorkspaceId() {
            return primaryWorkspaceId;
        }

        public final void setPrimaryWorkspaceId(String primaryWorkspaceId) {
            this.primaryWorkspaceId = primaryWorkspaceId;
        }

        @Override
        public final Builder primaryWorkspaceId(String primaryWorkspaceId) {
            this.primaryWorkspaceId = primaryWorkspaceId;
            return this;
        }

        public final String getVolumeEncryptionKey() {
            return volumeEncryptionKey;
        }

        public final void setVolumeEncryptionKey(String volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
        }

        @Override
        public final Builder volumeEncryptionKey(String volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public StandbyWorkspace build() {
            return new StandbyWorkspace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
