/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestAvailabilityConfigurationRequest extends WorkMailRequest implements
        ToCopyableBuilder<TestAvailabilityConfigurationRequest.Builder, TestAvailabilityConfigurationRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(TestAvailabilityConfigurationRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(TestAvailabilityConfigurationRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<EwsAvailabilityProvider> EWS_PROVIDER_FIELD = SdkField
            .<EwsAvailabilityProvider> builder(MarshallingType.SDK_POJO).memberName("EwsProvider")
            .getter(getter(TestAvailabilityConfigurationRequest::ewsProvider)).setter(setter(Builder::ewsProvider))
            .constructor(EwsAvailabilityProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EwsProvider").build()).build();

    private static final SdkField<LambdaAvailabilityProvider> LAMBDA_PROVIDER_FIELD = SdkField
            .<LambdaAvailabilityProvider> builder(MarshallingType.SDK_POJO).memberName("LambdaProvider")
            .getter(getter(TestAvailabilityConfigurationRequest::lambdaProvider)).setter(setter(Builder::lambdaProvider))
            .constructor(LambdaAvailabilityProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaProvider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            DOMAIN_NAME_FIELD, EWS_PROVIDER_FIELD, LAMBDA_PROVIDER_FIELD));

    private final String organizationId;

    private final String domainName;

    private final EwsAvailabilityProvider ewsProvider;

    private final LambdaAvailabilityProvider lambdaProvider;

    private TestAvailabilityConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.domainName = builder.domainName;
        this.ewsProvider = builder.ewsProvider;
        this.lambdaProvider = builder.lambdaProvider;
    }

    /**
     * <p>
     * The WorkMail organization where the availability provider will be tested.
     * </p>
     * 
     * @return The WorkMail organization where the availability provider will be tested.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The domain to which the provider applies. If this field is provided, a stored availability provider associated to
     * this domain name will be tested.
     * </p>
     * 
     * @return The domain to which the provider applies. If this field is provided, a stored availability provider
     *         associated to this domain name will be tested.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * Returns the value of the EwsProvider property for this object.
     * 
     * @return The value of the EwsProvider property for this object.
     */
    public final EwsAvailabilityProvider ewsProvider() {
        return ewsProvider;
    }

    /**
     * Returns the value of the LambdaProvider property for this object.
     * 
     * @return The value of the LambdaProvider property for this object.
     */
    public final LambdaAvailabilityProvider lambdaProvider() {
        return lambdaProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(ewsProvider());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestAvailabilityConfigurationRequest)) {
            return false;
        }
        TestAvailabilityConfigurationRequest other = (TestAvailabilityConfigurationRequest) obj;
        return Objects.equals(organizationId(), other.organizationId()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(ewsProvider(), other.ewsProvider()) && Objects.equals(lambdaProvider(), other.lambdaProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestAvailabilityConfigurationRequest").add("OrganizationId", organizationId())
                .add("DomainName", domainName()).add("EwsProvider", ewsProvider()).add("LambdaProvider", lambdaProvider())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "EwsProvider":
            return Optional.ofNullable(clazz.cast(ewsProvider()));
        case "LambdaProvider":
            return Optional.ofNullable(clazz.cast(lambdaProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestAvailabilityConfigurationRequest, T> g) {
        return obj -> g.apply((TestAvailabilityConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, TestAvailabilityConfigurationRequest> {
        /**
         * <p>
         * The WorkMail organization where the availability provider will be tested.
         * </p>
         * 
         * @param organizationId
         *        The WorkMail organization where the availability provider will be tested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The domain to which the provider applies. If this field is provided, a stored availability provider
         * associated to this domain name will be tested.
         * </p>
         * 
         * @param domainName
         *        The domain to which the provider applies. If this field is provided, a stored availability provider
         *        associated to this domain name will be tested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * Sets the value of the EwsProvider property for this object.
         *
         * @param ewsProvider
         *        The new value for the EwsProvider property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ewsProvider(EwsAvailabilityProvider ewsProvider);

        /**
         * Sets the value of the EwsProvider property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EwsAvailabilityProvider.Builder} avoiding
         * the need to create one manually via {@link EwsAvailabilityProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EwsAvailabilityProvider.Builder#build()} is called immediately
         * and its result is passed to {@link #ewsProvider(EwsAvailabilityProvider)}.
         * 
         * @param ewsProvider
         *        a consumer that will call methods on {@link EwsAvailabilityProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ewsProvider(EwsAvailabilityProvider)
         */
        default Builder ewsProvider(Consumer<EwsAvailabilityProvider.Builder> ewsProvider) {
            return ewsProvider(EwsAvailabilityProvider.builder().applyMutation(ewsProvider).build());
        }

        /**
         * Sets the value of the LambdaProvider property for this object.
         *
         * @param lambdaProvider
         *        The new value for the LambdaProvider property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaProvider(LambdaAvailabilityProvider lambdaProvider);

        /**
         * Sets the value of the LambdaProvider property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LambdaAvailabilityProvider.Builder}
         * avoiding the need to create one manually via {@link LambdaAvailabilityProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaAvailabilityProvider.Builder#build()} is called immediately
         * and its result is passed to {@link #lambdaProvider(LambdaAvailabilityProvider)}.
         * 
         * @param lambdaProvider
         *        a consumer that will call methods on {@link LambdaAvailabilityProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaProvider(LambdaAvailabilityProvider)
         */
        default Builder lambdaProvider(Consumer<LambdaAvailabilityProvider.Builder> lambdaProvider) {
            return lambdaProvider(LambdaAvailabilityProvider.builder().applyMutation(lambdaProvider).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String domainName;

        private EwsAvailabilityProvider ewsProvider;

        private LambdaAvailabilityProvider lambdaProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(TestAvailabilityConfigurationRequest model) {
            super(model);
            organizationId(model.organizationId);
            domainName(model.domainName);
            ewsProvider(model.ewsProvider);
            lambdaProvider(model.lambdaProvider);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final EwsAvailabilityProvider.Builder getEwsProvider() {
            return ewsProvider != null ? ewsProvider.toBuilder() : null;
        }

        public final void setEwsProvider(EwsAvailabilityProvider.BuilderImpl ewsProvider) {
            this.ewsProvider = ewsProvider != null ? ewsProvider.build() : null;
        }

        @Override
        public final Builder ewsProvider(EwsAvailabilityProvider ewsProvider) {
            this.ewsProvider = ewsProvider;
            return this;
        }

        public final LambdaAvailabilityProvider.Builder getLambdaProvider() {
            return lambdaProvider != null ? lambdaProvider.toBuilder() : null;
        }

        public final void setLambdaProvider(LambdaAvailabilityProvider.BuilderImpl lambdaProvider) {
            this.lambdaProvider = lambdaProvider != null ? lambdaProvider.build() : null;
        }

        @Override
        public final Builder lambdaProvider(LambdaAvailabilityProvider lambdaProvider) {
            this.lambdaProvider = lambdaProvider;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestAvailabilityConfigurationRequest build() {
            return new TestAvailabilityConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
