/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClient;
import software.amazon.awssdk.services.workdocs.internal.UserAgentUtils;
import software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse;
import software.amazon.awssdk.services.workdocs.model.FolderMetadata;

public class DescribeRootFoldersPublisher
implements SdkPublisher<DescribeRootFoldersResponse> {
    private final WorkDocsAsyncClient client;
    private final DescribeRootFoldersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRootFoldersPublisher(WorkDocsAsyncClient client, DescribeRootFoldersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRootFoldersPublisher(WorkDocsAsyncClient client, DescribeRootFoldersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRootFoldersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRootFoldersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FolderMetadata> folders() {
        Function<DescribeRootFoldersResponse, Iterator> getIterator = response -> {
            if (response != null && response.folders() != null) {
                return response.folders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRootFoldersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeRootFoldersResponseFetcher
    implements AsyncPageFetcher<DescribeRootFoldersResponse> {
        private DescribeRootFoldersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRootFoldersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeRootFoldersResponse> nextPage(DescribeRootFoldersResponse previousPage) {
            if (previousPage == null) {
                return DescribeRootFoldersPublisher.this.client.describeRootFolders(DescribeRootFoldersPublisher.this.firstRequest);
            }
            return DescribeRootFoldersPublisher.this.client.describeRootFolders((DescribeRootFoldersRequest)((Object)DescribeRootFoldersPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

