/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.internal.UserAgentUtils;
import software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.Principal;

public class DescribeResourcePermissionsIterable
implements SdkIterable<DescribeResourcePermissionsResponse> {
    private final WorkDocsClient client;
    private final DescribeResourcePermissionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeResourcePermissionsIterable(WorkDocsClient client, DescribeResourcePermissionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeResourcePermissionsResponseFetcher();
    }

    public Iterator<DescribeResourcePermissionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Principal> principals() {
        Function<DescribeResourcePermissionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.principals() != null) {
                return response.principals().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeResourcePermissionsResponseFetcher
    implements SyncPageFetcher<DescribeResourcePermissionsResponse> {
        private DescribeResourcePermissionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeResourcePermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeResourcePermissionsResponse nextPage(DescribeResourcePermissionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeResourcePermissionsIterable.this.client.describeResourcePermissions(DescribeResourcePermissionsIterable.this.firstRequest);
            }
            return DescribeResourcePermissionsIterable.this.client.describeResourcePermissions((DescribeResourcePermissionsRequest)((Object)DescribeResourcePermissionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

