/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.internal.UserAgentUtils;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;

public class DescribeDocumentVersionsIterable
implements SdkIterable<DescribeDocumentVersionsResponse> {
    private final WorkDocsClient client;
    private final DescribeDocumentVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDocumentVersionsIterable(WorkDocsClient client, DescribeDocumentVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDocumentVersionsResponseFetcher();
    }

    public Iterator<DescribeDocumentVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DocumentVersionMetadata> documentVersions() {
        Function<DescribeDocumentVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.documentVersions() != null) {
                return response.documentVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDocumentVersionsResponseFetcher
    implements SyncPageFetcher<DescribeDocumentVersionsResponse> {
        private DescribeDocumentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDocumentVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDocumentVersionsResponse nextPage(DescribeDocumentVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDocumentVersionsIterable.this.client.describeDocumentVersions(DescribeDocumentVersionsIterable.this.firstRequest);
            }
            return DescribeDocumentVersionsIterable.this.client.describeDocumentVersions((DescribeDocumentVersionsRequest)((Object)DescribeDocumentVersionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

