/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGeoMatchSetsResponse extends WafResponse implements
        ToCopyableBuilder<ListGeoMatchSetsResponse.Builder, ListGeoMatchSetsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListGeoMatchSetsResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<GeoMatchSetSummary>> GEO_MATCH_SETS_FIELD = SdkField
            .<List<GeoMatchSetSummary>> builder(MarshallingType.LIST)
            .memberName("GeoMatchSets")
            .getter(getter(ListGeoMatchSetsResponse::geoMatchSets))
            .setter(setter(Builder::geoMatchSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GeoMatchSetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(GeoMatchSetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            GEO_MATCH_SETS_FIELD));

    private final String nextMarker;

    private final List<GeoMatchSetSummary> geoMatchSets;

    private ListGeoMatchSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.geoMatchSets = builder.geoMatchSets;
    }

    /**
     * <p>
     * If you have more <code>GeoMatchSet</code> objects than the number that you specified for <code>Limit</code> in
     * the request, the response includes a <code>NextMarker</code> value. To list more <code>GeoMatchSet</code>
     * objects, submit another <code>ListGeoMatchSets</code> request, and specify the <code>NextMarker</code> value from
     * the response in the <code>NextMarker</code> value in the next request.
     * </p>
     * 
     * @return If you have more <code>GeoMatchSet</code> objects than the number that you specified for
     *         <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more
     *         <code>GeoMatchSet</code> objects, submit another <code>ListGeoMatchSets</code> request, and specify the
     *         <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the GeoMatchSets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGeoMatchSets() {
        return geoMatchSets != null && !(geoMatchSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>GeoMatchSetSummary</a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGeoMatchSets} method.
     * </p>
     * 
     * @return An array of <a>GeoMatchSetSummary</a> objects.
     */
    public final List<GeoMatchSetSummary> geoMatchSets() {
        return geoMatchSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(hasGeoMatchSets() ? geoMatchSets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeoMatchSetsResponse)) {
            return false;
        }
        ListGeoMatchSetsResponse other = (ListGeoMatchSetsResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && hasGeoMatchSets() == other.hasGeoMatchSets()
                && Objects.equals(geoMatchSets(), other.geoMatchSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGeoMatchSetsResponse").add("NextMarker", nextMarker())
                .add("GeoMatchSets", hasGeoMatchSets() ? geoMatchSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "GeoMatchSets":
            return Optional.ofNullable(clazz.cast(geoMatchSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGeoMatchSetsResponse, T> g) {
        return obj -> g.apply((ListGeoMatchSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListGeoMatchSetsResponse> {
        /**
         * <p>
         * If you have more <code>GeoMatchSet</code> objects than the number that you specified for <code>Limit</code>
         * in the request, the response includes a <code>NextMarker</code> value. To list more <code>GeoMatchSet</code>
         * objects, submit another <code>ListGeoMatchSets</code> request, and specify the <code>NextMarker</code> value
         * from the response in the <code>NextMarker</code> value in the next request.
         * </p>
         * 
         * @param nextMarker
         *        If you have more <code>GeoMatchSet</code> objects than the number that you specified for
         *        <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more
         *        <code>GeoMatchSet</code> objects, submit another <code>ListGeoMatchSets</code> request, and specify
         *        the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * An array of <a>GeoMatchSetSummary</a> objects.
         * </p>
         * 
         * @param geoMatchSets
         *        An array of <a>GeoMatchSetSummary</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoMatchSets(Collection<GeoMatchSetSummary> geoMatchSets);

        /**
         * <p>
         * An array of <a>GeoMatchSetSummary</a> objects.
         * </p>
         * 
         * @param geoMatchSets
         *        An array of <a>GeoMatchSetSummary</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoMatchSets(GeoMatchSetSummary... geoMatchSets);

        /**
         * <p>
         * An array of <a>GeoMatchSetSummary</a> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.waf.model.GeoMatchSetSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.waf.model.GeoMatchSetSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.waf.model.GeoMatchSetSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #geoMatchSets(List<GeoMatchSetSummary>)}.
         * 
         * @param geoMatchSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.waf.model.GeoMatchSetSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geoMatchSets(java.util.Collection<GeoMatchSetSummary>)
         */
        Builder geoMatchSets(Consumer<GeoMatchSetSummary.Builder>... geoMatchSets);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private List<GeoMatchSetSummary> geoMatchSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeoMatchSetsResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            geoMatchSets(model.geoMatchSets);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<GeoMatchSetSummary.Builder> getGeoMatchSets() {
            List<GeoMatchSetSummary.Builder> result = GeoMatchSetSummariesCopier.copyToBuilder(this.geoMatchSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeoMatchSets(Collection<GeoMatchSetSummary.BuilderImpl> geoMatchSets) {
            this.geoMatchSets = GeoMatchSetSummariesCopier.copyFromBuilder(geoMatchSets);
        }

        @Override
        public final Builder geoMatchSets(Collection<GeoMatchSetSummary> geoMatchSets) {
            this.geoMatchSets = GeoMatchSetSummariesCopier.copy(geoMatchSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoMatchSets(GeoMatchSetSummary... geoMatchSets) {
            geoMatchSets(Arrays.asList(geoMatchSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoMatchSets(Consumer<GeoMatchSetSummary.Builder>... geoMatchSets) {
            geoMatchSets(Stream.of(geoMatchSets).map(c -> GeoMatchSetSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListGeoMatchSetsResponse build() {
            return new ListGeoMatchSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
