/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkVpcAssociationSummary;

public class ListServiceNetworkVpcAssociationsIterable
implements SdkIterable<ListServiceNetworkVpcAssociationsResponse> {
    private final VpcLatticeClient client;
    private final ListServiceNetworkVpcAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceNetworkVpcAssociationsIterable(VpcLatticeClient client, ListServiceNetworkVpcAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServiceNetworkVpcAssociationsResponseFetcher();
    }

    public Iterator<ListServiceNetworkVpcAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceNetworkVpcAssociationSummary> items() {
        Function<ListServiceNetworkVpcAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceNetworkVpcAssociationsResponseFetcher
    implements SyncPageFetcher<ListServiceNetworkVpcAssociationsResponse> {
        private ListServiceNetworkVpcAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceNetworkVpcAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceNetworkVpcAssociationsResponse nextPage(ListServiceNetworkVpcAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceNetworkVpcAssociationsIterable.this.client.listServiceNetworkVpcAssociations(ListServiceNetworkVpcAssociationsIterable.this.firstRequest);
            }
            return ListServiceNetworkVpcAssociationsIterable.this.client.listServiceNetworkVpcAssociations((ListServiceNetworkVpcAssociationsRequest)((Object)ListServiceNetworkVpcAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

