/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.voiceid.VoiceIdAsyncClient;
import software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsRequest;
import software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsResponse;
import software.amazon.awssdk.services.voiceid.model.SpeakerEnrollmentJobSummary;

public class ListSpeakerEnrollmentJobsPublisher
implements SdkPublisher<ListSpeakerEnrollmentJobsResponse> {
    private final VoiceIdAsyncClient client;
    private final ListSpeakerEnrollmentJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSpeakerEnrollmentJobsPublisher(VoiceIdAsyncClient client, ListSpeakerEnrollmentJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSpeakerEnrollmentJobsPublisher(VoiceIdAsyncClient client, ListSpeakerEnrollmentJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSpeakerEnrollmentJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSpeakerEnrollmentJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SpeakerEnrollmentJobSummary> jobSummaries() {
        Function<ListSpeakerEnrollmentJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobSummaries() != null) {
                return response.jobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSpeakerEnrollmentJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSpeakerEnrollmentJobsResponseFetcher
    implements AsyncPageFetcher<ListSpeakerEnrollmentJobsResponse> {
        private ListSpeakerEnrollmentJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListSpeakerEnrollmentJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSpeakerEnrollmentJobsResponse> nextPage(ListSpeakerEnrollmentJobsResponse previousPage) {
            if (previousPage == null) {
                return ListSpeakerEnrollmentJobsPublisher.this.client.listSpeakerEnrollmentJobs(ListSpeakerEnrollmentJobsPublisher.this.firstRequest);
            }
            return ListSpeakerEnrollmentJobsPublisher.this.client.listSpeakerEnrollmentJobs((ListSpeakerEnrollmentJobsRequest)((Object)ListSpeakerEnrollmentJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

