/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Each step type has its own <code>StepDetails</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DecryptStepDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DecryptStepDetails.Builder, DecryptStepDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DecryptStepDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DecryptStepDetails::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> SOURCE_FILE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceFileLocation").getter(getter(DecryptStepDetails::sourceFileLocation))
            .setter(setter(Builder::sourceFileLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFileLocation").build())
            .build();

    private static final SdkField<String> OVERWRITE_EXISTING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OverwriteExisting").getter(getter(DecryptStepDetails::overwriteExistingAsString))
            .setter(setter(Builder::overwriteExisting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverwriteExisting").build()).build();

    private static final SdkField<InputFileLocation> DESTINATION_FILE_LOCATION_FIELD = SdkField
            .<InputFileLocation> builder(MarshallingType.SDK_POJO).memberName("DestinationFileLocation")
            .getter(getter(DecryptStepDetails::destinationFileLocation)).setter(setter(Builder::destinationFileLocation))
            .constructor(InputFileLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationFileLocation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            SOURCE_FILE_LOCATION_FIELD, OVERWRITE_EXISTING_FIELD, DESTINATION_FILE_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final String sourceFileLocation;

    private final String overwriteExisting;

    private final InputFileLocation destinationFileLocation;

    private DecryptStepDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.sourceFileLocation = builder.sourceFileLocation;
        this.overwriteExisting = builder.overwriteExisting;
        this.destinationFileLocation = builder.destinationFileLocation;
    }

    /**
     * <p>
     * The name of the step, used as an identifier.
     * </p>
     * 
     * @return The name of the step, used as an identifier.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of encryption used. Currently, this value must be <code>PGP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of encryption used. Currently, this value must be <code>PGP</code>.
     * @see EncryptionType
     */
    public final EncryptionType type() {
        return EncryptionType.fromValue(type);
    }

    /**
     * <p>
     * The type of encryption used. Currently, this value must be <code>PGP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of encryption used. Currently, this value must be <code>PGP</code>.
     * @see EncryptionType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Specifies which file to use as input to the workflow step: either the output from the previous step, or the
     * originally uploaded file for the workflow.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To use the previous file as the input, enter <code>${previous.file}</code>. In this case, this workflow step uses
     * the output file from the previous workflow step as input. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * To use the originally uploaded file location as input for this step, enter <code>${original.file}</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies which file to use as input to the workflow step: either the output from the previous step, or
     *         the originally uploaded file for the workflow.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         To use the previous file as the input, enter <code>${previous.file}</code>. In this case, this workflow
     *         step uses the output file from the previous workflow step as input. This is the default value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To use the originally uploaded file location as input for this step, enter <code>${original.file}</code>.
     *         </p>
     *         </li>
     */
    public final String sourceFileLocation() {
        return sourceFileLocation;
    }

    /**
     * <p>
     * A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code>.
     * </p>
     * <p>
     * If the workflow is processing a file that has the same name as an existing file, the behavior is as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>OverwriteExisting</code> is <code>TRUE</code>, the existing file is replaced with the file being
     * processed.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>OverwriteExisting</code> is <code>FALSE</code>, nothing happens, and the workflow processing stops.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overwriteExisting}
     * will return {@link OverwriteExisting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #overwriteExistingAsString}.
     * </p>
     * 
     * @return A flag that indicates whether to overwrite an existing file of the same name. The default is
     *         <code>FALSE</code>.</p>
     *         <p>
     *         If the workflow is processing a file that has the same name as an existing file, the behavior is as
     *         follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If <code>OverwriteExisting</code> is <code>TRUE</code>, the existing file is replaced with the file being
     *         processed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>OverwriteExisting</code> is <code>FALSE</code>, nothing happens, and the workflow processing
     *         stops.
     *         </p>
     *         </li>
     * @see OverwriteExisting
     */
    public final OverwriteExisting overwriteExisting() {
        return OverwriteExisting.fromValue(overwriteExisting);
    }

    /**
     * <p>
     * A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code>.
     * </p>
     * <p>
     * If the workflow is processing a file that has the same name as an existing file, the behavior is as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>OverwriteExisting</code> is <code>TRUE</code>, the existing file is replaced with the file being
     * processed.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>OverwriteExisting</code> is <code>FALSE</code>, nothing happens, and the workflow processing stops.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overwriteExisting}
     * will return {@link OverwriteExisting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #overwriteExistingAsString}.
     * </p>
     * 
     * @return A flag that indicates whether to overwrite an existing file of the same name. The default is
     *         <code>FALSE</code>.</p>
     *         <p>
     *         If the workflow is processing a file that has the same name as an existing file, the behavior is as
     *         follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If <code>OverwriteExisting</code> is <code>TRUE</code>, the existing file is replaced with the file being
     *         processed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>OverwriteExisting</code> is <code>FALSE</code>, nothing happens, and the workflow processing
     *         stops.
     *         </p>
     *         </li>
     * @see OverwriteExisting
     */
    public final String overwriteExistingAsString() {
        return overwriteExisting;
    }

    /**
     * <p>
     * Specifies the location for the file being decrypted. Use <code>${Transfer:UserName}</code> or
     * <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or uploaded
     * date.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to decrypt uploaded
     * files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that uploaded the file.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to decrypt uploaded
     * files to an Amazon S3 bucket that is prefixed with the date of the upload.
     * </p>
     * <note>
     * <p>
     * The system resolves <code>UploadDate</code> to a date format of <i>YYYY-MM-DD</i>, based on the date the file is
     * uploaded in UTC.
     * </p>
     * </note></li>
     * </ul>
     * 
     * @return Specifies the location for the file being decrypted. Use <code>${Transfer:UserName}</code> or
     *         <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or
     *         uploaded date.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to decrypt
     *         uploaded files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that
     *         uploaded the file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to decrypt
     *         uploaded files to an Amazon S3 bucket that is prefixed with the date of the upload.
     *         </p>
     *         <note>
     *         <p>
     *         The system resolves <code>UploadDate</code> to a date format of <i>YYYY-MM-DD</i>, based on the date the
     *         file is uploaded in UTC.
     *         </p>
     *         </note></li>
     */
    public final InputFileLocation destinationFileLocation() {
        return destinationFileLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFileLocation());
        hashCode = 31 * hashCode + Objects.hashCode(overwriteExistingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationFileLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecryptStepDetails)) {
            return false;
        }
        DecryptStepDetails other = (DecryptStepDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(sourceFileLocation(), other.sourceFileLocation())
                && Objects.equals(overwriteExistingAsString(), other.overwriteExistingAsString())
                && Objects.equals(destinationFileLocation(), other.destinationFileLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DecryptStepDetails").add("Name", name()).add("Type", typeAsString())
                .add("SourceFileLocation", sourceFileLocation()).add("OverwriteExisting", overwriteExistingAsString())
                .add("DestinationFileLocation", destinationFileLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "SourceFileLocation":
            return Optional.ofNullable(clazz.cast(sourceFileLocation()));
        case "OverwriteExisting":
            return Optional.ofNullable(clazz.cast(overwriteExistingAsString()));
        case "DestinationFileLocation":
            return Optional.ofNullable(clazz.cast(destinationFileLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DecryptStepDetails, T> g) {
        return obj -> g.apply((DecryptStepDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DecryptStepDetails> {
        /**
         * <p>
         * The name of the step, used as an identifier.
         * </p>
         * 
         * @param name
         *        The name of the step, used as an identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of encryption used. Currently, this value must be <code>PGP</code>.
         * </p>
         * 
         * @param type
         *        The type of encryption used. Currently, this value must be <code>PGP</code>.
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of encryption used. Currently, this value must be <code>PGP</code>.
         * </p>
         * 
         * @param type
         *        The type of encryption used. Currently, this value must be <code>PGP</code>.
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder type(EncryptionType type);

        /**
         * <p>
         * Specifies which file to use as input to the workflow step: either the output from the previous step, or the
         * originally uploaded file for the workflow.
         * </p>
         * <ul>
         * <li>
         * <p>
         * To use the previous file as the input, enter <code>${previous.file}</code>. In this case, this workflow step
         * uses the output file from the previous workflow step as input. This is the default value.
         * </p>
         * </li>
         * <li>
         * <p>
         * To use the originally uploaded file location as input for this step, enter <code>${original.file}</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceFileLocation
         *        Specifies which file to use as input to the workflow step: either the output from the previous step,
         *        or the originally uploaded file for the workflow.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        To use the previous file as the input, enter <code>${previous.file}</code>. In this case, this
         *        workflow step uses the output file from the previous workflow step as input. This is the default
         *        value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To use the originally uploaded file location as input for this step, enter
         *        <code>${original.file}</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFileLocation(String sourceFileLocation);

        /**
         * <p>
         * A flag that indicates whether to overwrite an existing file of the same name. The default is
         * <code>FALSE</code>.
         * </p>
         * <p>
         * If the workflow is processing a file that has the same name as an existing file, the behavior is as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If <code>OverwriteExisting</code> is <code>TRUE</code>, the existing file is replaced with the file being
         * processed.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>OverwriteExisting</code> is <code>FALSE</code>, nothing happens, and the workflow processing stops.
         * </p>
         * </li>
         * </ul>
         * 
         * @param overwriteExisting
         *        A flag that indicates whether to overwrite an existing file of the same name. The default is
         *        <code>FALSE</code>.</p>
         *        <p>
         *        If the workflow is processing a file that has the same name as an existing file, the behavior is as
         *        follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If <code>OverwriteExisting</code> is <code>TRUE</code>, the existing file is replaced with the file
         *        being processed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>OverwriteExisting</code> is <code>FALSE</code>, nothing happens, and the workflow processing
         *        stops.
         *        </p>
         *        </li>
         * @see OverwriteExisting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverwriteExisting
         */
        Builder overwriteExisting(String overwriteExisting);

        /**
         * <p>
         * A flag that indicates whether to overwrite an existing file of the same name. The default is
         * <code>FALSE</code>.
         * </p>
         * <p>
         * If the workflow is processing a file that has the same name as an existing file, the behavior is as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If <code>OverwriteExisting</code> is <code>TRUE</code>, the existing file is replaced with the file being
         * processed.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>OverwriteExisting</code> is <code>FALSE</code>, nothing happens, and the workflow processing stops.
         * </p>
         * </li>
         * </ul>
         * 
         * @param overwriteExisting
         *        A flag that indicates whether to overwrite an existing file of the same name. The default is
         *        <code>FALSE</code>.</p>
         *        <p>
         *        If the workflow is processing a file that has the same name as an existing file, the behavior is as
         *        follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If <code>OverwriteExisting</code> is <code>TRUE</code>, the existing file is replaced with the file
         *        being processed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>OverwriteExisting</code> is <code>FALSE</code>, nothing happens, and the workflow processing
         *        stops.
         *        </p>
         *        </li>
         * @see OverwriteExisting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverwriteExisting
         */
        Builder overwriteExisting(OverwriteExisting overwriteExisting);

        /**
         * <p>
         * Specifies the location for the file being decrypted. Use <code>${Transfer:UserName}</code> or
         * <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or
         * uploaded date.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to decrypt
         * uploaded files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that
         * uploaded the file.
         * </p>
         * </li>
         * <li>
         * <p>
         * Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to decrypt
         * uploaded files to an Amazon S3 bucket that is prefixed with the date of the upload.
         * </p>
         * <note>
         * <p>
         * The system resolves <code>UploadDate</code> to a date format of <i>YYYY-MM-DD</i>, based on the date the file
         * is uploaded in UTC.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param destinationFileLocation
         *        Specifies the location for the file being decrypted. Use <code>${Transfer:UserName}</code> or
         *        <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or
         *        uploaded date.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to decrypt
         *        uploaded files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that
         *        uploaded the file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to
         *        decrypt uploaded files to an Amazon S3 bucket that is prefixed with the date of the upload.
         *        </p>
         *        <note>
         *        <p>
         *        The system resolves <code>UploadDate</code> to a date format of <i>YYYY-MM-DD</i>, based on the date
         *        the file is uploaded in UTC.
         *        </p>
         *        </note></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationFileLocation(InputFileLocation destinationFileLocation);

        /**
         * <p>
         * Specifies the location for the file being decrypted. Use <code>${Transfer:UserName}</code> or
         * <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or
         * uploaded date.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to decrypt
         * uploaded files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that
         * uploaded the file.
         * </p>
         * </li>
         * <li>
         * <p>
         * Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to decrypt
         * uploaded files to an Amazon S3 bucket that is prefixed with the date of the upload.
         * </p>
         * <note>
         * <p>
         * The system resolves <code>UploadDate</code> to a date format of <i>YYYY-MM-DD</i>, based on the date the file
         * is uploaded in UTC.
         * </p>
         * </note></li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link InputFileLocation.Builder} avoiding the
         * need to create one manually via {@link InputFileLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputFileLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationFileLocation(InputFileLocation)}.
         * 
         * @param destinationFileLocation
         *        a consumer that will call methods on {@link InputFileLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationFileLocation(InputFileLocation)
         */
        default Builder destinationFileLocation(Consumer<InputFileLocation.Builder> destinationFileLocation) {
            return destinationFileLocation(InputFileLocation.builder().applyMutation(destinationFileLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String sourceFileLocation;

        private String overwriteExisting;

        private InputFileLocation destinationFileLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(DecryptStepDetails model) {
            name(model.name);
            type(model.type);
            sourceFileLocation(model.sourceFileLocation);
            overwriteExisting(model.overwriteExisting);
            destinationFileLocation(model.destinationFileLocation);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EncryptionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSourceFileLocation() {
            return sourceFileLocation;
        }

        public final void setSourceFileLocation(String sourceFileLocation) {
            this.sourceFileLocation = sourceFileLocation;
        }

        @Override
        public final Builder sourceFileLocation(String sourceFileLocation) {
            this.sourceFileLocation = sourceFileLocation;
            return this;
        }

        public final String getOverwriteExisting() {
            return overwriteExisting;
        }

        public final void setOverwriteExisting(String overwriteExisting) {
            this.overwriteExisting = overwriteExisting;
        }

        @Override
        public final Builder overwriteExisting(String overwriteExisting) {
            this.overwriteExisting = overwriteExisting;
            return this;
        }

        @Override
        public final Builder overwriteExisting(OverwriteExisting overwriteExisting) {
            this.overwriteExisting(overwriteExisting == null ? null : overwriteExisting.toString());
            return this;
        }

        public final InputFileLocation.Builder getDestinationFileLocation() {
            return destinationFileLocation != null ? destinationFileLocation.toBuilder() : null;
        }

        public final void setDestinationFileLocation(InputFileLocation.BuilderImpl destinationFileLocation) {
            this.destinationFileLocation = destinationFileLocation != null ? destinationFileLocation.build() : null;
        }

        @Override
        public final Builder destinationFileLocation(InputFileLocation destinationFileLocation) {
            this.destinationFileLocation = destinationFileLocation;
            return this;
        }

        @Override
        public DecryptStepDetails build() {
            return new DecryptStepDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
